/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioPermission;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixer;
import org.classpath.icedtea.pulseaudio.Stream;
import org.classpath.icedtea.pulseaudio.StreamBufferAttributes;

public final class PulseAudioTargetDataLine
extends PulseAudioDataLine
implements TargetDataLine {
    private byte[] fragmentBuffer;
    private boolean flushed = false;
    private boolean drained = false;
    public static final String DEFAULT_TARGETDATALINE_NAME = "Audio Stream";

    PulseAudioTargetDataLine(AudioFormat[] audioFormatArray, AudioFormat audioFormat) {
        this.supportedFormats = audioFormatArray;
        this.defaultFormat = audioFormat;
        this.currentFormat = audioFormat;
        this.streamName = DEFAULT_TARGETDATALINE_NAME;
    }

    public synchronized void close() {
        if (!this.isOpen()) {
            Debug.println(Debug.DebugLevel.Verbose, "PulseAudioTargetDataLine.close(): Line closed that wasn't open.");
            return;
        }
        AudioPermission audioPermission = new AudioPermission("record", null);
        audioPermission.checkGuard(null);
        PulseAudioMixer pulseAudioMixer = PulseAudioMixer.getInstance();
        pulseAudioMixer.removeTargetLine(this);
        super.close();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioTargetDataLine.close(): Line closed");
    }

    public synchronized void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        AudioPermission audioPermission = new AudioPermission("record", null);
        audioPermission.checkGuard(null);
        if (this.isOpen()) {
            throw new IllegalStateException("already open");
        }
        super.open(audioFormat, n);
        this.framesSinceOpen = 0L;
        this.fragmentBuffer = null;
        this.flushed = false;
        this.drained = false;
        PulseAudioMixer pulseAudioMixer = PulseAudioMixer.getInstance();
        pulseAudioMixer.addTargetLine(this);
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioTargetDataLine.open(): Line opened");
    }

    public synchronized void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, 50000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectLine(int n, Stream stream) throws LineUnavailableException {
        StreamBufferAttributes streamBufferAttributes;
        int n2 = this.currentFormat.getFrameSize();
        float f = this.currentFormat.getFrameRate();
        int n3 = (int)((float)n2 * f);
        long l = Stream.FLAG_START_CORKED;
        if (n3 * 2 < n) {
            streamBufferAttributes = new StreamBufferAttributes(n, -1, -1, -1, -1);
        } else {
            l |= Stream.FLAG_ADJUST_LATENCY;
            int n4 = n / 2;
            n4 = Math.max(n4 / n2 * n2, n2);
            streamBufferAttributes = new StreamBufferAttributes(n, -1, -1, -1, n4);
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.connectForRecording(Stream.DEFAULT_DEVICE, l, streamBufferAttributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        if (!this.isOpen()) {
            return 0;
        }
        int n4 = this.currentFormat.getFrameSize();
        if (n2 % n4 != 0) {
            throw new IllegalArgumentException("amount of data to read does not represent an integral number of frames");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (n < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException("array size: " + byArray.length + " offset:" + n + " length:" + n2);
        }
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        this.flushed = false;
        this.drained = false;
        PulseAudioTargetDataLine pulseAudioTargetDataLine = this;
        synchronized (pulseAudioTargetDataLine) {
            if (this.fragmentBuffer != null) {
                boolean bl = this.fragmentBuffer.length < n2;
                int n8 = Math.min(this.fragmentBuffer.length, n2);
                System.arraycopy(this.fragmentBuffer, 0, byArray, n5, n8);
                this.framesSinceOpen += (long)(n8 / this.currentFormat.getFrameSize());
                if (!bl) {
                    int n9 = this.fragmentBuffer.length - n2;
                    byte[] byArray2 = new byte[n9];
                    System.arraycopy(this.fragmentBuffer, n2, byArray2, 0, byArray2.length);
                    this.fragmentBuffer = byArray2;
                    return n2;
                }
                n3 = n8;
                n7 += n3;
                n5 += n3;
                n6 -= n3;
                this.fragmentBuffer = null;
            }
        }
        while (n6 != 0) {
            pulseAudioTargetDataLine = this;
            synchronized (pulseAudioTargetDataLine) {
                if (!this.isOpen() || !this.isStarted) {
                    return n7;
                }
                if (this.flushed) {
                    this.flushed = false;
                    return n7;
                }
                if (this.drained) {
                    this.drained = false;
                    return n7;
                }
                Object object = this.eventLoop.threadLock;
                synchronized (object) {
                    byte[] byArray3 = this.stream.peek();
                    this.stream.drop();
                    if (byArray3 == null) {
                        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioTargetDataLine.read():  error in stream.peek()");
                        continue;
                    }
                    n3 = Math.min(byArray3.length, n6);
                    if (n3 < byArray3.length) {
                        this.fragmentBuffer = new byte[byArray3.length - n3];
                        System.arraycopy(byArray3, n3, this.fragmentBuffer, 0, byArray3.length - n3);
                    }
                    System.arraycopy(byArray3, 0, byArray, n5, n3);
                    n7 += n3;
                    n5 += n3;
                    n6 -= n3;
                    this.framesSinceOpen += (long)(n3 / this.currentFormat.getFrameSize());
                }
            }
        }
        assert (n7 == n2);
        return n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        PulseAudioTargetDataLine pulseAudioTargetDataLine;
        while (true) {
            pulseAudioTargetDataLine = this;
            synchronized (pulseAudioTargetDataLine) {
                if (!this.isStarted || !this.isOpen()) {
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        pulseAudioTargetDataLine = this;
        synchronized (pulseAudioTargetDataLine) {
            this.drained = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        if (this.isOpen()) {
            Operation operation;
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                operation = this.stream.flush();
            }
            operation.waitForCompletion();
            operation.releaseReference();
        }
        this.flushed = true;
        this.fragmentBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        if (!this.isOpen()) {
            return 0;
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return this.stream.getReableSize();
        }
    }

    public int getFramePosition() {
        return (int)this.framesSinceOpen;
    }

    public long getLongFramePosition() {
        return this.framesSinceOpen;
    }

    public long getMicrosecondPosition() {
        return (long)((float)this.framesSinceOpen / this.currentFormat.getFrameRate());
    }

    public synchronized void start() {
        super.start();
        this.fireLineEvent(new LineEvent(this, LineEvent.Type.START, this.framesSinceOpen));
    }

    public synchronized void stop() {
        super.stop();
        this.fireLineEvent(new LineEvent(this, LineEvent.Type.STOP, this.framesSinceOpen));
    }

    public Line.Info getLineInfo() {
        return new DataLine.Info(TargetDataLine.class, this.supportedFormats, 0, 1000000);
    }
}

