/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixer;
import org.classpath.icedtea.pulseaudio.PulseAudioPlaybackLine;
import org.classpath.icedtea.pulseaudio.PulseAudioVolumeControl;
import org.classpath.icedtea.pulseaudio.Stream;
import org.classpath.icedtea.pulseaudio.StreamBufferAttributes;

public final class PulseAudioSourceDataLine
extends PulseAudioDataLine
implements SourceDataLine,
PulseAudioPlaybackLine {
    private PulseAudioVolumeControl volumeControl;
    public static final String DEFAULT_SOURCEDATALINE_NAME = "Audio Stream";

    PulseAudioSourceDataLine(AudioFormat[] audioFormatArray, AudioFormat audioFormat) {
        this.supportedFormats = audioFormatArray;
        this.lineListeners = new ArrayList();
        this.defaultFormat = audioFormat;
        this.currentFormat = audioFormat;
        this.streamName = DEFAULT_SOURCEDATALINE_NAME;
    }

    public synchronized void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        super.open(audioFormat, n);
        this.volumeControl = new PulseAudioVolumeControl(this, this.eventLoop);
        this.controls.add(this.volumeControl);
        PulseAudioMixer pulseAudioMixer = PulseAudioMixer.getInstance();
        pulseAudioMixer.addSourceLine(this);
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioSourceDataLine.open(): line opened");
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, 50000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] native_set_volume(float f) {
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return this.stream.native_set_volume(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] native_update_volume() {
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return this.stream.native_update_volume();
        }
    }

    public float getCachedVolume() {
        return this.stream.getCachedVolume();
    }

    public synchronized void setCachedVolume(float f) {
        this.stream.setCachedVolume(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectLine(int n, Stream stream) throws LineUnavailableException {
        StreamBufferAttributes streamBufferAttributes = new StreamBufferAttributes(n, n / 4, n / 8, Math.max(n / 10, 100), 0);
        if (stream != null) {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                this.stream.connectForPlayback(Stream.DEFAULT_DEVICE, streamBufferAttributes, stream.getStreamPointer());
            }
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.connectForPlayback(Stream.DEFAULT_DEVICE, streamBufferAttributes, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n, int n2) {
        PulseAudioSourceDataLine pulseAudioSourceDataLine = this;
        synchronized (pulseAudioSourceDataLine) {
            this.writeInterrupted = false;
        }
        if (!this.isOpen()) {
            return 0;
        }
        int n3 = this.currentFormat.getFrameSize();
        if (n2 % n3 != 0) {
            throw new IllegalArgumentException("amount of data to write does not represent an integral number of frames");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (n2 < 0 || n < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException("Overflow condition: buffer.length=" + byArray.length + " offset= " + n + " length=" + n2);
        }
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        while (n5 != 0) {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                PulseAudioSourceDataLine pulseAudioSourceDataLine2;
                do {
                    pulseAudioSourceDataLine2 = this;
                    synchronized (pulseAudioSourceDataLine2) {
                        if (this.writeInterrupted) {
                            return n7;
                        }
                    }
                    if (n6 == -1) {
                        return n7;
                    }
                    n6 = this.stream.getWritableSize();
                    if (n6 != 0) continue;
                    try {
                        this.eventLoop.threadLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                } while (n6 == 0);
                if (n6 > n5) {
                    n6 = n5;
                }
                n6 = n6 / n3 * n3;
                pulseAudioSourceDataLine2 = this;
                synchronized (pulseAudioSourceDataLine2) {
                    if (this.writeInterrupted) {
                        return n7;
                    }
                    this.stream.write(byArray, n4, n6);
                }
                n7 += n6;
                n4 += n6;
                n5 -= n6;
                this.framesSinceOpen += (long)(n6 / n3);
            }
        }
        assert (n7 == n2);
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return this.stream.getWritableSize();
        }
    }

    public int getFramePosition() {
        return (int)this.framesSinceOpen;
    }

    public long getLongFramePosition() {
        return this.framesSinceOpen;
    }

    public long getMicrosecondPosition() {
        float f = this.currentFormat.getFrameRate();
        float f2 = (float)this.framesSinceOpen / f;
        long l = (long)(f2 * 1000000.0f);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        Object object = this;
        synchronized (object) {
            this.writeInterrupted = true;
        }
        do {
            object = this;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                if (this.getBytesInBuffer() == 0) {
                    return;
                }
                if (this.isStarted) {
                    break;
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        } while (!this.isStarted);
        Object object2 = this.eventLoop.threadLock;
        synchronized (object2) {
            object = this.stream.drain();
        }
        ((Operation)object).waitForCompletion();
        ((Operation)object).releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this;
        synchronized (object) {
            this.writeInterrupted = true;
        }
        if (this.isOpen()) {
            Object object2 = this.eventLoop.threadLock;
            synchronized (object2) {
                object = this.stream.flush();
            }
            ((Operation)object).waitForCompletion();
            ((Operation)object).releaseReference();
        }
    }

    public synchronized void close() {
        if (!this.isOpen()) {
            return;
        }
        this.writeInterrupted = true;
        PulseAudioMixer pulseAudioMixer = PulseAudioMixer.getInstance();
        pulseAudioMixer.removeSourceLine(this);
        super.close();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioSourceDataLine.close(): line closed");
    }

    public Line.Info getLineInfo() {
        return new DataLine.Info(SourceDataLine.class, this.supportedFormats, 0, 1000000);
    }
}

