/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.v09;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongReader;
import org.herac.tuxguitar.io.base.TGSongReaderHandle;
import org.herac.tuxguitar.io.tg.TGFileFormatDetectorImpl;
import org.herac.tuxguitar.io.tg.TGFileFormatVersion;
import org.herac.tuxguitar.io.tg.v09.TGStream;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGSongReaderImpl
extends TGStream
implements TGSongReader {
    public static final TGFileFormatVersion SUPPORTED_FORMAT = new TGFileFormatVersion(TG_FORMAT, "TuxGuitar File Format - 0.9");
    private DataInputStream dataInputStream;
    private TGFactory factory;
    private int velocity;

    public TGFileFormat getFileFormat() {
        return TG_FORMAT;
    }

    public void read(TGSongReaderHandle handle) throws TGFileFormatException {
        try {
            this.factory = handle.getFactory();
            this.dataInputStream = new DataInputStream(handle.getInputStream());
            TGFileFormat fileFormat = new TGFileFormatDetectorImpl(new TGFileFormatVersion[]{SUPPORTED_FORMAT}).getFileFormat((InputStream)this.dataInputStream);
            if (fileFormat == null || !fileFormat.equals((Object)this.getFileFormat())) {
                throw new TGFileFormatException("Unsupported Version");
            }
            TGSong song = this.read();
            this.dataInputStream.close();
            handle.setSong(song);
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private TGSong read() {
        TGSong song = this.factory.newSong();
        song.setName(this.readString());
        song.setArtist(this.readString());
        song.setAlbum(this.readString());
        song.setAuthor(this.readString());
        int headerCount = this.readShort();
        long headerStart = 960L;
        TGMeasureHeader lastHeader = null;
        for (int i = 0; i < headerCount; ++i) {
            TGMeasureHeader header = this.readMeasureHeader(i + 1, headerStart, lastHeader);
            song.addMeasureHeader(header);
            headerStart += header.getLength();
            lastHeader = header;
        }
        int trackCount = this.readByte();
        for (int i = 0; i < trackCount; ++i) {
            song.addTrack(this.readTrack(i + 1, song));
        }
        return song;
    }

    private TGTrack readTrack(int number, TGSong song) {
        int header = this.readHeader();
        TGTrack track = this.factory.newTrack();
        track.setNumber(number);
        track.setName(this.readString());
        this.readChannel(song, track);
        int measureCount = song.countMeasureHeaders();
        TGMeasure lastMeasure = null;
        for (int i = 0; i < measureCount; ++i) {
            TGMeasure measure = this.readMeasure(song.getMeasureHeader(i), lastMeasure);
            track.addMeasure(measure);
            lastMeasure = measure;
        }
        int stringCount = this.readByte();
        for (int i = 0; i < stringCount; ++i) {
            track.getStrings().add(this.readInstrumentString(i + 1));
        }
        track.setOffset(-24 + this.readByte());
        this.readColor(track.getColor());
        if ((header & 1) != 0) {
            this.readLyrics(track.getLyrics());
        }
        return track;
    }

    private TGMeasureHeader readMeasureHeader(int number, long start, TGMeasureHeader lastMeasureHeader) {
        int header = this.readHeader();
        TGMeasureHeader measureHeader = this.factory.newHeader();
        measureHeader.setNumber(number);
        measureHeader.setStart(start);
        if ((header & 1) != 0) {
            this.readTimeSignature(measureHeader.getTimeSignature());
        } else if (lastMeasureHeader != null) {
            measureHeader.getTimeSignature().copyFrom(lastMeasureHeader.getTimeSignature());
        }
        if ((header & 2) != 0) {
            this.readTempo(measureHeader.getTempo());
        } else if (lastMeasureHeader != null) {
            measureHeader.getTempo().copyFrom(lastMeasureHeader.getTempo());
        }
        measureHeader.setRepeatOpen((header & 4) != 0);
        if ((header & 8) != 0) {
            measureHeader.setRepeatClose((int)this.readShort());
        }
        if ((header & 0x10) != 0) {
            measureHeader.setMarker(this.readMarker(number));
        }
        measureHeader.setTripletFeel(lastMeasureHeader != null ? lastMeasureHeader.getTripletFeel() : 1);
        if ((header & 0x20) != 0) {
            measureHeader.setTripletFeel(this.readByte());
        }
        return measureHeader;
    }

    private TGMeasure readMeasure(TGMeasureHeader measureHeader, TGMeasure lastMeasure) {
        this.velocity = 95;
        int header = this.readHeader();
        TGMeasure measure = this.factory.newMeasure(measureHeader);
        TGBeat previous = null;
        int componentCount = this.readShort();
        for (int i = 0; i < componentCount; ++i) {
            previous = this.readComponent(measure, previous);
        }
        measure.setClef(lastMeasure == null ? 1 : lastMeasure.getClef());
        if ((header & 1) != 0) {
            measure.setClef(this.readByte());
        }
        measure.setKeySignature(lastMeasure == null ? 0 : lastMeasure.getKeySignature());
        if ((header & 2) != 0) {
            measure.setKeySignature(this.readByte());
        }
        return measure;
    }

    private void readChannel(TGSong song, TGTrack track) {
        int header = this.readHeader();
        TGChannel channel = this.factory.newChannel();
        TGChannelParameter gmChannel1Param = this.factory.newChannelParameter();
        TGChannelParameter gmChannel2Param = this.factory.newChannelParameter();
        int channel1 = this.readByte() & 0xFF;
        gmChannel1Param.setKey("gm-channel-1");
        gmChannel1Param.setValue(Integer.toString(channel1));
        int channel2 = this.readByte() & 0xFF;
        gmChannel2Param.setKey("gm-channel-2");
        gmChannel2Param.setValue(Integer.toString(channel2));
        channel.setBank(channel1 == 9 ? (short)128 : 0);
        channel.setProgram((short)this.readByte());
        channel.setVolume((short)this.readByte());
        channel.setBalance((short)this.readByte());
        channel.setChorus((short)this.readByte());
        channel.setReverb((short)this.readByte());
        channel.setPhaser((short)this.readByte());
        channel.setTremolo((short)this.readByte());
        track.setSolo((header & 1) != 0);
        track.setMute((header & 2) != 0);
        for (int i = 0; i < song.countChannels(); ++i) {
            TGChannel channelAux = song.getChannel(i);
            for (int n = 0; n < channelAux.countParameters(); ++n) {
                TGChannelParameter channelParameter = channelAux.getParameter(n);
                if (!channelParameter.getKey().equals("gm-channel-1") || !Integer.toString(channel1).equals(channelParameter.getValue())) continue;
                channel.setChannelId(channelAux.getChannelId());
            }
        }
        if (channel.getChannelId() <= 0) {
            channel.setChannelId(song.countChannels() + 1);
            channel.setName(new TGSongManager(this.factory).createChannelNameFromProgram(song, channel));
            channel.addParameter(gmChannel1Param);
            channel.addParameter(gmChannel2Param);
            song.addChannel(channel);
        }
        track.setChannelId(channel.getChannelId());
    }

    private TGBeat readComponent(TGMeasure measure, TGBeat previous) {
        TGBeat beat = previous;
        int header = this.readHeader();
        if (beat == null) {
            beat = this.factory.newBeat();
            beat.setStart(measure.getStart());
            measure.addBeat(beat);
        } else if ((header & 0x10) != 0) {
            beat = this.factory.newBeat();
            beat.setStart(previous.getStart() + previous.getVoice(0).getDuration().getTime());
            measure.addBeat(beat);
        }
        TGVoice voice = beat.getVoice(0);
        voice.setEmpty(false);
        if ((header & 0x20) != 0) {
            this.readDuration(voice.getDuration());
        } else if (previous != null && !previous.equals(beat)) {
            voice.getDuration().copyFrom(previous.getVoice(0).getDuration());
        }
        if ((header & 1) != 0) {
            TGNote note = this.factory.newNote();
            note.setValue(this.readByte());
            note.setString(this.readByte());
            note.setTiedNote((header & 4) != 0);
            if ((header & 0x40) != 0) {
                this.velocity = this.readByte();
            }
            note.setVelocity(this.velocity);
            if ((header & 8) != 0) {
                this.readNoteEffect(note.getEffect());
            }
            voice.addNote(note);
        }
        return beat;
    }

    private TGString readInstrumentString(int number) {
        TGString string = this.factory.newString();
        string.setNumber(number);
        string.setValue(this.readByte());
        return string;
    }

    private void readTempo(TGTempo tempo) {
        tempo.setValue((int)this.readShort());
    }

    private void readTimeSignature(TGTimeSignature timeSignature) {
        timeSignature.setNumerator(this.readByte());
        this.readDuration(timeSignature.getDenominator());
    }

    private void readDuration(TGDuration duration) {
        int header = this.readHeader();
        duration.setDotted((header & 1) != 0);
        duration.setDoubleDotted((header & 2) != 0);
        duration.setValue(this.readByte());
        if ((header & 4) != 0) {
            this.readDivisionType(duration.getDivision());
        }
    }

    private void readDivisionType(TGDivisionType divisionType) {
        divisionType.setEnters(this.readByte());
        divisionType.setTimes(this.readByte());
    }

    private void readNoteEffect(TGNoteEffect effect) {
        int header = this.readHeader(3);
        if ((header & 1) != 0) {
            effect.setBend(this.readBendEffect());
        }
        if ((header & 2) != 0) {
            effect.setTremoloBar(this.readTremoloBarEffect());
        }
        if ((header & 4) != 0) {
            effect.setHarmonic(this.readHarmonicEffect());
        }
        if ((header & 8) != 0) {
            effect.setGrace(this.readGraceEffect());
        }
        if ((header & 0x10) != 0) {
            effect.setTrill(this.readTrillEffect());
        }
        if ((header & 0x20) != 0) {
            effect.setTremoloPicking(this.readTremoloPickingEffect());
        }
        effect.setVibrato((header & 0x40) != 0);
        effect.setDeadNote((header & 0x80) != 0);
        effect.setSlide((header & 0x100) != 0);
        effect.setHammer((header & 0x200) != 0);
        effect.setGhostNote((header & 0x400) != 0);
        effect.setAccentuatedNote((header & 0x800) != 0);
        effect.setHeavyAccentuatedNote((header & 0x1000) != 0);
        effect.setPalmMute((header & 0x2000) != 0);
        effect.setStaccato((header & 0x4000) != 0);
        effect.setTapping((header & 0x8000) != 0);
        effect.setSlapping((header & 0x10000) != 0);
        effect.setPopping((header & 0x20000) != 0);
        effect.setFadeIn((header & 0x40000) != 0);
    }

    private TGEffectBend readBendEffect() {
        TGEffectBend bend = this.factory.newEffectBend();
        int count = this.readByte();
        for (int i = 0; i < count; ++i) {
            int position = this.readByte();
            int value = this.readByte();
            bend.addPoint(position, value);
        }
        return bend;
    }

    private TGEffectTremoloBar readTremoloBarEffect() {
        TGEffectTremoloBar tremoloBar = this.factory.newEffectTremoloBar();
        int count = this.readByte();
        for (int i = 0; i < count; ++i) {
            int position = this.readByte();
            int value = this.readByte() - 12;
            tremoloBar.addPoint(position, value);
        }
        return tremoloBar;
    }

    private TGEffectHarmonic readHarmonicEffect() {
        TGEffectHarmonic harmonic = this.factory.newEffectHarmonic();
        harmonic.setType(this.readByte());
        if (harmonic.getType() == 2) {
            harmonic.setData(-24 + this.readByte());
        } else if (harmonic.getType() == 3) {
            harmonic.setData(this.readByte());
        }
        return harmonic;
    }

    private TGEffectGrace readGraceEffect() {
        TGEffectGrace grace = this.factory.newEffectGrace();
        int header = this.readHeader();
        grace.setDead((header & 1) != 0);
        grace.setOnBeat((header & 2) != 0);
        grace.setFret(this.readByte());
        grace.setDuration(this.readByte());
        grace.setDynamic(this.readByte());
        grace.setTransition(this.readByte());
        return grace;
    }

    private TGEffectTremoloPicking readTremoloPickingEffect() {
        TGEffectTremoloPicking tremoloPicking = this.factory.newEffectTremoloPicking();
        tremoloPicking.getDuration().setValue(this.readByte());
        return tremoloPicking;
    }

    private TGEffectTrill readTrillEffect() {
        TGEffectTrill trill = this.factory.newEffectTrill();
        trill.setFret(this.readByte());
        trill.getDuration().setValue(this.readByte());
        return trill;
    }

    private TGMarker readMarker(int measure) {
        TGMarker marker = this.factory.newMarker();
        marker.setMeasure(measure);
        marker.setTitle(this.readString());
        this.readColor(marker.getColor());
        return marker;
    }

    private void readColor(TGColor color) {
        color.setR((int)this.readShort());
        color.setG((int)this.readShort());
        color.setB((int)this.readShort());
    }

    private void readLyrics(TGLyric lyrics) {
        lyrics.setFrom((int)this.readShort());
        lyrics.setLyrics(this.readString());
    }

    private int readByte() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int readHeader() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int readHeader(int bCount) {
        int header = 0;
        for (int i = bCount; i > 0; --i) {
            header += this.readHeader() << 8 * i - 8;
        }
        return header;
    }

    private short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private String readString() {
        try {
            int length = this.dataInputStream.read();
            char[] chars = new char[length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(chars);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

