/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ascii;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.herac.tuxguitar.io.ascii.ASCIIOutputStream;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;

public class ASCIITabOutputStream {
    private static final String[] TONIC_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private static final int MAX_LINE_LENGTH = 80;
    private TGSongManager manager;
    private PrintStream stream;
    private ASCIIOutputStream out;

    public ASCIITabOutputStream(PrintStream stream) {
        this.stream = stream;
    }

    public ASCIITabOutputStream(OutputStream stream) {
        this(new PrintStream(stream));
    }

    public ASCIITabOutputStream(String fileName) throws FileNotFoundException {
        this(new FileOutputStream(fileName));
    }

    public void writeSong(TGSong song) {
        this.manager = new TGSongManager();
        this.out = new ASCIIOutputStream(this.stream);
        this.drawSong(song);
        this.out.flush();
        this.out.close();
    }

    private void drawSong(TGSong song) {
        this.out.drawStringLine("Title: " + song.getName());
        this.out.drawStringLine("Artist: " + song.getArtist());
        this.out.drawStringLine("Album: " + song.getAlbum());
        this.out.drawStringLine("Author: " + song.getAuthor());
        Iterator it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = (TGTrack)it.next();
            this.out.nextLine();
            this.drawTrack(track);
            this.out.nextLine();
        }
    }

    private void drawTrack(TGTrack track) {
        this.out.nextLine();
        this.out.drawStringLine("Track " + track.getNumber() + ": " + track.getName());
        String[] tuning = new String[track.getStrings().size()];
        int maxTuningLength = 1;
        for (int i = 0; i < track.getStrings().size(); ++i) {
            TGString string = (TGString)track.getStrings().get(i);
            tuning[i] = TONIC_NAMES[string.getValue() % TONIC_NAMES.length];
            maxTuningLength = Math.max(maxTuningLength, tuning[i].length());
        }
        int nextMeasure = 0;
        boolean eof = false;
        while (!eof) {
            this.out.nextLine();
            int index = nextMeasure;
            for (int i = 0; i < track.getStrings().size(); ++i) {
                TGString string = (TGString)track.getStrings().get(i);
                this.out.drawTuneSegment(tuning[i], maxTuningLength);
                int measureCount = track.countMeasures();
                for (int j = index; j < measureCount; ++j) {
                    TGMeasure measure = track.getMeasure(j);
                    this.drawMeasure(measure, string);
                    nextMeasure = j + 1;
                    eof = this.manager.getTrackManager().isLastMeasure(measure);
                    if (this.out.getPosX() > 80) break;
                }
                this.out.drawBarSegment();
                this.out.nextLine();
            }
            this.out.nextLine();
        }
        this.out.nextLine();
    }

    private void drawMeasure(TGMeasure measure, TGString string) {
        this.out.drawBarSegment();
        this.out.drawStringSegments(1);
        TGBeat beat = this.manager.getMeasureManager().getFirstBeat(measure.getBeats());
        while (beat != null) {
            int outLength = 0;
            TGNote note = this.manager.getMeasureManager().getNote(beat, string.getNumber());
            if (note != null) {
                outLength = Integer.toString(note.getValue()).length() - 1;
                this.out.drawNote(note.getValue());
            } else {
                this.out.drawStringSegments(1);
            }
            TGBeat nextBeat = this.manager.getMeasureManager().getNextBeat(measure.getBeats(), beat);
            long length = nextBeat != null ? nextBeat.getStart() - beat.getStart() : measure.getStart() + measure.getLength() - beat.getStart();
            this.out.drawStringSegments(this.getDurationScaping(length) - outLength);
            beat = nextBeat;
        }
    }

    private int getDurationScaping(long length) {
        int spacing = 6;
        if (length <= 120L) {
            spacing = 1;
        } else if (length <= 240L) {
            spacing = 2;
        } else if (length <= 480L) {
            spacing = 3;
        } else if (length <= 960L) {
            spacing = 4;
        } else if (length <= 1920L) {
            spacing = 5;
        }
        return spacing;
    }
}

