/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        long l = theme.notebookHandle;
        long l2 = OS.gtk_widget_get_style(l);
        long l3 = gC.getGCData().drawable;
        theme.transferClipping(gC, l2);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        n4 -= this.tabsHeight;
        int n5 = this.selectedX;
        int n6 = this.selectedWidth;
        int n7 = 2;
        if ((this.style & 0x400) != 0) {
            n7 = 3;
        } else {
            n2 += this.tabsHeight;
        }
        byte[] byArray = Converter.wcsToMbcs(null, "notebook", true);
        this.gtk_render_frame_gap(l2, l3, this.getStateType(0), 2, null, l, byArray, n, n2, n3, n4, n7, n5, n6);
        if (this.tabsArea != null) {
            this.tabsArea.x = rectangle.x;
            this.tabsArea.y = rectangle.y;
            this.tabsArea.width = rectangle.width;
            this.tabsArea.height = this.tabsHeight;
            if ((this.style & 0x400) != 0) {
                this.tabsArea.y += rectangle.height - this.tabsHeight;
            }
        }
    }

    @Override
    int getStateType(int n) {
        return 0;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }

    void gtk_render_frame_gap(long l, long l2, int n, int n2, GdkRectangle gdkRectangle, long l3, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (OS.GTK3) {
            long l4 = OS.gdk_cairo_create(l2);
            long l5 = OS.gtk_widget_get_style_context(l);
            OS.gtk_render_frame_gap(l5, l4, l5, n4, n9, n6, n7, n8, n8 + n9);
            Cairo.cairo_destroy(l4);
        } else {
            OS.gtk_paint_box_gap(l, l2, n, n2, gdkRectangle, l3, byArray, n3, n4, n5, n6, n7, n8, n9);
        }
    }
}

