// Generated by gmmproc 2.54.1 -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTTAG_H
#define _GTKMM_TEXTTAG_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glibmm/object.h>
#include <gtkmm/enums.h>
#include <gdkmm/color.h>
#include <gdkmm/rgba.h>
#include <pangomm/fontdescription.h>
#include <pangomm/tabarray.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkTextTag = struct _GtkTextTag;
using GtkTextTagClass = struct _GtkTextTagClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class TextTag_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

class TextIter;

/** Typedefed as Gtk::TextBuffer::Tag.
 *
 * Text in a buffer can be marked with tags. A tag is an attribute that can be applied to some range of text. For example, a tag
 * might be called "bold" and might make the text inside the tag bold. However, the tag concept is more general than that; tags don't
 * have to affect appearance. They can instead affect the behavior of mouse and key presses, "lock" a range of text so the user
 * can't edit it, or countless other things.
 * One tag can be applied to any number of text ranges in any number of @link Gtk::TextBuffer Gtk::TextBuffers@endlink.
 *
 * Each tag is stored in a @link Gtk::TextTagTable Gtk::TextBuffer::TagTable@endlink, and Tags should be in the
 * @link Gtk::TextTagTable Gtk::TextBuffer::TagTable@endlink for a given Gtk::TextBuffer before using
 * them with that buffer.
 *
 * Tags can have names, which is convenient sometimes (for example, you can name your tag that makes things bold "bold"), but
 * they can also be anonymous (which is convenient if you're creating tags on-the-fly).
 *
 * Gtk::TextBuffer::create_tag() is the best way to create tags. See the demo for numerous examples.
 *
 * @ingroup TextView
 */

class TextTag : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = TextTag;
  using CppClassType = TextTag_Class;
  using BaseObjectType = GtkTextTag;
  using BaseClassType = GtkTextTagClass;

  // noncopyable
  TextTag(const TextTag&) = delete;
  TextTag& operator=(const TextTag&) = delete;

private:  friend class TextTag_Class;
  static CppClassType texttag_class_;

protected:
  explicit TextTag(const Glib::ConstructParams& construct_params);
  explicit TextTag(GtkTextTag* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  TextTag(TextTag&& src) noexcept;
  TextTag& operator=(TextTag&& src) noexcept;

  ~TextTag() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTextTag*       gobj()       { return reinterpret_cast<GtkTextTag*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkTextTag* gobj() const { return reinterpret_cast<GtkTextTag*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkTextTag* gobj_copy();

private:

protected:
  TextTag();
    explicit TextTag(const Glib::ustring& name);


public:
  
  static Glib::RefPtr<TextTag> create();

  
  static Glib::RefPtr<TextTag> create(const Glib::ustring& name);


  /** Get the tag priority.
   * 
   * @return The tag’s priority.
   */
  int get_priority() const;
  
  /** Sets the priority of a Gtk::TextTag. Valid priorities
   * start at 0 and go to one less than Gtk::TextTagTable::get_size().
   * Each tag in a table has a unique priority; setting the priority
   * of one tag shifts the priorities of all the other tags in the
   * table to maintain a unique priority for each tag. Higher priority
   * tags “win” if two tags both set the same text attribute. When adding
   * a tag to a tag table, it will be assigned the highest priority in
   * the table by default; so normally the precedence of a set of tags
   * is the order in which they were added to the table, or created with
   * Gtk::TextBuffer::create_tag(), which adds the tag to the buffer’s table
   * automatically.
   * 
   * @param priority The new priority.
   */
  void set_priority(int priority);
  
  /** Emits the “event” signal on the Gtk::TextTag.
   * 
   * @param event_object Object that received the event, such as a widget.
   * @param gdk_event The event.
   * @param iter Location where the event was received.
   * @return Result of signal emission (whether the event was handled).
   */
  bool event(const Glib::RefPtr<Glib::Object>& event_object, GdkEvent* gdk_event, const TextIter& iter);
  
  /** Emits the Gtk::TextTagTable::signal_tag_changed() signal on the Gtk::TextTagTable where
   * the tag is included.
   * 
   * The signal is already emitted when setting a Gtk::TextTag property. This
   * function is useful for a Gtk::TextTag subclass.
   * 
   * @newin{3,20}
   * 
   * @param size_changed Whether the change affects the Gtk::TextView layout.
   */
  void tag_changed(bool size_changed);

 
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%event(const Glib::RefPtr<Glib::Object>& event_object, GdkEvent* gdk_event, const TextIter& iter)</tt>
   *
   * Flags: Run Last
   *
   * The signal_event() signal is emitted when an event occurs on a region of the
   * buffer marked with this tag.
   * 
   * @param event_object The object the event was fired from (typically a Gtk::TextView).
   * @param gdk_event The event which triggered the signal.
   * @param iter A Gtk::TextIter pointing at the location the event occurred.
   * @return <tt>true</tt> to stop other handlers from being invoked for the
   * event. <tt>false</tt> to propagate the event further.
   */

  Glib::SignalProxy< bool,const Glib::RefPtr<Glib::Object>&,GdkEvent*,const TextIter& > signal_event();


  /** Name used to refer to the text tag. <tt>nullptr</tt> for anonymous tags.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;

 //construct-only.
  /** Background color as a string.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_WriteOnly that allows you to set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::ustring > property_background() ;


  /** Foreground color as a string.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_WriteOnly that allows you to set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::ustring > property_foreground() ;


#ifndef GTKMM_DISABLE_DEPRECATED

/** Background color as a Gdk::Color.
   * 
   * Deprecated: 3.4: Use Gtk::TextTag::property_background_rgba() instead.
   * 
   * @deprecated Use property_background_rgba() instead.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::Color > property_background_gdk() ;

/** Background color as a Gdk::Color.
   * 
   * Deprecated: 3.4: Use Gtk::TextTag::property_background_rgba() instead.
   * 
   * @deprecated Use property_background_rgba() instead.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::Color > property_background_gdk() const;

#endif // GTKMM_DISABLE_DEPRECATED

  /** Background color as a Gdk::RGBA.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::RGBA > property_background_rgba() ;

/** Background color as a Gdk::RGBA.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::RGBA > property_background_rgba() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

/** Foreground color as a Gdk::Color.
   * 
   * Deprecated: 3.4: Use Gtk::TextTag::property_foreground_rgba() instead.
   * 
   * @deprecated Use property_foreground_rgba() instead.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::Color > property_foreground_gdk() ;

/** Foreground color as a Gdk::Color.
   * 
   * Deprecated: 3.4: Use Gtk::TextTag::property_foreground_rgba() instead.
   * 
   * @deprecated Use property_foreground_rgba() instead.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::Color > property_foreground_gdk() const;

#endif // GTKMM_DISABLE_DEPRECATED

  /** Foreground color as a Gdk::RGBA.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::RGBA > property_foreground_rgba() ;

/** Foreground color as a Gdk::RGBA.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::RGBA > property_foreground_rgba() const;

  /** Font description as string, e.g.\ \\"Sans Italic 12\\". 
   * 
   * Note that the initial value of this property depends on
   * the internals of Pango::FontDescription.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_font() ;

/** Font description as string, e.g.\ \\"Sans Italic 12\\". 
   * 
   * Note that the initial value of this property depends on
   * the internals of Pango::FontDescription.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_font() const;

  /** Font description as a PangoFontDescription struct.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::FontDescription > property_font_desc() ;

/** Font description as a PangoFontDescription struct.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::FontDescription > property_font_desc() const;

  /** Name of the font family, e.g. Sans, Helvetica, Times, Monospace.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_family() ;

/** Name of the font family, e.g. Sans, Helvetica, Times, Monospace.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_family() const;

  /** Font style as a PangoStyle, e.g. PANGO_STYLE_ITALIC.
   *
   * Default value: Pango::STYLE_NORMAL
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::Style > property_style() ;

/** Font style as a PangoStyle, e.g. PANGO_STYLE_ITALIC.
   *
   * Default value: Pango::STYLE_NORMAL
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::Style > property_style() const;

  /** Font variant as a PangoVariant, e.g. PANGO_VARIANT_SMALL_CAPS.
   *
   * Default value: Pango::VARIANT_NORMAL
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::Variant > property_variant() ;

/** Font variant as a PangoVariant, e.g. PANGO_VARIANT_SMALL_CAPS.
   *
   * Default value: Pango::VARIANT_NORMAL
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::Variant > property_variant() const;

  /** Font weight as an integer, see predefined values in PangoWeight; for example, PANGO_WEIGHT_BOLD.
   *
   * Default value: 400
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_weight() ;

/** Font weight as an integer, see predefined values in PangoWeight; for example, PANGO_WEIGHT_BOLD.
   *
   * Default value: 400
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_weight() const;

  /** Font stretch as a PangoStretch, e.g. PANGO_STRETCH_CONDENSED.
   *
   * Default value: Pango::STRETCH_NORMAL
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::Stretch > property_stretch() ;

/** Font stretch as a PangoStretch, e.g. PANGO_STRETCH_CONDENSED.
   *
   * Default value: Pango::STRETCH_NORMAL
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::Stretch > property_stretch() const;

  /** Font size in Pango units.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_size() ;

/** Font size in Pango units.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_size() const;

  /** Font size in points.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_size_points() ;

/** Font size in points.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_size_points() const;

  /** Font size as a scale factor relative to the default font size. This properly adapts to theme changes etc. so is recommended. Pango predefines some scales such as PANGO_SCALE_X_LARGE.
   *
   * Default value: 1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_scale() ;

/** Font size as a scale factor relative to the default font size. This properly adapts to theme changes etc. so is recommended. Pango predefines some scales such as PANGO_SCALE_X_LARGE.
   *
   * Default value: 1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_scale() const;

  /** Pixels of blank space above paragraphs.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_pixels_above_lines() ;

/** Pixels of blank space above paragraphs.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_pixels_above_lines() const;

  /** Pixels of blank space below paragraphs.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_pixels_below_lines() ;

/** Pixels of blank space below paragraphs.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_pixels_below_lines() const;

  /** Pixels of blank space between wrapped lines in a paragraph.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_pixels_inside_wrap() ;

/** Pixels of blank space between wrapped lines in a paragraph.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_pixels_inside_wrap() const;

  /** Whether the text can be modified by the user.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_editable() ;

/** Whether the text can be modified by the user.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_editable() const;

  /** Whether to wrap lines never, at word boundaries, or at character boundaries.
   *
   * Default value: Gtk::WRAP_NONE
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< WrapMode > property_wrap_mode() ;

/** Whether to wrap lines never, at word boundaries, or at character boundaries.
   *
   * Default value: Gtk::WRAP_NONE
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< WrapMode > property_wrap_mode() const;

  /** Left, right, or center justification.
   *
   * Default value: Gtk::JUSTIFY_LEFT
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Justification > property_justification() ;

/** Left, right, or center justification.
   *
   * Default value: Gtk::JUSTIFY_LEFT
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Justification > property_justification() const;

  /** Text direction, e.g. right-to-left or left-to-right.
   *
   * Default value: Gtk::TEXT_DIR_NONE
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< TextDirection > property_direction() ;

/** Text direction, e.g. right-to-left or left-to-right.
   *
   * Default value: Gtk::TEXT_DIR_NONE
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< TextDirection > property_direction() const;

  /** Width of the left margin in pixels.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_left_margin() ;

/** Width of the left margin in pixels.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_left_margin() const;

  /** Amount to indent the paragraph, in pixels.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_indent() ;

/** Amount to indent the paragraph, in pixels.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_indent() const;

  /** Whether to strike through the text.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_strikethrough() ;

/** Whether to strike through the text.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_strikethrough() const;

  /** This property modifies the color of strikeouts. If not set, strikeouts
   * will use the forground color.
   * 
   * @newin{3,20}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::RGBA > property_strikethrough_rgba() ;

/** This property modifies the color of strikeouts. If not set, strikeouts
   * will use the forground color.
   * 
   * @newin{3,20}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::RGBA > property_strikethrough_rgba() const;

  /** Width of the right margin in pixels.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_right_margin() ;

/** Width of the right margin in pixels.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_right_margin() const;

  /** Style of underline for this text.
   *
   * Default value: Pango::UNDERLINE_NONE
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::Underline > property_underline() ;

/** Style of underline for this text.
   *
   * Default value: Pango::UNDERLINE_NONE
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::Underline > property_underline() const;

  /** This property modifies the color of underlines. If not set, underlines
   * will use the forground color.
   * 
   * If Gtk::TextTag::property_underline() is set to Pango::UNDERLINE_ERROR, an alternate
   * color may be applied instead of the foreground. Setting this property
   * will always override those defaults.
   * 
   * @newin{3,20}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::RGBA > property_underline_rgba() ;

/** This property modifies the color of underlines. If not set, underlines
   * will use the forground color.
   * 
   * If Gtk::TextTag::property_underline() is set to Pango::UNDERLINE_ERROR, an alternate
   * color may be applied instead of the foreground. Setting this property
   * will always override those defaults.
   * 
   * @newin{3,20}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::RGBA > property_underline_rgba() const;

  /** Offset of text above the baseline (below the baseline if rise is negative) in Pango units.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_rise() ;

/** Offset of text above the baseline (below the baseline if rise is negative) in Pango units.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_rise() const;

  /** Whether the background color fills the entire line height or only the height of the tagged characters.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_background_full_height() ;

/** Whether the background color fills the entire line height or only the height of the tagged characters.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_background_full_height() const;

  /** The language this text is in, as an ISO code. Pango can use this as a 
   * hint when rendering the text. If not set, an appropriate default will be 
   * used.
   * 
   * Note that the initial value of this property depends on the current
   * locale, see also gtk_get_default_language().
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_language() ;

/** The language this text is in, as an ISO code. Pango can use this as a 
   * hint when rendering the text. If not set, an appropriate default will be 
   * used.
   * 
   * Note that the initial value of this property depends on the current
   * locale, see also gtk_get_default_language().
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_language() const;

  /** Custom tabs for this text.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::TabArray > property_tabs() ;

/** Custom tabs for this text.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::TabArray > property_tabs() const;

  /** Whether this text is hidden.
   * 
   * Note that there may still be problems with the support for invisible 
   * text, in particular when navigating programmatically inside a buffer
   * containing invisible segments. 
   * 
   * @newin{2,8}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_invisible() ;

/** Whether this text is hidden.
   * 
   * Note that there may still be problems with the support for invisible 
   * text, in particular when navigating programmatically inside a buffer
   * containing invisible segments. 
   * 
   * @newin{2,8}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_invisible() const;

  /** The paragraph background color as a string.
   * 
   * @newin{2,8}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_WriteOnly that allows you to set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::ustring > property_paragraph_background() ;


#ifndef GTKMM_DISABLE_DEPRECATED

/** The paragraph background color as a Gdk::Color.
   * 
   * @newin{2,8}
   * 
   * Deprecated: 3.4: Use Gtk::TextTag::property_paragraph_background_rgba() instead.
   * 
   * @deprecated Use property_paragraph_background_rgba() instead.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::Color > property_paragraph_background_gdk() ;

/** The paragraph background color as a Gdk::Color.
   * 
   * @newin{2,8}
   * 
   * Deprecated: 3.4: Use Gtk::TextTag::property_paragraph_background_rgba() instead.
   * 
   * @deprecated Use property_paragraph_background_rgba() instead.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::Color > property_paragraph_background_gdk() const;

#endif // GTKMM_DISABLE_DEPRECATED

  /** The paragraph background color as a Gdk::RGBA.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::RGBA > property_paragraph_background_rgba() ;

/** The paragraph background color as a Gdk::RGBA.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::RGBA > property_paragraph_background_rgba() const;

  /** OpenType font features, as a string.
   * 
   * @newin{3,20}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_font_features() ;

/** OpenType font features, as a string.
   * 
   * @newin{3,20}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_font_features() const;

  /** Whether the margins accumulate or override each other.
   * 
   * When set to <tt>true</tt> the margins of this tag are added to the margins 
   * of any other non-accumulative margins present. When set to <tt>false</tt> 
   * the margins override one another (the default).
   * 
   * @newin{2,12}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_accumulative_margin() ;

/** Whether the margins accumulate or override each other.
   * 
   * When set to <tt>true</tt> the margins of this tag are added to the margins 
   * of any other non-accumulative margins present. When set to <tt>false</tt> 
   * the margins override one another (the default).
   * 
   * @newin{2,12}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_accumulative_margin() const;

  /** Whether this tag affects the background color.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_background_set() ;

/** Whether this tag affects the background color.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_background_set() const;

  /** Whether this tag affects the foreground color.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_foreground_set() ;

/** Whether this tag affects the foreground color.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_foreground_set() const;

  /** Whether this tag affects the font family.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_family_set() ;

/** Whether this tag affects the font family.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_family_set() const;

  /** Whether this tag affects the font style.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_style_set() ;

/** Whether this tag affects the font style.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_style_set() const;

  /** Whether this tag affects the font variant.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_variant_set() ;

/** Whether this tag affects the font variant.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_variant_set() const;

  /** Whether this tag affects the font weight.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_weight_set() ;

/** Whether this tag affects the font weight.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_weight_set() const;

  /** Whether this tag affects the font stretch.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_stretch_set() ;

/** Whether this tag affects the font stretch.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_stretch_set() const;

  /** Whether this tag affects the font size.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_size_set() ;

/** Whether this tag affects the font size.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_size_set() const;

  /** Whether this tag scales the font size by a factor.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_scale_set() ;

/** Whether this tag scales the font size by a factor.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_scale_set() const;

  /** Whether this tag affects the number of pixels above lines.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_pixels_above_lines_set() ;

/** Whether this tag affects the number of pixels above lines.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_pixels_above_lines_set() const;

  /** Whether this tag affects the number of pixels above lines.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_pixels_below_lines_set() ;

/** Whether this tag affects the number of pixels above lines.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_pixels_below_lines_set() const;

  /** Whether this tag affects the number of pixels between wrapped lines.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_pixels_inside_wrap_set() ;

/** Whether this tag affects the number of pixels between wrapped lines.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_pixels_inside_wrap_set() const;

  /** Whether this tag affects text editability.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_editable_set() ;

/** Whether this tag affects text editability.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_editable_set() const;

  /** Whether this tag affects line wrap mode.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_wrap_mode_set() ;

/** Whether this tag affects line wrap mode.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_wrap_mode_set() const;

  /** Whether this tag affects paragraph justification.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_justification_set() ;

/** Whether this tag affects paragraph justification.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_justification_set() const;

  /** Whether this tag affects the left margin.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_left_margin_set() ;

/** Whether this tag affects the left margin.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_left_margin_set() const;

  /** Whether this tag affects indentation.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_indent_set() ;

/** Whether this tag affects indentation.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_indent_set() const;

  /** Whether this tag affects strikethrough.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_strikethrough_set() ;

/** Whether this tag affects strikethrough.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_strikethrough_set() const;

  /** If the Gtk::TextTag::property_strikethrough_rgba() property has been set.
   * 
   * @newin{3,20}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_strikethrough_rgba_set() ;

/** If the Gtk::TextTag::property_strikethrough_rgba() property has been set.
   * 
   * @newin{3,20}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_strikethrough_rgba_set() const;

  /** Whether this tag affects the right margin.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_right_margin_set() ;

/** Whether this tag affects the right margin.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_right_margin_set() const;

  /** Whether this tag affects underlining.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_underline_set() ;

/** Whether this tag affects underlining.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_underline_set() const;

  /** If the Gtk::TextTag::property_underline_rgba() property has been set.
   * 
   * @newin{3,20}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_underline_rgba_set() ;

/** If the Gtk::TextTag::property_underline_rgba() property has been set.
   * 
   * @newin{3,20}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_underline_rgba_set() const;

  /** Whether this tag affects the rise.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_rise_set() ;

/** Whether this tag affects the rise.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_rise_set() const;

  /** Whether this tag affects background height.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_background_full_height_set() ;

/** Whether this tag affects background height.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_background_full_height_set() const;

  /** Whether this tag affects the language the text is rendered as.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_language_set() ;

/** Whether this tag affects the language the text is rendered as.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_language_set() const;

  /** Whether this tag affects tabs.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_tabs_set() ;

/** Whether this tag affects tabs.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_tabs_set() const;

  /** Whether this tag affects text visibility.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_invisible_set() ;

/** Whether this tag affects text visibility.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_invisible_set() const;

  /** Whether this tag affects the paragraph background color.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_paragraph_background_set() ;

/** Whether this tag affects the paragraph background color.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_paragraph_background_set() const;

  /** Whether font fallback is enabled.
   * 
   * When set to <tt>true</tt>, other fonts will be substituted
   * where the current font is missing glyphs.
   * 
   * @newin{3,16}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_fallback() ;

/** Whether font fallback is enabled.
   * 
   * When set to <tt>true</tt>, other fonts will be substituted
   * where the current font is missing glyphs.
   * 
   * @newin{3,16}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_fallback() const;

  /** Whether this tag affects font fallback.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_fallback_set() ;

/** Whether this tag affects font fallback.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_fallback_set() const;

  /** Extra spacing between graphemes, in Pango units.
   * 
   * @newin{3,16}
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_letter_spacing() ;

/** Extra spacing between graphemes, in Pango units.
   * 
   * @newin{3,16}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_letter_spacing() const;

  /** Whether this tag affects letter spacing.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_letter_spacing_set() ;

/** Whether this tag affects letter spacing.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_letter_spacing_set() const;

  /** Whether this tag affects font features.
   *
   * @newin{3,20}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_font_features_set() ;

/** Whether this tag affects font features.
   *
   * @newin{3,20}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_font_features_set() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_event().
  virtual bool on_event(const Glib::RefPtr<Glib::Object>& event_object, GdkEvent* gdk_event, const TextIter& iter);


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::TextTag
   */
  Glib::RefPtr<Gtk::TextTag> wrap(GtkTextTag* object, bool take_copy = false);
}


#endif /* _GTKMM_TEXTTAG_H */

