// Generated by gmmproc 2.54.1 -- DO NOT MODIFY!
#ifndef _GTKMM_STATUSICON_H
#define _GTKMM_STATUSICON_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2005 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 
#include <gtkmm/image.h>
#include <gtkmm/stockid.h>
#include <gtkmm/menu.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/types.h>
#include <gtkmm/object.h>
#include <gtkmm/tooltip.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkStatusIcon = struct _GtkStatusIcon;
using GtkStatusIconClass = struct _GtkStatusIconClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class StatusIcon_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** The "system tray" or notification area is normally used for transient icons that indicate some
 * special state. For example, a system tray icon might appear to tell the user that they have new
 * mail, or have an incoming instant message, or something along those lines. The basic idea is
 * that creating an icon in the notification area is less annoying than popping up a dialog.
 *
 * A StatusIcon object can be used to display an icon in a "system tray". The icon can have a
 * tooltip, and the user can interact with it by activating it or popping up a context menu.
 * Critical information should not solely be displayed in a StatusIcon, since it may not be
 * visible (e.g. when the user doesn't have a notification area on his panel). This can be checked
 * with is_embedded().
 *
 * On X11, the implementation follows the freedesktop.org "System Tray" specification.
 * Implementations of the "tray" side of this specification can be found e.g. in the GNOME and KDE
 * panel applications.
 *
 * @newin{2,10}
 */

class StatusIcon : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = StatusIcon;
  using CppClassType = StatusIcon_Class;
  using BaseObjectType = GtkStatusIcon;
  using BaseClassType = GtkStatusIconClass;

  // noncopyable
  StatusIcon(const StatusIcon&) = delete;
  StatusIcon& operator=(const StatusIcon&) = delete;

private:  friend class StatusIcon_Class;
  static CppClassType statusicon_class_;

protected:
  explicit StatusIcon(const Glib::ConstructParams& construct_params);
  explicit StatusIcon(GtkStatusIcon* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  StatusIcon(StatusIcon&& src) noexcept;
  StatusIcon& operator=(StatusIcon&& src) noexcept;

  ~StatusIcon() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkStatusIcon*       gobj()       { return reinterpret_cast<GtkStatusIcon*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkStatusIcon* gobj() const { return reinterpret_cast<GtkStatusIcon*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkStatusIcon* gobj_copy();

private:

protected:
  StatusIcon();
  
    explicit StatusIcon(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

    explicit StatusIcon(const StockID& stock);

    explicit StatusIcon(const Glib::ustring& icon_name);

    explicit StatusIcon(const Glib::RefPtr<const Gio::Icon>& icon);


public:
  /** Creates a new Gtk::StatusIcon object.
   * @return A Glib::RefPtr<> to a newly created Gtk::StatusIcon object.
   */
  
  static Glib::RefPtr<StatusIcon> create(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

  
  static Glib::RefPtr<StatusIcon> create(const StockID& stock_id);

  
  static Glib::RefPtr<StatusIcon> create(const Glib::ustring& icon_name);


 /** Creates a status icon displaying the file @a filename.
  * The image will be scaled down to fit in the available
  * space in the notification area, if necessary.
  *
  * @param filename A filename.
  * @result A new StatusIcon
  *
  * @newin{2,10}
  */
  static Glib::RefPtr<StatusIcon> create_from_file(const std::string& filename);
  

  /** Makes @a status_icon display @a pixbuf.
   * See new_from_pixbuf() for details.
   * 
   * @newin{2,10}
   * 
   * @param pixbuf A Gdk::Pixbuf or <tt>nullptr</tt>.
   */
  void set(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  
  /** Makes @a status_icon display the file @a filename.
   * See new_from_file() for details.
   * 
   * @newin{2,10}
   * 
   * @param filename A filename.
   */
  void set_from_file(const Glib::ustring& filename);
  
  /** Makes @a status_icon display the stock icon with the id @a stock_id.
   * See new_from_stock() for details.
   * 
   * @newin{2,10}
   * 
   * @param stock_id A stock icon id.
   */
  void set(const StockID& stock_id);
  
  /** Makes @a status_icon display the icon named @a icon_name from the 
   * current icon theme.
   * See new_from_icon_name() for details.
   * 
   * @newin{2,10}
   * 
   * @param icon_name An icon name.
   */
  void set(const Glib::ustring& icon_name);
  
  /** Makes @a status_icon display the Icon.
   * See new_from_gicon() for details.
   * 
   * @newin{2,14}
   * 
   * @param icon A GIcon.
   */
  void set(const Glib::RefPtr<const Gio::Icon>& icon);

  
  /** Gets the type of representation being used by the Gtk::StatusIcon
   * to store image data. If the Gtk::StatusIcon has no image data,
   * the return value will be Gtk::IMAGE_EMPTY. 
   * 
   * @newin{2,10}
   * 
   * @return The image representation being used.
   */
  ImageType get_storage_type() const;

  
  /** Gets the Gdk::Pixbuf being displayed by the Gtk::StatusIcon.
   * The storage type of the status icon must be Gtk::IMAGE_EMPTY or
   * Gtk::IMAGE_PIXBUF (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned pixbuf.
   * 
   * @newin{2,10}
   * 
   * @return The displayed pixbuf,
   * or <tt>nullptr</tt> if the image is empty.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_pixbuf();
  
  /** Gets the Gdk::Pixbuf being displayed by the Gtk::StatusIcon.
   * The storage type of the status icon must be Gtk::IMAGE_EMPTY or
   * Gtk::IMAGE_PIXBUF (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned pixbuf.
   * 
   * @newin{2,10}
   * 
   * @return The displayed pixbuf,
   * or <tt>nullptr</tt> if the image is empty.
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_pixbuf() const;

  
  /** Gets the id of the stock icon being displayed by the Gtk::StatusIcon.
   * The storage type of the status icon must be Gtk::IMAGE_EMPTY or
   * Gtk::IMAGE_STOCK (see get_storage_type()).
   * The returned string is owned by the Gtk::StatusIcon and should not
   * be freed or modified.
   * 
   * @newin{2,10}
   * 
   * @return Stock id of the displayed stock icon,
   * or <tt>nullptr</tt> if the image is empty.
   */
  StockID get_stock() const;
  
  /** Gets the name of the icon being displayed by the Gtk::StatusIcon.
   * The storage type of the status icon must be Gtk::IMAGE_EMPTY or
   * Gtk::IMAGE_ICON_NAME (see get_storage_type()).
   * The returned string is owned by the Gtk::StatusIcon and should not
   * be freed or modified.
   * 
   * @newin{2,10}
   * 
   * @return Name of the displayed icon, or <tt>nullptr</tt> if the image is empty.
   */
  Glib::ustring get_icon_name() const;

  
  /** Retrieves the Icon being displayed by the Gtk::StatusIcon.
   * The storage type of the status icon must be Gtk::IMAGE_EMPTY or
   * Gtk::IMAGE_GICON (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned Icon.
   * 
   * If this function fails, @a icon is left unchanged;
   * 
   * @newin{2,14}
   * 
   * @return The displayed icon, or <tt>nullptr</tt> if the image is empty.
   */
  Glib::RefPtr<Gio::Icon> get_icon();
  
  /** Retrieves the Icon being displayed by the Gtk::StatusIcon.
   * The storage type of the status icon must be Gtk::IMAGE_EMPTY or
   * Gtk::IMAGE_GICON (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned Icon.
   * 
   * If this function fails, @a icon is left unchanged;
   * 
   * @newin{2,14}
   * 
   * @return The displayed icon, or <tt>nullptr</tt> if the image is empty.
   */
  Glib::RefPtr<const Gio::Icon> get_icon() const;

  
  /** Gets the size in pixels that is available for the image. 
   * Stock icons and named icons adapt their size automatically
   * if the size of the notification area changes. For other
   * storage types, the size-changed signal can be used to
   * react to size changes.
   * 
   * Note that the returned size is only meaningful while the 
   * status icon is embedded (see is_embedded()).
   * 
   * @newin{2,10}
   * 
   * @return The size that is available for the image.
   */
  int get_size() const;

  
  /** Sets the Gdk::Screen where @a status_icon is displayed; if
   * the icon is already mapped, it will be unmapped, and
   * then remapped on the new screen.
   * 
   * @newin{2,12}
   * 
   * @param screen A Gdk::Screen.
   */
  void set_screen(const Glib::RefPtr<Gdk::Screen>& screen);
  
  /** Returns the Gdk::Screen associated with @a status_icon.
   * 
   * @newin{2,12}
   * 
   * @return A Gdk::Screen.
   */
  Glib::RefPtr<Gdk::Screen> get_screen();
  
  /** Returns the Gdk::Screen associated with @a status_icon.
   * 
   * @newin{2,12}
   * 
   * @return A Gdk::Screen.
   */
  Glib::RefPtr<const Gdk::Screen> get_screen() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets the tooltip of the status icon.
   * 
   * @newin{2,10}
   * 
   * Deprecated: 2.16: Use set_tooltip_text() instead.
   * 
   * @param tooltip_text The tooltip text, or <tt>nullptr</tt>.
   */
  void set_tooltip(const Glib::ustring& tooltip_text);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Shows or hides a status icon.
   * 
   * @newin{2,10}
   * 
   * @param visible <tt>true</tt> to show the status icon, <tt>false</tt> to hide it.
   */
  void set_visible(bool visible =  true);
  
  /** Returns whether the status icon is visible or not. 
   * Note that being visible does not guarantee that 
   * the user can actually see the icon, see also 
   * is_embedded().
   * 
   * @newin{2,10}
   * 
   * @return <tt>true</tt> if the status icon is visible.
   */
  bool get_visible() const;
  
  /** Makes the status icon start or stop blinking. 
   * Note that blinking user interface elements may be problematic
   * for some users, and thus may be turned off, in which case
   * this setting has no effect.
   * 
   * @newin{2,10}
   * 
   * Deprecated: 2.22: This function will be removed in GTK+ 3
   * 
   * @param blinking <tt>true</tt> to turn blinking on, <tt>false</tt> to turn it off.
   */
  void set_blinking(bool blinking =  true);
  
  /** Returns whether the icon is blinking, see 
   * set_blinking().
   * 
   * @newin{2,10}
   * 
   * Deprecated: 2.22: This function will be removed in GTK+ 3
   * 
   * @return <tt>true</tt> if the icon is blinking.
   */
  bool get_blinking() const;

  
  /** Returns whether the status icon is embedded in a notification
   * area. 
   * 
   * @newin{2,10}
   * 
   * @return <tt>true</tt> if the status icon is embedded in
   * a notification area.
   */
  bool is_embedded() const;

  /** Displays a menu aligned to the status icon, and makes it available for selection.
   * Applications can use this function to display context-sensitive menus.
   *
   * This is equivalent to the gtk_status_icon_position_menu() helper callback in GTK+,
   * which can be provided to gtk_menu_popup().
   *
   * See Gtk::Menu::popup() for more details.
   *
   * @param menu The menu to popup for the status icon.
   * @param button The mouse button which was pressed to initiate the event.
   * @param activate_time The time at which the activation event occurred.
   *
   * @newin{2,12}
   */
  void popup_menu_at_position(Menu& menu, guint button, guint32 activate_time);
  
   //Note that gtk_status_icon_position_menu() is meant to be used as a helpful callback when calling gtk_menu_popup().
   //We make it easier by just providing a popup method that uses it.

  //In gtk_status_icon_get_geometry(), any of the parameters may be NULL,
  //but we don't need 6 different overloads, with different parameters.
  //But we can add some if there are common cases.

  /** Obtains information about the location of the status icon
   * on screen. This information can be used to e.g. position
   * popups like notification bubbles.
   * See popup_menu_at_position() for a more convenient
   * alternative for positioning menus.
   *
   * Note that some platforms do not allow GTK+ to provide
   * this information.
   *
   * @param screen: The screen.
   * @param area The area occupied by the status icon.
   * @param orientation The orientation of the panel  in which the status icon is embedded. A panel
   * at the top or bottom of the screen is horizontal, a panel at the left or right is vertical.
   * @result true if the location information has been filled in.
   *
   * @newin{2,10}
   */
  bool get_geometry(Glib::RefPtr<Gdk::Screen>& screen, Gdk::Rectangle& area, Orientation& orientation);
  

  /** Returns the current value of the has-tooltip property.
   * See Gtk::StatusIcon::property_has_tooltip() for more information.
   * 
   * @newin{2,16}
   * 
   * @return Current value of has-tooltip on @a status_icon.
   */
  bool get_has_tooltip() const;
  
  /** Sets the has-tooltip property on @a status_icon to @a has_tooltip.
   * See Gtk::StatusIcon::property_has_tooltip() for more information.
   * 
   * @newin{2,16}
   * 
   * @param has_tooltip Whether or not @a status_icon has a tooltip.
   */
  void set_has_tooltip(bool has_tooltip =  true);
  
  /** Gets the contents of the tooltip for @a status_icon.
   * 
   * @newin{2,16}
   * 
   * @return The tooltip text, or <tt>nullptr</tt>.
   */
  Glib::ustring get_tooltip_text() const;
  
  /** Sets @a text as the contents of the tooltip.
   * 
   * This function will take care of setting Gtk::StatusIcon::property_has_tooltip() to
   * <tt>true</tt> and of the default handler for the Gtk::StatusIcon::signal_query_tooltip()
   * signal.
   * 
   * See also the Gtk::StatusIcon::property_tooltip_text() property and
   * Gtk::Tooltip::set_text().
   * 
   * @newin{2,16}
   * 
   * @param text The contents of the tooltip for @a status_icon.
   */
  void set_tooltip_text(const Glib::ustring& text);
  
  /** Gets the contents of the tooltip for @a status_icon.
   * 
   * @newin{2,16}
   * 
   * @return The tooltip text, or <tt>nullptr</tt>.
   */
  Glib::ustring get_tooltip_markup() const;
  
  /** Sets @a markup as the contents of the tooltip, which is marked up with
   * the Pango text markup language.
   * 
   * This function will take care of setting Gtk::StatusIcon::property_has_tooltip() to <tt>true</tt>
   * and of the default handler for the Gtk::StatusIcon::signal_query_tooltip() signal.
   * 
   * See also the Gtk::StatusIcon::property_tooltip_markup() property and
   * Gtk::Tooltip::set_markup().
   * 
   * @newin{2,16}
   * 
   * @param markup The contents of the tooltip for @a status_icon, or <tt>nullptr</tt>.
   */
  void set_tooltip_markup(const Glib::ustring& markup);
  
  /** Sets the title of this tray icon.
   * This should be a short, human-readable, localized string 
   * describing the tray icon. It may be used by tools like screen
   * readers to render the tray icon.
   * 
   * @newin{2,18}
   * 
   * @param title The title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Gets the title of this tray icon. See set_title().
   * 
   * @newin{2,18}
   * 
   * @return The title of the status icon.
   */
  Glib::ustring get_title() const;
  
  /** Sets the name of this tray icon.
   * This should be a string identifying this icon. It is may be
   * used for sorting the icons in the tray and will not be shown to
   * the user.
   * 
   * @newin{2,20}
   * 
   * @param name The name.
   */
  void set_name(const Glib::ustring& name);

  
  /** This function is only useful on the X11/freedesktop.org platform.
   * It returns a window ID for the widget in the underlying
   * status icon implementation.  This is useful for the Galago 
   * notification service, which can send a window ID in the protocol 
   * in order for the server to position notification windows 
   * pointing to a status icon reliably.
   * 
   * This function is not intended for other use cases which are
   * more likely to be met by one of the non-X11 specific methods, such
   * as position_menu().
   * 
   * @newin{2,14}
   * 
   * @return An 32 bit unsigned integer identifier for the 
   * underlying X11 Window.
   */
  guint32 get_x11_window_id() const;

  /** A GdkPixbuf to display.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_pixbuf() ;

/** A GdkPixbuf to display.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_pixbuf() const;

  /** Filename to load and display.
   *
   * @return A PropertyProxy_WriteOnly that allows you to set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< std::string > property_file() ;


  /** Stock ID for a stock image to display.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< StockID > property_stock() ;

/** Stock ID for a stock image to display.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< StockID > property_stock() const;

  /** The name of the icon from the icon theme.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_icon_name() ;

/** The name of the icon from the icon theme.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_icon_name() const;

  /** The GIcon being displayed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > property_gicon() ;

/** The GIcon being displayed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > property_gicon() const;

  /** The representation being used for image data.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ImageType > property_storage_type() const;


  /** The size of the icon.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_size() const;


  /** The screen where this status icon will be displayed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Screen> > property_screen() ;

/** The screen where this status icon will be displayed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Screen> > property_screen() const;

  /** Whether or not the status icon is blinking.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_blinking() ;

/** Whether or not the status icon is blinking.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_blinking() const;

  /** Whether or not the status icon is visible.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_visible() ;

/** Whether or not the status icon is visible.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_visible() const;

  /** Whether or not the status icon is embedded.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_embedded() const;


  /** The orientation of the tray.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Orientation > property_orientation() const;


  /** Whether this tray icon has a tooltip.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_tooltip() ;

/** Whether this tray icon has a tooltip.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_tooltip() const;

  /** The contents of the tooltip for this widget.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_tooltip_text() ;

/** The contents of the tooltip for this widget.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_tooltip_text() const;

  /** The contents of the tooltip for this tray icon.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_tooltip_markup() ;

/** The contents of the tooltip for this tray icon.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_tooltip_markup() const;

  /** The title of this tray icon.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** The title of this tray icon.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;


  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%size_changed(int size)</tt>
   *
   * Flags: Run Last
   *
   */

  Glib::SignalProxy< bool,int > signal_size_changed();


  //TODO: Remove no_default_handler when we can break ABI.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%activate()</tt>
   *
   * Flags: Run First
   *
   */

  Glib::SignalProxy< void > signal_activate();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%popup_menu(guint button, guint32 activate_time)</tt>
   *
   * Flags: Run First
   *
   */

  Glib::SignalProxy< void,guint,guint32 > signal_popup_menu();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%button_press_event(GdkEventButton* event)</tt>
   *
   * Flags: Run Last
   *
   */

  Glib::SignalProxy< bool,GdkEventButton* > signal_button_press_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%button_release_event(GdkEventButton* event)</tt>
   *
   * Flags: Run Last
   *
   */

  Glib::SignalProxy< bool,GdkEventButton* > signal_button_release_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%scroll_event(GdkEventScroll* event)</tt>
   *
   * Flags: Run Last
   *
   */

  Glib::SignalProxy< bool,GdkEventScroll* > signal_scroll_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%query_tooltip(int x, int y, bool keyboard_mode, const Glib::RefPtr<Tooltip>& tooltip)</tt>
   *
   * Flags: Run Last
   *
   */

  Glib::SignalProxy< bool,int,int,bool,const Glib::RefPtr<Tooltip>& > signal_query_tooltip();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_size_changed().
  virtual bool on_size_changed(int size);


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::StatusIcon
   */
  Glib::RefPtr<Gtk::StatusIcon> wrap(GtkStatusIcon* object, bool take_copy = false);
}


#endif /* _GTKMM_STATUSICON_H */

