/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Set;
import org.gradle.internal.FileUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.deprecation.Deprecatable;
import org.gradle.internal.deprecation.LoggingDeprecatable;
import org.gradle.internal.impldep.javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLayoutParameters
implements Deprecatable {
    public static final String GRADLE_USER_HOME_PROPERTY_KEY = "gradle.user.home";
    public static final String NO_SEARCH_UPWARDS_PROPERTY_KEY = "gradle.internal.noSearchUpwards";
    private static final File DEFAULT_GRADLE_USER_HOME = new File(SystemProperties.getInstance().getUserHome() + "/.gradle");
    private final Deprecatable deprecationHandler = new LoggingDeprecatable();
    private boolean searchUpwards = true;
    private File currentDir = FileUtils.canonicalize(SystemProperties.getInstance().getCurrentDir());
    private File projectDir;
    private File gradleUserHomeDir;

    public BuildLayoutParameters() {
        String gradleUserHome = System.getProperty(GRADLE_USER_HOME_PROPERTY_KEY);
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = DEFAULT_GRADLE_USER_HOME.getAbsolutePath();
        }
        this.gradleUserHomeDir = FileUtils.canonicalize(new File(gradleUserHome));
        String noSearchUpwards = System.getProperty(NO_SEARCH_UPWARDS_PROPERTY_KEY);
        if (noSearchUpwards != null) {
            this.searchUpwards = Boolean.valueOf(noSearchUpwards) == false;
        }
    }

    public BuildLayoutParameters setSearchUpwards(boolean searchUpwards) {
        this.searchUpwards = searchUpwards;
        return this;
    }

    public BuildLayoutParameters setProjectDir(File projectDir) {
        this.projectDir = projectDir;
        return this;
    }

    public BuildLayoutParameters setGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        return this;
    }

    public BuildLayoutParameters setCurrentDir(File currentDir) {
        this.currentDir = currentDir;
        return this;
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    @Nullable
    public File getProjectDir() {
        return this.projectDir;
    }

    public File getSearchDir() {
        return this.projectDir != null ? this.projectDir : this.currentDir;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public boolean getSearchUpwards() {
        return this.searchUpwards;
    }

    @Override
    public void addDeprecation(String deprecation) {
        this.deprecationHandler.addDeprecation(deprecation);
    }

    @Override
    public Set<String> getDeprecations() {
        return this.deprecationHandler.getDeprecations();
    }

    @Override
    public void checkDeprecation() {
        this.deprecationHandler.checkDeprecation();
    }
}

