/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.rse.core.IRSESystemType;

public final class SystemTypeMatcher {
    private final List patterns = new LinkedList();
    private boolean matchAllTypes = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.SystemTypeMatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SystemTypeMatcher(String declaredSystemTypeIds) {
        String[] ids;
        if (declaredSystemTypeIds != null && (ids = declaredSystemTypeIds.split(";")) != null && ids.length > 0) {
            int i = 0;
            while (i < ids.length) {
                String id = ids[i].trim();
                if (id.equals("*")) {
                    this.matchAllTypes = true;
                    this.patterns.clear();
                    return;
                }
                if (id.length() > 0) {
                    SystemTypeIdPattern pattern = new SystemTypeIdPattern(Pattern.compile(this.makeRegex(id)));
                    this.patterns.add(pattern);
                }
                ++i;
            }
        }
    }

    private String makeRegex(String pattern) {
        if (!$assertionsDisabled && pattern == null) {
            throw new AssertionError();
        }
        String translated = pattern;
        if (translated.indexOf(46) != -1) {
            translated = translated.replaceAll("\\.", "\\.");
        }
        if (translated.indexOf(42) != -1) {
            translated = translated.replaceAll("\\*", ".*");
        }
        if (translated.indexOf(63) != -1) {
            translated = translated.replaceAll("\\?", ".");
        }
        return translated;
    }

    public boolean supportsAllSystemTypes() {
        return this.matchAllTypes;
    }

    public boolean matches(IRSESystemType systemType) {
        if (!$assertionsDisabled && systemType == null) {
            throw new AssertionError();
        }
        if (this.matchAllTypes) {
            return true;
        }
        Iterator iterator = this.patterns.iterator();
        while (iterator.hasNext()) {
            SystemTypeIdPattern matcher = (SystemTypeIdPattern)iterator.next();
            if (!matcher.matches(systemType)) continue;
            return true;
        }
        return false;
    }

    private final class SystemTypeIdPattern {
        private final Pattern pattern;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.SystemTypeMatcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public SystemTypeIdPattern(Pattern pattern) {
            if (!$assertionsDisabled && pattern == null) {
                throw new AssertionError();
            }
            this.pattern = pattern;
        }

        public boolean matches(IRSESystemType systemType) {
            if (!$assertionsDisabled && systemType == null) {
                throw new AssertionError();
            }
            return this.pattern.matcher(systemType.getId()).matches();
        }
    }
}

