/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.bower.internal.launch.shortcut;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.wst.jsdt.js.bower.BowerPlugin;
import org.eclipse.wst.jsdt.js.bower.util.BowerUtil;

public abstract class GenericBowerLaunch
implements ILaunchShortcut {
    protected abstract String getCommandName();

    public void launch(ISelection selection, String mode) {
        Object element;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            IResource selectedResource = (IResource)element;
            this.launch(selectedResource, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput = editor.getEditorInput();
        IFile file = ResourceUtil.getFile((IEditorInput)editorInput);
        if (file != null && file.exists() && "bower.json".equals(file.getName())) {
            this.launch((IResource)file, mode);
        }
    }

    private void launch(IResource resource, String mode) {
        try {
            IProject project = resource.getProject();
            IPath workingDirectory = this.getWorkingDirectory(resource);
            if (project.exists() && workingDirectory != null) {
                String projectName = project.getName();
                ILaunchConfigurationType bowerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.jsdt.js.bower.bowerLaunchConfigurationType");
                ILaunchConfigurationWorkingCopy bowerLaunch = bowerLaunchType.newInstance(null, this.generateLaunchName(projectName));
                bowerLaunch.setAttribute("org.eclipse.wst.jsdt.js.bower.COMMAND", this.getCommandName());
                bowerLaunch.setAttribute("org.eclipse.wst.jsdt.js.bower.PROJECT", projectName);
                bowerLaunch.setAttribute("org.eclipse.wst.jsdt.js.bower.DIR", workingDirectory.toOSString());
                DebugUITools.launch((ILaunchConfiguration)bowerLaunch, (String)mode);
            }
        }
        catch (CoreException e) {
            BowerPlugin.logError(e, e.getMessage());
        }
    }

    private String generateLaunchName(String projectName) {
        return String.valueOf(projectName) + " [" + "bower" + " " + this.getCommandName() + "]";
    }

    private IPath getWorkingDirectory(IResource resource) throws CoreException {
        IPath workingDir = null;
        if (resource != null && resource.exists()) {
            if (resource.getType() == 1 && "bower.json".equals(resource.getName())) {
                workingDir = resource.getParent().getLocation();
            } else if (resource.getType() == 2) {
                workingDir = resource.getLocation();
            } else if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                IFile file = project.getFile("bower.json");
                if (file.exists()) {
                    workingDir = resource.getLocation();
                } else {
                    try {
                        workingDir = this.getWorkingDirectory(project);
                    }
                    catch (IOException e) {
                        BowerPlugin.logError(e);
                    }
                }
            }
        }
        return workingDir;
    }

    private IPath getWorkingDirectory(IProject project) throws CoreException, UnsupportedEncodingException {
        IPath workingDir = null;
        IFile bowerrc = BowerUtil.getBowerrc(project);
        if (bowerrc != null) {
            IContainer parent = bowerrc.getParent();
            if (parent.exists() && parent.findMember("bower.json") != null) {
                workingDir = parent.getLocation();
            } else {
                String directoryName = BowerUtil.getDirectoryName(bowerrc);
                directoryName = directoryName != null ? directoryName : "bower_components";
                workingDir = BowerUtil.getBowerWorkingDir(project, directoryName);
            }
        } else {
            workingDir = BowerUtil.getBowerWorkingDir(project, "bower_components");
        }
        return workingDir;
    }
}

