/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsole;
import org.eclipse.cdt.dsf.gdb.internal.service.IGDBFocusSynchronizer;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.DebugUITools;

public interface IGDBDebuggerConsole
extends IDebuggerConsole {
    default public void consoleSelected() {
        final DsfSession session = ((GdbLaunch)this.getLaunch()).getSession();
        if (!session.isActive()) {
            return;
        }
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null) {
            ILaunch selectedLaunch = (ILaunch)context.getAdapter(ILaunch.class);
            if (this.getLaunch().equals(selectedLaunch)) {
                return;
            }
        }
        session.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
                IGDBFocusSynchronizer gdbSync = (IGDBFocusSynchronizer)tracker.getService(IGDBFocusSynchronizer.class);
                tracker.dispose();
                if (gdbSync != null) {
                    gdbSync.sessionSelected();
                }
            }
        });
    }
}

