# -*- coding: utf-8 -*-

"""
VirtualBox COM/XPCOM constants.

This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
"""

__copyright__ = \
"""
Copyright (C) 2009-2016 Oracle Corporation

This file is part of VirtualBox Open Source Edition (OSE), as
available from http://www.virtualbox.org. This file is free software;
you can redistribute it and/or modify it under the terms of the GNU
General Public License (GPL) as published by the Free Software
Foundation, in version 2 as it comes in the "COPYING" file of the
VirtualBox OSE distribution. VirtualBox OSE is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.

The contents of this file may alternatively be used under the terms
of the Common Development and Distribution License Version 1.0
(CDDL) only, as it comes in the "COPYING.CDDL" file of the
VirtualBox OSE distribution, in which case the provisions of the
CDDL are applicable instead of those of the GPL.

You may elect to license modified versions of this file under the
terms and conditions of either the GPL or the CDDL or both.
"""

__version__ = "$Revision: 131592 $";



class VirtualBoxReflectionInfo:
    """
    Enum constants for the various python styles.
    """

    def __init__(self, fIsSym):
        self.__fIsSym = fIsSym

    # iprt/err.h + VBox/err.h constants:
    __dVBoxStatuses = {
        'VINF_SUCCESS': 0,
        'VERR_GENERAL_FAILURE': -1,
        'VERR_INVALID_PARAMETER': -2,
        'VWRN_INVALID_PARAMETER': 2,
        'VERR_INVALID_MAGIC': -3,
        'VWRN_INVALID_MAGIC': 3,
        'VERR_INVALID_HANDLE': -4,
        'VWRN_INVALID_HANDLE': 4,
        'VERR_LOCK_FAILED': -5,
        'VERR_INVALID_POINTER': -6,
        'VERR_IDT_FAILED': -7,
        'VERR_NO_MEMORY': -8,
        'VERR_ALREADY_LOADED': -9,
        'VERR_PERMISSION_DENIED': -10,
        'VINF_PERMISSION_DENIED': 10,
        'VERR_VERSION_MISMATCH': -11,
        'VERR_NOT_IMPLEMENTED': -12,
        'VINF_NOT_IMPLEMENTED': 12,
        'VERR_INVALID_FLAGS': -13,
        'VERR_NOT_EQUAL': -18,
        'VERR_NOT_SYMLINK': -19,
        'VERR_NO_TMP_MEMORY': -20,
        'VERR_INVALID_FMODE': -21,
        'VERR_WRONG_ORDER': -22,
        'VERR_NO_TLS_FOR_SELF': -23,
        'VERR_FAILED_TO_SET_SELF_TLS': -24,
        'VERR_NO_CONT_MEMORY': -26,
        'VERR_NO_PAGE_MEMORY': -27,
        'VINF_ALREADY_INITIALIZED': 28,
        'VERR_THREAD_IS_DEAD': -29,
        'VERR_THREAD_NOT_WAITABLE': -30,
        'VERR_PAGE_TABLE_NOT_PRESENT': -31,
        'VERR_INVALID_CONTEXT': -32,
        'VERR_TIMER_BUSY': -33,
        'VERR_ADDRESS_CONFLICT': -34,
        'VERR_UNRESOLVED_ERROR': -35,
        'VERR_INVALID_FUNCTION': -36,
        'VERR_NOT_SUPPORTED': -37,
        'VINF_NOT_SUPPORTED': 37,
        'VERR_ACCESS_DENIED': -38,
        'VERR_INTERRUPTED': -39,
        'VINF_INTERRUPTED': 39,
        'VERR_TIMEOUT': -40,
        'VINF_TIMEOUT': 40,
        'VERR_BUFFER_OVERFLOW': -41,
        'VINF_BUFFER_OVERFLOW': 41,
        'VERR_TOO_MUCH_DATA': -42,
        'VERR_MAX_THRDS_REACHED': -43,
        'VERR_MAX_PROCS_REACHED': -44,
        'VERR_SIGNAL_REFUSED': -45,
        'VERR_SIGNAL_PENDING': -46,
        'VERR_SIGNAL_INVALID': -47,
        'VERR_STATE_CHANGED': -48,
        'VWRN_STATE_CHANGED': 48,
        'VERR_INVALID_UUID_FORMAT': -49,
        'VERR_PROCESS_NOT_FOUND': -50,
        'VERR_PROCESS_RUNNING': -51,
        'VERR_TRY_AGAIN': -52,
        'VINF_TRY_AGAIN': 52,
        'VERR_PARSE_ERROR': -53,
        'VERR_OUT_OF_RANGE': -54,
        'VERR_NUMBER_TOO_BIG': -55,
        'VWRN_NUMBER_TOO_BIG': 55,
        'VERR_NO_DIGITS': -56,
        'VWRN_NO_DIGITS': 56,
        'VERR_NEGATIVE_UNSIGNED': -57,
        'VWRN_NEGATIVE_UNSIGNED': 57,
        'VERR_NO_TRANSLATION': -58,
        'VWRN_NO_TRANSLATION': 58,
        'VERR_CODE_POINT_ENDIAN_INDICATOR': -59,
        'VERR_CODE_POINT_SURROGATE': -60,
        'VERR_INVALID_UTF8_ENCODING': -61,
        'VERR_INVALID_UTF16_ENCODING': -62,
        'VERR_CANT_RECODE_AS_UTF16': -63,
        'VERR_NO_STR_MEMORY': -64,
        'VERR_NO_UTF16_MEMORY': -65,
        'VERR_NO_CODE_POINT_MEMORY': -66,
        'VERR_MEMORY_BUSY': -67,
        'VERR_TIMER_ACTIVE': -68,
        'VERR_TIMER_SUSPENDED': -69,
        'VERR_CANCELLED': -70,
        'VERR_MEMOBJ_INIT_FAILED': -71,
        'VERR_NO_LOW_MEMORY': -72,
        'VERR_NO_PHYS_MEMORY': -73,
        'VERR_ADDRESS_TOO_BIG': -74,
        'VERR_MAP_FAILED': -75,
        'VERR_TRAILING_CHARS': -76,
        'VWRN_TRAILING_CHARS': 76,
        'VERR_TRAILING_SPACES': -77,
        'VWRN_TRAILING_SPACES': 77,
        'VERR_NOT_FOUND': -78,
        'VWRN_NOT_FOUND': 78,
        'VERR_INVALID_STATE': -79,
        'VWRN_INVALID_STATE': 79,
        'VERR_OUT_OF_RESOURCES': -80,
        'VWRN_OUT_OF_RESOURCES': 80,
        'VERR_NO_MORE_HANDLES': -81,
        'VERR_PREEMPT_DISABLED': -82,
        'VERR_END_OF_STRING': -83,
        'VINF_END_OF_STRING': 83,
        'VERR_PAGE_COUNT_OUT_OF_RANGE': -84,
        'VERR_OBJECT_DESTROYED': -85,
        'VINF_OBJECT_DESTROYED': 85,
        'VERR_DANGLING_OBJECTS': -86,
        'VWRN_DANGLING_OBJECTS': 86,
        'VERR_INVALID_BASE64_ENCODING': -87,
        'VERR_CALLBACK_RETURN': -88,
        'VINF_CALLBACK_RETURN': 88,
        'VERR_AUTHENTICATION_FAILURE': -89,
        'VERR_NOT_POWER_OF_TWO': -90,
        'VERR_IGNORED': -91,
        'VERR_CONCURRENT_ACCESS': -92,
        'VERR_CALLER_NO_REFERENCE': -93,
        'VERR_NO_CHANGE': -95,
        'VINF_NO_CHANGE': 95,
        'VERR_NO_EXEC_MEMORY': -96,
        'VERR_UNSUPPORTED_ALIGNMENT': -97,
        'VINF_UNSUPPORTED_ALIGNMENT': 97,
        'VERR_DUPLICATE': -98,
        'VERR_MISSING': -99,
        'VERR_UNEXPECTED_EXCEPTION': -22400,
        'VERR_BUFFER_UNDERFLOW': -22401,
        'VINF_BUFFER_UNDERFLOW': 22401,
        'VERR_UNEVEN_INPUT': -22402,
        'VERR_NOT_AVAILABLE': -22403,
        'VERR_PROC_DETACH_NOT_SUPPORTED': -22404,
        'VERR_ACCOUNT_RESTRICTED': -22405,
        'VINF_ACCOUNT_RESTRICTED': 22405,
        'VERR_UNABLE_TO_SATISFY_REQUIREMENTS': -22406,
        'VWRN_UNABLE_TO_SATISFY_REQUIREMENTS': 22406,
        'VERR_ALLOCATION_TOO_BIG': -22407,
        'VERR_MISMATCH': -22408,
        'VERR_WRONG_TYPE': -22409,
        'VWRN_WRONG_TYPE': 22409,
        'VERR_PRIVILEGE_NOT_HELD': -22410,
        'VERR_PROC_TCB_PRIV_NOT_HELD': -22411,
        'VERR_PROC_APT_PRIV_NOT_HELD': -22412,
        'VERR_PROC_IQ_PRIV_NOT_HELD': -22413,
        'VERR_MP_TOO_MANY_CPUS': -22414,
        'VERR_WRONG_PARAMETER_COUNT': -22415,
        'VERR_WRONG_PARAMETER_TYPE': -22416,
        'VERR_INVALID_CLIENT_ID': -22417,
        'VERR_INVALID_SESSION_ID': -22418,
        'VERR_PROC_ELEVATION_REQUIRED': -22419,
        'VERR_INCOMPATIBLE_CONFIG': -22420,
        'VERR_NO_STRING_TERMINATOR': -22421,
        'VERR_EMPTY_STRING': -22422,
        'VERR_TOO_MANY_REFERENCES': -22423,
        'VERR_FILE_IO_ERROR': -100,
        'VERR_OPEN_FAILED': -101,
        'VERR_FILE_NOT_FOUND': -102,
        'VERR_PATH_NOT_FOUND': -103,
        'VERR_INVALID_NAME': -104,
        'VERR_ALREADY_EXISTS': -105,
        'VWRN_ALREADY_EXISTS': 105,
        'VERR_TOO_MANY_OPEN_FILES': -106,
        'VERR_SEEK': -107,
        'VERR_NEGATIVE_SEEK': -108,
        'VERR_SEEK_ON_DEVICE': -109,
        'VERR_EOF': -110,
        'VINF_EOF': 110,
        'VERR_READ_ERROR': -111,
        'VERR_WRITE_ERROR': -112,
        'VERR_WRITE_PROTECT': -113,
        'VERR_SHARING_VIOLATION': -114,
        'VERR_FILE_LOCK_FAILED': -115,
        'VERR_FILE_LOCK_VIOLATION': -116,
        'VERR_CANT_CREATE': -117,
        'VERR_CANT_DELETE_DIRECTORY': -118,
        'VERR_NOT_SAME_DEVICE': -119,
        'VERR_FILENAME_TOO_LONG': -120,
        'VERR_MEDIA_NOT_PRESENT': -121,
        'VERR_MEDIA_NOT_RECOGNIZED': -122,
        'VERR_FILE_NOT_LOCKED': -123,
        'VERR_FILE_LOCK_LOST': -124,
        'VERR_DIR_NOT_EMPTY': -125,
        'VERR_NOT_A_DIRECTORY': -126,
        'VERR_IS_A_DIRECTORY': -127,
        'VERR_FILE_TOO_BIG': -128,
        'VERR_FILE_AIO_NO_REQUEST': -129,
        'VERR_FILE_AIO_IN_PROGRESS': -130,
        'VERR_FILE_AIO_COMPLETED': -131,
        'VERR_FILE_AIO_BUSY': -132,
        'VERR_FILE_AIO_LIMIT_EXCEEDED': -133,
        'VERR_FILE_AIO_CANCELED': -134,
        'VERR_FILE_AIO_NOT_SUBMITTED': -135,
        'VERR_FILE_AIO_NOT_PREPARED': -136,
        'VERR_FILE_AIO_INSUFFICIENT_RESSOURCES': -137,
        'VERR_RESOURCE_BUSY': -138,
        'VERR_NOT_A_FILE': -139,
        'VERR_IS_A_FILE': -140,
        'VERR_UNEXPECTED_FS_OBJ_TYPE': -141,
        'VERR_PATH_DOES_NOT_START_WITH_ROOT': -142,
        'VERR_PATH_IS_RELATIVE': -143,
        'VERR_PATH_IS_NOT_RELATIVE': -144,
        'VERR_PATH_ZERO_LENGTH': -145,
        'VERR_FILE_AIO_INSUFFICIENT_EVENTS': -146,
        'VERR_DISK_IO_ERROR': -150,
        'VERR_INVALID_DRIVE': -151,
        'VERR_DISK_FULL': -152,
        'VERR_DISK_CHANGE': -153,
        'VERR_DRIVE_LOCKED': -154,
        'VERR_DISK_INVALID_FORMAT': -155,
        'VERR_TOO_MANY_SYMLINKS': -156,
        'VERR_NS_SYMLINK_SET_TIME': -157,
        'VERR_NS_SYMLINK_CHANGE_OWNER': -158,
        'VERR_SYMLINK_NOT_ALLOWED': -159,
        'VERR_IS_A_SYMLINK': -160,
        'VERR_IS_A_FIFO': -161,
        'VERR_IS_A_SOCKET': -162,
        'VERR_IS_A_BLOCK_DEVICE': -163,
        'VERR_IS_A_CHAR_DEVICE': -164,
        'VERR_DRIVE_IS_EMPTY': -165,
        'VERR_SEARCH_ERROR': -200,
        'VERR_NO_MORE_FILES': -201,
        'VERR_NO_MORE_SEARCH_HANDLES': -202,
        'VWRN_NO_DIRENT_INFO': 203,
        'VERR_INTERNAL_ERROR': -225,
        'VERR_INTERNAL_ERROR_2': -226,
        'VERR_INTERNAL_ERROR_3': -227,
        'VERR_INTERNAL_ERROR_4': -228,
        'VERR_INTERNAL_ERROR_5': -229,
        'VERR_IPE_UNEXPECTED_STATUS': -230,
        'VERR_IPE_UNEXPECTED_INFO_STATUS': -231,
        'VERR_IPE_UNEXPECTED_ERROR_STATUS': -232,
        'VERR_IPE_UNINITIALIZED_STATUS': -233,
        'VERR_IPE_NOT_REACHED_DEFAULT_CASE': -234,
        'VERR_DEV_IO_ERROR': -250,
        'VERR_IO_BAD_UNIT': -251,
        'VERR_IO_NOT_READY': -252,
        'VERR_IO_BAD_COMMAND': -253,
        'VERR_IO_CRC': -254,
        'VERR_IO_BAD_LENGTH': -255,
        'VERR_IO_SECTOR_NOT_FOUND': -256,
        'VERR_IO_GEN_FAILURE': -257,
        'VERR_PIPE_IO_ERROR': -300,
        'VERR_BROKEN_PIPE': -301,
        'VERR_BAD_PIPE': -302,
        'VERR_PIPE_BUSY': -303,
        'VERR_NO_DATA': -304,
        'VERR_PIPE_NOT_CONNECTED': -305,
        'VERR_MORE_DATA': -306,
        'VERR_PIPE_NOT_READ': -307,
        'VERR_PIPE_NOT_WRITE': -308,
        'VERR_SEM_ERROR': -350,
        'VERR_TOO_MANY_SEMAPHORES': -351,
        'VERR_EXCL_SEM_ALREADY_OWNED': -352,
        'VERR_SEM_IS_SET': -353,
        'VERR_TOO_MANY_SEM_REQUESTS': -354,
        'VERR_NOT_OWNER': -355,
        'VERR_TOO_MANY_OPENS': -356,
        'VERR_TOO_MANY_POSTS': -357,
        'VERR_ALREADY_POSTED': -358,
        'VINF_ALREADY_POSTED': 358,
        'VERR_ALREADY_RESET': -359,
        'VERR_SEM_BUSY': -360,
        'VERR_SEM_OWNER_DIED': -361,
        'VERR_SEM_NOT_FOUND': -362,
        'VERR_SEM_DESTROYED': -363,
        'VERR_SEM_NESTED': -364,
        'VINF_SEM_NESTED': 364,
        'VERR_DEADLOCK': -365,
        'VERR_SEM_OUT_OF_TURN': -366,
        'VERR_SEM_BAD_CONTEXT': -367,
        'VINF_SEM_BAD_CONTEXT': 367,
        'VERR_SEM_LV_WRONG_ORDER': -368,
        'VERR_SEM_LV_WRONG_RELEASE_ORDER': -369,
        'VERR_SEM_LV_NESTED': -370,
        'VERR_SEM_LV_INVALID_PARAMETER': -371,
        'VERR_SEM_LV_DEADLOCK': -372,
        'VERR_SEM_LV_EXISTING_DEADLOCK': -373,
        'VERR_SEM_LV_NOT_OWNER': -374,
        'VERR_SEM_LV_ILLEGAL_UPGRADE': -375,
        'VERR_SEM_LV_NOT_SIGNALLER': -376,
        'VERR_SEM_LV_INTERNAL_ERROR': -377,
        'VERR_NET_IO_ERROR': -400,
        'VERR_NET_OUT_OF_RESOURCES': -401,
        'VERR_NET_HOST_NOT_FOUND': -402,
        'VERR_NET_PATH_NOT_FOUND': -403,
        'VERR_NET_PRINT_ERROR': -404,
        'VERR_NET_NO_NETWORK': -405,
        'VERR_NET_NOT_UNIQUE_NAME': -406,
        'VERR_NET_IN_PROGRESS': -436,
        'VERR_NET_ALREADY_IN_PROGRESS': -437,
        'VERR_NET_NOT_SOCKET': -438,
        'VERR_NET_DEST_ADDRESS_REQUIRED': -439,
        'VERR_NET_MSG_SIZE': -440,
        'VERR_NET_PROTOCOL_TYPE': -441,
        'VERR_NET_PROTOCOL_NOT_AVAILABLE': -442,
        'VERR_NET_PROTOCOL_NOT_SUPPORTED': -443,
        'VERR_NET_SOCKET_TYPE_NOT_SUPPORTED': -444,
        'VERR_NET_OPERATION_NOT_SUPPORTED': -445,
        'VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED': -446,
        'VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED': -447,
        'VERR_NET_ADDRESS_IN_USE': -448,
        'VERR_NET_ADDRESS_NOT_AVAILABLE': -449,
        'VERR_NET_DOWN': -450,
        'VERR_NET_UNREACHABLE': -451,
        'VERR_NET_CONNECTION_RESET': -452,
        'VERR_NET_CONNECTION_ABORTED': -453,
        'VERR_NET_CONNECTION_RESET_BY_PEER': -454,
        'VERR_NET_NO_BUFFER_SPACE': -455,
        'VERR_NET_ALREADY_CONNECTED': -456,
        'VERR_NET_NOT_CONNECTED': -457,
        'VERR_NET_SHUTDOWN': -458,
        'VERR_NET_TOO_MANY_REFERENCES': -459,
        'VERR_NET_CONNECTION_TIMED_OUT': -460,
        'VERR_NET_CONNECTION_REFUSED': -461,
        'VERR_NET_HOST_DOWN': -464,
        'VERR_NET_HOST_UNREACHABLE': -465,
        'VERR_NET_PROTOCOL_ERROR': -466,
        'VERR_NET_INCOMPLETE_TX_PACKET': -467,
        'VERR_NET_INIT_FAILED': -468,
        'VERR_NET_NOT_UNSUPPORTED': -469,
        'VERR_TCP_SERVER_STOP': -500,
        'VINF_TCP_SERVER_STOP': 500,
        'VERR_TCP_SERVER_SHUTDOWN': -501,
        'VERR_TCP_SERVER_DESTROYED': -502,
        'VINF_TCP_SERVER_NO_CLIENT': 503,
        'VERR_UDP_SERVER_STOP': -520,
        'VINF_UDP_SERVER_STOP': 520,
        'VERR_UDP_SERVER_SHUTDOWN': -521,
        'VERR_UDP_SERVER_DESTROYED': -522,
        'VINF_UDP_SERVER_NO_CLIENT': 523,
        'VERR_L4_INVALID_DS_OFFSET': -550,
        'VERR_IPC': -551,
        'VERR_RESOURCE_IN_USE': -552,
        'VERR_IPC_PROCESS_NOT_FOUND': -553,
        'VERR_IPC_RECEIVE_TIMEOUT': -554,
        'VERR_IPC_SEND_TIMEOUT': -555,
        'VERR_IPC_RECEIVE_CANCELLED': -556,
        'VERR_IPC_SEND_CANCELLED': -557,
        'VERR_IPC_RECEIVE_ABORTED': -558,
        'VERR_IPC_SEND_ABORTED': -559,
        'VERR_IPC_RECEIVE_MAP_FAILED': -560,
        'VERR_IPC_SEND_MAP_FAILED': -561,
        'VERR_IPC_RECEIVE_SEND_PF_TIMEOUT': -562,
        'VERR_IPC_SEND_SEND_PF_TIMEOUT': -563,
        'VINF_IPC_RECEIVE_MSG_CUT': 564,
        'VINF_IPC_SEND_MSG_CUT': 565,
        'VERR_L4_DS_MANAGER_NOT_FOUND': -566,
        'VERR_INVALID_EXE_SIGNATURE': -600,
        'VERR_ELF_EXE_NOT_SUPPORTED': -601,
        'VERR_PE_EXE_NOT_SUPPORTED': -602,
        'VERR_LX_EXE_NOT_SUPPORTED': -603,
        'VERR_LE_EXE_NOT_SUPPORTED': -604,
        'VERR_NE_EXE_NOT_SUPPORTED': -605,
        'VERR_MZ_EXE_NOT_SUPPORTED': -606,
        'VERR_AOUT_EXE_NOT_SUPPORTED': -607,
        'VERR_BAD_EXE_FORMAT': -608,
        'VERR_SYMBOL_NOT_FOUND': -609,
        'VERR_MODULE_NOT_FOUND': -610,
        'VERR_SYMBOL_VALUE_TOO_BIG': -611,
        'VERR_IMAGE_TOO_BIG': -612,
        'VERR_IMAGE_BASE_TOO_HIGH': -614,
        'VERR_LDR_ARCH_MISMATCH': -615,
        'VERR_LDR_MISMATCH_NATIVE': -616,
        'VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND': -617,
        'VERR_LDR_GENERAL_FAILURE': -618,
        'VERR_LDR_IMAGE_HASH': -619,
        'VERR_LDRPE_DELAY_IMPORT': -620,
        'VERR_LDRPE_CERT_MALFORMED': -621,
        'VERR_LDRPE_CERT_UNSUPPORTED': -622,
        'VERR_LDRPE_GLOBALPTR': -623,
        'VERR_LDRPE_TLS': -624,
        'VERR_LDRPE_COM_DESCRIPTOR': -625,
        'VERR_LDRPE_LOAD_CONFIG_SIZE': -626,
        'VERR_LDRPE_LOCK_PREFIX_TABLE': -627,
        'VERR_LDRPE_GUARD_CF_STUFF': -628,
        'VERR_LDRELF_ODD_ENDIAN': -630,
        'VERR_LDRELF_DYN': -631,
        'VERR_LDRELF_EXEC': -632,
        'VERR_LDRELF_MACHINE': -633,
        'VERR_LDRELF_VERSION': -634,
        'VERR_LDRELF_MULTIPLE_SYMTABS': -635,
        'VERR_LDRELF_RELOCATION_NOT_SUPPORTED': -636,
        'VERR_LDRELF_INVALID_SYMBOL_INDEX': -637,
        'VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET': -638,
        'VERR_LDRELF_INVALID_RELOCATION_OFFSET': -639,
        'VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS': -640,
        'VERR_LDRELF_UNTERMINATED_STRING_TAB': -641,
        'VERR_LDR_INVALID_LINK_ADDRESS': -647,
        'VERR_LDR_INVALID_RVA': -648,
        'VERR_LDR_INVALID_SEG_OFFSET': -649,
        'VERR_DBG_NO_LINE_NUMBERS': -650,
        'VERR_DBG_NO_SYMBOLS': -651,
        'VERR_DBG_INVALID_ADDRESS': -652,
        'VERR_DBG_INVALID_SEGMENT_INDEX': -653,
        'VERR_DBG_INVALID_SEGMENT_OFFSET': -654,
        'VERR_DBG_INVALID_RVA': -655,
        'VERR_DBG_SPECIAL_SEGMENT': -656,
        'VERR_DBG_ADDRESS_CONFLICT': -657,
        'VERR_DBG_DUPLICATE_SYMBOL': -658,
        'VERR_DBG_SEGMENT_INDEX_CONFLICT': -659,
        'VERR_DBG_LINE_NOT_FOUND': -660,
        'VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE': -661,
        'VERR_DBG_FILE_NAME_OUT_OF_RANGE': -662,
        'VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE': -663,
        'VERR_DBG_ADDRESS_WRAP': -664,
        'VERR_DBG_NOT_NM_MAP_FILE': -665,
        'VERR_DBG_NOT_LINUX_KALLSYMS': -666,
        'VERR_DBG_NO_MATCHING_INTERPRETER': -667,
        'VERR_DWARF_BAD_LINE_NUMBER_HEADER': -668,
        'VERR_DWARF_UNEXPECTED_END': -669,
        'VERR_DWARF_LEB_OVERFLOW': -670,
        'VERR_DWARF_BAD_LNE': -671,
        'VERR_DWARF_BAD_STRING': -672,
        'VERR_DWARF_BAD_POS': -673,
        'VERR_DWARF_BAD_INFO': -674,
        'VERR_DWARF_BAD_ABBREV': -675,
        'VERR_DWARF_ABBREV_NOT_FOUND': -676,
        'VERR_DWARF_UNKNOWN_FORM': -677,
        'VERR_DWARF_UNEXPECTED_FORM': -678,
        'VERR_DWARF_TODO': -679,
        'VERR_DWARF_UNKNOWN_LOC_OPCODE': -680,
        'VERR_DWARF_STACK_OVERFLOW': -681,
        'VERR_DWARF_STACK_UNDERFLOW': -682,
        'VERR_DWARF_IPE': -683,
        'VERR_DBG_CFG_INVALID_VALUE': -684,
        'VERR_DBG_CFG_NOT_UINT_PROP': -685,
        'VERR_DBG_DEFERRED_LOAD_FAILED': -686,
        'VERR_DBG_TODO': -687,
        'VERR_DBG_FILE_MISMATCH': -688,
        'VERR_DBG_MOD_IPE': -689,
        'VINF_DBG_ADJUSTED_SYM_SIZE': 690,
        'VERR_CV_BAD_FORMAT': -691,
        'VERR_CV_TODO': -692,
        'VERR_CV_IPE': -693,
        'VERR_DBG_NO_UNWIND_INFO': -694,
        'VERR_DBG_UNWIND_INFO_NOT_FOUND': -695,
        'VERR_DBG_MALFORMED_UNWIND_INFO': -696,
        'VERR_RT_REQUEST_INVALID_TYPE': -700,
        'VERR_RT_REQUEST_STATE': -701,
        'VERR_RT_REQUEST_INVALID_PACKAGE': -702,
        'VERR_RT_REQUEST_STATUS_STILL_PENDING': -703,
        'VERR_RT_REQUEST_STATUS_FREED': -704,
        'VERR_ENV_VAR_NOT_FOUND': -750,
        'VINF_ENV_VAR_NOT_FOUND': 750,
        'VWRN_ENV_NOT_FULLY_TRANSLATED': 751,
        'VERR_ENV_INVALID_VAR_NAME': -752,
        'VINF_ENV_VAR_UNSET': 753,
        'VERR_ENV_VAR_UNSET': -753,
        'VERR_CPU_OFFLINE': -800,
        'VERR_CPU_NOT_FOUND': -801,
        'VERR_NOT_ALL_CPUS_SHOWED': -802,
        'VERR_CPU_IPE_1': -803,
        'VERR_GETOPT_UNKNOWN_OPTION': -825,
        'VERR_GETOPT_REQUIRED_ARGUMENT_MISSING': -826,
        'VERR_GETOPT_INVALID_ARGUMENT_FORMAT': -827,
        'VINF_GETOPT_NOT_OPTION': 828,
        'VERR_GETOPT_INDEX_MISSING': -829,
        'VERR_CACHE_FULL': -850,
        'VERR_CACHE_EMPTY': -851,
        'VERR_MEM_CACHE_MAX_SIZE': -855,
        'VERR_S3_ACCESS_DENIED': -875,
        'VERR_S3_NOT_FOUND': -876,
        'VERR_S3_BUCKET_ALREADY_EXISTS': -877,
        'VERR_S3_BUCKET_NOT_EMPTY': -878,
        'VERR_S3_CANCELED': -879,
        'VERR_HTTP_STATUS_SERVER_ERROR': -884,
        'VERR_HTTP_INIT_FAILED': -885,
        'VERR_HTTP_NOT_FOUND': -886,
        'VERR_HTTP_ACCESS_DENIED': -887,
        'VERR_HTTP_BAD_REQUEST': -888,
        'VERR_HTTP_COULDNT_CONNECT': -889,
        'VERR_HTTP_SSL_CONNECT_ERROR': -890,
        'VERR_HTTP_CACERT_WRONG_FORMAT': -891,
        'VERR_HTTP_CACERT_CANNOT_AUTHENTICATE': -892,
        'VERR_HTTP_ABORTED': -893,
        'VERR_HTTP_REDIRECTED': -894,
        'VERR_HTTP_PROXY_NOT_FOUND': -895,
        'VERR_HTTP_HOST_NOT_FOUND': -896,
        'VERR_HTTP_CURL_PROXY_CONFIG': -897,
        'VERR_HTTP_CURL_ERROR': -899,
        'VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE': -900,
        'VERR_MANIFEST_WRONG_FILE_FORMAT': -901,
        'VERR_MANIFEST_DIGEST_MISMATCH': -902,
        'VERR_MANIFEST_FILE_MISMATCH': -903,
        'VERR_MANIFEST_ATTR_NOT_FOUND': -904,
        'VERR_MANIFEST_ATTR_TYPE_MISMATCH': -905,
        'VERR_MANIFEST_ATTR_TYPE_NOT_FOUND': -906,
        'VERR_TAR_CHKSUM_MISMATCH': -925,
        'VERR_TAR_END_OF_FILE': -926,
        'VERR_TAR_UNEXPECTED_EOS': -927,
        'VERR_TAR_EOS_MORE_INPUT': -928,
        'VERR_TAR_BAD_NUM_FIELD': -929,
        'VERR_TAR_BAD_NUM_FIELD_TERM': -930,
        'VERR_TAR_BASE_256_NOT_SUPPORTED': -931,
        'VERR_TAR_NUM_VALUE_TOO_LARGE': -932,
        'VERR_TAR_DEV_VALUE_TOO_LARGE': -933,
        'VERR_TAR_BAD_MODE_FIELD': -934,
        'VERR_TAR_MODE_WITH_TYPE': -935,
        'VERR_TAR_SIZE_NOT_ZERO': -936,
        'VERR_TAR_UNKNOWN_TYPE_FLAG': -937,
        'VERR_TAR_ZERO_HEADER': -938,
        'VERR_TAR_NOT_USTAR_V00': -939,
        'VERR_TAR_EMPTY_NAME': -940,
        'VERR_TAR_NON_DIR_ENDS_WITH_SLASH': -941,
        'VERR_TAR_UNSUPPORTED_PAX_TYPE': -942,
        'VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE': -943,
        'VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE': -944,
        'VERR_TAR_BAD_CHKSUM_FIELD': -945,
        'VERR_TAR_MALFORMED_GNU_LONGXXXX': -946,
        'VERR_TAR_NAME_TOO_LONG': -947,
        'VINF_TAR_DIR_PATH': 948,
        'VERR_POLL_HANDLE_NOT_POLLABLE': -950,
        'VERR_POLL_HANDLE_ID_EXISTS': -951,
        'VERR_POLL_HANDLE_ID_NOT_FOUND': -952,
        'VERR_POLL_SET_IS_FULL': -953,
        'VERR_PKZIP_NO_EOCB': -960,
        'VERR_PKZIP_NAME_TOO_LONG': -961,
        'VERR_PKZIP_BAD_LF_HEADER': -962,
        'VERR_PKZIP_BAD_CDF_HEADER': -963,
        'VERR_PKZIP_UNKNOWN_TYPE_FLAG': -964,
        'VERR_PKZIP_ZIP64EX_IN_ZIP32': -965,
        'VERR_ZIP_ERROR': -22000,
        'VERR_ZIP_CORRUPTED': -22001,
        'VERR_ZIP_NO_MEMORY': -22002,
        'VERR_ZIP_UNSUPPORTED_VERSION': -22003,
        'VERR_ZIP_UNSUPPORTED_METHOD': -22004,
        'VERR_ZIP_BAD_HEADER': -22005,
        'VERR_VFS_CHAIN_NO_PREFIX': -22100,
        'VERR_VFS_CHAIN_EMPTY': -22101,
        'VERR_VFS_CHAIN_EXPECTED_ELEMENT': -22102,
        'VERR_VFS_CHAIN_UNKNOWN_TYPE': -22103,
        'VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES': -22104,
        'VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES': -22105,
        'VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME': -22106,
        'VERR_VFS_CHAIN_EXPECTED_SEPARATOR': -22107,
        'VERR_VFS_CHAIN_LEADING_SEPARATOR': -22108,
        'VERR_VFS_CHAIN_TRAILING_SEPARATOR': -22109,
        'VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT': -22110,
        'VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT': -22111,
        'VERR_VFS_CHAIN_CAST_FAILED': -22112,
        'VERR_VFS_CHAIN_IPE': -22113,
        'VERR_VFS_CHAIN_PROVIDER_NOT_FOUND': -22114,
        'VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH': -22115,
        'VERR_VFS_CHAIN_NO_ARGS': -22116,
        'VERR_VFS_CHAIN_ONE_ARG': -22117,
        'VERR_VFS_CHAIN_AT_MOST_ONE_ARG': -22118,
        'VERR_VFS_CHAIN_AT_LEAST_ONE_ARG': -22119,
        'VERR_VFS_CHAIN_TWO_ARGS': -22120,
        'VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS': -22121,
        'VERR_VFS_CHAIN_AT_MOST_TWO_ARGS': -22122,
        'VERR_VFS_CHAIN_THREE_ARGS': -22123,
        'VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS': -22124,
        'VERR_VFS_CHAIN_AT_MOST_THREE_ARGS': -22125,
        'VERR_VFS_CHAIN_FOUR_ARGS': -22126,
        'VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS': -22127,
        'VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS': -22128,
        'VERR_VFS_CHAIN_FIVE_ARGS': -22129,
        'VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS': -22130,
        'VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS': -22131,
        'VERR_VFS_CHAIN_SIX_ARGS': -22132,
        'VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS': -22133,
        'VERR_VFS_CHAIN_AT_MOST_SIX_ARGS': -22134,
        'VERR_VFS_CHAIN_TOO_FEW_ARGS': -22135,
        'VERR_VFS_CHAIN_TOO_MANY_ARGS': -22136,
        'VERR_VFS_CHAIN_EMPTY_ARG': -22137,
        'VERR_VFS_CHAIN_INVALID_ARGUMENT': -22138,
        'VERR_VFS_CHAIN_ONLY_FILE_OR_IOS': -22139,
        'VERR_VFS_CHAIN_ONLY_IOS': -22140,
        'VERR_VFS_CHAIN_ONLY_DIR': -22141,
        'VERR_VFS_CHAIN_ONLY_FSS': -22142,
        'VERR_VFS_CHAIN_ONLY_VFS': -22143,
        'VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR': -22144,
        'VERR_VFS_CHAIN_ONLY_DIR_OR_VFS': -22145,
        'VERR_VFS_CHAIN_TAKES_FILE': -22146,
        'VERR_VFS_CHAIN_TAKES_FILE_OR_IOS': -22147,
        'VERR_VFS_CHAIN_TAKES_DIR': -22148,
        'VERR_VFS_CHAIN_TAKES_FSS': -22149,
        'VERR_VFS_CHAIN_TAKES_VFS': -22150,
        'VERR_VFS_CHAIN_TAKES_DIR_OR_VFS': -22151,
        'VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS': -22152,
        'VERR_VFS_CHAIN_READ_ONLY_IOS': -22153,
        'VERR_VFS_CHAIN_WRITE_ONLY_IOS': -22154,
        'VERR_VFS_CHAIN_PATH_ONLY': -22155,
        'VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY': -22156,
        'VERR_VFS_CHAIN_NOT_PATH_ONLY': -22157,
        'VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT': -22158,
        'VERR_DVM_MAP_EMPTY': -22200,
        'VERR_DVM_MAP_NO_VOLUME': -22201,
        'VERR_LOG_REVISION_MISMATCH': -22300,
        'VERR_SYS_CANNOT_POWER_OFF': -22500,
        'VINF_SYS_MAY_POWER_OFF': 22501,
        'VERR_SYS_SHUTDOWN_FAILED': -22502,
        'VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY': -22503,
        'VERR_FILESYSTEM_CORRUPT': -22600,
        'VERR_XAR_WRONG_MAGIC': -22700,
        'VERR_XAR_BAD_HDR_SIZE': -22701,
        'VERR_XAR_UNSUPPORTED_VERSION': -22702,
        'VERR_XAR_UNSUPPORTED_HASH_FUNCTION': -22703,
        'VERR_XAR_TOC_TOO_SMALL': -22704,
        'VERR_XAR_TOC_TOO_BIG': -22705,
        'VERR_XAR_TOC_TOO_BIG_COMPRESSED': -22706,
        'VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH': -22707,
        'VERR_XAR_TOC_STRLEN_MISMATCH': -22708,
        'VERR_XAR_TOC_UTF8_ENCODING': -22709,
        'VERR_XAR_TOC_XML_PARSE_ERROR': -22710,
        'VERR_XML_TOC_ELEMENT_MISSING': -22711,
        'VERR_XML_TOC_ELEMENT_HAS_SIBLINGS': -22712,
        'VERR_XAR_TOC_DIGEST_MISMATCH': -22713,
        'VERR_XAR_BAD_CHECKSUM_ELEMENT': -22714,
        'VERR_XAR_HASH_FUNCTION_MISMATCH': -22715,
        'VERR_XAR_BAD_DIGEST_LENGTH': -22716,
        'VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER': -22717,
        'VERR_XAR_MISSING_OFFSET_ELEMENT': -22718,
        'VERR_XAR_BAD_OFFSET_ELEMENT': -22719,
        'VERR_XAR_MISSING_SIZE_ELEMENT': -22720,
        'VERR_XAR_BAD_SIZE_ELEMENT': -22721,
        'VERR_XAR_MISSING_LENGTH_ELEMENT': -22722,
        'VERR_XAR_BAD_LENGTH_ELEMENT': -22723,
        'VERR_XAR_BAD_FILE_ELEMENT': -22724,
        'VERR_XAR_MISSING_DATA_ELEMENT': -22725,
        'VERR_XAR_UNKNOWN_FILE_TYPE': -22726,
        'VERR_XAR_NO_ENCODING': -22727,
        'VERR_XAR_BAD_FILE_TIMESTAMP': -22728,
        'VERR_XAR_BAD_FILE_MODE': -22729,
        'VERR_XAR_BAD_FILE_UID': -22730,
        'VERR_XAR_BAD_FILE_GID': -22731,
        'VERR_XAR_BAD_FILE_DEVICE_NO': -22732,
        'VERR_XAR_BAD_FILE_INODE': -22733,
        'VERR_XAR_INVALID_FILE_NAME': -22734,
        'VERR_XAR_EXTRACTED_HASH_MISMATCH': -22735,
        'VERR_XAR_EXTRACTED_SIZE_EXCEEDED': -22736,
        'VERR_XAR_ARCHIVED_HASH_MISMATCH': -22737,
        'VERR_XAR_UNUSED_ARCHIVED_DATA': -22738,
        'VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH': -22739,
        'VERR_X509_READING_CERT_FROM_BIO': -23100,
        'VERR_X509_EXTRACT_PUBKEY_FROM_CERT': -23101,
        'VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY': -23102,
        'VERR_X509_RSA_VERIFICATION_FUILURE': -23103,
        'VERR_X509_NO_BASIC_CONSTARAINTS': -23104,
        'VERR_X509_GETTING_EXTENSION_FROM_CERT': -23105,
        'VERR_X509_GETTING_DATA_FROM_EXTENSION': -23106,
        'VERR_X509_PRINT_EXTENSION_TO_BIO': -23107,
        'VERR_X509_CERTIFICATE_VERIFICATION_FAILURE': -23108,
        'VERR_X509_NOT_SELFSIGNED_CERTIFICATE': -23109,
        'VINF_X509_NOT_SELFSIGNED_CERTIFICATE': 23109,
        'VERR_ASN1_ERROR': -22800,
        'VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED': -22801,
        'VERR_ASN1_INVALID_UTF8_STRING_ENCODING': -22802,
        'VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING': -22803,
        'VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING': -22804,
        'VERR_ASN1_INVALID_T61_STRING_ENCODING': -22805,
        'VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING': -22806,
        'VERR_ASN1_INVALID_IA5_STRING_ENCODING': -22807,
        'VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING': -22808,
        'VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING': -22809,
        'VERR_ASN1_INVALID_GENERAL_STRING_ENCODING': -22810,
        'VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING': -22811,
        'VERR_ASN1_INVALID_BMP_STRING_ENCODING': -22812,
        'VERR_ASN1_INVALID_OBJID_ENCODING': -22813,
        'VERR_ASN1_OBJID_COMPONENT_TOO_BIG': -22814,
        'VERR_ASN1_OBJID_TOO_MANY_COMPONENTS': -22815,
        'VERR_ASN1_OBJID_TOO_LONG_STRING_FORM': -22816,
        'VERR_ASN1_OBJID_INVALID_DOTTED_STRING': -22817,
        'VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL': -22818,
        'VERR_ASN1_STRING_TAG_MISMATCH': -22819,
        'VERR_ASN1_TIME_TAG_MISMATCH': -22820,
        'VINF_ASN1_MORE_DATA': 22821,
        'VINF_ASN1_NOT_ENCODED': 22822,
        'VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ': -22823,
        'VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ': -22824,
        'VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET': -22825,
        'VERR_ASN1_NO_VTABLE': -22826,
        'VERR_ASN1_NO_CHECK_SANITY_METHOD': -22827,
        'VERR_ASN1_NOT_PRESENT': -22828,
        'VERR_ASN1_CURSOR_NOT_AT_END': -22829,
        'VERR_ASN1_CURSOR_LONG_TAG': -22830,
        'VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING': -22831,
        'VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH': -22832,
        'VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH': -22833,
        'VERR_ASN1_CURSOR_BAD_LENGTH': -22834,
        'VERR_ASN1_CURSOR_NO_MORE_DATA': -22835,
        'VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT': -22836,
        'VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING': -22837,
        'VERR_ASN1_CURSOR_TAG_MISMATCH': -22838,
        'VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH': -22839,
        'VERR_ASN1_BITSTRING_OUT_OF_BOUNDS': -22840,
        'VERR_ASN1_TIME_BAD_NORMALIZE_INPUT': -22841,
        'VERR_ASN1_TIME_NORMALIZE_ERROR': -22842,
        'VERR_ASN1_TIME_NORMALIZE_MISMATCH': -22843,
        'VERR_ASN1_INVALID_UTC_TIME_ENCODING': -22844,
        'VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING': -22845,
        'VERR_ASN1_INVALID_BOOLEAN_ENCODING': -22846,
        'VERR_ASN1_INVALID_NULL_ENCODING': -22847,
        'VERR_ASN1_INVALID_BITSTRING_ENCODING': -22848,
        'VERR_ASN1_DYNTYPE_TAG_NOT_IMPL': -22849,
        'VERR_ASN1_DYNTYPE_BAD_TAG': -22850,
        'VERR_ASN1_DUMMY_OBJECT': -22851,
        'VERR_ASN1_TOO_LONG': -22852,
        'VERR_ASN1_EXPECTED_PRIMITIVE': -22853,
        'VERR_ASN1_INVALID_DATA_POINTER': -22854,
        'VERR_ASN1_TOO_DEEPLY_NESTED': -22855,
        'VERR_ASN1_UNEXPECTED_OBJ_ID': -22856,
        'VERR_ASN1_INVALID_INTEGER_ENCODING': -22857,
        'VERR_ASN1_INTERNAL_ERROR_1': -22895,
        'VERR_ASN1_INTERNAL_ERROR_2': -22896,
        'VERR_ASN1_INTERNAL_ERROR_3': -22897,
        'VERR_ASN1_INTERNAL_ERROR_4': -22898,
        'VERR_ASN1_INTERNAL_ERROR_5': -22899,
        'VERR_LDRVI_NOT_SIGNED': -22900,
        'VINF_LDRVI_NOT_SIGNED': 22900,
        'VERR_LDRVI_READ_ERROR_HDR': -22901,
        'VERR_LDRVI_READ_ERROR_SHDRS': -22902,
        'VERR_LDRVI_READ_ERROR_SIGNATURE': -22903,
        'VERR_LDRVI_READ_ERROR_HASH': -22904,
        'VERR_LDRVI_FILE_LENGTH_ERROR': -22905,
        'VERR_LDRVI_NO_MEMORY_STATE': -22906,
        'VERR_LDRVI_NO_MEMORY_SIGNATURE': -22907,
        'VERR_LDRVI_NO_MEMORY_SHDRS': -22908,
        'VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT': -22909,
        'VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY': -22910,
        'VERR_LDRVI_BAD_CERT_HDR_LENGTH': -22911,
        'VERR_LDRVI_BAD_CERT_HDR_REVISION': -22912,
        'VERR_LDRVI_BAD_CERT_HDR_TYPE': -22913,
        'VERR_LDRVI_BAD_CERT_MULTIPLE': -22914,
        'VERR_LDRVI_BAD_MZ_OFFSET': -22915,
        'VERR_LDRVI_INVALID_SECTION_COUNT': -22916,
        'VERR_LDRVI_SECTION_RAW_DATA_VALUES': -22917,
        'VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH': -22918,
        'VERR_LDRVI_UNSUPPORTED_ARCH': -22919,
        'VERR_LDRVI_PARSE_IPE': -22921,
        'VERR_LDRVI_PARSE_BER_ERROR': -22922,
        'VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID': -22923,
        'VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW': -22924,
        'VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG': -22925,
        'VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED': -22926,
        'VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA': -22927,
        'VERR_LDRVI_PAGE_HASH_MISMATCH': -22928,
        'VERR_LDRVI_IMAGE_HASH_MISMATCH': -22929,
        'VERR_LDRVI_BAD_CERT_FORMAT': -22930,
        'VERR_LDR_FORWARDER': -22950,
        'VERR_LDR_NOT_FORWARDER': -22951,
        'VERR_LDR_BAD_FORWARDER': -22952,
        'VERR_LDR_FORWARDER_CHAIN_TOO_LONG': -22953,
        'VERR_LDR_FORWARDERS_NOT_SUPPORTED': -22954,
        'VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED': -22955,
        'VERR_LDRMACHO_BAD_HEADER': -22956,
        'VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE': -22957,
        'VERR_LDRMACHO_UNSUPPORTED_MACHINE': -22958,
        'VERR_LDRMACHO_BAD_LOAD_COMMAND': -22959,
        'VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND': -22960,
        'VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND': -22961,
        'VERR_LDRMACHO_BAD_SECTION': -22962,
        'VERR_LDRMACHO_UNSUPPORTED_SECTION': -22963,
        'VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION': -22964,
        'VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION': -22965,
        'VERR_LDRMACHO_UNKNOWN_SECTION': -22966,
        'VERR_LDRMACHO_BAD_SECTION_ORDER': -22967,
        'VERR_LDRMACHO_BIT_MIX': -22968,
        'VERR_LDRMACHO_BAD_OBJECT_FILE': -22969,
        'VERR_LDRMACHO_BAD_SYMBOL': -22970,
        'VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE': -22971,
        'VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS': -22972,
        'VERR_LDRMACHO_NON_CONT_SEG_BITS': -22973,
        'VERR_LDRMACHO_TODO': -22974,
        'VERR_LDRMACHO_BAD_SYMTAB_SIZE': -22975,
        'VERR_LDR_DUPLICATE_SEGMENT_NAME': -22976,
        'VERR_LDR_NO_IMAGE_UUID': -22977,
        'VERR_LDR_BAD_FIXUP': -22978,
        'VERR_LDR_ADDRESS_OVERFLOW': -22979,
        'VERR_LDRLX_BAD_HEADER': -22980,
        'VERR_LDRLX_BAD_LOADER_SECTION': -22981,
        'VERR_LDRLX_BAD_FIXUP_SECTION': -22982,
        'VERR_LDRLX_BAD_OBJECT_TABLE': -22983,
        'VERR_LDRLX_BAD_PAGE_MAP': -22984,
        'VERR_LDRLX_BAD_ITERDATA': -22985,
        'VERR_LDRLX_BAD_ITERDATA2': -22986,
        'VERR_LDRLX_BAD_BUNDLE': -22987,
        'VERR_LDRLX_NO_SONAME': -22988,
        'VERR_LDRLX_BAD_SONAME': -22989,
        'VERR_LDRLX_BAD_FORWARDER': -22990,
        'VERR_LDRLX_NRICHAIN_NOT_SUPPORTED': -22991,
        'VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS': -22992,
        'VERR_CR_X509_GENERIC_ERROR': -23000,
        'VERR_CR_X509_INTERNAL_ERROR': -23001,
        'VERR_CR_X509_CERTPATHS_INTERNAL_ERROR': -23002,
        'VERR_CR_X509_NOT_VERIFIED': -23003,
        'VERR_CR_X509_NO_TRUST_ANCHOR': -23004,
        'VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO': -23005,
        'VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH': -23006,
        'VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH': -23007,
        'VERR_CR_X509_TBSCERT_EXTS_REQ_V3': -23008,
        'VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2': -23009,
        'VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS': -23010,
        'VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION': -23011,
        'VERR_CR_X509_PUBLIC_KEY_TOO_SMALL': -23012,
        'VERR_CR_X509_INVALID_NAME_STRING_TAG': -23013,
        'VERR_CR_X509_NAME_EMPTY_STRING': -23014,
        'VERR_CR_X509_NAME_NOT_STRING': -23015,
        'VERR_CR_X509_NAME_EMPTY_SET': -23016,
        'VERR_CR_X509_NAME_EMPTY_SUB_SET': -23017,
        'VERR_CR_X509_VALIDITY_SWAPPED': -23018,
        'VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION': -23019,
        'VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY': -23020,
        'VERR_CR_X509_CPV_NO_TRUSTED_PATHS': -23021,
        'VERR_CR_X509_CPV_NO_VALID_POLICY': -23022,
        'VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION': -23023,
        'VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN': -23024,
        'VERR_CR_X509_CPV_MAX_PATH_LENGTH': -23025,
        'VERR_CR_X509_CPV_NOT_CA_CERT': -23026,
        'VERR_CR_X509_CPV_NOT_V3_CERT': -23027,
        'VERR_CR_X509_CPV_INVALID_POLICY_MAPPING': -23028,
        'VERR_CR_X509_CPV_NO_PERMITTED_NAMES': -23029,
        'VERR_CR_X509_CPV_NAME_NOT_PERMITTED': -23030,
        'VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED': -23031,
        'VERR_CR_X509_CPV_ISSUER_MISMATCH': -23032,
        'VERR_CR_X509_CPV_NOT_VALID_AT_TIME': -23033,
        'VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE': -23034,
        'VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN': -23035,
        'VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX': -23036,
        'VERR_CR_X509_CPB_BAD_CERT_CTX': -23037,
        'VERR_CR_X509_OSSL_D2I_FAILED': -23090,
        'VERR_CR_PKCS7_GENERIC_ERROR': -23300,
        'VERR_CR_PKCS7_NO_SIGNER_INFOS': -23301,
        'VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND': -23302,
        'VERR_CR_PKCS7_KEY_USAGE_MISMATCH': -23303,
        'VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB': -23304,
        'VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH': -23305,
        'VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB': -23306,
        'VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB': -23307,
        'VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH': -23308,
        'VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB': -23309,
        'VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED': -23310,
        'VERR_CR_PKCS7_INTERNAL_ERROR': -22311,
        'VERR_CR_PKCS7_OSSL_D2I_FAILED': -22312,
        'VERR_CR_PKCS7_OSSL_VERIFY_FAILED': -22313,
        'VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL': -22314,
        'VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST': -22315,
        'VERR_CR_PKCS7_NOT_SIGNED_DATA': -22316,
        'VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS': -22317,
        'VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS': -22318,
        'VERR_CR_PKCS7_DIGEST_CREATE_ERROR': -22319,
        'VERR_CR_PKCS7_DIGEST_CALC_ERROR': -22320,
        'VERR_CR_PKCS7_SIGNED_DATA_VERSION': -22350,
        'VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS': -22351,
        'VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM': -22352,
        'VERR_CR_PKCS7_NO_CERTIFICATES': -22353,
        'VERR_CR_PKCS7_EXPECTED_NO_CRLS': -22354,
        'VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO': -22355,
        'VERR_CR_PKCS7_SIGNER_INFO_VERSION': -22356,
        'VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO': -22357,
        'VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED': -22358,
        'VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH': -22359,
        'VERR_CR_PKCS7_NOT_DATA': -22360,
        'VERR_CR_SPC_GENERIC_ERROR': -23400,
        'VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS': -23401,
        'VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO': -23402,
        'VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH': -23403,
        'VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS': -23404,
        'VERR_CR_SPC_UNKNOWN_DIGEST_ALGO': -23405,
        'VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH': -23406,
        'VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA': -23407,
        'VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT': -23408,
        'VERR_CR_SPC_BAD_MONIKER_UUID': -23409,
        'VERR_CR_SPC_UNKNOWN_MONIKER_UUID': -23410,
        'VERR_CR_SPC_BAD_MONIKER_CHOICE': -23411,
        'VERR_CR_SPC_MONIKER_BAD_DATA': -23412,
        'VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS': -23413,
        'VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE': -23414,
        'VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED': -23415,
        'VERR_CR_SPC_PEIMAGE_NO_CONTENT': -23416,
        'VERR_CR_PKIX_GENERIC_ERROR': -23500,
        'VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS': -23501,
        'VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE': -23502,
        'VERR_CR_PKIX_INTERNAL_ERROR': -23503,
        'VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY': -23504,
        'VERR_CR_PKIX_SIGNATURE_TOO_LONG': -23505,
        'VERR_CR_PKIX_SIGNATURE_GE_KEY': -23506,
        'VERR_CR_PKIX_SIGNATURE_NEGATIVE': -23507,
        'VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH': -23508,
        'VERR_CR_PKIX_SIGNATURE_MISMATCH': -23509,
        'VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL': -23510,
        'VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN': -23511,
        'VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN': -23512,
        'VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP': -23513,
        'VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED': -23514,
        'VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED': -23515,
        'VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED': -23516,
        'VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR': -23517,
        'VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED': -23518,
        'VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR': -23519,
        'VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED': -23520,
        'VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE': -23521,
        'VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE': -23522,
        'VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY': -23523,
        'VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY': -23524,
        'VERR_CR_STORE_GENERIC_ERROR': -23700,
        'VERR_CR_KEY_UNKNOWN_TYPE': -23800,
        'VERR_CR_KEY_FORMAT_NOT_SUPPORTED': -23801,
        'VERR_CR_KEY_ENCRYPTED': -23802,
        'VERR_CR_KEY_NO_DEK_INFO': -23803,
        'VERR_CR_KEY_DEK_INFO_TOO_LONG': -23804,
        'VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED': -23805,
        'VERR_CR_KEY_UNSUPPORTED_CIPHER': -23806,
        'VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS': -23807,
        'VERR_CR_KEY_MISSING_CIPHER_PARAMS': -23808,
        'VERR_CR_KEY_TOO_SHORT_CIPHER_IV': -23809,
        'VERR_CR_KEY_MALFORMED_CIPHER_IV': -23810,
        'VERR_CR_KEY_PASSWORD_ENCODING': -23811,
        'VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR': -23812,
        'VERR_CR_KEY_DECRYPTION_FAILED': -23813,
        'VINF_CR_KEY_WAS_DECRYPTED': 23814,
        'VERR_CR_KEY_GEN_FAILED_RSA': -23815,
        'VERR_CR_RSA_GENERIC_ERROR': -23900,
        'VERR_BIGNUM_SENSITIVE_INPUT': -24000,
        'VERR_BIGNUM_DIV_BY_ZERO': -24001,
        'VERR_BIGNUM_NEGATIVE_EXPONENT': -24002,
        'VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR': -24200,
        'VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR': -24201,
        'VINF_CR_DIGEST_DEPRECATED': 24202,
        'VERR_CR_DIGEST_DEPRECATED': -24202,
        'VINF_CR_DIGEST_COMPROMISED': 24203,
        'VERR_CR_DIGEST_COMPROMISED': -24203,
        'VINF_CR_DIGEST_SEVERELY_COMPROMISED': 24204,
        'VERR_CR_DIGEST_SEVERELY_COMPROMISED': -24204,
        'VERR_CR_DIGEST_NOT_SUPPORTED': -24205,
        'VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED': -24396,
        'VERR_CR_RANDOM_SETUP_FAILED': -24397,
        'VERR_CR_RANDOM_FAILED': -24398,
        'VERR_CR_MALFORMED_PEM_HEADER': -24399,
        'VERR_PATH_MATCH_UNKNOWN_VARIABLE': -24400,
        'VERR_PATH_MATCH_VARIABLE_MUST_BE_FIRST': -24401,
        'VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED': -24402,
        'VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS': -24403,
        'VERR_URI_EMPTY': -24600,
        'VERR_URI_TOO_SHORT': -24601,
        'VERR_URI_INVALID_SCHEME': -24602,
        'VERR_URI_INVALID_PORT_NUMBER': -24603,
        'VERR_URI_INVALID_ESCAPE_SEQ': -24604,
        'VERR_URI_ESCAPED_ZERO': -24605,
        'VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8': -24606,
        'VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE': -24607,
        'VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE': -24608,
        'VERR_URI_MISSING_UTF8_CONTINUATION_BYTE': -24609,
        'VERR_URI_NOT_FILE_SCHEME': -24610,
        'VERR_JSON_VALUE_INVALID_TYPE': -24700,
        'VERR_JSON_ITERATOR_END': -24701,
        'VERR_JSON_MALFORMED': -24702,
        'VERR_JSON_IS_EMPTY': -24703,
        'VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE': -24704,
        'VERR_JSON_MISSING_SURROGATE_PAIR': -24705,
        'VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE': -24706,
        'VERR_JSON_INVALID_CODEPOINT': -24707,
        'VERR_VFS_UNKNOWN_FORMAT': -24800,
        'VERR_VFS_BOGUS_FORMAT': -24801,
        'VERR_VFS_BOGUS_OFFSET': -24802,
        'VERR_VFS_UNSUPPORTED_FORMAT': -24803,
        'VERR_VFS_UNSUPPORTED_CREATE_TYPE': -24804,
        'VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY': -25000,
        'VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY': -25001,
        'VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER': -25002,
        'VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY': -25003,
        'VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE': -25004,
        'VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY': -25005,
        'VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3': -25006,
        'VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE': -25007,
        'VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE': 25007,
        'VERR_ISOMK_SYMLINK_SUPPORT_DISABLED': -25008,
        'VERR_ISOMK_RR_NO_SPACE_FOR_CE': -25009,
        'VERR_ISOMK_IPE_RR_READ': -25010,
        'VERR_ISOMK_IPE_TABLE': -25011,
        'VERR_ISOMK_IPE_NAMESPACE_1': -25012,
        'VERR_ISOMK_IPE_NAMESPACE_2': -25013,
        'VERR_ISOMK_IPE_NAMESPACE_3': -25014,
        'VERR_ISOMK_IPE_NAMESPACE_4': -25015,
        'VERR_ISOMK_IPE_NAMESPACE_5': -25016,
        'VERR_ISOMK_IPE_NAMESPACE_6': -25017,
        'VERR_ISOMK_IPE_EMPTY_PATH': -25018,
        'VERR_ISOMK_IPE_EMPTY_COMPONENT': -25019,
        'VERR_ISOMK_IPE_ROOT_SLASH': -25020,
        'VERR_ISOMK_IPE_DESC_COUNT': -25021,
        'VERR_ISOMK_IPE_BUFFER_SIZE': -25022,
        'VERR_ISOMK_IPE_BOOT_CAT_FILE': -25023,
        'VERR_ISOMK_IPE_PRODUCE_TRANS_TBL': -25024,
        'VERR_ISOMK_IPE_READ_FILE_DATA_1': -25025,
        'VERR_ISOMK_IPE_READ_FILE_DATA_2': -25026,
        'VERR_ISOMK_IPE_READ_FILE_DATA_3': -25027,
        'VERR_ISOMK_IPE_FINALIZE_1': -25028,
        'VERR_ISOMK_RR_SPILL_FILE_FULL': -25029,
        'VERR_ISOMK_IMPORT_UNKNOWN_FORMAT': -25100,
        'VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS': -25101,
        'VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR': -25102,
        'VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS': -25103,
        'VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS': -25104,
        'VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS': -25105,
        'VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY': -25106,
        'VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER': -25107,
        'VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC': -25108,
        'VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER': -25109,
        'VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC': -25110,
        'VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB': -25111,
        'VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET': -25112,
        'VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO': -25113,
        'VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH': -25114,
        'VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH': -25115,
        'VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC': -25116,
        'VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR': -25117,
        'VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO': -25118,
        'VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS': -25119,
        'VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH': -25120,
        'VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG': -25121,
        'VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT': -25122,
        'VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE': -25123,
        'VERR_ISOMK_IMPORT_BAD_DIR_REC': -25124,
        'VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO': -25125,
        'VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS': -25126,
        'VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH': -25127,
        'VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH': -25128,
        'VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME': -25129,
        'VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS': -25130,
        'VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC': -25131,
        'VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT': -25132,
        'VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT': -25133,
        'VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS': -25140,
        'VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID': -25141,
        'VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS': -25142,
        'VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM': -25143,
        'VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID': -25144,
        'VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE': -25145,
        'VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS': -25146,
        'VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG': -25147,
        'VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD': -25148,
        'VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS': -25149,
        'VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE': -25150,
        'VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG': -25151,
        'VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND': -25152,
        'VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID': -25153,
        'VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS': -25154,
        'VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR': -25155,
        'VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE': -25156,
        'VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS': -25157,
        'VERR_ISOFS_TAG_IS_ALL_ZEROS': -25300,
        'VERR_ISOFS_UNSUPPORTED_TAG_VERSION': -25301,
        'VERR_ISOFS_BAD_TAG_CHECKSUM': -25302,
        'VERR_ISOFS_TAG_SECTOR_MISMATCH': -25303,
        'VERR_ISOFS_DESC_CRC_MISMATCH': -25304,
        'VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC': -25305,
        'VERR_ISOFS_UNEXPECTED_VDS_DESC': -25306,
        'VERR_ISOFS_TOO_MANY_PVDS': -25307,
        'VERR_ISOFS_TOO_MANY_LVDS': -25308,
        'VERR_ISOFS_TOO_MANY_PDS': -25309,
        'VERR_ISOFS_TOO_BIT_PARTMAP_IN_LVD': -25310,
        'VERR_ISOFS_NO_PVD': -25311,
        'VERR_ISOFS_NO_LVD': -25312,
        'VERR_ISOFS_NO_PD': -25313,
        'VERR_ISOFS_MULTIPLE_PVDS': -25314,
        'VERR_ISOFS_MULTIPLE_LVDS': -25315,
        'VERR_ISOFS_TOO_MANY_PART_MAPS': -25316,
        'VERR_ISOFS_MALFORMED_PART_MAP_TABLE': -25317,
        'VERR_ISOFS_PARTITION_NOT_FOUND': -25318,
        'VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE': -25319,
        'VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE': -25320,
        'VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID': -25321,
        'VERR_ISOFS_VPM_NOT_SUPPORTED': -25322,
        'VERR_ISOFS_SPM_NOT_SUPPORTED': -25323,
        'VERR_ISOFS_MPM_NOT_SUPPORTED': -25324,
        'VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE': -25325,
        'VERR_ISOFS_BAD_LVD_DOMAIN_ID': -25326,
        'VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION': -25327,
        'VERR_ISOFS_BAD_LVD_DESC_CHAR_SET': -25329,
        'VERR_ISOFS_INVALID_PARTITION_INDEX': -25330,
        'VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET': -25331,
        'VERR_ISOFS_FSD_ZERO_ROOT_DIR': -25332,
        'VERR_ISOFS_FSD_NEXT_EXTENT': -25333,
        'VERR_ISOFS_ICB_TOO_BIG': -25334,
        'VERR_ISOFS_ICB_TOO_SMALL': -25335,
        'VERR_ISOFS_NO_DIRECT_ICB_ENTRIES': -25336,
        'VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS': -25337,
        'VERR_ISOFS_TOO_DEEP_ICB_RECURSION': -25338,
        'VERR_ISOFS_ICB_ENTRY_TOO_SMALL': -25339,
        'VERR_ISOFS_UNSUPPORTED_ICB': -25340,
        'VERR_ISOFS_BAD_FILE_ENTRY': -25341,
        'VERR_ISO_FS_UNKNOWN_AD_TYPE': -25342,
        'VERR_ISOFS_BAD_EXTAD': -25343,
        'VERR_ISOFS_WRONG_FILE_TYPE': -25344,
        'VERR_ISOFS_UNKNOWN_FILE_TYPE': -25345,
        'VERR_ISOFS_UDF_NOT_IMPLEMENTED': -25390,
        'VERR_ISOFS_IPE_1': -25391,
        'VERR_ISOFS_IPE_2': -25392,
        'VERR_ISOFS_IPE_3': -25393,
        'VERR_ISOFS_IPE_4': -25394,
        'VERR_ISOFS_IPE_5': -25395,
        'VERR_SERIALPORT_BREAK_DETECTED': -25500,
        'VERR_SERIALPORT_INVALID_BAUDRATE': -25501,
        'VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED': -25700,
        'VERR_REST_RESPONSE_INVALID_UTF8_ENCODING': -25701,
        'VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR': -25702,
        'VERR_REST_RESPONSE_REPEAT_HEADER_FIELD': -25703,
        'VWRN_REST_UNABLE_TO_DECODE_DATE': 25704,
        'VERR_REST_UNABLE_TO_DECODE_DATE': -25704,
        'VERR_REST_WRONG_JSON_TYPE_FOR_BOOL': -25705,
        'VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER': -25706,
        'VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE': -25707,
        'VERR_REST_WRONG_JSON_TYPE_FOR_STRING': -25708,
        'VERR_REST_WRONG_JSON_TYPE_FOR_DATE': -25709,
        'VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL': -25710,
        'VERR_REST_PATH_PARAMETER_NOT_SET': -25711,
        'VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET': -25712,
        'VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET': -25713,
        'VERR_REST_INTERNAL_ERROR_1': -25791,
        'VERR_REST_INTERNAL_ERROR_2': -25792,
        'VERR_REST_INTERNAL_ERROR_3': -25793,
        'VERR_REST_INTERNAL_ERROR_4': -25794,
        'VERR_REST_INTERNAL_ERROR_5': -25795,
        'VERR_REST_INTERNAL_ERROR_6': -25796,
        'VERR_REST_INTERNAL_ERROR_7': -25797,
        'VERR_REST_INTERNAL_ERROR_8': -25798,
        'VERR_REST_INTERNAL_ERROR_9': -25799,
        'VERR_CR_CIPHER_NOT_SUPPORTED': -25800,
        'VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED': -25801,
        'VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED': -25802,
        'VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED': -25803,
        'VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED': -25804,
        'VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED': -25805,
        'VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED': -25806,
        'VERR_CR_CIPHER_INVALID_KEY_LENGTH': -25807,
        'VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH': -25808,
        'VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED': -26000,
        'VERR_IOQUEUE_HANDLE_NOT_REGISTERED': -26200,
        'VERR_IOQUEUE_FULL': -26201,
        'VERR_IOQUEUE_EMPTY': -26202,
        'VERR_IOQUEUE_BUSY': -26203,
        'VERR_FTP_STATUS_SERVER_ERROR': -26400,
        'VERR_FTP_INIT_FAILED': -26401,
        'VERR_NO_VM_MEMORY': -1000,
        'VERR_DONT_PANIC': -1001,
        'VERR_UNSUPPORTED_CPU': -1002,
        'VERR_UNSUPPORTED_CPU_MODE': -1003,
        'VERR_PAGE_NOT_PRESENT': -1004,
        'VERR_CFG_INVALID_FORMAT': -1005,
        'VERR_CFG_NO_VALUE': -1006,
        'VERR_SELECTOR_NOT_PRESENT': -1007,
        'VERR_NOT_CODE_SELECTOR': -1008,
        'VERR_NOT_DATA_SELECTOR': -1009,
        'VERR_OUT_OF_SELECTOR_BOUNDS': -1010,
        'VERR_INVALID_SELECTOR': -1011,
        'VERR_INVALID_RPL': -1012,
        'VERR_PAGE_MAP_LEVEL4_NOT_PRESENT': -1013,
        'VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT': -1014,
        'VERR_RAW_MODE_INVALID_SMP': -1015,
        'VERR_INVALID_VM_HANDLE': -1016,
        'VERR_INVALID_VMCPU_HANDLE': -1017,
        'VERR_INVALID_CPU_ID': -1018,
        'VERR_TOO_MANY_CPUS': -1019,
        'VERR_SERVICE_DISABLED': -1020,
        'VERR_NOT_SUP_IN_RAW_MODE': -1021,
        'VERR_INVALID_CPU_INDEX': -1022,
        'VERR_RAW_MODE_NOT_SUPPORTED': -1023,
        'VERR_INCONSISTENT_VM_HANDLE': -1024,
        'VERR_VM_RESTORED': -1025,
        'VERR_NOT_SUP_BY_NEM': -1026,
        'VINF_EM_FIRST': 1100,
        'VINF_EM_TERMINATE': 1100,
        'VINF_EM_DBG_HYPER_STEPPED': 1101,
        'VINF_EM_DBG_HYPER_BREAKPOINT': 1102,
        'VINF_EM_DBG_HYPER_ASSERTION': 1103,
        'VINF_EM_DBG_EVENT': 1104,
        'VINF_EM_DBG_STOP': 1105,
        'VINF_EM_DBG_STEPPED': 1106,
        'VINF_EM_DBG_BREAKPOINT': 1107,
        'VINF_EM_DBG_STEP': 1108,
        'VINF_EM_OFF': 1109,
        'VINF_EM_SUSPEND': 1110,
        'VINF_EM_RESET': 1111,
        'VINF_EM_HALT': 1112,
        'VINF_EM_RESUME': 1113,
        'VINF_EM_NO_MEMORY': 1114,
        'VERR_EM_NO_MEMORY': -1114,
        'VINF_EM_RESCHEDULE_REM': 1115,
        'VINF_EM_RESCHEDULE_HM': 1116,
        'VINF_EM_RESCHEDULE_RAW': 1117,
        'VINF_EM_RESCHEDULE': 1118,
        'VINF_EM_RESCHEDULE_PARAV': 1119,
        'VINF_EM_WAIT_SIPI': 1120,
        'VINF_EM_LAST': 1120,
        'VINF_EM_RAW_GUEST_TRAP': 1121,
        'VINF_EM_RAW_INTERRUPT': 1122,
        'VINF_EM_RAW_INTERRUPT_HYPER': 1123,
        'VINF_EM_RAW_RING_SWITCH': 1124,
        'VINF_EM_RAW_RING_SWITCH_INT': 1125,
        'VINF_EM_RAW_EXCEPTION_PRIVILEGED': 1126,
        'VINF_EM_RAW_EMULATE_INSTR': 1127,
        'VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT': 1128,
        'VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT': 1129,
        'VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT': 1130,
        'VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT': 1131,
        'VERR_EM_RAW_PATCH_CONFLICT': -1133,
        'VINF_EM_RAW_TO_R3': 1135,
        'VINF_EM_RAW_TIMER_PENDING': 1136,
        'VINF_EM_RAW_INTERRUPT_PENDING': 1137,
        'VINF_EM_RAW_STALE_SELECTOR': 1138,
        'VINF_EM_RAW_IRET_TRAP': 1139,
        'VERR_EM_INTERPRETER': -1148,
        'VERR_EM_INTERNAL_ERROR': -1149,
        'VINF_EM_PENDING_REQUEST': 1150,
        'VINF_EM_RAW_EMULATE_DBG_STEP': 1151,
        'VINF_EM_HM_PATCH_TPR_INSTR': 1152,
        'VERR_EM_UNEXPECTED_MAPPING_CONFLICT': -1154,
        'VINF_EM_TRIPLE_FAULT': 1155,
        'VERR_EM_CANNOT_EXEC_GUEST': -1156,
        'VINF_EM_RAW_INJECT_TRPM_EVENT': 1157,
        'VERR_EM_GUEST_CPU_HANG': -1158,
        'VINF_EM_PENDING_R3_IOPORT_READ': 1159,
        'VINF_EM_PENDING_R3_IOPORT_WRITE': 1160,
        'VINF_EM_RESUME_R3_HISTORY_EXEC': 1161,
        'VERR_DBGF_NOT_ATTACHED': -1200,
        'VERR_DBGF_ALREADY_ATTACHED': -1201,
        'VWRN_DBGF_ALREADY_HALTED': 1202,
        'VERR_DBGF_NO_MORE_BP_SLOTS': -1203,
        'VERR_DBGF_BP_NOT_FOUND': -1204,
        'VINF_DBGF_BP_ALREADY_ENABLED': 1205,
        'VINF_DBGF_BP_ALREADY_DISABLED': 1206,
        'VINF_DBGF_BP_ALREADY_EXIST': 1207,
        'VERR_DBGF_MEM_NOT_FOUND': -1208,
        'VERR_DBGF_OS_NOT_DETCTED': -1209,
        'VINF_DBGF_OS_NOT_DETCTED': 1209,
        'VERR_DBGF_REGISTER_NOT_FOUND': -1210,
        'VINF_DBGF_TRUNCATED_REGISTER': 1211,
        'VINF_DBGF_ZERO_EXTENDED_REGISTER': 1212,
        'VERR_DBGF_UNSUPPORTED_CAST': -1213,
        'VERR_DBGF_READ_ONLY_REGISTER': -1214,
        'VERR_DBGF_REG_IPE_1': -1215,
        'VERR_DBGF_REG_IPE_2': -1216,
        'VERR_DBGF_HYPER_DB_XCPT': -1217,
        'VERR_DBGF_STACK_IPE_1': -1218,
        'VERR_DBGF_STACK_IPE_2': -1219,
        'VERR_DBGF_NO_TRACE_BUFFER': -1220,
        'VWRN_CONTINUE_ANALYSIS': 1400,
        'VERR_PATCHING_REFUSED': -1401,
        'VERR_PATCH_NOT_FOUND': -1402,
        'VERR_PATCH_DISABLED': -1403,
        'VWRN_PATCH_ENABLED': 1404,
        'VERR_PATCH_ALREADY_DISABLED': -1405,
        'VERR_PATCH_ALREADY_ENABLED': -1406,
        'VWRN_PATCH_REMOVED': 1407,
        'VINF_PATM_PATCH_TRAP_GP': 1408,
        'VINF_PATM_PATCH_TRAP_PF': 1409,
        'VINF_PATM_PATCH_INT3': 1410,
        'VINF_PATM_CHECK_PATCH_PAGE': 1411,
        'VINF_PATM_DUPLICATE_FUNCTION': 1412,
        'VINF_PATCH_EMULATE_INSTR': 1413,
        'VINF_PATM_HC_MMIO_PATCH_WRITE': 1414,
        'VINF_PATM_HC_MMIO_PATCH_READ': 1415,
        'VINF_PATM_PENDING_IRQ_AFTER_IRET': 1416,
        'VERR_PATCH_NO_CONFLICT': -1425,
        'VERR_PATM_UNSAFE_CODE': -1426,
        'VWRN_PATCH_END_BRANCH': 1427,
        'VERR_PATM_ALREADY_PATCHED': -1428,
        'VINF_PATM_SPINLOCK_FAILED': 1429,
        'VINF_PATCH_CONTINUE': 1430,
        'VERR_PATM_HM_IPE': -1431,
        'VERR_PATM_IPE_TRAP_IN_PATCH_CODE': -1432,
        'VWRN_CSAM_TRAP_NOT_HANDLED': 1500,
        'VWRN_CSAM_INSTRUCTION_PATCHED': 1501,
        'VWRN_CSAM_PAGE_NOT_FOUND': 1502,
        'VINF_CSAM_PENDING_ACTION': 1503,
        'VERR_CSAM_HM_IPE': -1504,
        'VERR_PGM_MAPPING_CONFLICT': -1600,
        'VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE': -1601,
        'VERR_PGM_HANDLER_VIRTUAL_CONFLICT': -1602,
        'VERR_PGM_HANDLER_PHYSICAL_CONFLICT': -1603,
        'VERR_PGM_INVALID_PAGE_DIRECTORY': -1604,
        'VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS': -1605,
        'VERR_PGM_INVALID_GC_PHYSICAL_RANGE': -1606,
        'VERR_PGM_HANDLER_NOT_FOUND': -1607,
        'VERR_PGM_RAM_CONFLICT': -1608,
        'VERR_PGM_MAPPINGS_FIXED': -1609,
        'VERR_PGM_MAPPINGS_FIX_CONFLICT': -1610,
        'VERR_PGM_MAPPINGS_FIX_REJECTED': -1611,
        'VERR_PGM_MAPPINGS_FIX_TOO_SMALL': -1612,
        'VINF_PGM_SYNC_CR3': 1613,
        'VINF_PGM_NO_DIRTY_BIT_TRACKING': 1614,
        'VINF_PGM_HANDLED_DIRTY_BIT_FAULT': 1615,
        'VINF_PGM_HANDLER_DO_DEFAULT': 1616,
        'VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE': -1617,
        'VERR_PGM_PHYS_PAGE_RESERVED': -1618,
        'VERR_PGM_NO_HYPERVISOR_ADDRESS': -1619,
        'VINF_PGM_CACHED_PAGE': 1622,
        'VINF_PGM_GCPHYS_ALIASED': 1623,
        'VINF_PGM_CHANGE_MODE': 1624,
        'VINF_PGM_SYNCPAGE_MODIFIED_PDE': 1625,
        'VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY': -1626,
        'VERR_PGM_INTERMEDIATE_PAGING_CONFLICT': -1627,
        'VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE': -1628,
        'VERR_PGM_DYNMAP_FAILED': -1629,
        'VERR_PGM_DYNMAP_FULL_SET': -1630,
        'VERR_PGM_DYNMAP_SETUP_ERROR': -1631,
        'VERR_PGM_DYNMAP_EXPAND_ERROR': -1632,
        'VERR_PGM_PHYS_TLB_UNASSIGNED': -1633,
        'VERR_PGM_PHYS_TLB_CATCH_ALL': -1634,
        'VINF_PGM_PHYS_TLB_CATCH_WRITE': 1635,
        'VERR_PGM_PHYS_TLB_CATCH_WRITE': -1635,
        'VERR_PGM_NO_CR3_SHADOW_ROOT': -1636,
        'VERR_PGM_PHYS_INVALID_PAGE_ID': -1637,
        'VERR_PGM_PHYS_WR_HIT_HANDLER': -1638,
        'VERR_PGM_PHYS_NOT_RAM': -1639,
        'VERR_PGM_PHYS_NOT_ROM': -1640,
        'VERR_PGM_PHYS_NOT_MMIO': -1641,
        'VERR_PGM_PHYS_NOT_MMIO2': -1642,
        'VERR_PGM_HANDLER_ALREADY_ALIASED': -1643,
        'VINF_PGM_HANDLER_ALREADY_ALIASED': 1643,
        'VINF_PGM_POOL_FLUSH_PENDING': 1644,
        'VERR_PGM_INVALID_LARGE_PAGE_RANGE': -1645,
        'VERR_PGM_PHYS_PAGE_BALLOONED': -1646,
        'VERR_PGM_HANDLER_IPE_1': -1647,
        'VERR_PGM_MAP_MMIO2_ALIAS_MMIO': -1651,
        'VERR_PGM_MAPPINGS_DISABLED': -1652,
        'VERR_PGM_MAPPINGS_SMP': -1653,
        'VERR_PGM_INVALID_SAVED_PAGE_STATE': -1654,
        'VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE': -1655,
        'VERR_PGM_UNEXPECTED_PAGE_STATE': -1656,
        'VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND': -1657,
        'VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND': -1658,
        'VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND': -1659,
        'VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND': -1660,
        'VERR_PGM_SAVED_ROM_PAGE_PROT': -1661,
        'VERR_PGM_SAVED_REC_TYPE': -1662,
        'VERR_PGM_DYNMAP_IPE': -1663,
        'VERR_PGM_HANDY_PAGE_IPE': -1664,
        'VERR_PGM_PML4_MAPPING': -1665,
        'VERR_PGM_POOL_GET_PAGE_FAILED': -1666,
        'VERR_PGM_NOT_USED_IN_MODE': -1667,
        'VERR_PGM_INVALID_CR3_ADDR': -1668,
        'VERR_PGM_INVALID_PDPE_ADDR': -1669,
        'VERR_PGM_PHYS_HANDLER_IPE': -1670,
        'VERR_PGM_PHYS_PAGE_MAP_IPE_1': -1671,
        'VERR_PGM_PHYS_PAGE_MAP_IPE_2': -1672,
        'VERR_PGM_PHYS_PAGE_MAP_IPE_3': -1673,
        'VERR_PGM_PHYS_PAGE_MAP_IPE_4': -1674,
        'VERR_PGM_POOL_TOO_MANY_LOOPS': -1675,
        'VERR_PGM_MAPPING_IPE': -1676,
        'VERR_PGM_POOL_MAXED_OUT_ALREADY': -1677,
        'VERR_PGM_POOL_IPE': -1678,
        'VERR_PGM_WRITE_MONITOR_ENGAGED': -1679,
        'VERR_PGM_PHYS_PAGE_GET_IPE': -1680,
        'VERR_PGM_PHYS_NULL_PAGE_PARAM': -1681,
        'VERR_PGM_PCI_PASSTHRU_MISCONFIG': -1682,
        'VERR_PGM_TOO_MANY_MMIO2_RANGES': -1683,
        'VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE': -1684,
        'VERR_PGM_PHYS_MMIO_EX_IPE': -1685,
        'VERR_PGM_MODE_IPE': -1686,
        'VERR_PGM_SHW_NONE_IPE': -1687,
        'VERR_MM_RAM_CONFLICT': -1700,
        'VERR_MM_HYPER_NO_MEMORY': -1701,
        'VERR_MM_BAD_TRAP_TYPE_IPE': -1702,
        'VERR_CPUM_RAISE_GP_0': -1750,
        'VERR_CPUM_INCOMPATIBLE_CONFIG': -1751,
        'VERR_CPUM_HIDDEN_CS_LOAD_ERROR': -1752,
        'VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES': -1753,
        'VERR_CPUM_IPE_1': -1754,
        'VERR_CPUM_IPE_2': -1755,
        'VERR_CPUM_DB_CPU_NOT_FOUND': -1756,
        'VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET': -1757,
        'VINF_CPUM_R3_MSR_READ': 1758,
        'VINF_CPUM_R3_MSR_WRITE': 1759,
        'VERR_TOO_MANY_CPUID_LEAVES': -1760,
        'VERR_CPUM_INVALID_CONFIG_VALUE': -1761,
        'VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK': -1762,
        'VERR_CPUM_INVALID_XSAVE_COMP_MASK': -1763,
        'VERR_CPUM_INVALID_XSAVE_HDR': -1764,
        'VERR_CPUM_INVALID_XCR0': -1765,
        'VINF_CPUM_HOST_CR0_MODIFIED': 1766,
        'VERR_CPUM_INVALID_HWVIRT_CONFIG': -1767,
        'VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO': -1768,
        'VERR_SSM_UNIT_EXISTS': -1800,
        'VERR_SSM_UNIT_NOT_FOUND': -1801,
        'VERR_SSM_UNIT_NOT_OWNER': -1802,
        'VERR_SSM_INTEGRITY': -1810,
        'VERR_SSM_INTEGRITY_MAGIC': -1811,
        'VERR_SSM_INTEGRITY_VERSION': -1812,
        'VERR_SSM_INTEGRITY_SIZE': -1813,
        'VERR_SSM_INTEGRITY_CRC': -1814,
        'VERR_SMM_INTEGRITY_MACHINE': -1815,
        'VERR_SSM_INTEGRITY_HEADER': -1816,
        'VERR_SSM_INTEGRITY_UNIT': -1817,
        'VERR_SSM_INTEGRITY_UNIT_MAGIC': -1818,
        'VERR_SSM_INTEGRITY_UNIT_NOT_FOUND': -1819,
        'VERR_SSM_INTEGRITY_VBOX_VERSION': -1820,
        'VERR_SSM_INTEGRITY_FOOTER': -1821,
        'VERR_SSM_INTEGRITY_REC_HDR': -1822,
        'VERR_SSM_INTEGRITY_REC_TERM': -1823,
        'VERR_SSM_INTEGRITY_REC_TERM_CRC': -1824,
        'VERR_SSM_INTEGRITY_DECOMPRESSION': -1825,
        'VERR_SSM_INTEGRITY_DIR': -1826,
        'VERR_SSM_INTEGRITY_DIR_MAGIC': -1827,
        'VERR_SSM_NO_LOAD_EXEC': -1830,
        'VERR_SSM_LOADED_TOO_MUCH': -1831,
        'VERR_SSM_INVALID_STATE': -1832,
        'VERR_SSM_LOADED_TOO_LITTLE': -1833,
        'VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION': -1840,
        'VERR_SSM_DATA_UNIT_FORMAT_CHANGED': -1841,
        'VERR_SSM_LOAD_CPUID_MISMATCH': -1842,
        'VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH': -1843,
        'VERR_SSM_LOAD_CONFIG_MISMATCH': -1844,
        'VERR_SSM_VIRTUAL_CLOCK_HZ': -1845,
        'VERR_SSM_IDE_ASYNC_TIMEOUT': -1846,
        'VERR_SSM_STRUCTURE_MAGIC': -1847,
        'VERR_SSM_UNEXPECTED_DATA': -1848,
        'VERR_SSM_GCPHYS_OVERFLOW': -1849,
        'VERR_SSM_GCPTR_OVERFLOW': -1850,
        'VINF_SSM_VOTE_FOR_ANOTHER_PASS': 1851,
        'VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN': 1852,
        'VERR_SSM_VOTE_FOR_GIVING_UP': -1853,
        'VINF_SSM_DONT_CALL_AGAIN': 1854,
        'VERR_SSM_TOO_MANY_PASSES': -1855,
        'VERR_SSM_STATE_GREW_TOO_BIG': -1856,
        'VERR_SSM_LOW_ON_DISK_SPACE': -1857,
        'VERR_SSM_CANCELLED': -1858,
        'VERR_SSM_NO_PENDING_OPERATION': -1859,
        'VERR_SSM_ALREADY_CANCELLED': -1860,
        'VERR_SSM_LIVE_POWERED_OFF': -1861,
        'VERR_SSM_LIVE_GURU_MEDITATION': -1862,
        'VERR_SSM_LIVE_FATAL_ERROR': -1863,
        'VINF_SSM_LIVE_SUSPENDED': 1864,
        'VERR_SSM_FIELD_COMPLEX': -1864,
        'VERR_SSM_FIELD_INVALID_SIZE': -1865,
        'VERR_SSM_FIELD_OUT_OF_BOUNDS': -1866,
        'VERR_SSM_FIELD_NOT_CONSECUTIVE': -1867,
        'VERR_SSM_FIELD_INVALID_CALLBACK': -1868,
        'VERR_SSM_FIELD_INVALID_PADDING_SIZE': -1869,
        'VERR_SSM_FIELD_INVALID_VALUE': -1870,
        'VERR_SSM_STREAM_ERROR': -1871,
        'VERR_SSM_UNEXPECTED_PASS': -1872,
        'VERR_SSM_SKIP_BACKWARDS': -1873,
        'VERR_SSM_MEM_TOO_BIG': -1874,
        'VERR_SSM_BAD_REC_TYPE': -1875,
        'VERR_SSM_IPE_1': -1876,
        'VERR_SSM_IPE_2': -1877,
        'VERR_SSM_IPE_3': -1878,
        'VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION': -1879,
        'VERR_VM_ATRESET_NOT_FOUND': -1900,
        'VERR_VM_REQUEST_INVALID_TYPE': -1901,
        'VERR_VM_REQUEST_STATE': -1902,
        'VERR_VM_REQUEST_INVALID_PACKAGE': -1903,
        'VERR_VM_REQUEST_STATUS_STILL_PENDING': -1904,
        'VERR_VM_REQUEST_STATUS_FREED': -1905,
        'VERR_VM_THREAD_NOT_EMT': -1906,
        'VERR_VM_INVALID_VM_STATE': -1907,
        'VERR_VM_DRIVER_NOT_INSTALLED': -1908,
        'VERR_VM_DRIVER_NOT_ACCESSIBLE': -1909,
        'VERR_VM_DRIVER_LOAD_ERROR': -1910,
        'VERR_VM_DRIVER_OPEN_ERROR': -1911,
        'VERR_VM_DRIVER_VERSION_MISMATCH': -1912,
        'VERR_VM_SAVE_STATE_NOT_ALLOWED': -1913,
        'VERR_VM_THREAD_IS_EMT': -1914,
        'VERR_VM_UNEXPECTED_VM_STATE': -1915,
        'VERR_VM_UNEXPECTED_UNSTABLE_STATE': -1916,
        'VERR_VM_REQUEST_TOO_MANY_ARGS_IPE': -1917,
        'VERR_VM_FATAL_WAIT_ERROR': -1918,
        'VERR_VM_REQUEST_KILLED': -1919,
        'VERR_VRDP_ISO_UNSUPPORTED': -2000,
        'VERR_VRDP_SEC_ENGINE_FAIL': -2001,
        'VERR_VRDP_PROTOCOL_ERROR': -2002,
        'VERR_VRDP_NOT_SUPPORTED': -2003,
        'VERR_VRDP_INSUFFICIENT_DATA': -2004,
        'VERR_VRDP_INVALID_MODE': -2005,
        'VERR_VRDP_NO_MEMORY': -2006,
        'VERR_VRDP_ACCESS_DENIED': -2007,
        'VWRN_VRDP_PDU_NOT_SUPPORTED': 2008,
        'VINF_VRDP_PROCESS_PDU': 2009,
        'VINF_VRDP_OPERATION_COMPLETED': 2010,
        'VINF_VRDP_THREAD_STARTED': 2011,
        'VINF_VRDP_RESIZE_REQUESTED': 2012,
        'VINF_VRDP_OUTPUT_ENABLE': 2013,
        'VERR_CFGM_INTEGER_TOO_BIG': -2100,
        'VERR_CFGM_CHILD_NOT_FOUND': -2101,
        'VERR_CFGM_INVALID_CHILD_PATH': -2102,
        'VERR_CFGM_VALUE_NOT_FOUND': -2103,
        'VERR_CFGM_NO_PARENT': -2104,
        'VERR_CFGM_NO_NODE': -2105,
        'VERR_CFGM_NOT_INTEGER': -2106,
        'VERR_CFGM_NOT_STRING': -2107,
        'VERR_CFGM_NOT_BYTES': -2108,
        'VERR_CFGM_NOT_ENOUGH_SPACE': -2109,
        'VERR_CFGM_INVALID_NODE_PATH': -2160,
        'VERR_CFGM_NODE_EXISTS': -2161,
        'VERR_CFGM_LEAF_EXISTS': -2162,
        'VERR_CFGM_CONFIG_UNKNOWN_VALUE': -2163,
        'VERR_CFGM_CONFIG_UNKNOWN_NODE': -2164,
        'VERR_CFGM_IPE_1': -2165,
        'VERR_TM_LOAD_STATE': -2200,
        'VERR_TM_INVALID_STATE': -2201,
        'VERR_TM_UNKNOWN_STATE': -2202,
        'VERR_TM_UNSTABLE_STATE': -2203,
        'VERR_TM_GIP_REQUIRED': -2204,
        'VERR_TM_GIP_VERSION': -2205,
        'VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG': -2206,
        'VERR_TM_TIMER_BAD_CLOCK': -2207,
        'VERR_TM_TIMER_UNSTABLE_STATE': -2208,
        'VERR_TM_TSC_ALREADY_TICKING': -2209,
        'VERR_TM_TSC_ALREADY_PAUSED': -2210,
        'VERR_TM_VIRTUAL_TICKING_IPE': -2211,
        'VERR_REM_VIRTUAL_HARDWARE_ERROR': -2300,
        'VERR_REM_VIRTUAL_CPU_ERROR': -2301,
        'VINF_REM_INTERRUPED_FF': 2302,
        'VERR_REM_TOO_MANY_TRAPS': -2304,
        'VERR_REM_NO_MORE_BP_SLOTS': -2305,
        'VERR_REM_BP_NOT_FOUND': -2306,
        'VERR_TRPM_NO_ACTIVE_TRAP': -2400,
        'VERR_TRPM_ACTIVE_TRAP': -2401,
        'VERR_TRPM_SHADOW_IDT_WRITE': -2402,
        'VERR_TRPM_DONT_PANIC': -2403,
        'VERR_TRPM_PANIC': -2404,
        'VINF_TRPM_XCPT_DISPATCHED': 2405,
        'VERR_TRPM_BAD_TRAP_IN_OP': -2406,
        'VERR_TRPM_IPE_1': -2407,
        'VERR_TRPM_IPE_2': -2408,
        'VERR_TRPM_IPE_3': -2409,
        'VERR_TRPM_HM_IPE': -2410,
        'VERR_SELM_SHADOW_GDT_WRITE': -2500,
        'VERR_SELM_SHADOW_LDT_WRITE': -2501,
        'VERR_SELM_SHADOW_TSS_WRITE': -2502,
        'VINF_SELM_SYNC_GDT': 2503,
        'VERR_SELM_NO_TSS': -2504,
        'VERR_SELM_INVALID_LDT': -2505,
        'VERR_SELM_LDT_OUT_OF_BOUNDS': -2506,
        'VERR_SELM_GDT_READ_ERROR': -2507,
        'VERR_SELM_GDT_TOO_FULL': -2508,
        'VERR_SELM_HM_IPE': -2509,
        'VERR_IOM_INVALID_IOPORT_RANGE': -2600,
        'VERR_IOM_NO_R3_IOPORT_RANGE': -2601,
        'VERR_IOM_IOPORT_RANGE_CONFLICT': -2602,
        'VERR_IOM_IOPORT_RANGE_NOT_FOUND': -2603,
        'VERR_IOM_NOT_IOPORT_RANGE_OWNER': -2604,
        'VERR_IOM_INVALID_MMIO_RANGE': -2605,
        'VERR_IOM_NO_R3_MMIO_RANGE': -2606,
        'VERR_IOM_NOT_MMIO_RANGE_OWNER': -2607,
        'VERR_IOM_MMIO_RANGE_CONFLICT': -2608,
        'VERR_IOM_MMIO_RANGE_NOT_FOUND': -2609,
        'VERR_IOM_INCOMPLETE_MMIO_RANGE': -2610,
        'VERR_IOM_INVALID_IOPORT_SIZE': -2611,
        'VERR_IOM_MMIO_HANDLER_BOGUS_CALL': -2612,
        'VERR_IOM_MMIO_HANDLER_DISASM_ERROR': -2613,
        'VERR_IOM_IOPORT_UNUSED': -2614,
        'VINF_IOM_MMIO_UNUSED_00': 2615,
        'VINF_IOM_MMIO_UNUSED_FF': 2616,
        'VINF_IOM_R3_IOPORT_READ': 2620,
        'VINF_IOM_R3_IOPORT_WRITE': 2621,
        'VINF_IOM_R3_IOPORT_COMMIT_WRITE': 2622,
        'VINF_IOM_R3_MMIO_READ': 2623,
        'VINF_IOM_R3_MMIO_WRITE': 2624,
        'VINF_IOM_R3_MMIO_READ_WRITE': 2625,
        'VINF_IOM_R3_MMIO_COMMIT_WRITE': 2626,
        'VERR_IOM_IOPORT_UNKNOWN_OPCODE': -2630,
        'VERR_IOM_IOPORT_IPE_1': -2631,
        'VERR_IOM_IOPORT_IPE_2': -2632,
        'VERR_IOM_IOPORT_IPE_3': -2633,
        'VERR_IOM_MMIO_IPE_1': -2634,
        'VERR_IOM_MMIO_IPE_2': -2635,
        'VERR_IOM_MMIO_IPE_3': -2636,
        'VERR_IOM_HM_IPE': -2637,
        'VERR_IOM_FF_STATUS_IPE': -2638,
        'VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS': -2650,
        'VERR_IOM_INVALID_IOPORT_HANDLE': -2651,
        'VERR_IOM_IOPORTS_ALREADY_MAPPED': -2652,
        'VERR_IOM_IOPORTS_NOT_MAPPED': -2653,
        'VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS': -2660,
        'VERR_IOM_INVALID_MMIO_HANDLE': -2661,
        'VERR_IOM_MMIO_REGION_ALREADY_MAPPED': -2662,
        'VERR_IOM_MMIO_REGION_NOT_MAPPED': -2663,
        'VINF_VMM_CALL_HOST': 2700,
        'VERR_VMM_RING0_ASSERTION': -2701,
        'VERR_VMM_HYPER_CR3_MISMATCH': -2702,
        'VERR_VMM_RING3_CALL_DISABLED': -2703,
        'VERR_VMM_R0_VERSION_MISMATCH': -2704,
        'VERR_VMM_RC_VERSION_MISMATCH': -2705,
        'VERR_VMM_SET_JMP_ERROR': -2706,
        'VERR_VMM_SET_JMP_STACK_OVERFLOW': -2707,
        'VERR_VMM_SET_JMP_ABORTED_RESUME': -2708,
        'VERR_VMM_LONG_JMP_ERROR': -2709,
        'VERR_VMM_UNKNOWN_RING3_CALL': -2710,
        'VERR_VMM_RING3_CALL_NO_RC': -2711,
        'VINF_VMM_CALL_TRACER': 2712,
        'VERR_VMM_SWITCHER_IPE_1': -2713,
        'VINF_VMM_UNKNOWN_RING3_CALL': 2714,
        'VERR_VMM_SWITCHER_STUB': -2715,
        'VERR_VMM_WRONG_HM_VMCPU_STATE': -2716,
        'VERR_VMM_SMAP_BUT_AC_CLEAR': -2717,
        'VERR_VMM_WRONG_NEM_VMCPU_STATE': -2718,
        'VERR_PDM_NO_SUCH_LUN': -2800,
        'VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES': -2801,
        'VERR_PDM_MISSING_INTERFACE_ABOVE': -2802,
        'VERR_PDM_MISSING_INTERFACE_BELOW': -2803,
        'VERR_PDM_MISSING_INTERFACE': -2804,
        'VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES': -2805,
        'VERR_PDM_TOO_PCI_MANY_DEVICES': -2806,
        'VERR_PDM_NO_QUEUE_ITEMS': -2807,
        'VERR_PDM_DRVINS_NO_ATTACH': -2808,
        'VERR_PDM_DEVINS_NO_ATTACH': -2809,
        'VERR_PDM_NO_ATTACHED_DRIVER': -2810,
        'VERR_PDM_GEOMETRY_NOT_SET': -2811,
        'VERR_PDM_TRANSLATION_NOT_SET': -2812,
        'VERR_PDM_MEDIA_NOT_MOUNTED': -2813,
        'VERR_PDM_MEDIA_MOUNTED': -2814,
        'VERR_PDM_MEDIA_LOCKED': -2815,
        'VERR_PDM_BLOCK_NO_TYPE': -2816,
        'VERR_PDM_BLOCK_UNKNOWN_TYPE': -2817,
        'VERR_PDM_BLOCK_UNKNOWN_TRANSLATION': -2818,
        'VERR_PDM_UNSUPPORTED_BLOCK_TYPE': -2819,
        'VERR_PDM_DRIVER_ALREADY_ATTACHED': -2820,
        'VERR_PDM_NO_DRIVER_ATTACHED': -2821,
        'VERR_PDM_CFG_MISSING_DRIVER_NAME': -2822,
        'VERR_PDM_DRIVER_NOT_FOUND': -2823,
        'VINF_PDM_ALREADY_LOADED': 2824,
        'VERR_PDM_MODULE_NAME_CLASH': -2825,
        'VERR_PDM_NO_REGISTRATION_EXPORT': -2826,
        'VERR_PDM_MODULE_NAME_TOO_LONG': -2827,
        'VERR_PDM_DRIVER_NAME_CLASH': -2828,
        'VERR_PDM_UNKNOWN_DRVREG_VERSION': -2829,
        'VERR_PDM_INVALID_DRIVER_REGISTRATION': -2830,
        'VERR_PDM_INVALID_DRIVER_HOST_BITS': -2831,
        'VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE': -2832,
        'VERR_PDM_NO_PCI_BUS': -2833,
        'VERR_PDM_NOT_PCI_DEVICE': -2834,
        'VERR_PDM_UNKNOWN_DEVREG_VERSION': -2835,
        'VERR_PDM_INVALID_DEVICE_REGISTRATION': -2836,
        'VERR_PDM_INVALID_DEVICE_GUEST_BITS': -2837,
        'VERR_PDM_INVALID_DEVICE_HOST_BITS': -2838,
        'VERR_PDM_DEVICE_NAME_CLASH': -2839,
        'VERR_PDM_DEVICE_NOT_FOUND': -2840,
        'VERR_PDM_DEVICE_INSTANCE_NOT_FOUND': -2841,
        'VERR_PDM_DEVICE_INSTANCE_NO_IBASE': -2842,
        'VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND': -2843,
        'VERR_PDM_DRIVER_INSTANCE_NOT_FOUND': -2844,
        'VERR_PDM_LUN_NOT_FOUND': -2845,
        'VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN': -2846,
        'VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN': 2846,
        'VERR_PDM_NO_PIC_INSTANCE': -2847,
        'VERR_PDM_NO_APIC_INSTANCE': -2848,
        'VERR_PDM_NO_DMAC_INSTANCE': -2849,
        'VERR_PDM_NO_RTC_INSTANCE': -2850,
        'VERR_PDM_HIF_SHARING_VIOLATION': -2851,
        'VERR_PDM_HIF_OPEN_FAILED': -2852,
        'VERR_PDM_DEVICE_NO_RT_ATTACH': -2853,
        'VERR_PDM_DRIVER_NO_RT_ATTACH': -2854,
        'VERR_PDM_HIF_INVALID_VERSION': -2855,
        'VERR_PDM_UNKNOWN_USBREG_VERSION': -2856,
        'VERR_PDM_INVALID_USB_REGISTRATION': -2857,
        'VERR_PDM_USB_NAME_CLASH': -2858,
        'VERR_PDM_USB_HUB_EXISTS': -2859,
        'VERR_PDM_NO_USB_HUBS': -2860,
        'VERR_PDM_NO_USB_PORTS': -2861,
        'VERR_PDM_NO_USBPROXY': -2862,
        'VERR_PDM_ASYNC_TEMPLATE_BUSY': -2863,
        'VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED': -2864,
        'VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED': -2865,
        'VERR_PDM_DRIVER_INVALID_PROPERTIES': -2866,
        'VERR_PDM_TOO_MANY_DEVICE_INSTANCES': -2867,
        'VERR_PDM_TOO_MANY_DRIVER_INSTANCES': -2868,
        'VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES': -2869,
        'VERR_PDM_DEVINS_VERSION_MISMATCH': -2870,
        'VERR_PDM_DEVHLP_VERSION_MISMATCH': -2871,
        'VERR_PDM_USBINS_VERSION_MISMATCH': -2872,
        'VERR_PDM_USBHLPR3_VERSION_MISMATCH': -2873,
        'VERR_PDM_DRVINS_VERSION_MISMATCH': -2874,
        'VERR_PDM_DRVHLPR3_VERSION_MISMATCH': -2875,
        'VERR_PDM_DEVICE_VERSION_MISMATCH': -2876,
        'VERR_PDM_USBDEV_VERSION_MISMATCH': -2877,
        'VERR_PDM_DRIVER_VERSION_MISMATCH': -2878,
        'VERR_PDM_DEV_HEAP_R3_TO_GCPHYS': -2879,
        'VERR_PDM_HPET_LEGACY_NOTIFY_MISSING': -2880,
        'VERR_PDM_CRITSECT_IPE': -2881,
        'VERR_PDM_CRITSECT_NOT_FOUND': -2882,
        'VERR_PDM_THREAD_INVALID_CALLER': -2883,
        'VERR_PDM_THREAD_IPE_1': -2884,
        'VERR_PDM_THREAD_IPE_2': -2885,
        'VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE': -2886,
        'VERR_PDM_BAD_PCI_CONFIG': -2887,
        'VERR_PDM_DEV_IPE_1': -2888,
        'VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION': -2889,
        'VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER': -2890,
        'VERR_PDM_NOT_PCI_BUS_MASTER': -2891,
        'VERR_PDM_HM_IPE': -2892,
        'VERR_PDM_MEDIAEX_IOREQ_CANCELED': -2893,
        'VERR_PDM_MEDIAEX_IOBUF_OVERFLOW': -2894,
        'VERR_PDM_MEDIAEX_IOBUF_UNDERRUN': -2895,
        'VERR_PDM_MEDIAEX_IOREQID_CONFLICT': -2896,
        'VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND': -2897,
        'VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS': 2898,
        'VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE': -2899,
        'VINF_PDM_PCI_DO_DEFAULT': 7200,
        'VERR_HGCM_SERVICE_NOT_FOUND': -2900,
        'VINF_HGCM_CLIENT_REJECTED': 2901,
        'VERR_HGCM_INVALID_CMD_ADDRESS': -2902,
        'VINF_HGCM_ASYNC_EXECUTE': 2903,
        'VERR_HGCM_INTERNAL': -2904,
        'VERR_HGCM_INVALID_CLIENT_ID': -2905,
        'VINF_HGCM_SAVE_STATE': 2906,
        'VERR_HGCM_SERVICE_EXISTS': -2907,
        'VERR_NAT_REDIR_GUEST_IP': -3001,
        'VERR_NAT_REDIR_SETUP': -3002,
        'VERR_HOSTIF_INIT_FAILED': -3100,
        'VERR_HOSTIF_DEVICE_NAME_TOO_LONG': -3101,
        'VERR_HOSTIF_IOCTL': -3102,
        'VERR_HOSTIF_BLOCKING': -3103,
        'VERR_HOSTIF_FD_AND_INIT_TERM': -3104,
        'VERR_HOSTIF_TERM_FAILED': -3105,
        'VERR_VD_INVALID_TYPE': -3200,
        'VERR_VD_INVALID_STATE': -3201,
        'VERR_VD_VALUE_NOT_FOUND': -3202,
        'VERR_VD_NOT_OPENED': -3203,
        'VERR_VD_IMAGE_NOT_FOUND': -3204,
        'VERR_VD_IMAGE_READ_ONLY': -3205,
        'VERR_VD_GEOMETRY_NOT_SET': -3206,
        'VERR_VD_BLOCK_FREE': -3207,
        'VERR_VD_UUID_MISMATCH': -3208,
        'VINF_VD_ASYNC_IO_FINISHED': 3209,
        'VERR_VD_ASYNC_IO_IN_PROGRESS': -3210,
        'VERR_VD_INVALID_SIZE': -3211,
        'VERR_VD_UNKNOWN_CFG_VALUES': -3212,
        'VERR_VD_UNKNOWN_INTERFACE': -3213,
        'VERR_VD_DEK_MISSING': -3214,
        'VERR_VD_PASSWORD_INCORRECT': -3215,
        'VERR_VD_GEN_INVALID_HEADER': -3220,
        'VERR_VD_VDI_INVALID_HEADER': -3230,
        'VERR_VD_VDI_INVALID_SIGNATURE': -3231,
        'VERR_VD_VDI_UNSUPPORTED_VERSION': -3232,
        'VERR_VD_VDI_COMMENT_TOO_LONG': -3233,
        'VERR_VD_VMDK_INVALID_HEADER': -3240,
        'VERR_VD_VMDK_UNSUPPORTED_VERSION': -3241,
        'VERR_VD_VMDK_VALUE_NOT_FOUND': -3242,
        'VERR_VD_VMDK_INVALID_STATE': -3243,
        'VERR_VD_VMDK_INVALID_FORMAT': -3244,
        'VERR_VD_VMDK_INVALID_WRITE': -3245,
        'VERR_VD_ISCSI_INVALID_HEADER': -3250,
        'VERR_VD_ISCSI_INVALID_STATE': -3251,
        'VERR_VD_ISCSI_INVALID_TYPE': -3252,
        'VERR_VD_ISCSI_SECRET_ENCRYPTED': -3253,
        'VERR_VD_VHD_INVALID_HEADER': -3260,
        'VERR_VD_PARALLELS_INVALID_HEADER': -3265,
        'VERR_VD_DMG_INVALID_HEADER': -3267,
        'VERR_VD_RAW_INVALID_HEADER': -3270,
        'VERR_VD_RAW_INVALID_TYPE': -3271,
        'VERR_VD_NOT_ENOUGH_METADATA': -3272,
        'VERR_VD_IOCTX_HALT': -3273,
        'VERR_VD_CACHE_ALREADY_EXISTS': -3274,
        'VERR_VD_CACHE_NOT_FOUND': -3275,
        'VERR_VD_CACHE_NOT_UP_TO_DATE': -3276,
        'VERR_VD_DISCARD_ALIGNMENT_NOT_MET': -3277,
        'VERR_VD_DISCARD_NOT_SUPPORTED': -3278,
        'VERR_VD_IMAGE_CORRUPTED': -3279,
        'VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED': -3280,
        'VERR_VD_IMAGE_REPAIR_IMPOSSIBLE': -3281,
        'VERR_VD_READ_OUT_OF_RANGE': -3282,
        'VINF_VD_NEW_ZEROED_BLOCK': 3283,
        'VERR_VD_DMG_XML_PARSE_ERROR': -3284,
        'VERR_VD_DMG_NOT_FOUND_INSIDE_XAR': -3285,
        'VERR_VD_RAW_SIZE_MODULO_512': -3286,
        'VERR_VD_RAW_SIZE_MODULO_2048': -3287,
        'VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL': -3288,
        'VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG': -3289,
        'VERR_VD_SHRINK_NOT_SUPPORTED': -3290,
        'VERR_VBGL_NOT_INITIALIZED': -3300,
        'VERR_VBGL_INVALID_ADDR': -3301,
        'VERR_VBGL_IOCTL_FAILED': -3302,
        'VERR_VUSB_NO_PORTS': -3400,
        'VERR_VUSB_DEVICE_NOT_ATTACHED': -3401,
        'VERR_VUSB_NO_URB_MEMORY': -3402,
        'VERR_VUSB_FAILED_TO_QUEUE_URB': -3403,
        'VERR_VUSB_DEVICE_NAME_NOT_FOUND': -3404,
        'VERR_VUSB_USBFS_PERMISSION': -3405,
        'VERR_VUSB_DEVICE_IS_RESETTING': -3406,
        'VERR_VUSB_DEVICE_IS_SUSPENDED': -3407,
        'VERR_VUSB_USB_DEVICE_PERMISSION': -3408,
        'VERR_VGA_INVALID_CUSTOM_MODE': -3500,
        'VINF_VGA_RESIZE_IN_PROGRESS': 3501,
        'VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE': -3502,
        'VERR_VGA_GL_LOAD_FAILURE': -3503,
        'VERR_VGA_GL_SYMBOL_NOT_FOUND': -3504,
        'VERR_INTNET_FLT_IF_NOT_FOUND': -3600,
        'VERR_INTNET_FLT_IF_BUSY': -3601,
        'VERR_INTNET_FLT_IF_FAILED': -3602,
        'VERR_INTNET_INCOMPATIBLE_TRUNK': -3603,
        'VERR_INTNET_INCOMPATIBLE_FLAGS': -3604,
        'VERR_INTNET_FLT_VNIC_CREATE_FAILED': -3605,
        'VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND': -3606,
        'VERR_INTNET_FLT_VNIC_INIT_FAILED': -3607,
        'VERR_INTNET_FLT_VNIC_OPEN_FAILED': -3608,
        'VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND': -3609,
        'VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED': -3610,
        'VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND': -3611,
        'VERR_SUPDRV_COMPONENT_NOT_FOUND': -3700,
        'VERR_SUPDRV_INTERFACE_NOT_SUPPORTED': -3701,
        'VERR_SUPDRV_SERVICE_NOT_FOUND': -3702,
        'VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX': -3703,
        'VERR_SUPDRV_VTG_MAGIC': -3704,
        'VERR_SUPDRV_VTG_BITS': -3705,
        'VERR_SUPDRV_VTG_BAD_HDR_MISC': -3706,
        'VERR_SUPDRV_VTG_BAD_HDR_OFF': -3707,
        'VERR_SUPDRV_VTG_BAD_HDR_PTR': -3708,
        'VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW': -3709,
        'VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH': -3710,
        'VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE': -3711,
        'VERR_SUPDRV_VTG_STRTAB_OFF': -3712,
        'VERR_SUPDRV_VTG_BAD_STRING': -3713,
        'VERR_SUPDRV_VTG_STRING_TOO_LONG': -3714,
        'VERR_SUPDRV_VTG_BAD_ATTR': -3715,
        'VERR_SUPDRV_VTG_BAD_PROVIDER': -3716,
        'VERR_SUPDRV_VTG_BAD_PROBE': -3717,
        'VERR_SUPDRV_VTG_BAD_ARGLIST': -3718,
        'VERR_SUPDRV_VTG_BAD_PROBE_ENABLED': -3719,
        'VERR_SUPDRV_VTG_BAD_PROBE_LOC': -3720,
        'VERR_SUPDRV_VTG_ALREADY_REGISTERED': -3721,
        'VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION': -3722,
        'VERR_SUPDRV_TRACER_ALREADY_REGISTERED': -3723,
        'VERR_SUPDRV_TRACER_NOT_REGISTERED': -3724,
        'VERR_SUPDRV_TRACER_ALREADY_OPENED': -3725,
        'VERR_SUPDRV_TRACER_NOT_OPENED': -3726,
        'VERR_SUPDRV_TRACER_NOT_PRESENT': -3727,
        'VERR_SUPDRV_TRACER_UNLOADING': -3728,
        'VERR_SUPDRV_TRACER_SESSION_BUSY': -3729,
        'VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF': -3730,
        'VERR_SUPDRV_TRACER_BAD_ARG_FLAGS': -3731,
        'VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS': -3732,
        'VERR_SUPDRV_TRACER_TOO_LARGE': -3733,
        'VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT': -3734,
        'VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES': -3735,
        'VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG': -3736,
        'VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD': -3737,
        'VERR_SUPDRV_HARDENING_EVIL_HANDLE': -3738,
        'VERR_SUPDRV_APIPORT_OPEN_ERROR': -3739,
        'VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR': -3740,
        'VERR_SUPDRV_CSRSS_NOT_FOUND': -3741,
        'VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE': -3742,
        'VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED': -3743,
        'VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED': -3744,
        'VERR_SUPDRV_TSC_READ_FAILED': -3745,
        'VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED': 3746,
        'VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY': -3747,
        'VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1': -3748,
        'VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2': -3749,
        'VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT': -7000,
        'VERR_SUPLIB_PATH_NOT_ABSOLUTE': -3750,
        'VERR_SUPLIB_PATH_NOT_CLEAN': -3751,
        'VERR_SUPLIB_PATH_TOO_LONG': -3752,
        'VERR_SUPLIB_PATH_TOO_SHORT': -3753,
        'VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS': -3754,
        'VERR_SUPLIB_PATH_IS_ROOT': -3755,
        'VERR_SUPLIB_DIR_ENUM_FAILED': -3756,
        'VERR_SUPLIB_STAT_ENUM_FAILED': -3757,
        'VERR_SUPLIB_STAT_FAILED': -3758,
        'VERR_SUPLIB_FSTAT_FAILED': -3759,
        'VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED': -3760,
        'VERR_SUPLIB_NOT_DIR_NOT_FILE': -3761,
        'VERR_SUPLIB_IS_DIRECTORY': -3762,
        'VERR_SUPLIB_IS_FILE': -3763,
        'VERR_SUPLIB_NOT_SAME_OBJECT': -3764,
        'VERR_SUPLIB_OWNER_NOT_ROOT': -3765,
        'VERR_SUPLIB_WRITE_NON_SYS_GROUP': -3766,
        'VERR_SUPLIB_WORLD_WRITABLE': -3767,
        'VERR_SUPLIB_INVALID_ARGV0_INTERNAL': -3768,
        'VERR_SUPLIB_INVALID_INTERNAL_APP_DIR': -3769,
        'VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0': -3770,
        'VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1': -3771,
        'VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2': -3772,
        'VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3': -3773,
        'VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4': -3774,
        'VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5': -3775,
        'VERR_SUPLIB_TEXT_NOT_WRITEABLE': -3776,
        'VERR_SUPLIB_TEXT_NOT_SEALED': -3777,
        'VERR_SUPLIB_UNEXPECTED_INSTRUCTION': -3778,
        'VERR_GMM_SEED_ME': -3800,
        'VERR_GMM_OUT_OF_MEMORY': -3801,
        'VERR_GMM_HIT_GLOBAL_LIMIT': -3802,
        'VERR_GMM_HIT_VM_ACCOUNT_LIMIT': -3803,
        'VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH': -3804,
        'VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH': -3805,
        'VERR_GMM_PAGE_NOT_FOUND': -3806,
        'VERR_GMM_PAGE_NOT_PRIVATE': -3807,
        'VERR_GMM_PAGE_NOT_SHARED': -3808,
        'VERR_GMM_PAGE_ALREADY_FREE': -3809,
        'VERR_GMM_NOT_PAGE_OWNER': -3810,
        'VERR_GMM_CHUNK_NOT_FOUND': -3811,
        'VERR_GMM_CHUNK_ALREADY_MAPPED': -3812,
        'VERR_GMM_CHUNK_NOT_MAPPED': -3813,
        'VERR_GMM_TOO_MANY_CHUNK_MAPPINGS': -3814,
        'VERR_GMM_MEMORY_RESERVATION_DECLINED': -3815,
        'VERR_GMM_IS_NOT_SANE': -3816,
        'VERR_GMM_CHUNK_INSERT': -3817,
        'VERR_GMM_INSTANCE': -3818,
        'VERR_GMM_MTX_FLAGS': -3819,
        'VERR_GMM_ALLOC_PAGES_IPE': -3820,
        'VERR_GMM_ACTUAL_PAGES_IPE': -3821,
        'VERR_GMM_MODULE_NAME_TOO_LONG': -3822,
        'VERR_GMM_MODULE_VERSION_TOO_LONG': -3823,
        'VERR_GMM_TOO_MANY_REGIONS': -3824,
        'VERR_GMM_TOO_MANY_PER_VM_MODULES': -3825,
        'VERR_GMM_TOO_MANY_GLOBAL_MODULES': -3826,
        'VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED': 3827,
        'VERR_GMM_SHARED_MODULE_ADDRESS_CLASH': -3828,
        'VERR_GMM_SHARED_MODULE_NOT_FOUND': -3829,
        'VERR_GMM_BAD_SHARED_MODULE_SIZE': -3830,
        'VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE': -3831,
        'VERR_GVM_TOO_MANY_VMS': -3900,
        'VINF_GVM_NOT_BLOCKED': 3901,
        'VINF_GVM_NOT_BUSY_IN_GC': 3902,
        'VINF_GVM_YIELDED': 3903,
        'VERR_VMX_VMXON_FAILED': -4000,
        'VERR_VMX_INVALID_VMCS_PTR': -4001,
        'VERR_VMX_INVALID_VMCS_FIELD': -4002,
        'VERR_VMX_RESERVED': -4003,
        'VERR_VMX_INVALID_VMXON_PTR': -4004,
        'VERR_VMX_UNABLE_TO_START_VM': -4005,
        'VERR_VMX_INVALID_HOST_STATE': -4006,
        'VERR_VMX_NO_VMX': -4009,
        'VERR_VMX_IN_VMX_ROOT_MODE': -4011,
        'VERR_VMX_X86_CR4_VMXE_CLEARED': -4012,
        'VERR_VMX_MSR_LOCKING_FAILED': -4013,
        'VERR_VMX_INVALID_GUEST_STATE': -4014,
        'VERR_VMX_UNEXPECTED_EXIT': -4015,
        'VERR_VMX_UNEXPECTED_EXCEPTION': -4016,
        'VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE': -4017,
        'VERR_VMX_NOT_IN_VMX_ROOT_MODE': -4018,
        'VERR_VMX_UNDEFINED_EXIT_CODE': -4019,
        'VERR_VMX_VMPTRLD_FAILED': -4021,
        'VERR_VMX_INVALID_VMCS_PTR_TO_START_VM': -4022,
        'VERR_VMX_IPE_1': -4023,
        'VERR_VMX_IPE_2': -4024,
        'VERR_VMX_IPE_3': -4025,
        'VERR_VMX_IPE_4': -4026,
        'VERR_VMX_IPE_5': -4027,
        'VERR_VMX_MSR_ALL_VMX_DISABLED': -4028,
        'VERR_VMX_MSR_VMX_DISABLED': -4029,
        'VERR_VMX_VMCS_FIELD_CACHE_INVALID': -4030,
        'VERR_VMX_MSR_VMX_ENABLE_FAILED': -4031,
        'VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED': -4032,
        'VINF_VMX_VMEXIT': 4033,
        'VERR_VMX_VMENTRY_FAILED': -4033,
        'VERR_VMX_VMEXIT_FAILED': -4034,
        'VINF_VMX_INTERCEPT_NOT_ACTIVE': 4035,
        'VINF_VMX_MODIFIES_BEHAVIOR': 4036,
        'VINF_VMX_VMLAUNCH_VMRESUME': 4037,
        'VERR_VMX_INVALID_VMCS_LAUNCH_STATE': -4038,
        'VERR_SVM_UNABLE_TO_START_VM': -4050,
        'VERR_SVM_ILLEGAL_EFER_MSR': -4051,
        'VERR_SVM_NO_SVM': -4052,
        'VERR_SVM_DISABLED': -4053,
        'VERR_SVM_IN_USE': -4054,
        'VERR_SVM_INVALID_PVMCB': -4055,
        'VERR_SVM_UNEXPECTED_EXIT': -4056,
        'VERR_SVM_UNEXPECTED_XCPT_EXIT': -4057,
        'VERR_SVM_UNEXPECTED_PATCH_TYPE': -4058,
        'VERR_SVM_INVALID_GUEST_STATE': -4059,
        'VERR_SVM_UNKNOWN_EXIT': -4060,
        'VERR_SVM_IPE_1': -4061,
        'VERR_SVM_IPE_2': -4062,
        'VERR_SVM_IPE_3': -4063,
        'VERR_SVM_IPE_4': -4064,
        'VERR_SVM_IPE_5': -4065,
        'VERR_SVM_VMEXIT_FAILED': -4066,
        'VINF_SVM_VMEXIT': 4067,
        'VINF_SVM_VMRUN': 4068,
        'VINF_SVM_INTERCEPT_NOT_ACTIVE': 4069,
        'VERR_HM_SUSPEND_PENDING': -4100,
        'VERR_HM_CONFIG_MISMATCH': -4103,
        'VERR_HM_ALREADY_ENABLED_IPE': -4104,
        'VERR_HM_UNEXPECTED_LD_ST_MSR': -4105,
        'VERR_HM_NO_32_TO_64_SWITCHER': -4106,
        'VERR_HM_WRONG_CPU': -4107,
        'VERR_HM_IPE_1': -4108,
        'VERR_HM_IPE_2': -4109,
        'VERR_HM_WRONG_SWITCHER': -4110,
        'VERR_HM_UNKNOWN_IO_INSTRUCTION': -4111,
        'VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO': -4112,
        'VERR_HM_IPE_3': -4113,
        'VERR_HM_IPE_4': -4114,
        'VERR_HM_IPE_5': -4115,
        'VERR_HM_INVALID_HM64ON32OP': -4116,
        'VINF_HM_DOUBLE_FAULT': 4117,
        'VINF_HM_PENDING_XCPT': 4118,
        'VERR_DIS_INVALID_OPCODE': -4200,
        'VERR_DIS_GEN_FAILURE': -4201,
        'VERR_DIS_NO_READ_CALLBACK': -4202,
        'VERR_DIS_INVALID_MODRM': -4203,
        'VERR_DIS_INVALID_PARAMETER': -4204,
        'VERR_DIS_TOO_LONG_INSTR': -4206,
        'VERR_WEB_NOT_AUTHENTICATED': -4300,
        'VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE': -4301,
        'VERR_WEB_INVALID_SESSION_ID': -4302,
        'VERR_WEB_INVALID_OBJECT_ID': -4303,
        'VERR_WEB_UNSUPPORTED_INTERFACE': -4304,
        'VINF_PARAV_SWITCH_TO_HOST': 4400,
        'VINF_VHWA_CMD_PENDING': 4500,
        'VERR_COM_UNEXPECTED': -4600,
        'VERR_COM_VBOX_LOWEST': -4699,
        'VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST': -4700,
        'VINF_AIO_TASK_PENDING': 4800,
        'VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED': -4900,
        'VERR_VSCSI_LUN_ATTACHED_TO_DEVICE': -4901,
        'VERR_VSCSI_LUN_INVALID': -4902,
        'VERR_VSCSI_LUN_NOT_ATTACHED': -4903,
        'VERR_VSCSI_LUN_BUSY': -4904,
        'VERR_FAM_OPEN_FAILED': -5000,
        'VERR_FAM_MONITOR_FILE_FAILED': -5001,
        'VERR_FAM_MONITOR_DIRECTORY_FAILED': -5002,
        'VERR_FAM_CONNECTION_LOST': -5003,
        'VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC': -5100,
        'VERR_PCI_PASSTHROUGH_NO_HM': -5101,
        'VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING': -5102,
        'VINF_PCI_MAPPING_DONE': 5150,
        'VERR_GVMM_INSTANCE': -5200,
        'VERR_GVMM_HOST_CPU_RANGE': -5201,
        'VERR_GVMM_BROKEN_IPRT': -5202,
        'VERR_GVMM_IPE_1': -5203,
        'VERR_GVMM_IPE_2': -5204,
        'VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED': -5205,
        'VERR_IEM_INSTR_NOT_IMPLEMENTED': -5300,
        'VERR_IEM_INVALID_OPERAND_SIZE': -5301,
        'VERR_IEM_INVALID_ADDRESS_MODE': -5302,
        'VERR_IEM_INVALID_EFF_SEG': -5303,
        'VERR_IEM_INVALID_INSTR_LENGTH': -5304,
        'VINF_IEM_SELECTOR_NOT_OK': 5305,
        'VERR_IEM_RESTART_INSTRUCTION': -5389,
        'VERR_IEM_ASPECT_NOT_IMPLEMENTED': -5390,
        'VERR_IEM_IPE_1': -5391,
        'VERR_IEM_IPE_2': -5392,
        'VERR_IEM_IPE_3': -5393,
        'VERR_IEM_IPE_4': -5394,
        'VERR_IEM_IPE_5': -5395,
        'VERR_IEM_IPE_6': -5396,
        'VERR_IEM_IPE_7': -5397,
        'VERR_IEM_IPE_8': -5398,
        'VERR_IEM_IPE_9': -5399,
        'VERR_DBGC_QUIT': -5400,
        'VWRN_DBGC_CMD_PENDING': 5401,
        'VWRN_DBGC_ALREADY_REGISTERED': 5402,
        'VERR_DBGC_COMMANDS_NOT_REGISTERED': -5403,
        'VERR_DBGC_BP_NOT_FOUND': -5404,
        'VERR_DBGC_BP_EXISTS': -5405,
        'VINF_DBGC_BP_NO_COMMAND': 5406,
        'VERR_DBGC_COMMAND_FAILED': -5407,
        'VERR_DBGC_IPE': -5408,
        'VERR_DBGC_PARSE_LOWEST': -5499,
        'VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH': -5600,
        'VERR_SUP_VP_SECTION_PROTECTION_MISMATCH': -5601,
        'VERR_SUP_VP_SECTION_NOT_MAPPED': -5602,
        'VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED': -5603,
        'VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE': -5604,
        'VERR_SUP_VP_BAD_IMAGE_BASE': -5605,
        'VERR_SUP_VP_BAD_IMAGE_SIGNATURE': -5606,
        'VERR_SUP_VP_BAD_IMAGE_SIZE': -5607,
        'VERR_SUP_VP_BAD_MZ_OFFSET': -5608,
        'VERR_SUP_VP_BAD_OPTIONAL_HEADER': -5609,
        'VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE': -5610,
        'VERR_SUP_VP_BAD_SECTION_FILE_SIZE': -5611,
        'VERR_SUP_VP_BAD_SECTION_RVA': -5612,
        'VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE': -5613,
        'VERR_SUP_VP_BAD_SIZE_OF_HEADERS': -5614,
        'VERR_SUP_VP_DEBUGGED': -5615,
        'VERR_SUP_VP_DUPLICATE_DLL_MAPPING': -5616,
        'VERR_SUP_VP_EMPTY_REGION_TOO_LARGE': -5617,
        'VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH': -5618,
        'VERR_SUP_VP_FOUND_EXEC_MEMORY': -5619,
        'VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING': -5620,
        'VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR': -5621,
        'VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR': -5622,
        'VERR_SUP_VP_IMAGE_HDR_READ_ERROR': -5623,
        'VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR': -5624,
        'VERR_SUP_VP_MEMORY_READ_ERROR': -5625,
        'VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING': -5626,
        'VERR_SUP_VP_NO_IMAGE_MAPPING_NAME': -5627,
        'VERR_SUP_VP_NO_KERNEL32_MAPPING': -5628,
        'VERR_SUP_VP_NO_MEMORY': -5629,
        'VERR_SUP_VP_NO_MEMORY_STATE': -5630,
        'VERR_SUP_VP_NO_NTDLL_MAPPING': -5631,
        'VERR_SUP_VP_NON_SYSTEM32_DLL': -5632,
        'VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE': -5633,
        'VERR_SUP_VP_NT_MAPPING_NAME_CHANGED': -5634,
        'VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR': -5635,
        'VERR_SUP_VP_NT_QI_THREAD_ERROR': -5636,
        'VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR': -5637,
        'VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR': -5638,
        'VERR_SUP_VP_SYSTEM32_PATH': -5639,
        'VERR_SUP_VP_THREAD_NOT_ALONE': -5640,
        'VERR_SUP_VP_TOO_HIGH_REGION_RVA': -5641,
        'VERR_SUP_VP_TOO_LARGE_REGION': -5642,
        'VERR_SUP_VP_TOO_MANY_DLLS_LOADED': -5643,
        'VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS': -5644,
        'VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS': -5645,
        'VERR_SUP_VP_TOO_MANY_SECTIONS': -5646,
        'VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE': -5647,
        'VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS': -5648,
        'VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY': -5649,
        'VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE': -5650,
        'VERR_SUP_VP_EXE_MISSING_NX_COMPAT': -5651,
        'VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH': -5652,
        'VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH': -5653,
        'VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR': -5654,
        'VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR': -5655,
        'VERR_SUP_VP_WINTRUST_CAT_FAILURE': -5656,
        'VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT': -5657,
        'VERR_SUP_VP_NOT_BUILD_CERT_IPE': -5658,
        'VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE': -5659,
        'VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT': -5660,
        'VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED': -5661,
        'VERR_SUP_VP_SYSFER_DLL': -5662,
        'VERR_SUP_VP_KERNEL32_ALREADY_MAPPED': -5663,
        'VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED': -5664,
        'VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED': -5665,
        'VERR_SUP_VP_UNKOWN_MEM_TYPE': -5666,
        'VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER': -5667,
        'VERR_SUP_VP_IMAGE_TOO_BIG': -5668,
        'VERR_SUP_VP_STUB_NOT_FOUND': -5669,
        'VERR_SUP_VP_STUB_OPEN_ERROR': -5670,
        'VERR_SUP_VP_STUB_THREAD_NOT_FOUND': -5671,
        'VERR_SUP_VP_STUB_THREAD_OPEN_ERROR': -5672,
        'VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED': -5673,
        'VERR_SUP_VP_FILE_MODE_ERROR': -5674,
        'VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED': -5675,
        'VERR_SUP_VP_UNDESIRABLE_MODULE': -5676,
        'VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL': -6000,
        'VERR_EXTPACK_VBOX_VERSION_MISMATCH': -6001,
        'VERR_GSTCTL_GUEST_ERROR': -6200,
        'VWRN_GSTCTL_OBJECTSTATE_CHANGED': 6220,
        'VERR_GSTCTL_PROCESS_WRONG_STATE': -6221,
        'VERR_GSTCTL_MAX_CID_SESSIONS_REACHED': -6222,
        'VERR_GSTCTL_MAX_CID_OBJECTS_REACHED': -6223,
        'VERR_GSTCTL_MAX_CID_COUNT_REACHED': -6224,
        'VERR_GSTCTL_PROCESS_EXIT_CODE': -6225,
        'VERR_GIM_NOT_ENABLED': -6300,
        'VERR_GIM_IPE_1': -6301,
        'VERR_GIM_IPE_2': -6302,
        'VERR_GIM_IPE_3': -6303,
        'VERR_GIM_PVTSC_NOT_AVAILABLE': -6304,
        'VERR_GIM_PVTSC_NOT_ENABLED': -6305,
        'VERR_GIM_INVALID_PROVIDER': -6306,
        'VERR_GIM_OPERATION_FAILED': -6307,
        'VERR_GIM_HYPERCALLS_NOT_AVAILABLE': -6308,
        'VERR_GIM_HYPERCALLS_NOT_ENABLED': -6309,
        'VERR_GIM_DEVICE_NOT_REGISTERED': -6310,
        'VERR_GIM_HYPERCALL_ACCESS_DENIED': -6311,
        'VERR_GIM_HYPERCALL_MEMORY_READ_FAILED': -6312,
        'VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED': -6313,
        'VERR_GIM_HYPERCALL_FAILED': -6314,
        'VERR_GIM_NO_DEBUG_CONNECTION': -6315,
        'VINF_GIM_R3_HYPERCALL': 6316,
        'VINF_GIM_HYPERCALL_CONTINUING': 6317,
        'VERR_GIM_INVALID_HYPERCALL_INSTR': -6318,
        'VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR': -6400,
        'VERR_MAIN_CONFIG_CONSTRUCTOR_IPE': -6401,
        'VERR_GSTDND_GUEST_ERROR': -6500,
        'VERR_AUDIO_BACKEND_INIT_FAILED': -6600,
        'VERR_AUDIO_BACKEND_NOT_ATTACHED': -6601,
        'VERR_AUDIO_NO_FREE_INPUT_STREAMS': -6602,
        'VERR_AUDIO_NO_FREE_OUTPUT_STREAMS': -6603,
        'VERR_AUDIO_STREAM_PENDING_DISABLE': -6604,
        'VINF_AUDIO_MORE_DATA_AVAILABLE': 6605,
        'VERR_AUDIO_STREAM_NOT_READY': -6605,
        'VERR_AUDIO_STREAM_COULD_NOT_CREATE': -6606,
        'VERR_APIC_INTR_NOT_PENDING': -6700,
        'VERR_APIC_INTR_MASKED_BY_TPR': -6701,
        'VERR_APIC_INTR_DISCARDED': -6702,
        'VERR_NEM_NOT_ENABLED': -6800,
        'VERR_NEM_NOT_AVAILABLE': -6801,
        'VERR_NEM_INIT_FAILED': -6802,
        'VERR_NEM_MISSING_KERNEL_API': -6803,
        'VERR_NEM_RING3_ONLY': -6804,
        'VERR_NEM_VM_CREATE_FAILED': -6805,
        'VERR_NEM_MAP_PAGES_FAILED': -6806,
        'VERR_NEM_UNMAP_PAGES_FAILED': -6807,
        'VERR_NEM_GET_REGISTERS_FAILED': -6808,
        'VERR_NEM_SET_REGISTERS_FAILED': -6809,
        'VERR_NEM_FLUSH_TLB': -6810,
        'VINF_NEM_FLUSH_TLB': 6810,
        'VERR_NEM_SET_TSC': -6811,
        'VERR_NEM_IPE_0': -6890,
        'VERR_NEM_IPE_1': -6891,
        'VERR_NEM_IPE_2': -6892,
        'VERR_NEM_IPE_3': -6893,
        'VERR_NEM_IPE_4': -6894,
        'VERR_NEM_IPE_5': -6895,
        'VERR_NEM_IPE_6': -6896,
        'VERR_NEM_IPE_7': -6897,
        'VERR_NEM_IPE_8': -6898,
        'VERR_NEM_IPE_9': -6899,
        'VERR_RECORDING_CODEC_NOT_FOUND': -6900,
        'VERR_RECORDING_CODEC_INIT_FAILED': -6902,
        'VERR_RECORDING_CODEC_NOT_SUPPORTED': -6903,
        'VERR_RECORDING_FORMAT_NOT_SUPPORTED': -6904,
        'VERR_RECORDING_RESTRICTED': -6905,
        'VINF_RECORDING_LIMIT_REACHED': 6906,
        'VERR_RECORDING_LIMIT_REACHED': -6906,
        'VINF_RECORDING_THROTTLED': 6907,
        'VERR_RECORDING_THROTTLED': -6907,
        'VERR_SHCLPB_MAX_TRANSFERS_REACHED': -7100,
        'VERR_SHCLPB_MAX_OBJECTS_REACHED': -7101,
        'VERR_SHCLPB_MAX_LISTS_REACHED': -7102,
        'VERR_SHCLPB_LIST_HANDLE_INVALID': -7103,
        'VERR_SHCLPB_OBJ_HANDLE_INVALID': -7104,
        'VERR_SHCLPB_TRANSFER_ID_NOT_FOUND': -7105,

    }

    __dValues = {
        'SettingsVersion': {
            'Null': 0,
            'v1_0': 1,
            'v1_1': 2,
            'v1_2': 3,
            'v1_3pre': 4,
            'v1_3': 5,
            'v1_4': 6,
            'v1_5': 7,
            'v1_6': 8,
            'v1_7': 9,
            'v1_8': 10,
            'v1_9': 11,
            'v1_10': 12,
            'v1_11': 13,
            'v1_12': 14,
            'v1_13': 15,
            'v1_14': 16,
            'v1_15': 17,
            'v1_16': 18,
            'v1_17': 19,
            'v1_18': 20,
            'Future': 99999,
        },
        'AccessMode': {
            'ReadOnly': 1,
            'ReadWrite': 2,
        },
        'MachineState': {
            'Null': 0,
            'PoweredOff': 1,
            'Saved': 2,
            'Teleported': 3,
            'Aborted': 4,
            'Running': 5,
            'Paused': 6,
            'Stuck': 7,
            'Teleporting': 8,
            'LiveSnapshotting': 9,
            'Starting': 10,
            'Stopping': 11,
            'Saving': 12,
            'Restoring': 13,
            'TeleportingPausedVM': 14,
            'TeleportingIn': 15,
            'DeletingSnapshotOnline': 16,
            'DeletingSnapshotPaused': 17,
            'OnlineSnapshotting': 18,
            'RestoringSnapshot': 19,
            'DeletingSnapshot': 20,
            'SettingUp': 21,
            'Snapshotting': 22,
            'FirstOnline': 5,
            'LastOnline': 18,
            'FirstTransient': 8,
            'LastTransient': 22,
        },
        'SessionState': {
            'Null': 0,
            'Unlocked': 1,
            'Locked': 2,
            'Spawning': 3,
            'Unlocking': 4,
        },
        'CPUPropertyType': {
            'Null': 0,
            'PAE': 1,
            'LongMode': 2,
            'TripleFaultReset': 3,
            'APIC': 4,
            'X2APIC': 5,
            'IBPBOnVMExit': 6,
            'IBPBOnVMEntry': 7,
            'HWVirt': 8,
            'SpecCtrl': 9,
            'SpecCtrlByHost': 10,
            'L1DFlushOnEMTScheduling': 11,
            'L1DFlushOnVMEntry': 12,
            'MDSClearOnEMTScheduling': 13,
            'MDSClearOnVMEntry': 14,
        },
        'HWVirtExPropertyType': {
            'Null': 0,
            'Enabled': 1,
            'VPID': 2,
            'NestedPaging': 3,
            'UnrestrictedExecution': 4,
            'LargePages': 5,
            'Force': 6,
            'UseNativeApi': 7,
        },
        'ParavirtProvider': {
            'None': 0,
            'Default': 1,
            'Legacy': 2,
            'Minimal': 3,
            'HyperV': 4,
            'KVM': 5,
        },
        'LockType': {
            'Null': 0,
            'Shared': 1,
            'Write': 2,
            'VM': 3,
        },
        'SessionType': {
            'Null': 0,
            'WriteLock': 1,
            'Remote': 2,
            'Shared': 3,
        },
        'DeviceType': {
            'Null': 0,
            'Floppy': 1,
            'DVD': 2,
            'HardDisk': 3,
            'Network': 4,
            'USB': 5,
            'SharedFolder': 6,
            'Graphics3D': 7,
        },
        'DeviceActivity': {
            'Null': 0,
            'Idle': 1,
            'Reading': 2,
            'Writing': 3,
        },
        'ClipboardMode': {
            'Disabled': 0,
            'HostToGuest': 1,
            'GuestToHost': 2,
            'Bidirectional': 3,
        },
        'DnDMode': {
            'Disabled': 0,
            'HostToGuest': 1,
            'GuestToHost': 2,
            'Bidirectional': 3,
        },
        'Scope': {
            'Global': 0,
            'Machine': 1,
            'Session': 2,
        },
        'BIOSBootMenuMode': {
            'Disabled': 0,
            'MenuOnly': 1,
            'MessageAndMenu': 2,
        },
        'APICMode': {
            'Disabled': 0,
            'APIC': 1,
            'X2APIC': 2,
        },
        'ProcessorFeature': {
            'HWVirtEx': 0,
            'PAE': 1,
            'LongMode': 2,
            'NestedPaging': 3,
            'UnrestrictedGuest': 4,
            'NestedHWVirt': 5,
        },
        'FirmwareType': {
            'BIOS': 1,
            'EFI': 2,
            'EFI32': 3,
            'EFI64': 4,
            'EFIDUAL': 5,
        },
        'PointingHIDType': {
            'None': 1,
            'PS2Mouse': 2,
            'USBMouse': 3,
            'USBTablet': 4,
            'ComboMouse': 5,
            'USBMultiTouch': 6,
        },
        'KeyboardHIDType': {
            'None': 1,
            'PS2Keyboard': 2,
            'USBKeyboard': 3,
            'ComboKeyboard': 4,
        },
        'BitmapFormat': {
            'Opaque': 0,
            'BGR': 0x20524742,
            'BGR0': 0x30524742,
            'BGRA': 0x41524742,
            'RGBA': 0x41424752,
            'PNG': 0x20474E50,
            'JPEG': 0x4745504A,
        },
        'DHCPOption': {
            'SubnetMask': 1,
            'TimeOffset': 2,
            'Routers': 3,
            'TimeServers': 4,
            'NameServers': 5,
            'DomainNameServers': 6,
            'LogServers': 7,
            'CookieServers': 8,
            'LPRServers': 9,
            'ImpressServers': 10,
            'ResourseLocationServers': 11,
            'HostName': 12,
            'BootFileSize': 13,
            'MeritDumpFile': 14,
            'DomainName': 15,
            'SwapServer': 16,
            'RootPath': 17,
            'ExtensionPath': 18,
            'IPForwarding': 19,
            'OptNonLocalSourceRouting': 20,
            'PolicyFilter': 21,
            'MaxDgramReassemblySize': 22,
            'DefaultIPTTL': 23,
            'PathMTUAgingTimeout': 24,
            'PathMTUPlateauTable': 25,
            'InterfaceMTU': 26,
            'AllSubnetsAreLocal': 27,
            'BroadcastAddress': 28,
            'PerformMaskDiscovery': 29,
            'MaskSupplier': 30,
            'PerformRouterDiscovery': 31,
            'RouterSolicitationAddress': 32,
            'StaticRoute': 33,
            'TrailerEncapsulation': 34,
            'ARPCacheTimeout': 35,
            'EthernetEncapsulation': 36,
            'TCPDefaultTTL': 37,
            'TCPKeepaliveInterval': 38,
            'TCPKeepaliveGarbage': 39,
            'NISDomain': 40,
            'NISServers': 41,
            'NTPServers': 42,
            'VendorSpecificInfo': 43,
            'NetBIOSNameServers': 44,
            'NetBIOSDatagramServers': 45,
            'NetBIOSNodeType': 46,
            'NetBIOSScope': 47,
            'XWindowsFontServers': 48,
            'XWindowsDisplayManager': 49,
            'NetWareIPDomainName': 62,
            'NetWareIPInformation': 63,
            'NISPlusDomain': 64,
            'NISPlusServers': 65,
            'TFTPServerName': 66,
            'BootfileName': 67,
            'MobileIPHomeAgents': 68,
            'SMTPServers': 69,
            'POP3Servers': 70,
            'NNTPServers': 71,
            'WWWServers': 72,
            'FingerServers': 73,
            'IRCServers': 74,
            'StreetTalkServers': 75,
            'STDAServers': 76,
            'SLPDirectoryAgent': 78,
            'SLPServiceScope': 79,
            'DomainSearch': 119,
        },
        'DHCPOptionEncoding': {
            'Normal': 0,
            'Hex': 1,
        },
        'DHCPConfigScope': {
            'Global': 0,
            'Group': 1,
            'MachineNIC': 2,
            'MAC': 3,
        },
        'DHCPGroupConditionType': {
            'MAC': 0,
            'MACWildcard': 1,
            'vendorClassID': 2,
            'vendorClassIDWildcard': 3,
            'userClassID': 4,
            'userClassIDWildcard': 5,
        },
        'VFSType': {
            'File': 1,
            'Cloud': 2,
            'S3': 3,
            'WebDav': 4,
        },
        'ImportOptions': {
            'KeepAllMACs': 1,
            'KeepNATMACs': 2,
            'ImportToVDI': 3,
        },
        'ExportOptions': {
            'CreateManifest': 1,
            'ExportDVDImages': 2,
            'StripAllMACs': 3,
            'StripAllNonNATMACs': 4,
        },
        'CertificateVersion': {
            'V1': 1,
            'V2': 2,
            'V3': 3,
            'Unknown': 99,
        },
        'VirtualSystemDescriptionType': {
            'Ignore': 1,
            'OS': 2,
            'Name': 3,
            'Product': 4,
            'Vendor': 5,
            'Version': 6,
            'ProductUrl': 7,
            'VendorUrl': 8,
            'Description': 9,
            'License': 10,
            'Miscellaneous': 11,
            'CPU': 12,
            'Memory': 13,
            'HardDiskControllerIDE': 14,
            'HardDiskControllerSATA': 15,
            'HardDiskControllerSCSI': 16,
            'HardDiskControllerSAS': 17,
            'HardDiskImage': 18,
            'Floppy': 19,
            'CDROM': 20,
            'NetworkAdapter': 21,
            'USBController': 22,
            'SoundCard': 23,
            'SettingsFile': 24,
            'BaseFolder': 25,
            'PrimaryGroup': 26,
            'CloudInstanceShape': 27,
            'CloudDomain': 28,
            'CloudBootDiskSize': 29,
            'CloudBucket': 30,
            'CloudOCIVCN': 31,
            'CloudPublicIP': 32,
            'CloudProfileName': 33,
            'CloudOCISubnet': 34,
            'CloudKeepObject': 35,
            'CloudLaunchInstance': 36,
            'CloudInstanceId': 37,
            'CloudImageId': 38,
            'CloudInstanceState': 39,
            'CloudImageState': 40,
            'CloudInstanceDisplayName': 41,
            'CloudImageDisplayName': 42,
            'CloudOCILaunchMode': 43,
            'CloudPrivateIP': 44,
            'CloudBootVolumeId': 45,
            'CloudOCIVCNCompartment': 46,
            'CloudOCISubnetCompartment': 47,
            'CloudPublicSSHKey': 48,
            'BootingFirmware': 49,
        },
        'VirtualSystemDescriptionValueType': {
            'Reference': 1,
            'Original': 2,
            'Auto': 3,
            'ExtraConfig': 4,
        },
        'RecordingDestination': {
            'None': 0,
            'File': 1,
        },
        'RecordingFeature': {
            'None': 0,
            'Video': 1,
            'Audio': 2,
        },
        'RecordingAudioCodec': {
            'None': 0,
            'WavPCM': 1,
            'Opus': 2,
        },
        'RecordingVideoCodec': {
            'None': 0,
            'VP8': 1,
            'VP9': 2,
            'AV1': 3,
        },
        'RecordingVideoScalingMethod': {
            'None': 0,
            'NearestNeighbor': 1,
            'Bilinear': 2,
            'Bicubic': 3,
        },
        'RecordingVideoRateControlMode': {
            'CBR': 0,
            'VBR': 1,
        },
        'GraphicsControllerType': {
            'Null': 0,
            'VBoxVGA': 1,
            'VMSVGA': 2,
            'VBoxSVGA': 3,
        },
        'CleanupMode': {
            'UnregisterOnly': 1,
            'DetachAllReturnNone': 2,
            'DetachAllReturnHardDisksOnly': 3,
            'Full': 4,
        },
        'CloneMode': {
            'MachineState': 1,
            'MachineAndChildStates': 2,
            'AllStates': 3,
        },
        'CloneOptions': {
            'Link': 1,
            'KeepAllMACs': 2,
            'KeepNATMACs': 3,
            'KeepDiskNames': 4,
            'KeepHwUUIDs': 5,
        },
        'AutostopType': {
            'Disabled': 1,
            'SaveState': 2,
            'PowerOff': 3,
            'AcpiShutdown': 4,
        },
        'VMProcPriority': {
            'Invalid': 0,
            'Default': 1,
            'Flat': 2,
            'Low': 3,
            'Normal': 5,
            'High': 6,
        },
        'HostNetworkInterfaceMediumType': {
            'Unknown': 0,
            'Ethernet': 1,
            'PPP': 2,
            'SLIP': 3,
        },
        'HostNetworkInterfaceStatus': {
            'Unknown': 0,
            'Up': 1,
            'Down': 2,
        },
        'HostNetworkInterfaceType': {
            'Bridged': 1,
            'HostOnly': 2,
        },
        'ProxyMode': {
            'System': 0,
            'NoProxy': 1,
            'Manual': 2,
        },
        'AdditionsFacilityType': {
            'None': 0,
            'VBoxGuestDriver': 20,
            'AutoLogon': 90,
            'VBoxService': 100,
            'VBoxTrayClient': 101,
            'Seamless': 1000,
            'Graphics': 1100,
            'MonitorAttach': 1101,
            'All': 2147483646,
        },
        'AdditionsFacilityClass': {
            'None': 0,
            'Driver': 10,
            'Service': 30,
            'Program': 50,
            'Feature': 100,
            'ThirdParty': 999,
            'All': 2147483646,
        },
        'AdditionsFacilityStatus': {
            'Inactive': 0,
            'Paused': 1,
            'PreInit': 20,
            'Init': 30,
            'Active': 50,
            'Terminating': 100,
            'Terminated': 101,
            'Failed': 800,
            'Unknown': 999,
        },
        'AdditionsRunLevelType': {
            'None': 0,
            'System': 1,
            'Userland': 2,
            'Desktop': 3,
        },
        'AdditionsUpdateFlag': {
            'None': 0,
            'WaitForUpdateStartOnly': 1,
        },
        'GuestSessionStatus': {
            'Undefined': 0,
            'Starting': 10,
            'Started': 100,
            'Terminating': 480,
            'Terminated': 500,
            'TimedOutKilled': 512,
            'TimedOutAbnormally': 513,
            'Down': 600,
            'Error': 800,
        },
        'GuestSessionWaitForFlag': {
            'None': 0,
            'Start': 1,
            'Terminate': 2,
            'Status': 4,
        },
        'GuestSessionWaitResult': {
            'None': 0,
            'Start': 1,
            'Terminate': 2,
            'Status': 3,
            'Error': 4,
            'Timeout': 5,
            'WaitFlagNotSupported': 6,
        },
        'GuestUserState': {
            'Unknown': 0,
            'LoggedIn': 1,
            'LoggedOut': 2,
            'Locked': 3,
            'Unlocked': 4,
            'Disabled': 5,
            'Idle': 6,
            'InUse': 7,
            'Created': 8,
            'Deleted': 9,
            'SessionChanged': 10,
            'CredentialsChanged': 11,
            'RoleChanged': 12,
            'GroupAdded': 13,
            'GroupRemoved': 14,
            'Elevated': 15,
        },
        'FileSeekOrigin': {
            'Begin': 0,
            'Current': 1,
            'End': 2,
        },
        'ProcessInputFlag': {
            'None': 0,
            'EndOfFile': 1,
        },
        'ProcessOutputFlag': {
            'None': 0,
            'StdErr': 1,
        },
        'ProcessWaitForFlag': {
            'None': 0,
            'Start': 1,
            'Terminate': 2,
            'StdIn': 4,
            'StdOut': 8,
            'StdErr': 16,
        },
        'ProcessWaitResult': {
            'None': 0,
            'Start': 1,
            'Terminate': 2,
            'Status': 3,
            'Error': 4,
            'Timeout': 5,
            'StdIn': 6,
            'StdOut': 7,
            'StdErr': 8,
            'WaitFlagNotSupported': 9,
        },
        'FileCopyFlag': {
            'None': 0,
            'NoReplace': 1,
            'FollowLinks': 2,
            'Update': 4,
        },
        'FsObjMoveFlag': {
            'None': 0,
            'Replace': 1,
            'FollowLinks': 2,
            'AllowDirectoryMoves': 4,
        },
        'DirectoryCreateFlag': {
            'None': 0,
            'Parents': 1,
        },
        'DirectoryCopyFlag': {
            'None': 0,
            'CopyIntoExisting': 1,
        },
        'DirectoryRemoveRecFlag': {
            'None': 0,
            'ContentAndDir': 1,
            'ContentOnly': 2,
        },
        'FsObjRenameFlag': {
            'NoReplace': 0,
            'Replace': 1,
        },
        'ProcessCreateFlag': {
            'None': 0,
            'WaitForProcessStartOnly': 1,
            'IgnoreOrphanedProcesses': 2,
            'Hidden': 4,
            'Profile': 8,
            'WaitForStdOut': 16,
            'WaitForStdErr': 32,
            'ExpandArguments': 64,
            'UnquotedArguments': 128,
        },
        'ProcessPriority': {
            'Invalid': 0,
            'Default': 1,
        },
        'SymlinkType': {
            'Unknown': 0,
            'Directory': 1,
            'File': 2,
        },
        'SymlinkReadFlag': {
            'None': 0,
            'NoSymlinks': 1,
        },
        'ProcessStatus': {
            'Undefined': 0,
            'Starting': 10,
            'Started': 100,
            'Paused': 110,
            'Terminating': 480,
            'TerminatedNormally': 500,
            'TerminatedSignal': 510,
            'TerminatedAbnormally': 511,
            'TimedOutKilled': 512,
            'TimedOutAbnormally': 513,
            'Down': 600,
            'Error': 800,
        },
        'ProcessInputStatus': {
            'Undefined': 0,
            'Broken': 1,
            'Available': 10,
            'Written': 50,
            'Overflow': 100,
        },
        'PathStyle': {
            'DOS': 1,
            'UNIX': 2,
            'Unknown': 8,
        },
        'FileAccessMode': {
            'ReadOnly': 1,
            'WriteOnly': 2,
            'ReadWrite': 3,
            'AppendOnly': 4,
            'AppendRead': 5,
        },
        'FileOpenAction': {
            'OpenExisting': 1,
            'OpenOrCreate': 2,
            'CreateNew': 3,
            'CreateOrReplace': 4,
            'OpenExistingTruncated': 5,
            'AppendOrCreate': 99,
        },
        'FileSharingMode': {
            'Read': 1,
            'Write': 2,
            'ReadWrite': 3,
            'Delete': 4,
            'ReadDelete': 5,
            'WriteDelete': 6,
            'All': 7,
        },
        'FileOpenExFlag': {
            'None': 0,
        },
        'FileStatus': {
            'Undefined': 0,
            'Opening': 10,
            'Open': 100,
            'Closing': 150,
            'Closed': 200,
            'Down': 600,
            'Error': 800,
        },
        'FsObjType': {
            'Unknown': 1,
            'Fifo': 2,
            'DevChar': 3,
            'Directory': 4,
            'DevBlock': 5,
            'File': 6,
            'Symlink': 7,
            'Socket': 8,
            'WhiteOut': 9,
        },
        'DnDAction': {
            'Ignore': 0,
            'Copy': 1,
            'Move': 2,
            'Link': 3,
        },
        'DirectoryOpenFlag': {
            'None': 0,
            'NoSymlinks': 1,
        },
        'MediumState': {
            'NotCreated': 0,
            'Created': 1,
            'LockedRead': 2,
            'LockedWrite': 3,
            'Inaccessible': 4,
            'Creating': 5,
            'Deleting': 6,
        },
        'MediumType': {
            'Normal': 0,
            'Immutable': 1,
            'Writethrough': 2,
            'Shareable': 3,
            'Readonly': 4,
            'MultiAttach': 5,
        },
        'MediumVariant': {
            'Standard': 0,
            'VmdkSplit2G': 0x01,
            'VmdkRawDisk': 0x02,
            'VmdkStreamOptimized': 0x04,
            'VmdkESX': 0x08,
            'VdiZeroExpand': 0x100,
            'Fixed': 0x10000,
            'Diff': 0x20000,
            'Formatted': 0x20000000,
            'NoCreateDir': 0x40000000,
        },
        'DataType': {
            'Int32': 0,
            'Int8': 1,
            'String': 2,
        },
        'DataFlags': {
            'None': 0x00,
            'Mandatory': 0x01,
            'Expert': 0x02,
            'Array': 0x04,
            'FlagMask': 0x07,
        },
        'MediumFormatCapabilities': {
            'Uuid': 0x01,
            'CreateFixed': 0x02,
            'CreateDynamic': 0x04,
            'CreateSplit2G': 0x08,
            'Differencing': 0x10,
            'Asynchronous': 0x20,
            'File': 0x40,
            'Properties': 0x80,
            'TcpNetworking': 0x100,
            'VFS': 0x200,
            'Discard': 0x400,
            'Preferred': 0x800,
            'CapabilityMask': 0xFFF,
        },
        'PartitionTableType': {
            'MBR': 1,
            'GPT': 2,
        },
        'KeyboardLED': {
            'NumLock': 0x01,
            'CapsLock': 0x02,
            'ScrollLock': 0x04,
        },
        'MouseButtonState': {
            'LeftButton': 0x01,
            'RightButton': 0x02,
            'MiddleButton': 0x04,
            'WheelUp': 0x08,
            'WheelDown': 0x10,
            'XButton1': 0x20,
            'XButton2': 0x40,
            'MouseStateMask': 0x7F,
        },
        'TouchContactState': {
            'None': 0x00,
            'InContact': 0x01,
            'InRange': 0x02,
            'ContactStateMask': 0x03,
        },
        'FramebufferCapabilities': {
            'UpdateImage': 0x01,
            'VHWA': 0x02,
            'VisibleRegion': 0x04,
            'RenderCursor': 0x08,
            'MoveCursor': 0x10,
        },
        'GuestMonitorStatus': {
            'Disabled': 0,
            'Enabled': 1,
            'Blank': 2,
        },
        'ScreenLayoutMode': {
            'Apply': 0,
            'Reset': 1,
            'Attach': 2,
            'Silent': 3,
        },
        'NetworkAttachmentType': {
            'Null': 0,
            'NAT': 1,
            'Bridged': 2,
            'Internal': 3,
            'HostOnly': 4,
            'Generic': 5,
            'NATNetwork': 6,
            'Cloud': 7,
        },
        'NetworkAdapterType': {
            'Null': 0,
            'Am79C970A': 1,
            'Am79C973': 2,
            'I82540EM': 3,
            'I82543GC': 4,
            'I82545EM': 5,
            'Virtio': 6,
            'Am79C960': 7,
            'Virtio_1_0': 8,
        },
        'NetworkAdapterPromiscModePolicy': {
            'Deny': 1,
            'AllowNetwork': 2,
            'AllowAll': 3,
        },
        'PortMode': {
            'Disconnected': 0,
            'HostPipe': 1,
            'HostDevice': 2,
            'RawFile': 3,
            'TCP': 4,
        },
        'UartType': {
            'U16450': 0,
            'U16550A': 1,
            'U16750': 2,
        },
        'VMExecutionEngine': {
            'NotSet': 0,
            'RawMode': 1,
            'HwVirt': 2,
            'NativeApi': 3,
        },
        'USBControllerType': {
            'Null': 0,
            'OHCI': 1,
            'EHCI': 2,
            'XHCI': 3,
            'Last': 4,
        },
        'USBConnectionSpeed': {
            'Null': 0,
            'Low': 1,
            'Full': 2,
            'High': 3,
            'Super': 4,
            'SuperPlus': 5,
        },
        'USBDeviceState': {
            'NotSupported': 0,
            'Unavailable': 1,
            'Busy': 2,
            'Available': 3,
            'Held': 4,
            'Captured': 5,
        },
        'USBDeviceFilterAction': {
            'Null': 0,
            'Ignore': 1,
            'Hold': 2,
        },
        'AudioDriverType': {
            'Null': 0,
            'WinMM': 1,
            'OSS': 2,
            'ALSA': 3,
            'DirectSound': 4,
            'CoreAudio': 5,
            'MMPM': 6,
            'Pulse': 7,
            'SolAudio': 8,
        },
        'AudioControllerType': {
            'AC97': 0,
            'SB16': 1,
            'HDA': 2,
        },
        'AudioCodecType': {
            'Null': 0,
            'SB16': 1,
            'STAC9700': 2,
            'AD1980': 3,
            'STAC9221': 4,
        },
        'AuthType': {
            'Null': 0,
            'External': 1,
            'Guest': 2,
        },
        'Reason': {
            'Unspecified': 0,
            'HostSuspend': 1,
            'HostResume': 2,
            'HostBatteryLow': 3,
            'Snapshot': 4,
        },
        'StorageBus': {
            'Null': 0,
            'IDE': 1,
            'SATA': 2,
            'SCSI': 3,
            'Floppy': 4,
            'SAS': 5,
            'USB': 6,
            'PCIe': 7,
            'VirtioSCSI': 8,
        },
        'StorageControllerType': {
            'Null': 0,
            'LsiLogic': 1,
            'BusLogic': 2,
            'IntelAhci': 3,
            'PIIX3': 4,
            'PIIX4': 5,
            'ICH6': 6,
            'I82078': 7,
            'LsiLogicSas': 8,
            'USB': 9,
            'NVMe': 10,
            'VirtioSCSI': 11,
        },
        'ChipsetType': {
            'Null': 0,
            'PIIX3': 1,
            'ICH9': 2,
        },
        'NATAliasMode': {
            'AliasLog': 0x1,
            'AliasProxyOnly': 0x02,
            'AliasUseSamePorts': 0x04,
        },
        'NATProtocol': {
            'UDP': 0,
            'TCP': 1,
        },
        'BandwidthGroupType': {
            'Null': 0,
            'Disk': 1,
            'Network': 2,
        },
        'VBoxEventType': {
            'Invalid': 0,
            'Any': 1,
            'Vetoable': 2,
            'MachineEvent': 3,
            'SnapshotEvent': 4,
            'InputEvent': 5,
            'LastWildcard': 31,
            'OnMachineStateChanged': 32,
            'OnMachineDataChanged': 33,
            'OnExtraDataChanged': 34,
            'OnExtraDataCanChange': 35,
            'OnMediumRegistered': 36,
            'OnMachineRegistered': 37,
            'OnSessionStateChanged': 38,
            'OnSnapshotTaken': 39,
            'OnSnapshotDeleted': 40,
            'OnSnapshotChanged': 41,
            'OnGuestPropertyChanged': 42,
            'OnMousePointerShapeChanged': 43,
            'OnMouseCapabilityChanged': 44,
            'OnKeyboardLedsChanged': 45,
            'OnStateChanged': 46,
            'OnAdditionsStateChanged': 47,
            'OnNetworkAdapterChanged': 48,
            'OnSerialPortChanged': 49,
            'OnParallelPortChanged': 50,
            'OnStorageControllerChanged': 51,
            'OnMediumChanged': 52,
            'OnVRDEServerChanged': 53,
            'OnUSBControllerChanged': 54,
            'OnUSBDeviceStateChanged': 55,
            'OnSharedFolderChanged': 56,
            'OnRuntimeError': 57,
            'OnCanShowWindow': 58,
            'OnShowWindow': 59,
            'OnCPUChanged': 60,
            'OnVRDEServerInfoChanged': 61,
            'OnEventSourceChanged': 62,
            'OnCPUExecutionCapChanged': 63,
            'OnGuestKeyboard': 64,
            'OnGuestMouse': 65,
            'OnNATRedirect': 66,
            'OnHostPCIDevicePlug': 67,
            'OnVBoxSVCAvailabilityChanged': 68,
            'OnBandwidthGroupChanged': 69,
            'OnGuestMonitorChanged': 70,
            'OnStorageDeviceChanged': 71,
            'OnClipboardModeChanged': 72,
            'OnDnDModeChanged': 73,
            'OnNATNetworkChanged': 74,
            'OnNATNetworkStartStop': 75,
            'OnNATNetworkAlter': 76,
            'OnNATNetworkCreationDeletion': 77,
            'OnNATNetworkSetting': 78,
            'OnNATNetworkPortForward': 79,
            'OnGuestSessionStateChanged': 80,
            'OnGuestSessionRegistered': 81,
            'OnGuestProcessRegistered': 82,
            'OnGuestProcessStateChanged': 83,
            'OnGuestProcessInputNotify': 84,
            'OnGuestProcessOutput': 85,
            'OnGuestFileRegistered': 86,
            'OnGuestFileStateChanged': 87,
            'OnGuestFileOffsetChanged': 88,
            'OnGuestFileRead': 89,
            'OnGuestFileWrite': 90,
            'OnRecordingChanged': 91,
            'OnGuestUserStateChanged': 92,
            'OnGuestMultiTouch': 93,
            'OnHostNameResolutionConfigurationChange': 94,
            'OnSnapshotRestored': 95,
            'OnMediumConfigChanged': 96,
            'OnAudioAdapterChanged': 97,
            'OnProgressPercentageChanged': 98,
            'OnProgressTaskCompleted': 99,
            'OnCursorPositionChanged': 100,
            'OnGuestAdditionsStatusChanged': 101,
            'OnGuestMonitorInfoChanged': 102,
            'OnGuestFileSizeChanged': 103,
            'OnClipboardFileTransferModeChanged': 104,
            'Last': 105,
        },
        'GuestMouseEventMode': {
            'Relative': 0,
            'Absolute': 1,
        },
        'GuestMonitorChangedEventType': {
            'Enabled': 0,
            'Disabled': 1,
            'NewOrigin': 2,
        },
        'FormValueType': {
            'Boolean': 0,
            'String': 1,
            'Choice': 2,
            'RangedInteger': 3,
        },
        'CloudMachineState': {
            'Invalid': 0,
            'Provisioning': 1,
            'Running': 2,
            'Starting': 3,
            'Stopping': 4,
            'Stopped': 5,
            'CreatingImage': 6,
            'Terminating': 7,
            'Terminated': 8,
        },
        'CloudImageState': {
            'Invalid': 0,
            'Provisioning': 1,
            'Importing': 2,
            'Available': 3,
            'Exporting': 4,
            'Disabled': 5,
            'Deleted': 6,
        },
        # iprt/err.h + VBox/err.h constants:
        'VBoxStatus': __dVBoxStatuses,
    }

    __dValuesSym = {
        'SettingsVersion': {
            'Null': 'Null',
            'v1_0': 'v1_0',
            'v1_1': 'v1_1',
            'v1_2': 'v1_2',
            'v1_3pre': 'v1_3pre',
            'v1_3': 'v1_3',
            'v1_4': 'v1_4',
            'v1_5': 'v1_5',
            'v1_6': 'v1_6',
            'v1_7': 'v1_7',
            'v1_8': 'v1_8',
            'v1_9': 'v1_9',
            'v1_10': 'v1_10',
            'v1_11': 'v1_11',
            'v1_12': 'v1_12',
            'v1_13': 'v1_13',
            'v1_14': 'v1_14',
            'v1_15': 'v1_15',
            'v1_16': 'v1_16',
            'v1_17': 'v1_17',
            'v1_18': 'v1_18',
            'Future': 'Future',
        },
        'AccessMode': {
            'ReadOnly': 'ReadOnly',
            'ReadWrite': 'ReadWrite',
        },
        'MachineState': {
            'Null': 'Null',
            'PoweredOff': 'PoweredOff',
            'Saved': 'Saved',
            'Teleported': 'Teleported',
            'Aborted': 'Aborted',
            'Running': 'Running',
            'Paused': 'Paused',
            'Stuck': 'Stuck',
            'Teleporting': 'Teleporting',
            'LiveSnapshotting': 'LiveSnapshotting',
            'Starting': 'Starting',
            'Stopping': 'Stopping',
            'Saving': 'Saving',
            'Restoring': 'Restoring',
            'TeleportingPausedVM': 'TeleportingPausedVM',
            'TeleportingIn': 'TeleportingIn',
            'DeletingSnapshotOnline': 'DeletingSnapshotOnline',
            'DeletingSnapshotPaused': 'DeletingSnapshotPaused',
            'OnlineSnapshotting': 'OnlineSnapshotting',
            'RestoringSnapshot': 'RestoringSnapshot',
            'DeletingSnapshot': 'DeletingSnapshot',
            'SettingUp': 'SettingUp',
            'Snapshotting': 'Snapshotting',
            'FirstOnline': 'FirstOnline',
            'LastOnline': 'LastOnline',
            'FirstTransient': 'FirstTransient',
            'LastTransient': 'LastTransient',
        },
        'SessionState': {
            'Null': 'Null',
            'Unlocked': 'Unlocked',
            'Locked': 'Locked',
            'Spawning': 'Spawning',
            'Unlocking': 'Unlocking',
        },
        'CPUPropertyType': {
            'Null': 'Null',
            'PAE': 'PAE',
            'LongMode': 'LongMode',
            'TripleFaultReset': 'TripleFaultReset',
            'APIC': 'APIC',
            'X2APIC': 'X2APIC',
            'IBPBOnVMExit': 'IBPBOnVMExit',
            'IBPBOnVMEntry': 'IBPBOnVMEntry',
            'HWVirt': 'HWVirt',
            'SpecCtrl': 'SpecCtrl',
            'SpecCtrlByHost': 'SpecCtrlByHost',
            'L1DFlushOnEMTScheduling': 'L1DFlushOnEMTScheduling',
            'L1DFlushOnVMEntry': 'L1DFlushOnVMEntry',
            'MDSClearOnEMTScheduling': 'MDSClearOnEMTScheduling',
            'MDSClearOnVMEntry': 'MDSClearOnVMEntry',
        },
        'HWVirtExPropertyType': {
            'Null': 'Null',
            'Enabled': 'Enabled',
            'VPID': 'VPID',
            'NestedPaging': 'NestedPaging',
            'UnrestrictedExecution': 'UnrestrictedExecution',
            'LargePages': 'LargePages',
            'Force': 'Force',
            'UseNativeApi': 'UseNativeApi',
        },
        'ParavirtProvider': {
            'None': 'None',
            'Default': 'Default',
            'Legacy': 'Legacy',
            'Minimal': 'Minimal',
            'HyperV': 'HyperV',
            'KVM': 'KVM',
        },
        'LockType': {
            'Null': 'Null',
            'Shared': 'Shared',
            'Write': 'Write',
            'VM': 'VM',
        },
        'SessionType': {
            'Null': 'Null',
            'WriteLock': 'WriteLock',
            'Remote': 'Remote',
            'Shared': 'Shared',
        },
        'DeviceType': {
            'Null': 'Null',
            'Floppy': 'Floppy',
            'DVD': 'DVD',
            'HardDisk': 'HardDisk',
            'Network': 'Network',
            'USB': 'USB',
            'SharedFolder': 'SharedFolder',
            'Graphics3D': 'Graphics3D',
        },
        'DeviceActivity': {
            'Null': 'Null',
            'Idle': 'Idle',
            'Reading': 'Reading',
            'Writing': 'Writing',
        },
        'ClipboardMode': {
            'Disabled': 'Disabled',
            'HostToGuest': 'HostToGuest',
            'GuestToHost': 'GuestToHost',
            'Bidirectional': 'Bidirectional',
        },
        'DnDMode': {
            'Disabled': 'Disabled',
            'HostToGuest': 'HostToGuest',
            'GuestToHost': 'GuestToHost',
            'Bidirectional': 'Bidirectional',
        },
        'Scope': {
            'Global': 'Global',
            'Machine': 'Machine',
            'Session': 'Session',
        },
        'BIOSBootMenuMode': {
            'Disabled': 'Disabled',
            'MenuOnly': 'MenuOnly',
            'MessageAndMenu': 'MessageAndMenu',
        },
        'APICMode': {
            'Disabled': 'Disabled',
            'APIC': 'APIC',
            'X2APIC': 'X2APIC',
        },
        'ProcessorFeature': {
            'HWVirtEx': 'HWVirtEx',
            'PAE': 'PAE',
            'LongMode': 'LongMode',
            'NestedPaging': 'NestedPaging',
            'UnrestrictedGuest': 'UnrestrictedGuest',
            'NestedHWVirt': 'NestedHWVirt',
        },
        'FirmwareType': {
            'BIOS': 'BIOS',
            'EFI': 'EFI',
            'EFI32': 'EFI32',
            'EFI64': 'EFI64',
            'EFIDUAL': 'EFIDUAL',
        },
        'PointingHIDType': {
            'None': 'None',
            'PS2Mouse': 'PS2Mouse',
            'USBMouse': 'USBMouse',
            'USBTablet': 'USBTablet',
            'ComboMouse': 'ComboMouse',
            'USBMultiTouch': 'USBMultiTouch',
        },
        'KeyboardHIDType': {
            'None': 'None',
            'PS2Keyboard': 'PS2Keyboard',
            'USBKeyboard': 'USBKeyboard',
            'ComboKeyboard': 'ComboKeyboard',
        },
        'BitmapFormat': {
            'Opaque': 'Opaque',
            'BGR': 'BGR',
            'BGR0': 'BGR0',
            'BGRA': 'BGRA',
            'RGBA': 'RGBA',
            'PNG': 'PNG',
            'JPEG': 'JPEG',
        },
        'DHCPOption': {
            'SubnetMask': 'SubnetMask',
            'TimeOffset': 'TimeOffset',
            'Routers': 'Routers',
            'TimeServers': 'TimeServers',
            'NameServers': 'NameServers',
            'DomainNameServers': 'DomainNameServers',
            'LogServers': 'LogServers',
            'CookieServers': 'CookieServers',
            'LPRServers': 'LPRServers',
            'ImpressServers': 'ImpressServers',
            'ResourseLocationServers': 'ResourseLocationServers',
            'HostName': 'HostName',
            'BootFileSize': 'BootFileSize',
            'MeritDumpFile': 'MeritDumpFile',
            'DomainName': 'DomainName',
            'SwapServer': 'SwapServer',
            'RootPath': 'RootPath',
            'ExtensionPath': 'ExtensionPath',
            'IPForwarding': 'IPForwarding',
            'OptNonLocalSourceRouting': 'OptNonLocalSourceRouting',
            'PolicyFilter': 'PolicyFilter',
            'MaxDgramReassemblySize': 'MaxDgramReassemblySize',
            'DefaultIPTTL': 'DefaultIPTTL',
            'PathMTUAgingTimeout': 'PathMTUAgingTimeout',
            'PathMTUPlateauTable': 'PathMTUPlateauTable',
            'InterfaceMTU': 'InterfaceMTU',
            'AllSubnetsAreLocal': 'AllSubnetsAreLocal',
            'BroadcastAddress': 'BroadcastAddress',
            'PerformMaskDiscovery': 'PerformMaskDiscovery',
            'MaskSupplier': 'MaskSupplier',
            'PerformRouterDiscovery': 'PerformRouterDiscovery',
            'RouterSolicitationAddress': 'RouterSolicitationAddress',
            'StaticRoute': 'StaticRoute',
            'TrailerEncapsulation': 'TrailerEncapsulation',
            'ARPCacheTimeout': 'ARPCacheTimeout',
            'EthernetEncapsulation': 'EthernetEncapsulation',
            'TCPDefaultTTL': 'TCPDefaultTTL',
            'TCPKeepaliveInterval': 'TCPKeepaliveInterval',
            'TCPKeepaliveGarbage': 'TCPKeepaliveGarbage',
            'NISDomain': 'NISDomain',
            'NISServers': 'NISServers',
            'NTPServers': 'NTPServers',
            'VendorSpecificInfo': 'VendorSpecificInfo',
            'NetBIOSNameServers': 'NetBIOSNameServers',
            'NetBIOSDatagramServers': 'NetBIOSDatagramServers',
            'NetBIOSNodeType': 'NetBIOSNodeType',
            'NetBIOSScope': 'NetBIOSScope',
            'XWindowsFontServers': 'XWindowsFontServers',
            'XWindowsDisplayManager': 'XWindowsDisplayManager',
            'NetWareIPDomainName': 'NetWareIPDomainName',
            'NetWareIPInformation': 'NetWareIPInformation',
            'NISPlusDomain': 'NISPlusDomain',
            'NISPlusServers': 'NISPlusServers',
            'TFTPServerName': 'TFTPServerName',
            'BootfileName': 'BootfileName',
            'MobileIPHomeAgents': 'MobileIPHomeAgents',
            'SMTPServers': 'SMTPServers',
            'POP3Servers': 'POP3Servers',
            'NNTPServers': 'NNTPServers',
            'WWWServers': 'WWWServers',
            'FingerServers': 'FingerServers',
            'IRCServers': 'IRCServers',
            'StreetTalkServers': 'StreetTalkServers',
            'STDAServers': 'STDAServers',
            'SLPDirectoryAgent': 'SLPDirectoryAgent',
            'SLPServiceScope': 'SLPServiceScope',
            'DomainSearch': 'DomainSearch',
        },
        'DHCPOptionEncoding': {
            'Normal': 'Normal',
            'Hex': 'Hex',
        },
        'DHCPConfigScope': {
            'Global': 'Global',
            'Group': 'Group',
            'MachineNIC': 'MachineNIC',
            'MAC': 'MAC',
        },
        'DHCPGroupConditionType': {
            'MAC': 'MAC',
            'MACWildcard': 'MACWildcard',
            'vendorClassID': 'vendorClassID',
            'vendorClassIDWildcard': 'vendorClassIDWildcard',
            'userClassID': 'userClassID',
            'userClassIDWildcard': 'userClassIDWildcard',
        },
        'VFSType': {
            'File': 'File',
            'Cloud': 'Cloud',
            'S3': 'S3',
            'WebDav': 'WebDav',
        },
        'ImportOptions': {
            'KeepAllMACs': 'KeepAllMACs',
            'KeepNATMACs': 'KeepNATMACs',
            'ImportToVDI': 'ImportToVDI',
        },
        'ExportOptions': {
            'CreateManifest': 'CreateManifest',
            'ExportDVDImages': 'ExportDVDImages',
            'StripAllMACs': 'StripAllMACs',
            'StripAllNonNATMACs': 'StripAllNonNATMACs',
        },
        'CertificateVersion': {
            'V1': 'V1',
            'V2': 'V2',
            'V3': 'V3',
            'Unknown': 'Unknown',
        },
        'VirtualSystemDescriptionType': {
            'Ignore': 'Ignore',
            'OS': 'OS',
            'Name': 'Name',
            'Product': 'Product',
            'Vendor': 'Vendor',
            'Version': 'Version',
            'ProductUrl': 'ProductUrl',
            'VendorUrl': 'VendorUrl',
            'Description': 'Description',
            'License': 'License',
            'Miscellaneous': 'Miscellaneous',
            'CPU': 'CPU',
            'Memory': 'Memory',
            'HardDiskControllerIDE': 'HardDiskControllerIDE',
            'HardDiskControllerSATA': 'HardDiskControllerSATA',
            'HardDiskControllerSCSI': 'HardDiskControllerSCSI',
            'HardDiskControllerSAS': 'HardDiskControllerSAS',
            'HardDiskImage': 'HardDiskImage',
            'Floppy': 'Floppy',
            'CDROM': 'CDROM',
            'NetworkAdapter': 'NetworkAdapter',
            'USBController': 'USBController',
            'SoundCard': 'SoundCard',
            'SettingsFile': 'SettingsFile',
            'BaseFolder': 'BaseFolder',
            'PrimaryGroup': 'PrimaryGroup',
            'CloudInstanceShape': 'CloudInstanceShape',
            'CloudDomain': 'CloudDomain',
            'CloudBootDiskSize': 'CloudBootDiskSize',
            'CloudBucket': 'CloudBucket',
            'CloudOCIVCN': 'CloudOCIVCN',
            'CloudPublicIP': 'CloudPublicIP',
            'CloudProfileName': 'CloudProfileName',
            'CloudOCISubnet': 'CloudOCISubnet',
            'CloudKeepObject': 'CloudKeepObject',
            'CloudLaunchInstance': 'CloudLaunchInstance',
            'CloudInstanceId': 'CloudInstanceId',
            'CloudImageId': 'CloudImageId',
            'CloudInstanceState': 'CloudInstanceState',
            'CloudImageState': 'CloudImageState',
            'CloudInstanceDisplayName': 'CloudInstanceDisplayName',
            'CloudImageDisplayName': 'CloudImageDisplayName',
            'CloudOCILaunchMode': 'CloudOCILaunchMode',
            'CloudPrivateIP': 'CloudPrivateIP',
            'CloudBootVolumeId': 'CloudBootVolumeId',
            'CloudOCIVCNCompartment': 'CloudOCIVCNCompartment',
            'CloudOCISubnetCompartment': 'CloudOCISubnetCompartment',
            'CloudPublicSSHKey': 'CloudPublicSSHKey',
            'BootingFirmware': 'BootingFirmware',
        },
        'VirtualSystemDescriptionValueType': {
            'Reference': 'Reference',
            'Original': 'Original',
            'Auto': 'Auto',
            'ExtraConfig': 'ExtraConfig',
        },
        'RecordingDestination': {
            'None': 'None',
            'File': 'File',
        },
        'RecordingFeature': {
            'None': 'None',
            'Video': 'Video',
            'Audio': 'Audio',
        },
        'RecordingAudioCodec': {
            'None': 'None',
            'WavPCM': 'WavPCM',
            'Opus': 'Opus',
        },
        'RecordingVideoCodec': {
            'None': 'None',
            'VP8': 'VP8',
            'VP9': 'VP9',
            'AV1': 'AV1',
        },
        'RecordingVideoScalingMethod': {
            'None': 'None',
            'NearestNeighbor': 'NearestNeighbor',
            'Bilinear': 'Bilinear',
            'Bicubic': 'Bicubic',
        },
        'RecordingVideoRateControlMode': {
            'CBR': 'CBR',
            'VBR': 'VBR',
        },
        'GraphicsControllerType': {
            'Null': 'Null',
            'VBoxVGA': 'VBoxVGA',
            'VMSVGA': 'VMSVGA',
            'VBoxSVGA': 'VBoxSVGA',
        },
        'CleanupMode': {
            'UnregisterOnly': 'UnregisterOnly',
            'DetachAllReturnNone': 'DetachAllReturnNone',
            'DetachAllReturnHardDisksOnly': 'DetachAllReturnHardDisksOnly',
            'Full': 'Full',
        },
        'CloneMode': {
            'MachineState': 'MachineState',
            'MachineAndChildStates': 'MachineAndChildStates',
            'AllStates': 'AllStates',
        },
        'CloneOptions': {
            'Link': 'Link',
            'KeepAllMACs': 'KeepAllMACs',
            'KeepNATMACs': 'KeepNATMACs',
            'KeepDiskNames': 'KeepDiskNames',
            'KeepHwUUIDs': 'KeepHwUUIDs',
        },
        'AutostopType': {
            'Disabled': 'Disabled',
            'SaveState': 'SaveState',
            'PowerOff': 'PowerOff',
            'AcpiShutdown': 'AcpiShutdown',
        },
        'VMProcPriority': {
            'Invalid': 'Invalid',
            'Default': 'Default',
            'Flat': 'Flat',
            'Low': 'Low',
            'Normal': 'Normal',
            'High': 'High',
        },
        'HostNetworkInterfaceMediumType': {
            'Unknown': 'Unknown',
            'Ethernet': 'Ethernet',
            'PPP': 'PPP',
            'SLIP': 'SLIP',
        },
        'HostNetworkInterfaceStatus': {
            'Unknown': 'Unknown',
            'Up': 'Up',
            'Down': 'Down',
        },
        'HostNetworkInterfaceType': {
            'Bridged': 'Bridged',
            'HostOnly': 'HostOnly',
        },
        'ProxyMode': {
            'System': 'System',
            'NoProxy': 'NoProxy',
            'Manual': 'Manual',
        },
        'AdditionsFacilityType': {
            'None': 'None',
            'VBoxGuestDriver': 'VBoxGuestDriver',
            'AutoLogon': 'AutoLogon',
            'VBoxService': 'VBoxService',
            'VBoxTrayClient': 'VBoxTrayClient',
            'Seamless': 'Seamless',
            'Graphics': 'Graphics',
            'MonitorAttach': 'MonitorAttach',
            'All': 'All',
        },
        'AdditionsFacilityClass': {
            'None': 'None',
            'Driver': 'Driver',
            'Service': 'Service',
            'Program': 'Program',
            'Feature': 'Feature',
            'ThirdParty': 'ThirdParty',
            'All': 'All',
        },
        'AdditionsFacilityStatus': {
            'Inactive': 'Inactive',
            'Paused': 'Paused',
            'PreInit': 'PreInit',
            'Init': 'Init',
            'Active': 'Active',
            'Terminating': 'Terminating',
            'Terminated': 'Terminated',
            'Failed': 'Failed',
            'Unknown': 'Unknown',
        },
        'AdditionsRunLevelType': {
            'None': 'None',
            'System': 'System',
            'Userland': 'Userland',
            'Desktop': 'Desktop',
        },
        'AdditionsUpdateFlag': {
            'None': 'None',
            'WaitForUpdateStartOnly': 'WaitForUpdateStartOnly',
        },
        'GuestSessionStatus': {
            'Undefined': 'Undefined',
            'Starting': 'Starting',
            'Started': 'Started',
            'Terminating': 'Terminating',
            'Terminated': 'Terminated',
            'TimedOutKilled': 'TimedOutKilled',
            'TimedOutAbnormally': 'TimedOutAbnormally',
            'Down': 'Down',
            'Error': 'Error',
        },
        'GuestSessionWaitForFlag': {
            'None': 'None',
            'Start': 'Start',
            'Terminate': 'Terminate',
            'Status': 'Status',
        },
        'GuestSessionWaitResult': {
            'None': 'None',
            'Start': 'Start',
            'Terminate': 'Terminate',
            'Status': 'Status',
            'Error': 'Error',
            'Timeout': 'Timeout',
            'WaitFlagNotSupported': 'WaitFlagNotSupported',
        },
        'GuestUserState': {
            'Unknown': 'Unknown',
            'LoggedIn': 'LoggedIn',
            'LoggedOut': 'LoggedOut',
            'Locked': 'Locked',
            'Unlocked': 'Unlocked',
            'Disabled': 'Disabled',
            'Idle': 'Idle',
            'InUse': 'InUse',
            'Created': 'Created',
            'Deleted': 'Deleted',
            'SessionChanged': 'SessionChanged',
            'CredentialsChanged': 'CredentialsChanged',
            'RoleChanged': 'RoleChanged',
            'GroupAdded': 'GroupAdded',
            'GroupRemoved': 'GroupRemoved',
            'Elevated': 'Elevated',
        },
        'FileSeekOrigin': {
            'Begin': 'Begin',
            'Current': 'Current',
            'End': 'End',
        },
        'ProcessInputFlag': {
            'None': 'None',
            'EndOfFile': 'EndOfFile',
        },
        'ProcessOutputFlag': {
            'None': 'None',
            'StdErr': 'StdErr',
        },
        'ProcessWaitForFlag': {
            'None': 'None',
            'Start': 'Start',
            'Terminate': 'Terminate',
            'StdIn': 'StdIn',
            'StdOut': 'StdOut',
            'StdErr': 'StdErr',
        },
        'ProcessWaitResult': {
            'None': 'None',
            'Start': 'Start',
            'Terminate': 'Terminate',
            'Status': 'Status',
            'Error': 'Error',
            'Timeout': 'Timeout',
            'StdIn': 'StdIn',
            'StdOut': 'StdOut',
            'StdErr': 'StdErr',
            'WaitFlagNotSupported': 'WaitFlagNotSupported',
        },
        'FileCopyFlag': {
            'None': 'None',
            'NoReplace': 'NoReplace',
            'FollowLinks': 'FollowLinks',
            'Update': 'Update',
        },
        'FsObjMoveFlag': {
            'None': 'None',
            'Replace': 'Replace',
            'FollowLinks': 'FollowLinks',
            'AllowDirectoryMoves': 'AllowDirectoryMoves',
        },
        'DirectoryCreateFlag': {
            'None': 'None',
            'Parents': 'Parents',
        },
        'DirectoryCopyFlag': {
            'None': 'None',
            'CopyIntoExisting': 'CopyIntoExisting',
        },
        'DirectoryRemoveRecFlag': {
            'None': 'None',
            'ContentAndDir': 'ContentAndDir',
            'ContentOnly': 'ContentOnly',
        },
        'FsObjRenameFlag': {
            'NoReplace': 'NoReplace',
            'Replace': 'Replace',
        },
        'ProcessCreateFlag': {
            'None': 'None',
            'WaitForProcessStartOnly': 'WaitForProcessStartOnly',
            'IgnoreOrphanedProcesses': 'IgnoreOrphanedProcesses',
            'Hidden': 'Hidden',
            'Profile': 'Profile',
            'WaitForStdOut': 'WaitForStdOut',
            'WaitForStdErr': 'WaitForStdErr',
            'ExpandArguments': 'ExpandArguments',
            'UnquotedArguments': 'UnquotedArguments',
        },
        'ProcessPriority': {
            'Invalid': 'Invalid',
            'Default': 'Default',
        },
        'SymlinkType': {
            'Unknown': 'Unknown',
            'Directory': 'Directory',
            'File': 'File',
        },
        'SymlinkReadFlag': {
            'None': 'None',
            'NoSymlinks': 'NoSymlinks',
        },
        'ProcessStatus': {
            'Undefined': 'Undefined',
            'Starting': 'Starting',
            'Started': 'Started',
            'Paused': 'Paused',
            'Terminating': 'Terminating',
            'TerminatedNormally': 'TerminatedNormally',
            'TerminatedSignal': 'TerminatedSignal',
            'TerminatedAbnormally': 'TerminatedAbnormally',
            'TimedOutKilled': 'TimedOutKilled',
            'TimedOutAbnormally': 'TimedOutAbnormally',
            'Down': 'Down',
            'Error': 'Error',
        },
        'ProcessInputStatus': {
            'Undefined': 'Undefined',
            'Broken': 'Broken',
            'Available': 'Available',
            'Written': 'Written',
            'Overflow': 'Overflow',
        },
        'PathStyle': {
            'DOS': 'DOS',
            'UNIX': 'UNIX',
            'Unknown': 'Unknown',
        },
        'FileAccessMode': {
            'ReadOnly': 'ReadOnly',
            'WriteOnly': 'WriteOnly',
            'ReadWrite': 'ReadWrite',
            'AppendOnly': 'AppendOnly',
            'AppendRead': 'AppendRead',
        },
        'FileOpenAction': {
            'OpenExisting': 'OpenExisting',
            'OpenOrCreate': 'OpenOrCreate',
            'CreateNew': 'CreateNew',
            'CreateOrReplace': 'CreateOrReplace',
            'OpenExistingTruncated': 'OpenExistingTruncated',
            'AppendOrCreate': 'AppendOrCreate',
        },
        'FileSharingMode': {
            'Read': 'Read',
            'Write': 'Write',
            'ReadWrite': 'ReadWrite',
            'Delete': 'Delete',
            'ReadDelete': 'ReadDelete',
            'WriteDelete': 'WriteDelete',
            'All': 'All',
        },
        'FileOpenExFlag': {
            'None': 'None',
        },
        'FileStatus': {
            'Undefined': 'Undefined',
            'Opening': 'Opening',
            'Open': 'Open',
            'Closing': 'Closing',
            'Closed': 'Closed',
            'Down': 'Down',
            'Error': 'Error',
        },
        'FsObjType': {
            'Unknown': 'Unknown',
            'Fifo': 'Fifo',
            'DevChar': 'DevChar',
            'Directory': 'Directory',
            'DevBlock': 'DevBlock',
            'File': 'File',
            'Symlink': 'Symlink',
            'Socket': 'Socket',
            'WhiteOut': 'WhiteOut',
        },
        'DnDAction': {
            'Ignore': 'Ignore',
            'Copy': 'Copy',
            'Move': 'Move',
            'Link': 'Link',
        },
        'DirectoryOpenFlag': {
            'None': 'None',
            'NoSymlinks': 'NoSymlinks',
        },
        'MediumState': {
            'NotCreated': 'NotCreated',
            'Created': 'Created',
            'LockedRead': 'LockedRead',
            'LockedWrite': 'LockedWrite',
            'Inaccessible': 'Inaccessible',
            'Creating': 'Creating',
            'Deleting': 'Deleting',
        },
        'MediumType': {
            'Normal': 'Normal',
            'Immutable': 'Immutable',
            'Writethrough': 'Writethrough',
            'Shareable': 'Shareable',
            'Readonly': 'Readonly',
            'MultiAttach': 'MultiAttach',
        },
        'MediumVariant': {
            'Standard': 'Standard',
            'VmdkSplit2G': 'VmdkSplit2G',
            'VmdkRawDisk': 'VmdkRawDisk',
            'VmdkStreamOptimized': 'VmdkStreamOptimized',
            'VmdkESX': 'VmdkESX',
            'VdiZeroExpand': 'VdiZeroExpand',
            'Fixed': 'Fixed',
            'Diff': 'Diff',
            'Formatted': 'Formatted',
            'NoCreateDir': 'NoCreateDir',
        },
        'DataType': {
            'Int32': 'Int32',
            'Int8': 'Int8',
            'String': 'String',
        },
        'DataFlags': {
            'None': 'None',
            'Mandatory': 'Mandatory',
            'Expert': 'Expert',
            'Array': 'Array',
            'FlagMask': 'FlagMask',
        },
        'MediumFormatCapabilities': {
            'Uuid': 'Uuid',
            'CreateFixed': 'CreateFixed',
            'CreateDynamic': 'CreateDynamic',
            'CreateSplit2G': 'CreateSplit2G',
            'Differencing': 'Differencing',
            'Asynchronous': 'Asynchronous',
            'File': 'File',
            'Properties': 'Properties',
            'TcpNetworking': 'TcpNetworking',
            'VFS': 'VFS',
            'Discard': 'Discard',
            'Preferred': 'Preferred',
            'CapabilityMask': 'CapabilityMask',
        },
        'PartitionTableType': {
            'MBR': 'MBR',
            'GPT': 'GPT',
        },
        'KeyboardLED': {
            'NumLock': 'NumLock',
            'CapsLock': 'CapsLock',
            'ScrollLock': 'ScrollLock',
        },
        'MouseButtonState': {
            'LeftButton': 'LeftButton',
            'RightButton': 'RightButton',
            'MiddleButton': 'MiddleButton',
            'WheelUp': 'WheelUp',
            'WheelDown': 'WheelDown',
            'XButton1': 'XButton1',
            'XButton2': 'XButton2',
            'MouseStateMask': 'MouseStateMask',
        },
        'TouchContactState': {
            'None': 'None',
            'InContact': 'InContact',
            'InRange': 'InRange',
            'ContactStateMask': 'ContactStateMask',
        },
        'FramebufferCapabilities': {
            'UpdateImage': 'UpdateImage',
            'VHWA': 'VHWA',
            'VisibleRegion': 'VisibleRegion',
            'RenderCursor': 'RenderCursor',
            'MoveCursor': 'MoveCursor',
        },
        'GuestMonitorStatus': {
            'Disabled': 'Disabled',
            'Enabled': 'Enabled',
            'Blank': 'Blank',
        },
        'ScreenLayoutMode': {
            'Apply': 'Apply',
            'Reset': 'Reset',
            'Attach': 'Attach',
            'Silent': 'Silent',
        },
        'NetworkAttachmentType': {
            'Null': 'Null',
            'NAT': 'NAT',
            'Bridged': 'Bridged',
            'Internal': 'Internal',
            'HostOnly': 'HostOnly',
            'Generic': 'Generic',
            'NATNetwork': 'NATNetwork',
            'Cloud': 'Cloud',
        },
        'NetworkAdapterType': {
            'Null': 'Null',
            'Am79C970A': 'Am79C970A',
            'Am79C973': 'Am79C973',
            'I82540EM': 'I82540EM',
            'I82543GC': 'I82543GC',
            'I82545EM': 'I82545EM',
            'Virtio': 'Virtio',
            'Am79C960': 'Am79C960',
            'Virtio_1_0': 'Virtio_1_0',
        },
        'NetworkAdapterPromiscModePolicy': {
            'Deny': 'Deny',
            'AllowNetwork': 'AllowNetwork',
            'AllowAll': 'AllowAll',
        },
        'PortMode': {
            'Disconnected': 'Disconnected',
            'HostPipe': 'HostPipe',
            'HostDevice': 'HostDevice',
            'RawFile': 'RawFile',
            'TCP': 'TCP',
        },
        'UartType': {
            'U16450': 'U16450',
            'U16550A': 'U16550A',
            'U16750': 'U16750',
        },
        'VMExecutionEngine': {
            'NotSet': 'NotSet',
            'RawMode': 'RawMode',
            'HwVirt': 'HwVirt',
            'NativeApi': 'NativeApi',
        },
        'USBControllerType': {
            'Null': 'Null',
            'OHCI': 'OHCI',
            'EHCI': 'EHCI',
            'XHCI': 'XHCI',
            'Last': 'Last',
        },
        'USBConnectionSpeed': {
            'Null': 'Null',
            'Low': 'Low',
            'Full': 'Full',
            'High': 'High',
            'Super': 'Super',
            'SuperPlus': 'SuperPlus',
        },
        'USBDeviceState': {
            'NotSupported': 'NotSupported',
            'Unavailable': 'Unavailable',
            'Busy': 'Busy',
            'Available': 'Available',
            'Held': 'Held',
            'Captured': 'Captured',
        },
        'USBDeviceFilterAction': {
            'Null': 'Null',
            'Ignore': 'Ignore',
            'Hold': 'Hold',
        },
        'AudioDriverType': {
            'Null': 'Null',
            'WinMM': 'WinMM',
            'OSS': 'OSS',
            'ALSA': 'ALSA',
            'DirectSound': 'DirectSound',
            'CoreAudio': 'CoreAudio',
            'MMPM': 'MMPM',
            'Pulse': 'Pulse',
            'SolAudio': 'SolAudio',
        },
        'AudioControllerType': {
            'AC97': 'AC97',
            'SB16': 'SB16',
            'HDA': 'HDA',
        },
        'AudioCodecType': {
            'Null': 'Null',
            'SB16': 'SB16',
            'STAC9700': 'STAC9700',
            'AD1980': 'AD1980',
            'STAC9221': 'STAC9221',
        },
        'AuthType': {
            'Null': 'Null',
            'External': 'External',
            'Guest': 'Guest',
        },
        'Reason': {
            'Unspecified': 'Unspecified',
            'HostSuspend': 'HostSuspend',
            'HostResume': 'HostResume',
            'HostBatteryLow': 'HostBatteryLow',
            'Snapshot': 'Snapshot',
        },
        'StorageBus': {
            'Null': 'Null',
            'IDE': 'IDE',
            'SATA': 'SATA',
            'SCSI': 'SCSI',
            'Floppy': 'Floppy',
            'SAS': 'SAS',
            'USB': 'USB',
            'PCIe': 'PCIe',
            'VirtioSCSI': 'VirtioSCSI',
        },
        'StorageControllerType': {
            'Null': 'Null',
            'LsiLogic': 'LsiLogic',
            'BusLogic': 'BusLogic',
            'IntelAhci': 'IntelAhci',
            'PIIX3': 'PIIX3',
            'PIIX4': 'PIIX4',
            'ICH6': 'ICH6',
            'I82078': 'I82078',
            'LsiLogicSas': 'LsiLogicSas',
            'USB': 'USB',
            'NVMe': 'NVMe',
            'VirtioSCSI': 'VirtioSCSI',
        },
        'ChipsetType': {
            'Null': 'Null',
            'PIIX3': 'PIIX3',
            'ICH9': 'ICH9',
        },
        'NATAliasMode': {
            'AliasLog': 'AliasLog',
            'AliasProxyOnly': 'AliasProxyOnly',
            'AliasUseSamePorts': 'AliasUseSamePorts',
        },
        'NATProtocol': {
            'UDP': 'UDP',
            'TCP': 'TCP',
        },
        'BandwidthGroupType': {
            'Null': 'Null',
            'Disk': 'Disk',
            'Network': 'Network',
        },
        'VBoxEventType': {
            'Invalid': 'Invalid',
            'Any': 'Any',
            'Vetoable': 'Vetoable',
            'MachineEvent': 'MachineEvent',
            'SnapshotEvent': 'SnapshotEvent',
            'InputEvent': 'InputEvent',
            'LastWildcard': 'LastWildcard',
            'OnMachineStateChanged': 'OnMachineStateChanged',
            'OnMachineDataChanged': 'OnMachineDataChanged',
            'OnExtraDataChanged': 'OnExtraDataChanged',
            'OnExtraDataCanChange': 'OnExtraDataCanChange',
            'OnMediumRegistered': 'OnMediumRegistered',
            'OnMachineRegistered': 'OnMachineRegistered',
            'OnSessionStateChanged': 'OnSessionStateChanged',
            'OnSnapshotTaken': 'OnSnapshotTaken',
            'OnSnapshotDeleted': 'OnSnapshotDeleted',
            'OnSnapshotChanged': 'OnSnapshotChanged',
            'OnGuestPropertyChanged': 'OnGuestPropertyChanged',
            'OnMousePointerShapeChanged': 'OnMousePointerShapeChanged',
            'OnMouseCapabilityChanged': 'OnMouseCapabilityChanged',
            'OnKeyboardLedsChanged': 'OnKeyboardLedsChanged',
            'OnStateChanged': 'OnStateChanged',
            'OnAdditionsStateChanged': 'OnAdditionsStateChanged',
            'OnNetworkAdapterChanged': 'OnNetworkAdapterChanged',
            'OnSerialPortChanged': 'OnSerialPortChanged',
            'OnParallelPortChanged': 'OnParallelPortChanged',
            'OnStorageControllerChanged': 'OnStorageControllerChanged',
            'OnMediumChanged': 'OnMediumChanged',
            'OnVRDEServerChanged': 'OnVRDEServerChanged',
            'OnUSBControllerChanged': 'OnUSBControllerChanged',
            'OnUSBDeviceStateChanged': 'OnUSBDeviceStateChanged',
            'OnSharedFolderChanged': 'OnSharedFolderChanged',
            'OnRuntimeError': 'OnRuntimeError',
            'OnCanShowWindow': 'OnCanShowWindow',
            'OnShowWindow': 'OnShowWindow',
            'OnCPUChanged': 'OnCPUChanged',
            'OnVRDEServerInfoChanged': 'OnVRDEServerInfoChanged',
            'OnEventSourceChanged': 'OnEventSourceChanged',
            'OnCPUExecutionCapChanged': 'OnCPUExecutionCapChanged',
            'OnGuestKeyboard': 'OnGuestKeyboard',
            'OnGuestMouse': 'OnGuestMouse',
            'OnNATRedirect': 'OnNATRedirect',
            'OnHostPCIDevicePlug': 'OnHostPCIDevicePlug',
            'OnVBoxSVCAvailabilityChanged': 'OnVBoxSVCAvailabilityChanged',
            'OnBandwidthGroupChanged': 'OnBandwidthGroupChanged',
            'OnGuestMonitorChanged': 'OnGuestMonitorChanged',
            'OnStorageDeviceChanged': 'OnStorageDeviceChanged',
            'OnClipboardModeChanged': 'OnClipboardModeChanged',
            'OnDnDModeChanged': 'OnDnDModeChanged',
            'OnNATNetworkChanged': 'OnNATNetworkChanged',
            'OnNATNetworkStartStop': 'OnNATNetworkStartStop',
            'OnNATNetworkAlter': 'OnNATNetworkAlter',
            'OnNATNetworkCreationDeletion': 'OnNATNetworkCreationDeletion',
            'OnNATNetworkSetting': 'OnNATNetworkSetting',
            'OnNATNetworkPortForward': 'OnNATNetworkPortForward',
            'OnGuestSessionStateChanged': 'OnGuestSessionStateChanged',
            'OnGuestSessionRegistered': 'OnGuestSessionRegistered',
            'OnGuestProcessRegistered': 'OnGuestProcessRegistered',
            'OnGuestProcessStateChanged': 'OnGuestProcessStateChanged',
            'OnGuestProcessInputNotify': 'OnGuestProcessInputNotify',
            'OnGuestProcessOutput': 'OnGuestProcessOutput',
            'OnGuestFileRegistered': 'OnGuestFileRegistered',
            'OnGuestFileStateChanged': 'OnGuestFileStateChanged',
            'OnGuestFileOffsetChanged': 'OnGuestFileOffsetChanged',
            'OnGuestFileRead': 'OnGuestFileRead',
            'OnGuestFileWrite': 'OnGuestFileWrite',
            'OnRecordingChanged': 'OnRecordingChanged',
            'OnGuestUserStateChanged': 'OnGuestUserStateChanged',
            'OnGuestMultiTouch': 'OnGuestMultiTouch',
            'OnHostNameResolutionConfigurationChange': 'OnHostNameResolutionConfigurationChange',
            'OnSnapshotRestored': 'OnSnapshotRestored',
            'OnMediumConfigChanged': 'OnMediumConfigChanged',
            'OnAudioAdapterChanged': 'OnAudioAdapterChanged',
            'OnProgressPercentageChanged': 'OnProgressPercentageChanged',
            'OnProgressTaskCompleted': 'OnProgressTaskCompleted',
            'OnCursorPositionChanged': 'OnCursorPositionChanged',
            'OnGuestAdditionsStatusChanged': 'OnGuestAdditionsStatusChanged',
            'OnGuestMonitorInfoChanged': 'OnGuestMonitorInfoChanged',
            'OnGuestFileSizeChanged': 'OnGuestFileSizeChanged',
            'OnClipboardFileTransferModeChanged': 'OnClipboardFileTransferModeChanged',
            'Last': 'Last',
        },
        'GuestMouseEventMode': {
            'Relative': 'Relative',
            'Absolute': 'Absolute',
        },
        'GuestMonitorChangedEventType': {
            'Enabled': 'Enabled',
            'Disabled': 'Disabled',
            'NewOrigin': 'NewOrigin',
        },
        'FormValueType': {
            'Boolean': 'Boolean',
            'String': 'String',
            'Choice': 'Choice',
            'RangedInteger': 'RangedInteger',
        },
        'CloudMachineState': {
            'Invalid': 'Invalid',
            'Provisioning': 'Provisioning',
            'Running': 'Running',
            'Starting': 'Starting',
            'Stopping': 'Stopping',
            'Stopped': 'Stopped',
            'CreatingImage': 'CreatingImage',
            'Terminating': 'Terminating',
            'Terminated': 'Terminated',
        },
        'CloudImageState': {
            'Invalid': 'Invalid',
            'Provisioning': 'Provisioning',
            'Importing': 'Importing',
            'Available': 'Available',
            'Exporting': 'Exporting',
            'Disabled': 'Disabled',
            'Deleted': 'Deleted',
        },
    }

    __dValuesFlat = dict({
        'SettingsVersion_Null': 0,
        'SettingsVersion_v1_0': 1,
        'SettingsVersion_v1_1': 2,
        'SettingsVersion_v1_2': 3,
        'SettingsVersion_v1_3pre': 4,
        'SettingsVersion_v1_3': 5,
        'SettingsVersion_v1_4': 6,
        'SettingsVersion_v1_5': 7,
        'SettingsVersion_v1_6': 8,
        'SettingsVersion_v1_7': 9,
        'SettingsVersion_v1_8': 10,
        'SettingsVersion_v1_9': 11,
        'SettingsVersion_v1_10': 12,
        'SettingsVersion_v1_11': 13,
        'SettingsVersion_v1_12': 14,
        'SettingsVersion_v1_13': 15,
        'SettingsVersion_v1_14': 16,
        'SettingsVersion_v1_15': 17,
        'SettingsVersion_v1_16': 18,
        'SettingsVersion_v1_17': 19,
        'SettingsVersion_v1_18': 20,
        'SettingsVersion_Future': 99999,
        'AccessMode_ReadOnly': 1,
        'AccessMode_ReadWrite': 2,
        'MachineState_Null': 0,
        'MachineState_PoweredOff': 1,
        'MachineState_Saved': 2,
        'MachineState_Teleported': 3,
        'MachineState_Aborted': 4,
        'MachineState_Running': 5,
        'MachineState_Paused': 6,
        'MachineState_Stuck': 7,
        'MachineState_Teleporting': 8,
        'MachineState_LiveSnapshotting': 9,
        'MachineState_Starting': 10,
        'MachineState_Stopping': 11,
        'MachineState_Saving': 12,
        'MachineState_Restoring': 13,
        'MachineState_TeleportingPausedVM': 14,
        'MachineState_TeleportingIn': 15,
        'MachineState_DeletingSnapshotOnline': 16,
        'MachineState_DeletingSnapshotPaused': 17,
        'MachineState_OnlineSnapshotting': 18,
        'MachineState_RestoringSnapshot': 19,
        'MachineState_DeletingSnapshot': 20,
        'MachineState_SettingUp': 21,
        'MachineState_Snapshotting': 22,
        'MachineState_FirstOnline': 5,
        'MachineState_LastOnline': 18,
        'MachineState_FirstTransient': 8,
        'MachineState_LastTransient': 22,
        'SessionState_Null': 0,
        'SessionState_Unlocked': 1,
        'SessionState_Locked': 2,
        'SessionState_Spawning': 3,
        'SessionState_Unlocking': 4,
        'CPUPropertyType_Null': 0,
        'CPUPropertyType_PAE': 1,
        'CPUPropertyType_LongMode': 2,
        'CPUPropertyType_TripleFaultReset': 3,
        'CPUPropertyType_APIC': 4,
        'CPUPropertyType_X2APIC': 5,
        'CPUPropertyType_IBPBOnVMExit': 6,
        'CPUPropertyType_IBPBOnVMEntry': 7,
        'CPUPropertyType_HWVirt': 8,
        'CPUPropertyType_SpecCtrl': 9,
        'CPUPropertyType_SpecCtrlByHost': 10,
        'CPUPropertyType_L1DFlushOnEMTScheduling': 11,
        'CPUPropertyType_L1DFlushOnVMEntry': 12,
        'CPUPropertyType_MDSClearOnEMTScheduling': 13,
        'CPUPropertyType_MDSClearOnVMEntry': 14,
        'HWVirtExPropertyType_Null': 0,
        'HWVirtExPropertyType_Enabled': 1,
        'HWVirtExPropertyType_VPID': 2,
        'HWVirtExPropertyType_NestedPaging': 3,
        'HWVirtExPropertyType_UnrestrictedExecution': 4,
        'HWVirtExPropertyType_LargePages': 5,
        'HWVirtExPropertyType_Force': 6,
        'HWVirtExPropertyType_UseNativeApi': 7,
        'ParavirtProvider_None': 0,
        'ParavirtProvider_Default': 1,
        'ParavirtProvider_Legacy': 2,
        'ParavirtProvider_Minimal': 3,
        'ParavirtProvider_HyperV': 4,
        'ParavirtProvider_KVM': 5,
        'LockType_Null': 0,
        'LockType_Shared': 1,
        'LockType_Write': 2,
        'LockType_VM': 3,
        'SessionType_Null': 0,
        'SessionType_WriteLock': 1,
        'SessionType_Remote': 2,
        'SessionType_Shared': 3,
        'DeviceType_Null': 0,
        'DeviceType_Floppy': 1,
        'DeviceType_DVD': 2,
        'DeviceType_HardDisk': 3,
        'DeviceType_Network': 4,
        'DeviceType_USB': 5,
        'DeviceType_SharedFolder': 6,
        'DeviceType_Graphics3D': 7,
        'DeviceActivity_Null': 0,
        'DeviceActivity_Idle': 1,
        'DeviceActivity_Reading': 2,
        'DeviceActivity_Writing': 3,
        'ClipboardMode_Disabled': 0,
        'ClipboardMode_HostToGuest': 1,
        'ClipboardMode_GuestToHost': 2,
        'ClipboardMode_Bidirectional': 3,
        'DnDMode_Disabled': 0,
        'DnDMode_HostToGuest': 1,
        'DnDMode_GuestToHost': 2,
        'DnDMode_Bidirectional': 3,
        'Scope_Global': 0,
        'Scope_Machine': 1,
        'Scope_Session': 2,
        'BIOSBootMenuMode_Disabled': 0,
        'BIOSBootMenuMode_MenuOnly': 1,
        'BIOSBootMenuMode_MessageAndMenu': 2,
        'APICMode_Disabled': 0,
        'APICMode_APIC': 1,
        'APICMode_X2APIC': 2,
        'ProcessorFeature_HWVirtEx': 0,
        'ProcessorFeature_PAE': 1,
        'ProcessorFeature_LongMode': 2,
        'ProcessorFeature_NestedPaging': 3,
        'ProcessorFeature_UnrestrictedGuest': 4,
        'ProcessorFeature_NestedHWVirt': 5,
        'FirmwareType_BIOS': 1,
        'FirmwareType_EFI': 2,
        'FirmwareType_EFI32': 3,
        'FirmwareType_EFI64': 4,
        'FirmwareType_EFIDUAL': 5,
        'PointingHIDType_None': 1,
        'PointingHIDType_PS2Mouse': 2,
        'PointingHIDType_USBMouse': 3,
        'PointingHIDType_USBTablet': 4,
        'PointingHIDType_ComboMouse': 5,
        'PointingHIDType_USBMultiTouch': 6,
        'KeyboardHIDType_None': 1,
        'KeyboardHIDType_PS2Keyboard': 2,
        'KeyboardHIDType_USBKeyboard': 3,
        'KeyboardHIDType_ComboKeyboard': 4,
        'BitmapFormat_Opaque': 0,
        'BitmapFormat_BGR': 0x20524742,
        'BitmapFormat_BGR0': 0x30524742,
        'BitmapFormat_BGRA': 0x41524742,
        'BitmapFormat_RGBA': 0x41424752,
        'BitmapFormat_PNG': 0x20474E50,
        'BitmapFormat_JPEG': 0x4745504A,
        'DHCPOption_SubnetMask': 1,
        'DHCPOption_TimeOffset': 2,
        'DHCPOption_Routers': 3,
        'DHCPOption_TimeServers': 4,
        'DHCPOption_NameServers': 5,
        'DHCPOption_DomainNameServers': 6,
        'DHCPOption_LogServers': 7,
        'DHCPOption_CookieServers': 8,
        'DHCPOption_LPRServers': 9,
        'DHCPOption_ImpressServers': 10,
        'DHCPOption_ResourseLocationServers': 11,
        'DHCPOption_HostName': 12,
        'DHCPOption_BootFileSize': 13,
        'DHCPOption_MeritDumpFile': 14,
        'DHCPOption_DomainName': 15,
        'DHCPOption_SwapServer': 16,
        'DHCPOption_RootPath': 17,
        'DHCPOption_ExtensionPath': 18,
        'DHCPOption_IPForwarding': 19,
        'DHCPOption_OptNonLocalSourceRouting': 20,
        'DHCPOption_PolicyFilter': 21,
        'DHCPOption_MaxDgramReassemblySize': 22,
        'DHCPOption_DefaultIPTTL': 23,
        'DHCPOption_PathMTUAgingTimeout': 24,
        'DHCPOption_PathMTUPlateauTable': 25,
        'DHCPOption_InterfaceMTU': 26,
        'DHCPOption_AllSubnetsAreLocal': 27,
        'DHCPOption_BroadcastAddress': 28,
        'DHCPOption_PerformMaskDiscovery': 29,
        'DHCPOption_MaskSupplier': 30,
        'DHCPOption_PerformRouterDiscovery': 31,
        'DHCPOption_RouterSolicitationAddress': 32,
        'DHCPOption_StaticRoute': 33,
        'DHCPOption_TrailerEncapsulation': 34,
        'DHCPOption_ARPCacheTimeout': 35,
        'DHCPOption_EthernetEncapsulation': 36,
        'DHCPOption_TCPDefaultTTL': 37,
        'DHCPOption_TCPKeepaliveInterval': 38,
        'DHCPOption_TCPKeepaliveGarbage': 39,
        'DHCPOption_NISDomain': 40,
        'DHCPOption_NISServers': 41,
        'DHCPOption_NTPServers': 42,
        'DHCPOption_VendorSpecificInfo': 43,
        'DHCPOption_NetBIOSNameServers': 44,
        'DHCPOption_NetBIOSDatagramServers': 45,
        'DHCPOption_NetBIOSNodeType': 46,
        'DHCPOption_NetBIOSScope': 47,
        'DHCPOption_XWindowsFontServers': 48,
        'DHCPOption_XWindowsDisplayManager': 49,
        'DHCPOption_NetWareIPDomainName': 62,
        'DHCPOption_NetWareIPInformation': 63,
        'DHCPOption_NISPlusDomain': 64,
        'DHCPOption_NISPlusServers': 65,
        'DHCPOption_TFTPServerName': 66,
        'DHCPOption_BootfileName': 67,
        'DHCPOption_MobileIPHomeAgents': 68,
        'DHCPOption_SMTPServers': 69,
        'DHCPOption_POP3Servers': 70,
        'DHCPOption_NNTPServers': 71,
        'DHCPOption_WWWServers': 72,
        'DHCPOption_FingerServers': 73,
        'DHCPOption_IRCServers': 74,
        'DHCPOption_StreetTalkServers': 75,
        'DHCPOption_STDAServers': 76,
        'DHCPOption_SLPDirectoryAgent': 78,
        'DHCPOption_SLPServiceScope': 79,
        'DHCPOption_DomainSearch': 119,
        'DHCPOptionEncoding_Normal': 0,
        'DHCPOptionEncoding_Hex': 1,
        'DHCPConfigScope_Global': 0,
        'DHCPConfigScope_Group': 1,
        'DHCPConfigScope_MachineNIC': 2,
        'DHCPConfigScope_MAC': 3,
        'DHCPGroupConditionType_MAC': 0,
        'DHCPGroupConditionType_MACWildcard': 1,
        'DHCPGroupConditionType_vendorClassID': 2,
        'DHCPGroupConditionType_vendorClassIDWildcard': 3,
        'DHCPGroupConditionType_userClassID': 4,
        'DHCPGroupConditionType_userClassIDWildcard': 5,
        'VFSType_File': 1,
        'VFSType_Cloud': 2,
        'VFSType_S3': 3,
        'VFSType_WebDav': 4,
        'ImportOptions_KeepAllMACs': 1,
        'ImportOptions_KeepNATMACs': 2,
        'ImportOptions_ImportToVDI': 3,
        'ExportOptions_CreateManifest': 1,
        'ExportOptions_ExportDVDImages': 2,
        'ExportOptions_StripAllMACs': 3,
        'ExportOptions_StripAllNonNATMACs': 4,
        'CertificateVersion_V1': 1,
        'CertificateVersion_V2': 2,
        'CertificateVersion_V3': 3,
        'CertificateVersion_Unknown': 99,
        'VirtualSystemDescriptionType_Ignore': 1,
        'VirtualSystemDescriptionType_OS': 2,
        'VirtualSystemDescriptionType_Name': 3,
        'VirtualSystemDescriptionType_Product': 4,
        'VirtualSystemDescriptionType_Vendor': 5,
        'VirtualSystemDescriptionType_Version': 6,
        'VirtualSystemDescriptionType_ProductUrl': 7,
        'VirtualSystemDescriptionType_VendorUrl': 8,
        'VirtualSystemDescriptionType_Description': 9,
        'VirtualSystemDescriptionType_License': 10,
        'VirtualSystemDescriptionType_Miscellaneous': 11,
        'VirtualSystemDescriptionType_CPU': 12,
        'VirtualSystemDescriptionType_Memory': 13,
        'VirtualSystemDescriptionType_HardDiskControllerIDE': 14,
        'VirtualSystemDescriptionType_HardDiskControllerSATA': 15,
        'VirtualSystemDescriptionType_HardDiskControllerSCSI': 16,
        'VirtualSystemDescriptionType_HardDiskControllerSAS': 17,
        'VirtualSystemDescriptionType_HardDiskImage': 18,
        'VirtualSystemDescriptionType_Floppy': 19,
        'VirtualSystemDescriptionType_CDROM': 20,
        'VirtualSystemDescriptionType_NetworkAdapter': 21,
        'VirtualSystemDescriptionType_USBController': 22,
        'VirtualSystemDescriptionType_SoundCard': 23,
        'VirtualSystemDescriptionType_SettingsFile': 24,
        'VirtualSystemDescriptionType_BaseFolder': 25,
        'VirtualSystemDescriptionType_PrimaryGroup': 26,
        'VirtualSystemDescriptionType_CloudInstanceShape': 27,
        'VirtualSystemDescriptionType_CloudDomain': 28,
        'VirtualSystemDescriptionType_CloudBootDiskSize': 29,
        'VirtualSystemDescriptionType_CloudBucket': 30,
        'VirtualSystemDescriptionType_CloudOCIVCN': 31,
        'VirtualSystemDescriptionType_CloudPublicIP': 32,
        'VirtualSystemDescriptionType_CloudProfileName': 33,
        'VirtualSystemDescriptionType_CloudOCISubnet': 34,
        'VirtualSystemDescriptionType_CloudKeepObject': 35,
        'VirtualSystemDescriptionType_CloudLaunchInstance': 36,
        'VirtualSystemDescriptionType_CloudInstanceId': 37,
        'VirtualSystemDescriptionType_CloudImageId': 38,
        'VirtualSystemDescriptionType_CloudInstanceState': 39,
        'VirtualSystemDescriptionType_CloudImageState': 40,
        'VirtualSystemDescriptionType_CloudInstanceDisplayName': 41,
        'VirtualSystemDescriptionType_CloudImageDisplayName': 42,
        'VirtualSystemDescriptionType_CloudOCILaunchMode': 43,
        'VirtualSystemDescriptionType_CloudPrivateIP': 44,
        'VirtualSystemDescriptionType_CloudBootVolumeId': 45,
        'VirtualSystemDescriptionType_CloudOCIVCNCompartment': 46,
        'VirtualSystemDescriptionType_CloudOCISubnetCompartment': 47,
        'VirtualSystemDescriptionType_CloudPublicSSHKey': 48,
        'VirtualSystemDescriptionType_BootingFirmware': 49,
        'VirtualSystemDescriptionValueType_Reference': 1,
        'VirtualSystemDescriptionValueType_Original': 2,
        'VirtualSystemDescriptionValueType_Auto': 3,
        'VirtualSystemDescriptionValueType_ExtraConfig': 4,
        'RecordingDestination_None': 0,
        'RecordingDestination_File': 1,
        'RecordingFeature_None': 0,
        'RecordingFeature_Video': 1,
        'RecordingFeature_Audio': 2,
        'RecordingAudioCodec_None': 0,
        'RecordingAudioCodec_WavPCM': 1,
        'RecordingAudioCodec_Opus': 2,
        'RecordingVideoCodec_None': 0,
        'RecordingVideoCodec_VP8': 1,
        'RecordingVideoCodec_VP9': 2,
        'RecordingVideoCodec_AV1': 3,
        'RecordingVideoScalingMethod_None': 0,
        'RecordingVideoScalingMethod_NearestNeighbor': 1,
        'RecordingVideoScalingMethod_Bilinear': 2,
        'RecordingVideoScalingMethod_Bicubic': 3,
        'RecordingVideoRateControlMode_CBR': 0,
        'RecordingVideoRateControlMode_VBR': 1,
        'GraphicsControllerType_Null': 0,
        'GraphicsControllerType_VBoxVGA': 1,
        'GraphicsControllerType_VMSVGA': 2,
        'GraphicsControllerType_VBoxSVGA': 3,
        'CleanupMode_UnregisterOnly': 1,
        'CleanupMode_DetachAllReturnNone': 2,
        'CleanupMode_DetachAllReturnHardDisksOnly': 3,
        'CleanupMode_Full': 4,
        'CloneMode_MachineState': 1,
        'CloneMode_MachineAndChildStates': 2,
        'CloneMode_AllStates': 3,
        'CloneOptions_Link': 1,
        'CloneOptions_KeepAllMACs': 2,
        'CloneOptions_KeepNATMACs': 3,
        'CloneOptions_KeepDiskNames': 4,
        'CloneOptions_KeepHwUUIDs': 5,
        'AutostopType_Disabled': 1,
        'AutostopType_SaveState': 2,
        'AutostopType_PowerOff': 3,
        'AutostopType_AcpiShutdown': 4,
        'VMProcPriority_Invalid': 0,
        'VMProcPriority_Default': 1,
        'VMProcPriority_Flat': 2,
        'VMProcPriority_Low': 3,
        'VMProcPriority_Normal': 5,
        'VMProcPriority_High': 6,
        'HostNetworkInterfaceMediumType_Unknown': 0,
        'HostNetworkInterfaceMediumType_Ethernet': 1,
        'HostNetworkInterfaceMediumType_PPP': 2,
        'HostNetworkInterfaceMediumType_SLIP': 3,
        'HostNetworkInterfaceStatus_Unknown': 0,
        'HostNetworkInterfaceStatus_Up': 1,
        'HostNetworkInterfaceStatus_Down': 2,
        'HostNetworkInterfaceType_Bridged': 1,
        'HostNetworkInterfaceType_HostOnly': 2,
        'ProxyMode_System': 0,
        'ProxyMode_NoProxy': 1,
        'ProxyMode_Manual': 2,
        'AdditionsFacilityType_None': 0,
        'AdditionsFacilityType_VBoxGuestDriver': 20,
        'AdditionsFacilityType_AutoLogon': 90,
        'AdditionsFacilityType_VBoxService': 100,
        'AdditionsFacilityType_VBoxTrayClient': 101,
        'AdditionsFacilityType_Seamless': 1000,
        'AdditionsFacilityType_Graphics': 1100,
        'AdditionsFacilityType_MonitorAttach': 1101,
        'AdditionsFacilityType_All': 2147483646,
        'AdditionsFacilityClass_None': 0,
        'AdditionsFacilityClass_Driver': 10,
        'AdditionsFacilityClass_Service': 30,
        'AdditionsFacilityClass_Program': 50,
        'AdditionsFacilityClass_Feature': 100,
        'AdditionsFacilityClass_ThirdParty': 999,
        'AdditionsFacilityClass_All': 2147483646,
        'AdditionsFacilityStatus_Inactive': 0,
        'AdditionsFacilityStatus_Paused': 1,
        'AdditionsFacilityStatus_PreInit': 20,
        'AdditionsFacilityStatus_Init': 30,
        'AdditionsFacilityStatus_Active': 50,
        'AdditionsFacilityStatus_Terminating': 100,
        'AdditionsFacilityStatus_Terminated': 101,
        'AdditionsFacilityStatus_Failed': 800,
        'AdditionsFacilityStatus_Unknown': 999,
        'AdditionsRunLevelType_None': 0,
        'AdditionsRunLevelType_System': 1,
        'AdditionsRunLevelType_Userland': 2,
        'AdditionsRunLevelType_Desktop': 3,
        'AdditionsUpdateFlag_None': 0,
        'AdditionsUpdateFlag_WaitForUpdateStartOnly': 1,
        'GuestSessionStatus_Undefined': 0,
        'GuestSessionStatus_Starting': 10,
        'GuestSessionStatus_Started': 100,
        'GuestSessionStatus_Terminating': 480,
        'GuestSessionStatus_Terminated': 500,
        'GuestSessionStatus_TimedOutKilled': 512,
        'GuestSessionStatus_TimedOutAbnormally': 513,
        'GuestSessionStatus_Down': 600,
        'GuestSessionStatus_Error': 800,
        'GuestSessionWaitForFlag_None': 0,
        'GuestSessionWaitForFlag_Start': 1,
        'GuestSessionWaitForFlag_Terminate': 2,
        'GuestSessionWaitForFlag_Status': 4,
        'GuestSessionWaitResult_None': 0,
        'GuestSessionWaitResult_Start': 1,
        'GuestSessionWaitResult_Terminate': 2,
        'GuestSessionWaitResult_Status': 3,
        'GuestSessionWaitResult_Error': 4,
        'GuestSessionWaitResult_Timeout': 5,
        'GuestSessionWaitResult_WaitFlagNotSupported': 6,
        'GuestUserState_Unknown': 0,
        'GuestUserState_LoggedIn': 1,
        'GuestUserState_LoggedOut': 2,
        'GuestUserState_Locked': 3,
        'GuestUserState_Unlocked': 4,
        'GuestUserState_Disabled': 5,
        'GuestUserState_Idle': 6,
        'GuestUserState_InUse': 7,
        'GuestUserState_Created': 8,
        'GuestUserState_Deleted': 9,
        'GuestUserState_SessionChanged': 10,
        'GuestUserState_CredentialsChanged': 11,
        'GuestUserState_RoleChanged': 12,
        'GuestUserState_GroupAdded': 13,
        'GuestUserState_GroupRemoved': 14,
        'GuestUserState_Elevated': 15,
        'FileSeekOrigin_Begin': 0,
        'FileSeekOrigin_Current': 1,
        'FileSeekOrigin_End': 2,
        'ProcessInputFlag_None': 0,
        'ProcessInputFlag_EndOfFile': 1,
        'ProcessOutputFlag_None': 0,
        'ProcessOutputFlag_StdErr': 1,
        'ProcessWaitForFlag_None': 0,
        'ProcessWaitForFlag_Start': 1,
        'ProcessWaitForFlag_Terminate': 2,
        'ProcessWaitForFlag_StdIn': 4,
        'ProcessWaitForFlag_StdOut': 8,
        'ProcessWaitForFlag_StdErr': 16,
        'ProcessWaitResult_None': 0,
        'ProcessWaitResult_Start': 1,
        'ProcessWaitResult_Terminate': 2,
        'ProcessWaitResult_Status': 3,
        'ProcessWaitResult_Error': 4,
        'ProcessWaitResult_Timeout': 5,
        'ProcessWaitResult_StdIn': 6,
        'ProcessWaitResult_StdOut': 7,
        'ProcessWaitResult_StdErr': 8,
        'ProcessWaitResult_WaitFlagNotSupported': 9,
        'FileCopyFlag_None': 0,
        'FileCopyFlag_NoReplace': 1,
        'FileCopyFlag_FollowLinks': 2,
        'FileCopyFlag_Update': 4,
        'FsObjMoveFlag_None': 0,
        'FsObjMoveFlag_Replace': 1,
        'FsObjMoveFlag_FollowLinks': 2,
        'FsObjMoveFlag_AllowDirectoryMoves': 4,
        'DirectoryCreateFlag_None': 0,
        'DirectoryCreateFlag_Parents': 1,
        'DirectoryCopyFlag_None': 0,
        'DirectoryCopyFlag_CopyIntoExisting': 1,
        'DirectoryRemoveRecFlag_None': 0,
        'DirectoryRemoveRecFlag_ContentAndDir': 1,
        'DirectoryRemoveRecFlag_ContentOnly': 2,
        'FsObjRenameFlag_NoReplace': 0,
        'FsObjRenameFlag_Replace': 1,
        'ProcessCreateFlag_None': 0,
        'ProcessCreateFlag_WaitForProcessStartOnly': 1,
        'ProcessCreateFlag_IgnoreOrphanedProcesses': 2,
        'ProcessCreateFlag_Hidden': 4,
        'ProcessCreateFlag_Profile': 8,
        'ProcessCreateFlag_WaitForStdOut': 16,
        'ProcessCreateFlag_WaitForStdErr': 32,
        'ProcessCreateFlag_ExpandArguments': 64,
        'ProcessCreateFlag_UnquotedArguments': 128,
        'ProcessPriority_Invalid': 0,
        'ProcessPriority_Default': 1,
        'SymlinkType_Unknown': 0,
        'SymlinkType_Directory': 1,
        'SymlinkType_File': 2,
        'SymlinkReadFlag_None': 0,
        'SymlinkReadFlag_NoSymlinks': 1,
        'ProcessStatus_Undefined': 0,
        'ProcessStatus_Starting': 10,
        'ProcessStatus_Started': 100,
        'ProcessStatus_Paused': 110,
        'ProcessStatus_Terminating': 480,
        'ProcessStatus_TerminatedNormally': 500,
        'ProcessStatus_TerminatedSignal': 510,
        'ProcessStatus_TerminatedAbnormally': 511,
        'ProcessStatus_TimedOutKilled': 512,
        'ProcessStatus_TimedOutAbnormally': 513,
        'ProcessStatus_Down': 600,
        'ProcessStatus_Error': 800,
        'ProcessInputStatus_Undefined': 0,
        'ProcessInputStatus_Broken': 1,
        'ProcessInputStatus_Available': 10,
        'ProcessInputStatus_Written': 50,
        'ProcessInputStatus_Overflow': 100,
        'PathStyle_DOS': 1,
        'PathStyle_UNIX': 2,
        'PathStyle_Unknown': 8,
        'FileAccessMode_ReadOnly': 1,
        'FileAccessMode_WriteOnly': 2,
        'FileAccessMode_ReadWrite': 3,
        'FileAccessMode_AppendOnly': 4,
        'FileAccessMode_AppendRead': 5,
        'FileOpenAction_OpenExisting': 1,
        'FileOpenAction_OpenOrCreate': 2,
        'FileOpenAction_CreateNew': 3,
        'FileOpenAction_CreateOrReplace': 4,
        'FileOpenAction_OpenExistingTruncated': 5,
        'FileOpenAction_AppendOrCreate': 99,
        'FileSharingMode_Read': 1,
        'FileSharingMode_Write': 2,
        'FileSharingMode_ReadWrite': 3,
        'FileSharingMode_Delete': 4,
        'FileSharingMode_ReadDelete': 5,
        'FileSharingMode_WriteDelete': 6,
        'FileSharingMode_All': 7,
        'FileOpenExFlag_None': 0,
        'FileStatus_Undefined': 0,
        'FileStatus_Opening': 10,
        'FileStatus_Open': 100,
        'FileStatus_Closing': 150,
        'FileStatus_Closed': 200,
        'FileStatus_Down': 600,
        'FileStatus_Error': 800,
        'FsObjType_Unknown': 1,
        'FsObjType_Fifo': 2,
        'FsObjType_DevChar': 3,
        'FsObjType_Directory': 4,
        'FsObjType_DevBlock': 5,
        'FsObjType_File': 6,
        'FsObjType_Symlink': 7,
        'FsObjType_Socket': 8,
        'FsObjType_WhiteOut': 9,
        'DnDAction_Ignore': 0,
        'DnDAction_Copy': 1,
        'DnDAction_Move': 2,
        'DnDAction_Link': 3,
        'DirectoryOpenFlag_None': 0,
        'DirectoryOpenFlag_NoSymlinks': 1,
        'MediumState_NotCreated': 0,
        'MediumState_Created': 1,
        'MediumState_LockedRead': 2,
        'MediumState_LockedWrite': 3,
        'MediumState_Inaccessible': 4,
        'MediumState_Creating': 5,
        'MediumState_Deleting': 6,
        'MediumType_Normal': 0,
        'MediumType_Immutable': 1,
        'MediumType_Writethrough': 2,
        'MediumType_Shareable': 3,
        'MediumType_Readonly': 4,
        'MediumType_MultiAttach': 5,
        'MediumVariant_Standard': 0,
        'MediumVariant_VmdkSplit2G': 0x01,
        'MediumVariant_VmdkRawDisk': 0x02,
        'MediumVariant_VmdkStreamOptimized': 0x04,
        'MediumVariant_VmdkESX': 0x08,
        'MediumVariant_VdiZeroExpand': 0x100,
        'MediumVariant_Fixed': 0x10000,
        'MediumVariant_Diff': 0x20000,
        'MediumVariant_Formatted': 0x20000000,
        'MediumVariant_NoCreateDir': 0x40000000,
        'DataType_Int32': 0,
        'DataType_Int8': 1,
        'DataType_String': 2,
        'DataFlags_None': 0x00,
        'DataFlags_Mandatory': 0x01,
        'DataFlags_Expert': 0x02,
        'DataFlags_Array': 0x04,
        'DataFlags_FlagMask': 0x07,
        'MediumFormatCapabilities_Uuid': 0x01,
        'MediumFormatCapabilities_CreateFixed': 0x02,
        'MediumFormatCapabilities_CreateDynamic': 0x04,
        'MediumFormatCapabilities_CreateSplit2G': 0x08,
        'MediumFormatCapabilities_Differencing': 0x10,
        'MediumFormatCapabilities_Asynchronous': 0x20,
        'MediumFormatCapabilities_File': 0x40,
        'MediumFormatCapabilities_Properties': 0x80,
        'MediumFormatCapabilities_TcpNetworking': 0x100,
        'MediumFormatCapabilities_VFS': 0x200,
        'MediumFormatCapabilities_Discard': 0x400,
        'MediumFormatCapabilities_Preferred': 0x800,
        'MediumFormatCapabilities_CapabilityMask': 0xFFF,
        'PartitionTableType_MBR': 1,
        'PartitionTableType_GPT': 2,
        'KeyboardLED_NumLock': 0x01,
        'KeyboardLED_CapsLock': 0x02,
        'KeyboardLED_ScrollLock': 0x04,
        'MouseButtonState_LeftButton': 0x01,
        'MouseButtonState_RightButton': 0x02,
        'MouseButtonState_MiddleButton': 0x04,
        'MouseButtonState_WheelUp': 0x08,
        'MouseButtonState_WheelDown': 0x10,
        'MouseButtonState_XButton1': 0x20,
        'MouseButtonState_XButton2': 0x40,
        'MouseButtonState_MouseStateMask': 0x7F,
        'TouchContactState_None': 0x00,
        'TouchContactState_InContact': 0x01,
        'TouchContactState_InRange': 0x02,
        'TouchContactState_ContactStateMask': 0x03,
        'FramebufferCapabilities_UpdateImage': 0x01,
        'FramebufferCapabilities_VHWA': 0x02,
        'FramebufferCapabilities_VisibleRegion': 0x04,
        'FramebufferCapabilities_RenderCursor': 0x08,
        'FramebufferCapabilities_MoveCursor': 0x10,
        'GuestMonitorStatus_Disabled': 0,
        'GuestMonitorStatus_Enabled': 1,
        'GuestMonitorStatus_Blank': 2,
        'ScreenLayoutMode_Apply': 0,
        'ScreenLayoutMode_Reset': 1,
        'ScreenLayoutMode_Attach': 2,
        'ScreenLayoutMode_Silent': 3,
        'NetworkAttachmentType_Null': 0,
        'NetworkAttachmentType_NAT': 1,
        'NetworkAttachmentType_Bridged': 2,
        'NetworkAttachmentType_Internal': 3,
        'NetworkAttachmentType_HostOnly': 4,
        'NetworkAttachmentType_Generic': 5,
        'NetworkAttachmentType_NATNetwork': 6,
        'NetworkAttachmentType_Cloud': 7,
        'NetworkAdapterType_Null': 0,
        'NetworkAdapterType_Am79C970A': 1,
        'NetworkAdapterType_Am79C973': 2,
        'NetworkAdapterType_I82540EM': 3,
        'NetworkAdapterType_I82543GC': 4,
        'NetworkAdapterType_I82545EM': 5,
        'NetworkAdapterType_Virtio': 6,
        'NetworkAdapterType_Am79C960': 7,
        'NetworkAdapterType_Virtio_1_0': 8,
        'NetworkAdapterPromiscModePolicy_Deny': 1,
        'NetworkAdapterPromiscModePolicy_AllowNetwork': 2,
        'NetworkAdapterPromiscModePolicy_AllowAll': 3,
        'PortMode_Disconnected': 0,
        'PortMode_HostPipe': 1,
        'PortMode_HostDevice': 2,
        'PortMode_RawFile': 3,
        'PortMode_TCP': 4,
        'UartType_U16450': 0,
        'UartType_U16550A': 1,
        'UartType_U16750': 2,
        'VMExecutionEngine_NotSet': 0,
        'VMExecutionEngine_RawMode': 1,
        'VMExecutionEngine_HwVirt': 2,
        'VMExecutionEngine_NativeApi': 3,
        'USBControllerType_Null': 0,
        'USBControllerType_OHCI': 1,
        'USBControllerType_EHCI': 2,
        'USBControllerType_XHCI': 3,
        'USBControllerType_Last': 4,
        'USBConnectionSpeed_Null': 0,
        'USBConnectionSpeed_Low': 1,
        'USBConnectionSpeed_Full': 2,
        'USBConnectionSpeed_High': 3,
        'USBConnectionSpeed_Super': 4,
        'USBConnectionSpeed_SuperPlus': 5,
        'USBDeviceState_NotSupported': 0,
        'USBDeviceState_Unavailable': 1,
        'USBDeviceState_Busy': 2,
        'USBDeviceState_Available': 3,
        'USBDeviceState_Held': 4,
        'USBDeviceState_Captured': 5,
        'USBDeviceFilterAction_Null': 0,
        'USBDeviceFilterAction_Ignore': 1,
        'USBDeviceFilterAction_Hold': 2,
        'AudioDriverType_Null': 0,
        'AudioDriverType_WinMM': 1,
        'AudioDriverType_OSS': 2,
        'AudioDriverType_ALSA': 3,
        'AudioDriverType_DirectSound': 4,
        'AudioDriverType_CoreAudio': 5,
        'AudioDriverType_MMPM': 6,
        'AudioDriverType_Pulse': 7,
        'AudioDriverType_SolAudio': 8,
        'AudioControllerType_AC97': 0,
        'AudioControllerType_SB16': 1,
        'AudioControllerType_HDA': 2,
        'AudioCodecType_Null': 0,
        'AudioCodecType_SB16': 1,
        'AudioCodecType_STAC9700': 2,
        'AudioCodecType_AD1980': 3,
        'AudioCodecType_STAC9221': 4,
        'AuthType_Null': 0,
        'AuthType_External': 1,
        'AuthType_Guest': 2,
        'Reason_Unspecified': 0,
        'Reason_HostSuspend': 1,
        'Reason_HostResume': 2,
        'Reason_HostBatteryLow': 3,
        'Reason_Snapshot': 4,
        'StorageBus_Null': 0,
        'StorageBus_IDE': 1,
        'StorageBus_SATA': 2,
        'StorageBus_SCSI': 3,
        'StorageBus_Floppy': 4,
        'StorageBus_SAS': 5,
        'StorageBus_USB': 6,
        'StorageBus_PCIe': 7,
        'StorageBus_VirtioSCSI': 8,
        'StorageControllerType_Null': 0,
        'StorageControllerType_LsiLogic': 1,
        'StorageControllerType_BusLogic': 2,
        'StorageControllerType_IntelAhci': 3,
        'StorageControllerType_PIIX3': 4,
        'StorageControllerType_PIIX4': 5,
        'StorageControllerType_ICH6': 6,
        'StorageControllerType_I82078': 7,
        'StorageControllerType_LsiLogicSas': 8,
        'StorageControllerType_USB': 9,
        'StorageControllerType_NVMe': 10,
        'StorageControllerType_VirtioSCSI': 11,
        'ChipsetType_Null': 0,
        'ChipsetType_PIIX3': 1,
        'ChipsetType_ICH9': 2,
        'NATAliasMode_AliasLog': 0x1,
        'NATAliasMode_AliasProxyOnly': 0x02,
        'NATAliasMode_AliasUseSamePorts': 0x04,
        'NATProtocol_UDP': 0,
        'NATProtocol_TCP': 1,
        'BandwidthGroupType_Null': 0,
        'BandwidthGroupType_Disk': 1,
        'BandwidthGroupType_Network': 2,
        'VBoxEventType_Invalid': 0,
        'VBoxEventType_Any': 1,
        'VBoxEventType_Vetoable': 2,
        'VBoxEventType_MachineEvent': 3,
        'VBoxEventType_SnapshotEvent': 4,
        'VBoxEventType_InputEvent': 5,
        'VBoxEventType_LastWildcard': 31,
        'VBoxEventType_OnMachineStateChanged': 32,
        'VBoxEventType_OnMachineDataChanged': 33,
        'VBoxEventType_OnExtraDataChanged': 34,
        'VBoxEventType_OnExtraDataCanChange': 35,
        'VBoxEventType_OnMediumRegistered': 36,
        'VBoxEventType_OnMachineRegistered': 37,
        'VBoxEventType_OnSessionStateChanged': 38,
        'VBoxEventType_OnSnapshotTaken': 39,
        'VBoxEventType_OnSnapshotDeleted': 40,
        'VBoxEventType_OnSnapshotChanged': 41,
        'VBoxEventType_OnGuestPropertyChanged': 42,
        'VBoxEventType_OnMousePointerShapeChanged': 43,
        'VBoxEventType_OnMouseCapabilityChanged': 44,
        'VBoxEventType_OnKeyboardLedsChanged': 45,
        'VBoxEventType_OnStateChanged': 46,
        'VBoxEventType_OnAdditionsStateChanged': 47,
        'VBoxEventType_OnNetworkAdapterChanged': 48,
        'VBoxEventType_OnSerialPortChanged': 49,
        'VBoxEventType_OnParallelPortChanged': 50,
        'VBoxEventType_OnStorageControllerChanged': 51,
        'VBoxEventType_OnMediumChanged': 52,
        'VBoxEventType_OnVRDEServerChanged': 53,
        'VBoxEventType_OnUSBControllerChanged': 54,
        'VBoxEventType_OnUSBDeviceStateChanged': 55,
        'VBoxEventType_OnSharedFolderChanged': 56,
        'VBoxEventType_OnRuntimeError': 57,
        'VBoxEventType_OnCanShowWindow': 58,
        'VBoxEventType_OnShowWindow': 59,
        'VBoxEventType_OnCPUChanged': 60,
        'VBoxEventType_OnVRDEServerInfoChanged': 61,
        'VBoxEventType_OnEventSourceChanged': 62,
        'VBoxEventType_OnCPUExecutionCapChanged': 63,
        'VBoxEventType_OnGuestKeyboard': 64,
        'VBoxEventType_OnGuestMouse': 65,
        'VBoxEventType_OnNATRedirect': 66,
        'VBoxEventType_OnHostPCIDevicePlug': 67,
        'VBoxEventType_OnVBoxSVCAvailabilityChanged': 68,
        'VBoxEventType_OnBandwidthGroupChanged': 69,
        'VBoxEventType_OnGuestMonitorChanged': 70,
        'VBoxEventType_OnStorageDeviceChanged': 71,
        'VBoxEventType_OnClipboardModeChanged': 72,
        'VBoxEventType_OnDnDModeChanged': 73,
        'VBoxEventType_OnNATNetworkChanged': 74,
        'VBoxEventType_OnNATNetworkStartStop': 75,
        'VBoxEventType_OnNATNetworkAlter': 76,
        'VBoxEventType_OnNATNetworkCreationDeletion': 77,
        'VBoxEventType_OnNATNetworkSetting': 78,
        'VBoxEventType_OnNATNetworkPortForward': 79,
        'VBoxEventType_OnGuestSessionStateChanged': 80,
        'VBoxEventType_OnGuestSessionRegistered': 81,
        'VBoxEventType_OnGuestProcessRegistered': 82,
        'VBoxEventType_OnGuestProcessStateChanged': 83,
        'VBoxEventType_OnGuestProcessInputNotify': 84,
        'VBoxEventType_OnGuestProcessOutput': 85,
        'VBoxEventType_OnGuestFileRegistered': 86,
        'VBoxEventType_OnGuestFileStateChanged': 87,
        'VBoxEventType_OnGuestFileOffsetChanged': 88,
        'VBoxEventType_OnGuestFileRead': 89,
        'VBoxEventType_OnGuestFileWrite': 90,
        'VBoxEventType_OnRecordingChanged': 91,
        'VBoxEventType_OnGuestUserStateChanged': 92,
        'VBoxEventType_OnGuestMultiTouch': 93,
        'VBoxEventType_OnHostNameResolutionConfigurationChange': 94,
        'VBoxEventType_OnSnapshotRestored': 95,
        'VBoxEventType_OnMediumConfigChanged': 96,
        'VBoxEventType_OnAudioAdapterChanged': 97,
        'VBoxEventType_OnProgressPercentageChanged': 98,
        'VBoxEventType_OnProgressTaskCompleted': 99,
        'VBoxEventType_OnCursorPositionChanged': 100,
        'VBoxEventType_OnGuestAdditionsStatusChanged': 101,
        'VBoxEventType_OnGuestMonitorInfoChanged': 102,
        'VBoxEventType_OnGuestFileSizeChanged': 103,
        'VBoxEventType_OnClipboardFileTransferModeChanged': 104,
        'VBoxEventType_Last': 105,
        'GuestMouseEventMode_Relative': 0,
        'GuestMouseEventMode_Absolute': 1,
        'GuestMonitorChangedEventType_Enabled': 0,
        'GuestMonitorChangedEventType_Disabled': 1,
        'GuestMonitorChangedEventType_NewOrigin': 2,
        'FormValueType_Boolean': 0,
        'FormValueType_String': 1,
        'FormValueType_Choice': 2,
        'FormValueType_RangedInteger': 3,
        'CloudMachineState_Invalid': 0,
        'CloudMachineState_Provisioning': 1,
        'CloudMachineState_Running': 2,
        'CloudMachineState_Starting': 3,
        'CloudMachineState_Stopping': 4,
        'CloudMachineState_Stopped': 5,
        'CloudMachineState_CreatingImage': 6,
        'CloudMachineState_Terminating': 7,
        'CloudMachineState_Terminated': 8,
        'CloudImageState_Invalid': 0,
        'CloudImageState_Provisioning': 1,
        'CloudImageState_Importing': 2,
        'CloudImageState_Available': 3,
        'CloudImageState_Exporting': 4,
        'CloudImageState_Disabled': 5,
        'CloudImageState_Deleted': 6,
        # Result constants:
        'VBOX_E_OBJECT_NOT_FOUND': 0x80BB0001,
        'VBOX_E_INVALID_VM_STATE': 0x80BB0002,
        'VBOX_E_VM_ERROR': 0x80BB0003,
        'VBOX_E_FILE_ERROR': 0x80BB0004,
        'VBOX_E_IPRT_ERROR': 0x80BB0005,
        'VBOX_E_PDM_ERROR': 0x80BB0006,
        'VBOX_E_INVALID_OBJECT_STATE': 0x80BB0007,
        'VBOX_E_HOST_ERROR': 0x80BB0008,
        'VBOX_E_NOT_SUPPORTED': 0x80BB0009,
        'VBOX_E_XML_ERROR': 0x80BB000A,
        'VBOX_E_INVALID_SESSION_STATE': 0x80BB000B,
        'VBOX_E_OBJECT_IN_USE': 0x80BB000C,
        'VBOX_E_PASSWORD_INCORRECT': 0x80BB000D,
        'VBOX_E_MAXIMUM_REACHED': 0x80BB000E,
        'VBOX_E_GSTCTL_GUEST_ERROR': 0x80BB000F,
        'VBOX_E_TIMEOUT': 0x80BB0010,
    }, **__dVBoxStatuses)

    __dValuesFlatSym = {
        'SettingsVersion_Null': 'Null',
        'SettingsVersion_v1_0': 'v1_0',
        'SettingsVersion_v1_1': 'v1_1',
        'SettingsVersion_v1_2': 'v1_2',
        'SettingsVersion_v1_3pre': 'v1_3pre',
        'SettingsVersion_v1_3': 'v1_3',
        'SettingsVersion_v1_4': 'v1_4',
        'SettingsVersion_v1_5': 'v1_5',
        'SettingsVersion_v1_6': 'v1_6',
        'SettingsVersion_v1_7': 'v1_7',
        'SettingsVersion_v1_8': 'v1_8',
        'SettingsVersion_v1_9': 'v1_9',
        'SettingsVersion_v1_10': 'v1_10',
        'SettingsVersion_v1_11': 'v1_11',
        'SettingsVersion_v1_12': 'v1_12',
        'SettingsVersion_v1_13': 'v1_13',
        'SettingsVersion_v1_14': 'v1_14',
        'SettingsVersion_v1_15': 'v1_15',
        'SettingsVersion_v1_16': 'v1_16',
        'SettingsVersion_v1_17': 'v1_17',
        'SettingsVersion_v1_18': 'v1_18',
        'SettingsVersion_Future': 'Future',
        'AccessMode_ReadOnly': 'ReadOnly',
        'AccessMode_ReadWrite': 'ReadWrite',
        'MachineState_Null': 'Null',
        'MachineState_PoweredOff': 'PoweredOff',
        'MachineState_Saved': 'Saved',
        'MachineState_Teleported': 'Teleported',
        'MachineState_Aborted': 'Aborted',
        'MachineState_Running': 'Running',
        'MachineState_Paused': 'Paused',
        'MachineState_Stuck': 'Stuck',
        'MachineState_Teleporting': 'Teleporting',
        'MachineState_LiveSnapshotting': 'LiveSnapshotting',
        'MachineState_Starting': 'Starting',
        'MachineState_Stopping': 'Stopping',
        'MachineState_Saving': 'Saving',
        'MachineState_Restoring': 'Restoring',
        'MachineState_TeleportingPausedVM': 'TeleportingPausedVM',
        'MachineState_TeleportingIn': 'TeleportingIn',
        'MachineState_DeletingSnapshotOnline': 'DeletingSnapshotOnline',
        'MachineState_DeletingSnapshotPaused': 'DeletingSnapshotPaused',
        'MachineState_OnlineSnapshotting': 'OnlineSnapshotting',
        'MachineState_RestoringSnapshot': 'RestoringSnapshot',
        'MachineState_DeletingSnapshot': 'DeletingSnapshot',
        'MachineState_SettingUp': 'SettingUp',
        'MachineState_Snapshotting': 'Snapshotting',
        'MachineState_FirstOnline': 'FirstOnline',
        'MachineState_LastOnline': 'LastOnline',
        'MachineState_FirstTransient': 'FirstTransient',
        'MachineState_LastTransient': 'LastTransient',
        'SessionState_Null': 'Null',
        'SessionState_Unlocked': 'Unlocked',
        'SessionState_Locked': 'Locked',
        'SessionState_Spawning': 'Spawning',
        'SessionState_Unlocking': 'Unlocking',
        'CPUPropertyType_Null': 'Null',
        'CPUPropertyType_PAE': 'PAE',
        'CPUPropertyType_LongMode': 'LongMode',
        'CPUPropertyType_TripleFaultReset': 'TripleFaultReset',
        'CPUPropertyType_APIC': 'APIC',
        'CPUPropertyType_X2APIC': 'X2APIC',
        'CPUPropertyType_IBPBOnVMExit': 'IBPBOnVMExit',
        'CPUPropertyType_IBPBOnVMEntry': 'IBPBOnVMEntry',
        'CPUPropertyType_HWVirt': 'HWVirt',
        'CPUPropertyType_SpecCtrl': 'SpecCtrl',
        'CPUPropertyType_SpecCtrlByHost': 'SpecCtrlByHost',
        'CPUPropertyType_L1DFlushOnEMTScheduling': 'L1DFlushOnEMTScheduling',
        'CPUPropertyType_L1DFlushOnVMEntry': 'L1DFlushOnVMEntry',
        'CPUPropertyType_MDSClearOnEMTScheduling': 'MDSClearOnEMTScheduling',
        'CPUPropertyType_MDSClearOnVMEntry': 'MDSClearOnVMEntry',
        'HWVirtExPropertyType_Null': 'Null',
        'HWVirtExPropertyType_Enabled': 'Enabled',
        'HWVirtExPropertyType_VPID': 'VPID',
        'HWVirtExPropertyType_NestedPaging': 'NestedPaging',
        'HWVirtExPropertyType_UnrestrictedExecution': 'UnrestrictedExecution',
        'HWVirtExPropertyType_LargePages': 'LargePages',
        'HWVirtExPropertyType_Force': 'Force',
        'HWVirtExPropertyType_UseNativeApi': 'UseNativeApi',
        'ParavirtProvider_None': 'None',
        'ParavirtProvider_Default': 'Default',
        'ParavirtProvider_Legacy': 'Legacy',
        'ParavirtProvider_Minimal': 'Minimal',
        'ParavirtProvider_HyperV': 'HyperV',
        'ParavirtProvider_KVM': 'KVM',
        'LockType_Null': 'Null',
        'LockType_Shared': 'Shared',
        'LockType_Write': 'Write',
        'LockType_VM': 'VM',
        'SessionType_Null': 'Null',
        'SessionType_WriteLock': 'WriteLock',
        'SessionType_Remote': 'Remote',
        'SessionType_Shared': 'Shared',
        'DeviceType_Null': 'Null',
        'DeviceType_Floppy': 'Floppy',
        'DeviceType_DVD': 'DVD',
        'DeviceType_HardDisk': 'HardDisk',
        'DeviceType_Network': 'Network',
        'DeviceType_USB': 'USB',
        'DeviceType_SharedFolder': 'SharedFolder',
        'DeviceType_Graphics3D': 'Graphics3D',
        'DeviceActivity_Null': 'Null',
        'DeviceActivity_Idle': 'Idle',
        'DeviceActivity_Reading': 'Reading',
        'DeviceActivity_Writing': 'Writing',
        'ClipboardMode_Disabled': 'Disabled',
        'ClipboardMode_HostToGuest': 'HostToGuest',
        'ClipboardMode_GuestToHost': 'GuestToHost',
        'ClipboardMode_Bidirectional': 'Bidirectional',
        'DnDMode_Disabled': 'Disabled',
        'DnDMode_HostToGuest': 'HostToGuest',
        'DnDMode_GuestToHost': 'GuestToHost',
        'DnDMode_Bidirectional': 'Bidirectional',
        'Scope_Global': 'Global',
        'Scope_Machine': 'Machine',
        'Scope_Session': 'Session',
        'BIOSBootMenuMode_Disabled': 'Disabled',
        'BIOSBootMenuMode_MenuOnly': 'MenuOnly',
        'BIOSBootMenuMode_MessageAndMenu': 'MessageAndMenu',
        'APICMode_Disabled': 'Disabled',
        'APICMode_APIC': 'APIC',
        'APICMode_X2APIC': 'X2APIC',
        'ProcessorFeature_HWVirtEx': 'HWVirtEx',
        'ProcessorFeature_PAE': 'PAE',
        'ProcessorFeature_LongMode': 'LongMode',
        'ProcessorFeature_NestedPaging': 'NestedPaging',
        'ProcessorFeature_UnrestrictedGuest': 'UnrestrictedGuest',
        'ProcessorFeature_NestedHWVirt': 'NestedHWVirt',
        'FirmwareType_BIOS': 'BIOS',
        'FirmwareType_EFI': 'EFI',
        'FirmwareType_EFI32': 'EFI32',
        'FirmwareType_EFI64': 'EFI64',
        'FirmwareType_EFIDUAL': 'EFIDUAL',
        'PointingHIDType_None': 'None',
        'PointingHIDType_PS2Mouse': 'PS2Mouse',
        'PointingHIDType_USBMouse': 'USBMouse',
        'PointingHIDType_USBTablet': 'USBTablet',
        'PointingHIDType_ComboMouse': 'ComboMouse',
        'PointingHIDType_USBMultiTouch': 'USBMultiTouch',
        'KeyboardHIDType_None': 'None',
        'KeyboardHIDType_PS2Keyboard': 'PS2Keyboard',
        'KeyboardHIDType_USBKeyboard': 'USBKeyboard',
        'KeyboardHIDType_ComboKeyboard': 'ComboKeyboard',
        'BitmapFormat_Opaque': 'Opaque',
        'BitmapFormat_BGR': 'BGR',
        'BitmapFormat_BGR0': 'BGR0',
        'BitmapFormat_BGRA': 'BGRA',
        'BitmapFormat_RGBA': 'RGBA',
        'BitmapFormat_PNG': 'PNG',
        'BitmapFormat_JPEG': 'JPEG',
        'DHCPOption_SubnetMask': 'SubnetMask',
        'DHCPOption_TimeOffset': 'TimeOffset',
        'DHCPOption_Routers': 'Routers',
        'DHCPOption_TimeServers': 'TimeServers',
        'DHCPOption_NameServers': 'NameServers',
        'DHCPOption_DomainNameServers': 'DomainNameServers',
        'DHCPOption_LogServers': 'LogServers',
        'DHCPOption_CookieServers': 'CookieServers',
        'DHCPOption_LPRServers': 'LPRServers',
        'DHCPOption_ImpressServers': 'ImpressServers',
        'DHCPOption_ResourseLocationServers': 'ResourseLocationServers',
        'DHCPOption_HostName': 'HostName',
        'DHCPOption_BootFileSize': 'BootFileSize',
        'DHCPOption_MeritDumpFile': 'MeritDumpFile',
        'DHCPOption_DomainName': 'DomainName',
        'DHCPOption_SwapServer': 'SwapServer',
        'DHCPOption_RootPath': 'RootPath',
        'DHCPOption_ExtensionPath': 'ExtensionPath',
        'DHCPOption_IPForwarding': 'IPForwarding',
        'DHCPOption_OptNonLocalSourceRouting': 'OptNonLocalSourceRouting',
        'DHCPOption_PolicyFilter': 'PolicyFilter',
        'DHCPOption_MaxDgramReassemblySize': 'MaxDgramReassemblySize',
        'DHCPOption_DefaultIPTTL': 'DefaultIPTTL',
        'DHCPOption_PathMTUAgingTimeout': 'PathMTUAgingTimeout',
        'DHCPOption_PathMTUPlateauTable': 'PathMTUPlateauTable',
        'DHCPOption_InterfaceMTU': 'InterfaceMTU',
        'DHCPOption_AllSubnetsAreLocal': 'AllSubnetsAreLocal',
        'DHCPOption_BroadcastAddress': 'BroadcastAddress',
        'DHCPOption_PerformMaskDiscovery': 'PerformMaskDiscovery',
        'DHCPOption_MaskSupplier': 'MaskSupplier',
        'DHCPOption_PerformRouterDiscovery': 'PerformRouterDiscovery',
        'DHCPOption_RouterSolicitationAddress': 'RouterSolicitationAddress',
        'DHCPOption_StaticRoute': 'StaticRoute',
        'DHCPOption_TrailerEncapsulation': 'TrailerEncapsulation',
        'DHCPOption_ARPCacheTimeout': 'ARPCacheTimeout',
        'DHCPOption_EthernetEncapsulation': 'EthernetEncapsulation',
        'DHCPOption_TCPDefaultTTL': 'TCPDefaultTTL',
        'DHCPOption_TCPKeepaliveInterval': 'TCPKeepaliveInterval',
        'DHCPOption_TCPKeepaliveGarbage': 'TCPKeepaliveGarbage',
        'DHCPOption_NISDomain': 'NISDomain',
        'DHCPOption_NISServers': 'NISServers',
        'DHCPOption_NTPServers': 'NTPServers',
        'DHCPOption_VendorSpecificInfo': 'VendorSpecificInfo',
        'DHCPOption_NetBIOSNameServers': 'NetBIOSNameServers',
        'DHCPOption_NetBIOSDatagramServers': 'NetBIOSDatagramServers',
        'DHCPOption_NetBIOSNodeType': 'NetBIOSNodeType',
        'DHCPOption_NetBIOSScope': 'NetBIOSScope',
        'DHCPOption_XWindowsFontServers': 'XWindowsFontServers',
        'DHCPOption_XWindowsDisplayManager': 'XWindowsDisplayManager',
        'DHCPOption_NetWareIPDomainName': 'NetWareIPDomainName',
        'DHCPOption_NetWareIPInformation': 'NetWareIPInformation',
        'DHCPOption_NISPlusDomain': 'NISPlusDomain',
        'DHCPOption_NISPlusServers': 'NISPlusServers',
        'DHCPOption_TFTPServerName': 'TFTPServerName',
        'DHCPOption_BootfileName': 'BootfileName',
        'DHCPOption_MobileIPHomeAgents': 'MobileIPHomeAgents',
        'DHCPOption_SMTPServers': 'SMTPServers',
        'DHCPOption_POP3Servers': 'POP3Servers',
        'DHCPOption_NNTPServers': 'NNTPServers',
        'DHCPOption_WWWServers': 'WWWServers',
        'DHCPOption_FingerServers': 'FingerServers',
        'DHCPOption_IRCServers': 'IRCServers',
        'DHCPOption_StreetTalkServers': 'StreetTalkServers',
        'DHCPOption_STDAServers': 'STDAServers',
        'DHCPOption_SLPDirectoryAgent': 'SLPDirectoryAgent',
        'DHCPOption_SLPServiceScope': 'SLPServiceScope',
        'DHCPOption_DomainSearch': 'DomainSearch',
        'DHCPOptionEncoding_Normal': 'Normal',
        'DHCPOptionEncoding_Hex': 'Hex',
        'DHCPConfigScope_Global': 'Global',
        'DHCPConfigScope_Group': 'Group',
        'DHCPConfigScope_MachineNIC': 'MachineNIC',
        'DHCPConfigScope_MAC': 'MAC',
        'DHCPGroupConditionType_MAC': 'MAC',
        'DHCPGroupConditionType_MACWildcard': 'MACWildcard',
        'DHCPGroupConditionType_vendorClassID': 'vendorClassID',
        'DHCPGroupConditionType_vendorClassIDWildcard': 'vendorClassIDWildcard',
        'DHCPGroupConditionType_userClassID': 'userClassID',
        'DHCPGroupConditionType_userClassIDWildcard': 'userClassIDWildcard',
        'VFSType_File': 'File',
        'VFSType_Cloud': 'Cloud',
        'VFSType_S3': 'S3',
        'VFSType_WebDav': 'WebDav',
        'ImportOptions_KeepAllMACs': 'KeepAllMACs',
        'ImportOptions_KeepNATMACs': 'KeepNATMACs',
        'ImportOptions_ImportToVDI': 'ImportToVDI',
        'ExportOptions_CreateManifest': 'CreateManifest',
        'ExportOptions_ExportDVDImages': 'ExportDVDImages',
        'ExportOptions_StripAllMACs': 'StripAllMACs',
        'ExportOptions_StripAllNonNATMACs': 'StripAllNonNATMACs',
        'CertificateVersion_V1': 'V1',
        'CertificateVersion_V2': 'V2',
        'CertificateVersion_V3': 'V3',
        'CertificateVersion_Unknown': 'Unknown',
        'VirtualSystemDescriptionType_Ignore': 'Ignore',
        'VirtualSystemDescriptionType_OS': 'OS',
        'VirtualSystemDescriptionType_Name': 'Name',
        'VirtualSystemDescriptionType_Product': 'Product',
        'VirtualSystemDescriptionType_Vendor': 'Vendor',
        'VirtualSystemDescriptionType_Version': 'Version',
        'VirtualSystemDescriptionType_ProductUrl': 'ProductUrl',
        'VirtualSystemDescriptionType_VendorUrl': 'VendorUrl',
        'VirtualSystemDescriptionType_Description': 'Description',
        'VirtualSystemDescriptionType_License': 'License',
        'VirtualSystemDescriptionType_Miscellaneous': 'Miscellaneous',
        'VirtualSystemDescriptionType_CPU': 'CPU',
        'VirtualSystemDescriptionType_Memory': 'Memory',
        'VirtualSystemDescriptionType_HardDiskControllerIDE': 'HardDiskControllerIDE',
        'VirtualSystemDescriptionType_HardDiskControllerSATA': 'HardDiskControllerSATA',
        'VirtualSystemDescriptionType_HardDiskControllerSCSI': 'HardDiskControllerSCSI',
        'VirtualSystemDescriptionType_HardDiskControllerSAS': 'HardDiskControllerSAS',
        'VirtualSystemDescriptionType_HardDiskImage': 'HardDiskImage',
        'VirtualSystemDescriptionType_Floppy': 'Floppy',
        'VirtualSystemDescriptionType_CDROM': 'CDROM',
        'VirtualSystemDescriptionType_NetworkAdapter': 'NetworkAdapter',
        'VirtualSystemDescriptionType_USBController': 'USBController',
        'VirtualSystemDescriptionType_SoundCard': 'SoundCard',
        'VirtualSystemDescriptionType_SettingsFile': 'SettingsFile',
        'VirtualSystemDescriptionType_BaseFolder': 'BaseFolder',
        'VirtualSystemDescriptionType_PrimaryGroup': 'PrimaryGroup',
        'VirtualSystemDescriptionType_CloudInstanceShape': 'CloudInstanceShape',
        'VirtualSystemDescriptionType_CloudDomain': 'CloudDomain',
        'VirtualSystemDescriptionType_CloudBootDiskSize': 'CloudBootDiskSize',
        'VirtualSystemDescriptionType_CloudBucket': 'CloudBucket',
        'VirtualSystemDescriptionType_CloudOCIVCN': 'CloudOCIVCN',
        'VirtualSystemDescriptionType_CloudPublicIP': 'CloudPublicIP',
        'VirtualSystemDescriptionType_CloudProfileName': 'CloudProfileName',
        'VirtualSystemDescriptionType_CloudOCISubnet': 'CloudOCISubnet',
        'VirtualSystemDescriptionType_CloudKeepObject': 'CloudKeepObject',
        'VirtualSystemDescriptionType_CloudLaunchInstance': 'CloudLaunchInstance',
        'VirtualSystemDescriptionType_CloudInstanceId': 'CloudInstanceId',
        'VirtualSystemDescriptionType_CloudImageId': 'CloudImageId',
        'VirtualSystemDescriptionType_CloudInstanceState': 'CloudInstanceState',
        'VirtualSystemDescriptionType_CloudImageState': 'CloudImageState',
        'VirtualSystemDescriptionType_CloudInstanceDisplayName': 'CloudInstanceDisplayName',
        'VirtualSystemDescriptionType_CloudImageDisplayName': 'CloudImageDisplayName',
        'VirtualSystemDescriptionType_CloudOCILaunchMode': 'CloudOCILaunchMode',
        'VirtualSystemDescriptionType_CloudPrivateIP': 'CloudPrivateIP',
        'VirtualSystemDescriptionType_CloudBootVolumeId': 'CloudBootVolumeId',
        'VirtualSystemDescriptionType_CloudOCIVCNCompartment': 'CloudOCIVCNCompartment',
        'VirtualSystemDescriptionType_CloudOCISubnetCompartment': 'CloudOCISubnetCompartment',
        'VirtualSystemDescriptionType_CloudPublicSSHKey': 'CloudPublicSSHKey',
        'VirtualSystemDescriptionType_BootingFirmware': 'BootingFirmware',
        'VirtualSystemDescriptionValueType_Reference': 'Reference',
        'VirtualSystemDescriptionValueType_Original': 'Original',
        'VirtualSystemDescriptionValueType_Auto': 'Auto',
        'VirtualSystemDescriptionValueType_ExtraConfig': 'ExtraConfig',
        'RecordingDestination_None': 'None',
        'RecordingDestination_File': 'File',
        'RecordingFeature_None': 'None',
        'RecordingFeature_Video': 'Video',
        'RecordingFeature_Audio': 'Audio',
        'RecordingAudioCodec_None': 'None',
        'RecordingAudioCodec_WavPCM': 'WavPCM',
        'RecordingAudioCodec_Opus': 'Opus',
        'RecordingVideoCodec_None': 'None',
        'RecordingVideoCodec_VP8': 'VP8',
        'RecordingVideoCodec_VP9': 'VP9',
        'RecordingVideoCodec_AV1': 'AV1',
        'RecordingVideoScalingMethod_None': 'None',
        'RecordingVideoScalingMethod_NearestNeighbor': 'NearestNeighbor',
        'RecordingVideoScalingMethod_Bilinear': 'Bilinear',
        'RecordingVideoScalingMethod_Bicubic': 'Bicubic',
        'RecordingVideoRateControlMode_CBR': 'CBR',
        'RecordingVideoRateControlMode_VBR': 'VBR',
        'GraphicsControllerType_Null': 'Null',
        'GraphicsControllerType_VBoxVGA': 'VBoxVGA',
        'GraphicsControllerType_VMSVGA': 'VMSVGA',
        'GraphicsControllerType_VBoxSVGA': 'VBoxSVGA',
        'CleanupMode_UnregisterOnly': 'UnregisterOnly',
        'CleanupMode_DetachAllReturnNone': 'DetachAllReturnNone',
        'CleanupMode_DetachAllReturnHardDisksOnly': 'DetachAllReturnHardDisksOnly',
        'CleanupMode_Full': 'Full',
        'CloneMode_MachineState': 'MachineState',
        'CloneMode_MachineAndChildStates': 'MachineAndChildStates',
        'CloneMode_AllStates': 'AllStates',
        'CloneOptions_Link': 'Link',
        'CloneOptions_KeepAllMACs': 'KeepAllMACs',
        'CloneOptions_KeepNATMACs': 'KeepNATMACs',
        'CloneOptions_KeepDiskNames': 'KeepDiskNames',
        'CloneOptions_KeepHwUUIDs': 'KeepHwUUIDs',
        'AutostopType_Disabled': 'Disabled',
        'AutostopType_SaveState': 'SaveState',
        'AutostopType_PowerOff': 'PowerOff',
        'AutostopType_AcpiShutdown': 'AcpiShutdown',
        'VMProcPriority_Invalid': 'Invalid',
        'VMProcPriority_Default': 'Default',
        'VMProcPriority_Flat': 'Flat',
        'VMProcPriority_Low': 'Low',
        'VMProcPriority_Normal': 'Normal',
        'VMProcPriority_High': 'High',
        'HostNetworkInterfaceMediumType_Unknown': 'Unknown',
        'HostNetworkInterfaceMediumType_Ethernet': 'Ethernet',
        'HostNetworkInterfaceMediumType_PPP': 'PPP',
        'HostNetworkInterfaceMediumType_SLIP': 'SLIP',
        'HostNetworkInterfaceStatus_Unknown': 'Unknown',
        'HostNetworkInterfaceStatus_Up': 'Up',
        'HostNetworkInterfaceStatus_Down': 'Down',
        'HostNetworkInterfaceType_Bridged': 'Bridged',
        'HostNetworkInterfaceType_HostOnly': 'HostOnly',
        'ProxyMode_System': 'System',
        'ProxyMode_NoProxy': 'NoProxy',
        'ProxyMode_Manual': 'Manual',
        'AdditionsFacilityType_None': 'None',
        'AdditionsFacilityType_VBoxGuestDriver': 'VBoxGuestDriver',
        'AdditionsFacilityType_AutoLogon': 'AutoLogon',
        'AdditionsFacilityType_VBoxService': 'VBoxService',
        'AdditionsFacilityType_VBoxTrayClient': 'VBoxTrayClient',
        'AdditionsFacilityType_Seamless': 'Seamless',
        'AdditionsFacilityType_Graphics': 'Graphics',
        'AdditionsFacilityType_MonitorAttach': 'MonitorAttach',
        'AdditionsFacilityType_All': 'All',
        'AdditionsFacilityClass_None': 'None',
        'AdditionsFacilityClass_Driver': 'Driver',
        'AdditionsFacilityClass_Service': 'Service',
        'AdditionsFacilityClass_Program': 'Program',
        'AdditionsFacilityClass_Feature': 'Feature',
        'AdditionsFacilityClass_ThirdParty': 'ThirdParty',
        'AdditionsFacilityClass_All': 'All',
        'AdditionsFacilityStatus_Inactive': 'Inactive',
        'AdditionsFacilityStatus_Paused': 'Paused',
        'AdditionsFacilityStatus_PreInit': 'PreInit',
        'AdditionsFacilityStatus_Init': 'Init',
        'AdditionsFacilityStatus_Active': 'Active',
        'AdditionsFacilityStatus_Terminating': 'Terminating',
        'AdditionsFacilityStatus_Terminated': 'Terminated',
        'AdditionsFacilityStatus_Failed': 'Failed',
        'AdditionsFacilityStatus_Unknown': 'Unknown',
        'AdditionsRunLevelType_None': 'None',
        'AdditionsRunLevelType_System': 'System',
        'AdditionsRunLevelType_Userland': 'Userland',
        'AdditionsRunLevelType_Desktop': 'Desktop',
        'AdditionsUpdateFlag_None': 'None',
        'AdditionsUpdateFlag_WaitForUpdateStartOnly': 'WaitForUpdateStartOnly',
        'GuestSessionStatus_Undefined': 'Undefined',
        'GuestSessionStatus_Starting': 'Starting',
        'GuestSessionStatus_Started': 'Started',
        'GuestSessionStatus_Terminating': 'Terminating',
        'GuestSessionStatus_Terminated': 'Terminated',
        'GuestSessionStatus_TimedOutKilled': 'TimedOutKilled',
        'GuestSessionStatus_TimedOutAbnormally': 'TimedOutAbnormally',
        'GuestSessionStatus_Down': 'Down',
        'GuestSessionStatus_Error': 'Error',
        'GuestSessionWaitForFlag_None': 'None',
        'GuestSessionWaitForFlag_Start': 'Start',
        'GuestSessionWaitForFlag_Terminate': 'Terminate',
        'GuestSessionWaitForFlag_Status': 'Status',
        'GuestSessionWaitResult_None': 'None',
        'GuestSessionWaitResult_Start': 'Start',
        'GuestSessionWaitResult_Terminate': 'Terminate',
        'GuestSessionWaitResult_Status': 'Status',
        'GuestSessionWaitResult_Error': 'Error',
        'GuestSessionWaitResult_Timeout': 'Timeout',
        'GuestSessionWaitResult_WaitFlagNotSupported': 'WaitFlagNotSupported',
        'GuestUserState_Unknown': 'Unknown',
        'GuestUserState_LoggedIn': 'LoggedIn',
        'GuestUserState_LoggedOut': 'LoggedOut',
        'GuestUserState_Locked': 'Locked',
        'GuestUserState_Unlocked': 'Unlocked',
        'GuestUserState_Disabled': 'Disabled',
        'GuestUserState_Idle': 'Idle',
        'GuestUserState_InUse': 'InUse',
        'GuestUserState_Created': 'Created',
        'GuestUserState_Deleted': 'Deleted',
        'GuestUserState_SessionChanged': 'SessionChanged',
        'GuestUserState_CredentialsChanged': 'CredentialsChanged',
        'GuestUserState_RoleChanged': 'RoleChanged',
        'GuestUserState_GroupAdded': 'GroupAdded',
        'GuestUserState_GroupRemoved': 'GroupRemoved',
        'GuestUserState_Elevated': 'Elevated',
        'FileSeekOrigin_Begin': 'Begin',
        'FileSeekOrigin_Current': 'Current',
        'FileSeekOrigin_End': 'End',
        'ProcessInputFlag_None': 'None',
        'ProcessInputFlag_EndOfFile': 'EndOfFile',
        'ProcessOutputFlag_None': 'None',
        'ProcessOutputFlag_StdErr': 'StdErr',
        'ProcessWaitForFlag_None': 'None',
        'ProcessWaitForFlag_Start': 'Start',
        'ProcessWaitForFlag_Terminate': 'Terminate',
        'ProcessWaitForFlag_StdIn': 'StdIn',
        'ProcessWaitForFlag_StdOut': 'StdOut',
        'ProcessWaitForFlag_StdErr': 'StdErr',
        'ProcessWaitResult_None': 'None',
        'ProcessWaitResult_Start': 'Start',
        'ProcessWaitResult_Terminate': 'Terminate',
        'ProcessWaitResult_Status': 'Status',
        'ProcessWaitResult_Error': 'Error',
        'ProcessWaitResult_Timeout': 'Timeout',
        'ProcessWaitResult_StdIn': 'StdIn',
        'ProcessWaitResult_StdOut': 'StdOut',
        'ProcessWaitResult_StdErr': 'StdErr',
        'ProcessWaitResult_WaitFlagNotSupported': 'WaitFlagNotSupported',
        'FileCopyFlag_None': 'None',
        'FileCopyFlag_NoReplace': 'NoReplace',
        'FileCopyFlag_FollowLinks': 'FollowLinks',
        'FileCopyFlag_Update': 'Update',
        'FsObjMoveFlag_None': 'None',
        'FsObjMoveFlag_Replace': 'Replace',
        'FsObjMoveFlag_FollowLinks': 'FollowLinks',
        'FsObjMoveFlag_AllowDirectoryMoves': 'AllowDirectoryMoves',
        'DirectoryCreateFlag_None': 'None',
        'DirectoryCreateFlag_Parents': 'Parents',
        'DirectoryCopyFlag_None': 'None',
        'DirectoryCopyFlag_CopyIntoExisting': 'CopyIntoExisting',
        'DirectoryRemoveRecFlag_None': 'None',
        'DirectoryRemoveRecFlag_ContentAndDir': 'ContentAndDir',
        'DirectoryRemoveRecFlag_ContentOnly': 'ContentOnly',
        'FsObjRenameFlag_NoReplace': 'NoReplace',
        'FsObjRenameFlag_Replace': 'Replace',
        'ProcessCreateFlag_None': 'None',
        'ProcessCreateFlag_WaitForProcessStartOnly': 'WaitForProcessStartOnly',
        'ProcessCreateFlag_IgnoreOrphanedProcesses': 'IgnoreOrphanedProcesses',
        'ProcessCreateFlag_Hidden': 'Hidden',
        'ProcessCreateFlag_Profile': 'Profile',
        'ProcessCreateFlag_WaitForStdOut': 'WaitForStdOut',
        'ProcessCreateFlag_WaitForStdErr': 'WaitForStdErr',
        'ProcessCreateFlag_ExpandArguments': 'ExpandArguments',
        'ProcessCreateFlag_UnquotedArguments': 'UnquotedArguments',
        'ProcessPriority_Invalid': 'Invalid',
        'ProcessPriority_Default': 'Default',
        'SymlinkType_Unknown': 'Unknown',
        'SymlinkType_Directory': 'Directory',
        'SymlinkType_File': 'File',
        'SymlinkReadFlag_None': 'None',
        'SymlinkReadFlag_NoSymlinks': 'NoSymlinks',
        'ProcessStatus_Undefined': 'Undefined',
        'ProcessStatus_Starting': 'Starting',
        'ProcessStatus_Started': 'Started',
        'ProcessStatus_Paused': 'Paused',
        'ProcessStatus_Terminating': 'Terminating',
        'ProcessStatus_TerminatedNormally': 'TerminatedNormally',
        'ProcessStatus_TerminatedSignal': 'TerminatedSignal',
        'ProcessStatus_TerminatedAbnormally': 'TerminatedAbnormally',
        'ProcessStatus_TimedOutKilled': 'TimedOutKilled',
        'ProcessStatus_TimedOutAbnormally': 'TimedOutAbnormally',
        'ProcessStatus_Down': 'Down',
        'ProcessStatus_Error': 'Error',
        'ProcessInputStatus_Undefined': 'Undefined',
        'ProcessInputStatus_Broken': 'Broken',
        'ProcessInputStatus_Available': 'Available',
        'ProcessInputStatus_Written': 'Written',
        'ProcessInputStatus_Overflow': 'Overflow',
        'PathStyle_DOS': 'DOS',
        'PathStyle_UNIX': 'UNIX',
        'PathStyle_Unknown': 'Unknown',
        'FileAccessMode_ReadOnly': 'ReadOnly',
        'FileAccessMode_WriteOnly': 'WriteOnly',
        'FileAccessMode_ReadWrite': 'ReadWrite',
        'FileAccessMode_AppendOnly': 'AppendOnly',
        'FileAccessMode_AppendRead': 'AppendRead',
        'FileOpenAction_OpenExisting': 'OpenExisting',
        'FileOpenAction_OpenOrCreate': 'OpenOrCreate',
        'FileOpenAction_CreateNew': 'CreateNew',
        'FileOpenAction_CreateOrReplace': 'CreateOrReplace',
        'FileOpenAction_OpenExistingTruncated': 'OpenExistingTruncated',
        'FileOpenAction_AppendOrCreate': 'AppendOrCreate',
        'FileSharingMode_Read': 'Read',
        'FileSharingMode_Write': 'Write',
        'FileSharingMode_ReadWrite': 'ReadWrite',
        'FileSharingMode_Delete': 'Delete',
        'FileSharingMode_ReadDelete': 'ReadDelete',
        'FileSharingMode_WriteDelete': 'WriteDelete',
        'FileSharingMode_All': 'All',
        'FileOpenExFlag_None': 'None',
        'FileStatus_Undefined': 'Undefined',
        'FileStatus_Opening': 'Opening',
        'FileStatus_Open': 'Open',
        'FileStatus_Closing': 'Closing',
        'FileStatus_Closed': 'Closed',
        'FileStatus_Down': 'Down',
        'FileStatus_Error': 'Error',
        'FsObjType_Unknown': 'Unknown',
        'FsObjType_Fifo': 'Fifo',
        'FsObjType_DevChar': 'DevChar',
        'FsObjType_Directory': 'Directory',
        'FsObjType_DevBlock': 'DevBlock',
        'FsObjType_File': 'File',
        'FsObjType_Symlink': 'Symlink',
        'FsObjType_Socket': 'Socket',
        'FsObjType_WhiteOut': 'WhiteOut',
        'DnDAction_Ignore': 'Ignore',
        'DnDAction_Copy': 'Copy',
        'DnDAction_Move': 'Move',
        'DnDAction_Link': 'Link',
        'DirectoryOpenFlag_None': 'None',
        'DirectoryOpenFlag_NoSymlinks': 'NoSymlinks',
        'MediumState_NotCreated': 'NotCreated',
        'MediumState_Created': 'Created',
        'MediumState_LockedRead': 'LockedRead',
        'MediumState_LockedWrite': 'LockedWrite',
        'MediumState_Inaccessible': 'Inaccessible',
        'MediumState_Creating': 'Creating',
        'MediumState_Deleting': 'Deleting',
        'MediumType_Normal': 'Normal',
        'MediumType_Immutable': 'Immutable',
        'MediumType_Writethrough': 'Writethrough',
        'MediumType_Shareable': 'Shareable',
        'MediumType_Readonly': 'Readonly',
        'MediumType_MultiAttach': 'MultiAttach',
        'MediumVariant_Standard': 'Standard',
        'MediumVariant_VmdkSplit2G': 'VmdkSplit2G',
        'MediumVariant_VmdkRawDisk': 'VmdkRawDisk',
        'MediumVariant_VmdkStreamOptimized': 'VmdkStreamOptimized',
        'MediumVariant_VmdkESX': 'VmdkESX',
        'MediumVariant_VdiZeroExpand': 'VdiZeroExpand',
        'MediumVariant_Fixed': 'Fixed',
        'MediumVariant_Diff': 'Diff',
        'MediumVariant_Formatted': 'Formatted',
        'MediumVariant_NoCreateDir': 'NoCreateDir',
        'DataType_Int32': 'Int32',
        'DataType_Int8': 'Int8',
        'DataType_String': 'String',
        'DataFlags_None': 'None',
        'DataFlags_Mandatory': 'Mandatory',
        'DataFlags_Expert': 'Expert',
        'DataFlags_Array': 'Array',
        'DataFlags_FlagMask': 'FlagMask',
        'MediumFormatCapabilities_Uuid': 'Uuid',
        'MediumFormatCapabilities_CreateFixed': 'CreateFixed',
        'MediumFormatCapabilities_CreateDynamic': 'CreateDynamic',
        'MediumFormatCapabilities_CreateSplit2G': 'CreateSplit2G',
        'MediumFormatCapabilities_Differencing': 'Differencing',
        'MediumFormatCapabilities_Asynchronous': 'Asynchronous',
        'MediumFormatCapabilities_File': 'File',
        'MediumFormatCapabilities_Properties': 'Properties',
        'MediumFormatCapabilities_TcpNetworking': 'TcpNetworking',
        'MediumFormatCapabilities_VFS': 'VFS',
        'MediumFormatCapabilities_Discard': 'Discard',
        'MediumFormatCapabilities_Preferred': 'Preferred',
        'MediumFormatCapabilities_CapabilityMask': 'CapabilityMask',
        'PartitionTableType_MBR': 'MBR',
        'PartitionTableType_GPT': 'GPT',
        'KeyboardLED_NumLock': 'NumLock',
        'KeyboardLED_CapsLock': 'CapsLock',
        'KeyboardLED_ScrollLock': 'ScrollLock',
        'MouseButtonState_LeftButton': 'LeftButton',
        'MouseButtonState_RightButton': 'RightButton',
        'MouseButtonState_MiddleButton': 'MiddleButton',
        'MouseButtonState_WheelUp': 'WheelUp',
        'MouseButtonState_WheelDown': 'WheelDown',
        'MouseButtonState_XButton1': 'XButton1',
        'MouseButtonState_XButton2': 'XButton2',
        'MouseButtonState_MouseStateMask': 'MouseStateMask',
        'TouchContactState_None': 'None',
        'TouchContactState_InContact': 'InContact',
        'TouchContactState_InRange': 'InRange',
        'TouchContactState_ContactStateMask': 'ContactStateMask',
        'FramebufferCapabilities_UpdateImage': 'UpdateImage',
        'FramebufferCapabilities_VHWA': 'VHWA',
        'FramebufferCapabilities_VisibleRegion': 'VisibleRegion',
        'FramebufferCapabilities_RenderCursor': 'RenderCursor',
        'FramebufferCapabilities_MoveCursor': 'MoveCursor',
        'GuestMonitorStatus_Disabled': 'Disabled',
        'GuestMonitorStatus_Enabled': 'Enabled',
        'GuestMonitorStatus_Blank': 'Blank',
        'ScreenLayoutMode_Apply': 'Apply',
        'ScreenLayoutMode_Reset': 'Reset',
        'ScreenLayoutMode_Attach': 'Attach',
        'ScreenLayoutMode_Silent': 'Silent',
        'NetworkAttachmentType_Null': 'Null',
        'NetworkAttachmentType_NAT': 'NAT',
        'NetworkAttachmentType_Bridged': 'Bridged',
        'NetworkAttachmentType_Internal': 'Internal',
        'NetworkAttachmentType_HostOnly': 'HostOnly',
        'NetworkAttachmentType_Generic': 'Generic',
        'NetworkAttachmentType_NATNetwork': 'NATNetwork',
        'NetworkAttachmentType_Cloud': 'Cloud',
        'NetworkAdapterType_Null': 'Null',
        'NetworkAdapterType_Am79C970A': 'Am79C970A',
        'NetworkAdapterType_Am79C973': 'Am79C973',
        'NetworkAdapterType_I82540EM': 'I82540EM',
        'NetworkAdapterType_I82543GC': 'I82543GC',
        'NetworkAdapterType_I82545EM': 'I82545EM',
        'NetworkAdapterType_Virtio': 'Virtio',
        'NetworkAdapterType_Am79C960': 'Am79C960',
        'NetworkAdapterType_Virtio_1_0': 'Virtio_1_0',
        'NetworkAdapterPromiscModePolicy_Deny': 'Deny',
        'NetworkAdapterPromiscModePolicy_AllowNetwork': 'AllowNetwork',
        'NetworkAdapterPromiscModePolicy_AllowAll': 'AllowAll',
        'PortMode_Disconnected': 'Disconnected',
        'PortMode_HostPipe': 'HostPipe',
        'PortMode_HostDevice': 'HostDevice',
        'PortMode_RawFile': 'RawFile',
        'PortMode_TCP': 'TCP',
        'UartType_U16450': 'U16450',
        'UartType_U16550A': 'U16550A',
        'UartType_U16750': 'U16750',
        'VMExecutionEngine_NotSet': 'NotSet',
        'VMExecutionEngine_RawMode': 'RawMode',
        'VMExecutionEngine_HwVirt': 'HwVirt',
        'VMExecutionEngine_NativeApi': 'NativeApi',
        'USBControllerType_Null': 'Null',
        'USBControllerType_OHCI': 'OHCI',
        'USBControllerType_EHCI': 'EHCI',
        'USBControllerType_XHCI': 'XHCI',
        'USBControllerType_Last': 'Last',
        'USBConnectionSpeed_Null': 'Null',
        'USBConnectionSpeed_Low': 'Low',
        'USBConnectionSpeed_Full': 'Full',
        'USBConnectionSpeed_High': 'High',
        'USBConnectionSpeed_Super': 'Super',
        'USBConnectionSpeed_SuperPlus': 'SuperPlus',
        'USBDeviceState_NotSupported': 'NotSupported',
        'USBDeviceState_Unavailable': 'Unavailable',
        'USBDeviceState_Busy': 'Busy',
        'USBDeviceState_Available': 'Available',
        'USBDeviceState_Held': 'Held',
        'USBDeviceState_Captured': 'Captured',
        'USBDeviceFilterAction_Null': 'Null',
        'USBDeviceFilterAction_Ignore': 'Ignore',
        'USBDeviceFilterAction_Hold': 'Hold',
        'AudioDriverType_Null': 'Null',
        'AudioDriverType_WinMM': 'WinMM',
        'AudioDriverType_OSS': 'OSS',
        'AudioDriverType_ALSA': 'ALSA',
        'AudioDriverType_DirectSound': 'DirectSound',
        'AudioDriverType_CoreAudio': 'CoreAudio',
        'AudioDriverType_MMPM': 'MMPM',
        'AudioDriverType_Pulse': 'Pulse',
        'AudioDriverType_SolAudio': 'SolAudio',
        'AudioControllerType_AC97': 'AC97',
        'AudioControllerType_SB16': 'SB16',
        'AudioControllerType_HDA': 'HDA',
        'AudioCodecType_Null': 'Null',
        'AudioCodecType_SB16': 'SB16',
        'AudioCodecType_STAC9700': 'STAC9700',
        'AudioCodecType_AD1980': 'AD1980',
        'AudioCodecType_STAC9221': 'STAC9221',
        'AuthType_Null': 'Null',
        'AuthType_External': 'External',
        'AuthType_Guest': 'Guest',
        'Reason_Unspecified': 'Unspecified',
        'Reason_HostSuspend': 'HostSuspend',
        'Reason_HostResume': 'HostResume',
        'Reason_HostBatteryLow': 'HostBatteryLow',
        'Reason_Snapshot': 'Snapshot',
        'StorageBus_Null': 'Null',
        'StorageBus_IDE': 'IDE',
        'StorageBus_SATA': 'SATA',
        'StorageBus_SCSI': 'SCSI',
        'StorageBus_Floppy': 'Floppy',
        'StorageBus_SAS': 'SAS',
        'StorageBus_USB': 'USB',
        'StorageBus_PCIe': 'PCIe',
        'StorageBus_VirtioSCSI': 'VirtioSCSI',
        'StorageControllerType_Null': 'Null',
        'StorageControllerType_LsiLogic': 'LsiLogic',
        'StorageControllerType_BusLogic': 'BusLogic',
        'StorageControllerType_IntelAhci': 'IntelAhci',
        'StorageControllerType_PIIX3': 'PIIX3',
        'StorageControllerType_PIIX4': 'PIIX4',
        'StorageControllerType_ICH6': 'ICH6',
        'StorageControllerType_I82078': 'I82078',
        'StorageControllerType_LsiLogicSas': 'LsiLogicSas',
        'StorageControllerType_USB': 'USB',
        'StorageControllerType_NVMe': 'NVMe',
        'StorageControllerType_VirtioSCSI': 'VirtioSCSI',
        'ChipsetType_Null': 'Null',
        'ChipsetType_PIIX3': 'PIIX3',
        'ChipsetType_ICH9': 'ICH9',
        'NATAliasMode_AliasLog': 'AliasLog',
        'NATAliasMode_AliasProxyOnly': 'AliasProxyOnly',
        'NATAliasMode_AliasUseSamePorts': 'AliasUseSamePorts',
        'NATProtocol_UDP': 'UDP',
        'NATProtocol_TCP': 'TCP',
        'BandwidthGroupType_Null': 'Null',
        'BandwidthGroupType_Disk': 'Disk',
        'BandwidthGroupType_Network': 'Network',
        'VBoxEventType_Invalid': 'Invalid',
        'VBoxEventType_Any': 'Any',
        'VBoxEventType_Vetoable': 'Vetoable',
        'VBoxEventType_MachineEvent': 'MachineEvent',
        'VBoxEventType_SnapshotEvent': 'SnapshotEvent',
        'VBoxEventType_InputEvent': 'InputEvent',
        'VBoxEventType_LastWildcard': 'LastWildcard',
        'VBoxEventType_OnMachineStateChanged': 'OnMachineStateChanged',
        'VBoxEventType_OnMachineDataChanged': 'OnMachineDataChanged',
        'VBoxEventType_OnExtraDataChanged': 'OnExtraDataChanged',
        'VBoxEventType_OnExtraDataCanChange': 'OnExtraDataCanChange',
        'VBoxEventType_OnMediumRegistered': 'OnMediumRegistered',
        'VBoxEventType_OnMachineRegistered': 'OnMachineRegistered',
        'VBoxEventType_OnSessionStateChanged': 'OnSessionStateChanged',
        'VBoxEventType_OnSnapshotTaken': 'OnSnapshotTaken',
        'VBoxEventType_OnSnapshotDeleted': 'OnSnapshotDeleted',
        'VBoxEventType_OnSnapshotChanged': 'OnSnapshotChanged',
        'VBoxEventType_OnGuestPropertyChanged': 'OnGuestPropertyChanged',
        'VBoxEventType_OnMousePointerShapeChanged': 'OnMousePointerShapeChanged',
        'VBoxEventType_OnMouseCapabilityChanged': 'OnMouseCapabilityChanged',
        'VBoxEventType_OnKeyboardLedsChanged': 'OnKeyboardLedsChanged',
        'VBoxEventType_OnStateChanged': 'OnStateChanged',
        'VBoxEventType_OnAdditionsStateChanged': 'OnAdditionsStateChanged',
        'VBoxEventType_OnNetworkAdapterChanged': 'OnNetworkAdapterChanged',
        'VBoxEventType_OnSerialPortChanged': 'OnSerialPortChanged',
        'VBoxEventType_OnParallelPortChanged': 'OnParallelPortChanged',
        'VBoxEventType_OnStorageControllerChanged': 'OnStorageControllerChanged',
        'VBoxEventType_OnMediumChanged': 'OnMediumChanged',
        'VBoxEventType_OnVRDEServerChanged': 'OnVRDEServerChanged',
        'VBoxEventType_OnUSBControllerChanged': 'OnUSBControllerChanged',
        'VBoxEventType_OnUSBDeviceStateChanged': 'OnUSBDeviceStateChanged',
        'VBoxEventType_OnSharedFolderChanged': 'OnSharedFolderChanged',
        'VBoxEventType_OnRuntimeError': 'OnRuntimeError',
        'VBoxEventType_OnCanShowWindow': 'OnCanShowWindow',
        'VBoxEventType_OnShowWindow': 'OnShowWindow',
        'VBoxEventType_OnCPUChanged': 'OnCPUChanged',
        'VBoxEventType_OnVRDEServerInfoChanged': 'OnVRDEServerInfoChanged',
        'VBoxEventType_OnEventSourceChanged': 'OnEventSourceChanged',
        'VBoxEventType_OnCPUExecutionCapChanged': 'OnCPUExecutionCapChanged',
        'VBoxEventType_OnGuestKeyboard': 'OnGuestKeyboard',
        'VBoxEventType_OnGuestMouse': 'OnGuestMouse',
        'VBoxEventType_OnNATRedirect': 'OnNATRedirect',
        'VBoxEventType_OnHostPCIDevicePlug': 'OnHostPCIDevicePlug',
        'VBoxEventType_OnVBoxSVCAvailabilityChanged': 'OnVBoxSVCAvailabilityChanged',
        'VBoxEventType_OnBandwidthGroupChanged': 'OnBandwidthGroupChanged',
        'VBoxEventType_OnGuestMonitorChanged': 'OnGuestMonitorChanged',
        'VBoxEventType_OnStorageDeviceChanged': 'OnStorageDeviceChanged',
        'VBoxEventType_OnClipboardModeChanged': 'OnClipboardModeChanged',
        'VBoxEventType_OnDnDModeChanged': 'OnDnDModeChanged',
        'VBoxEventType_OnNATNetworkChanged': 'OnNATNetworkChanged',
        'VBoxEventType_OnNATNetworkStartStop': 'OnNATNetworkStartStop',
        'VBoxEventType_OnNATNetworkAlter': 'OnNATNetworkAlter',
        'VBoxEventType_OnNATNetworkCreationDeletion': 'OnNATNetworkCreationDeletion',
        'VBoxEventType_OnNATNetworkSetting': 'OnNATNetworkSetting',
        'VBoxEventType_OnNATNetworkPortForward': 'OnNATNetworkPortForward',
        'VBoxEventType_OnGuestSessionStateChanged': 'OnGuestSessionStateChanged',
        'VBoxEventType_OnGuestSessionRegistered': 'OnGuestSessionRegistered',
        'VBoxEventType_OnGuestProcessRegistered': 'OnGuestProcessRegistered',
        'VBoxEventType_OnGuestProcessStateChanged': 'OnGuestProcessStateChanged',
        'VBoxEventType_OnGuestProcessInputNotify': 'OnGuestProcessInputNotify',
        'VBoxEventType_OnGuestProcessOutput': 'OnGuestProcessOutput',
        'VBoxEventType_OnGuestFileRegistered': 'OnGuestFileRegistered',
        'VBoxEventType_OnGuestFileStateChanged': 'OnGuestFileStateChanged',
        'VBoxEventType_OnGuestFileOffsetChanged': 'OnGuestFileOffsetChanged',
        'VBoxEventType_OnGuestFileRead': 'OnGuestFileRead',
        'VBoxEventType_OnGuestFileWrite': 'OnGuestFileWrite',
        'VBoxEventType_OnRecordingChanged': 'OnRecordingChanged',
        'VBoxEventType_OnGuestUserStateChanged': 'OnGuestUserStateChanged',
        'VBoxEventType_OnGuestMultiTouch': 'OnGuestMultiTouch',
        'VBoxEventType_OnHostNameResolutionConfigurationChange': 'OnHostNameResolutionConfigurationChange',
        'VBoxEventType_OnSnapshotRestored': 'OnSnapshotRestored',
        'VBoxEventType_OnMediumConfigChanged': 'OnMediumConfigChanged',
        'VBoxEventType_OnAudioAdapterChanged': 'OnAudioAdapterChanged',
        'VBoxEventType_OnProgressPercentageChanged': 'OnProgressPercentageChanged',
        'VBoxEventType_OnProgressTaskCompleted': 'OnProgressTaskCompleted',
        'VBoxEventType_OnCursorPositionChanged': 'OnCursorPositionChanged',
        'VBoxEventType_OnGuestAdditionsStatusChanged': 'OnGuestAdditionsStatusChanged',
        'VBoxEventType_OnGuestMonitorInfoChanged': 'OnGuestMonitorInfoChanged',
        'VBoxEventType_OnGuestFileSizeChanged': 'OnGuestFileSizeChanged',
        'VBoxEventType_OnClipboardFileTransferModeChanged': 'OnClipboardFileTransferModeChanged',
        'VBoxEventType_Last': 'Last',
        'GuestMouseEventMode_Relative': 'Relative',
        'GuestMouseEventMode_Absolute': 'Absolute',
        'GuestMonitorChangedEventType_Enabled': 'Enabled',
        'GuestMonitorChangedEventType_Disabled': 'Disabled',
        'GuestMonitorChangedEventType_NewOrigin': 'NewOrigin',
        'FormValueType_Boolean': 'Boolean',
        'FormValueType_String': 'String',
        'FormValueType_Choice': 'Choice',
        'FormValueType_RangedInteger': 'RangedInteger',
        'CloudMachineState_Invalid': 'Invalid',
        'CloudMachineState_Provisioning': 'Provisioning',
        'CloudMachineState_Running': 'Running',
        'CloudMachineState_Starting': 'Starting',
        'CloudMachineState_Stopping': 'Stopping',
        'CloudMachineState_Stopped': 'Stopped',
        'CloudMachineState_CreatingImage': 'CreatingImage',
        'CloudMachineState_Terminating': 'Terminating',
        'CloudMachineState_Terminated': 'Terminated',
        'CloudImageState_Invalid': 'Invalid',
        'CloudImageState_Provisioning': 'Provisioning',
        'CloudImageState_Importing': 'Importing',
        'CloudImageState_Available': 'Available',
        'CloudImageState_Exporting': 'Exporting',
        'CloudImageState_Disabled': 'Disabled',
        'CloudImageState_Deleted': 'Deleted',
        # Result constants:
        'VBOX_E_OBJECT_NOT_FOUND': 'VBOX_E_OBJECT_NOT_FOUND',
        'VBOX_E_INVALID_VM_STATE': 'VBOX_E_INVALID_VM_STATE',
        'VBOX_E_VM_ERROR': 'VBOX_E_VM_ERROR',
        'VBOX_E_FILE_ERROR': 'VBOX_E_FILE_ERROR',
        'VBOX_E_IPRT_ERROR': 'VBOX_E_IPRT_ERROR',
        'VBOX_E_PDM_ERROR': 'VBOX_E_PDM_ERROR',
        'VBOX_E_INVALID_OBJECT_STATE': 'VBOX_E_INVALID_OBJECT_STATE',
        'VBOX_E_HOST_ERROR': 'VBOX_E_HOST_ERROR',
        'VBOX_E_NOT_SUPPORTED': 'VBOX_E_NOT_SUPPORTED',
        'VBOX_E_XML_ERROR': 'VBOX_E_XML_ERROR',
        'VBOX_E_INVALID_SESSION_STATE': 'VBOX_E_INVALID_SESSION_STATE',
        'VBOX_E_OBJECT_IN_USE': 'VBOX_E_OBJECT_IN_USE',
        'VBOX_E_PASSWORD_INCORRECT': 'VBOX_E_PASSWORD_INCORRECT',
        'VBOX_E_MAXIMUM_REACHED': 'VBOX_E_MAXIMUM_REACHED',
        'VBOX_E_GSTCTL_GUEST_ERROR': 'VBOX_E_GSTCTL_GUEST_ERROR',
        'VBOX_E_TIMEOUT': 'VBOX_E_TIMEOUT',
    }

    def __getattr__(self, sAttrName):
        if self.__fIsSym:
            oValue = self.__dValuesFlatSym.get(sAttrName)
        else:
            oValue = self.__dValuesFlat.get(sAttrName)
        if oValue is None:
            raise AttributeError
        return oValue

    def all_values(self, sEnumName):
        """ Returns a dictionary with all the value names for a given enum type. """
        if self.__fIsSym:
            dValues = self.__dValuesSym.get(sEnumName)
        else:
            dValues = self.__dValues.get(sEnumName)
        if dValues is None:
            dValues = {}
        return dValues

