
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * ICloudClient.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;

public class ICloudClient extends IUnknown
{

    public ICloudClient(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }
    public static ICloudClient queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new ICloudClient(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Returns a form for editing the virtual system description for
exporting a local VM into a cloud custom image.
@param description Virtual system description to be edited.

@param form An IForm instance for editing the virtual system description.

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress getExportDescriptionForm(org.virtualbox_6_1.IVirtualSystemDescription description, Holder<org.virtualbox_6_1.IVirtualSystemDescriptionForm> form)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
        javax.xml.ws.Holder<String> tmp_form = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iCloudClientGetExportDescriptionForm(obj, ((description == null) ? null :description.getWrapped()), tmp_form, retVal);
        form.value = (tmp_form.value.length() > 0) ? new org.virtualbox_6_1.IVirtualSystemDescriptionForm(tmp_form.value, getObjMgr(), port) : null;
           return (retVal.value.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal.value, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Export local VM into the cloud, creating a custom image.
@param description Virtual system description object which describes the
machine and all required parameters.

@param progress Progress object to track the operation completion.

*/
    public void exportVM(org.virtualbox_6_1.IVirtualSystemDescription description, org.virtualbox_6_1.IProgress progress)
    {
        try
        {
        port.iCloudClientExportVM(obj, ((description == null) ? null :description.getWrapped()), ((progress == null) ? null :progress.getWrapped()));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public org.virtualbox_6_1.IProgress getLaunchDescriptionForm(org.virtualbox_6_1.IVirtualSystemDescription description, Holder<org.virtualbox_6_1.IVirtualSystemDescriptionForm> form)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
        javax.xml.ws.Holder<String> tmp_form = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iCloudClientGetLaunchDescriptionForm(obj, ((description == null) ? null :description.getWrapped()), tmp_form, retVal);
        form.value = (tmp_form.value.length() > 0) ? new org.virtualbox_6_1.IVirtualSystemDescriptionForm(tmp_form.value, getObjMgr(), port) : null;
           return (retVal.value.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal.value, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public org.virtualbox_6_1.IProgress launchVM(org.virtualbox_6_1.IVirtualSystemDescription description)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientLaunchVM(obj, ((description == null) ? null :description.getWrapped()));
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Returns a form for editing the virtual system description for
import from cloud.
@param description Virtual system description to be edited.

@param form An IForm instance for editing the virtual system description.

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress getImportDescriptionForm(org.virtualbox_6_1.IVirtualSystemDescription description, Holder<org.virtualbox_6_1.IVirtualSystemDescriptionForm> form)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
        javax.xml.ws.Holder<String> tmp_form = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iCloudClientGetImportDescriptionForm(obj, ((description == null) ? null :description.getWrapped()), tmp_form, retVal);
        form.value = (tmp_form.value.length() > 0) ? new org.virtualbox_6_1.IVirtualSystemDescriptionForm(tmp_form.value, getObjMgr(), port) : null;
           return (retVal.value.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal.value, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Import an existing cloud instance to the local host.
All needed parameters are passed in the description (VSD).
@param description VirtualSystemDescription object which is describing a machine and all required parameters.

@param progress Progress object to track the operation completion.

*/
    public void importInstance(org.virtualbox_6_1.IVirtualSystemDescription description, org.virtualbox_6_1.IProgress progress)
    {
        try
        {
        port.iCloudClientImportInstance(obj, ((description == null) ? null :description.getWrapped()), ((progress == null) ? null :progress.getWrapped()));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the list of the instances in the Cloud.
@param machineState State of each VM.

@param returnNames VM names.

@param returnIds VM ids.

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress listInstances(List<org.virtualbox_6_1.CloudMachineState> machineState, Holder<org.virtualbox_6_1.IStringArray> returnNames, Holder<org.virtualbox_6_1.IStringArray> returnIds)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
        javax.xml.ws.Holder<String> tmp_returnNames = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> tmp_returnIds = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iCloudClientListInstances(obj, Helper.convertEnums(org.virtualbox_6_1.CloudMachineState.class, org.virtualbox_6_1.jaxws.CloudMachineState.class, machineState), tmp_returnNames, tmp_returnIds, retVal);
        returnNames.value = (tmp_returnNames.value.length() > 0) ? new org.virtualbox_6_1.IStringArray(tmp_returnNames.value, getObjMgr(), port) : null;
        returnIds.value = (tmp_returnIds.value.length() > 0) ? new org.virtualbox_6_1.IStringArray(tmp_returnIds.value, getObjMgr(), port) : null;
           return (retVal.value.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal.value, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Returns the list of the images in the Cloud.
@param imageState State of each image.

@param returnNames Images names.

@param returnIds Images ids.

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress listImages(List<org.virtualbox_6_1.CloudImageState> imageState, Holder<org.virtualbox_6_1.IStringArray> returnNames, Holder<org.virtualbox_6_1.IStringArray> returnIds)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
        javax.xml.ws.Holder<String> tmp_returnNames = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> tmp_returnIds = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iCloudClientListImages(obj, Helper.convertEnums(org.virtualbox_6_1.CloudImageState.class, org.virtualbox_6_1.jaxws.CloudImageState.class, imageState), tmp_returnNames, tmp_returnIds, retVal);
        returnNames.value = (tmp_returnNames.value.length() > 0) ? new org.virtualbox_6_1.IStringArray(tmp_returnNames.value, getObjMgr(), port) : null;
        returnIds.value = (tmp_returnIds.value.length() > 0) ? new org.virtualbox_6_1.IStringArray(tmp_returnIds.value, getObjMgr(), port) : null;
           return (retVal.value.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal.value, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Returns the information about an instance in the Cloud.
@param uid The id of instance in the Cloud.

@param description VirtualSystemDescription object which is describing a machine

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress getInstanceInfo(String uid, org.virtualbox_6_1.IVirtualSystemDescription description)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientGetInstanceInfo(obj, uid, ((description == null) ? null :description.getWrapped()));
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Start an existing instance with passed id.
@param uid The id of instance in the Cloud.

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress startInstance(String uid)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientStartInstance(obj, uid);
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Pause an existing instance with passed id.
@param uid The id of instance in the Cloud.

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress pauseInstance(String uid)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientPauseInstance(obj, uid);
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Terminate an existing instance with passed id.
@param uid the id of instance in the Cloud.

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress terminateInstance(String uid)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientTerminateInstance(obj, uid);
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Create an image in the Cloud.
@param parameters Each parameter in the array must be in the form "name=value".

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress createImage(List<String> parameters)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientCreateImage(obj, parameters);
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Export an existing VBox image in the Cloud.
@param image Reference to the existing VBox image.

@param parameters Each parameter in the array must be in the form "name=value".

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress exportImage(org.virtualbox_6_1.IMedium image, List<String> parameters)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientExportImage(obj, ((image == null) ? null :image.getWrapped()), parameters);
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Import an existing image in the Cloud to the local host.
@param uid the id of image in the Cloud.

@param parameters Each parameter in the array must be in the form "name=value".

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress importImage(String uid, List<String> parameters)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientImportImage(obj, uid, parameters);
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Delete an existing image with passed id from the Cloud.
@param uid The id of image in the Cloud.

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress deleteImage(String uid)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iCloudClientDeleteImage(obj, uid);
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Returns the information about an image in the Cloud.
@param uid The id of image in the Cloud.

@param infoArray An array where the image settings or properties is returned.
Each parameter in the array must be in the form "name=value".

@return Progress object to track the operation completion.

*/
    public org.virtualbox_6_1.IProgress getImageInfo(String uid, Holder<org.virtualbox_6_1.IStringArray> infoArray)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
        javax.xml.ws.Holder<String> tmp_infoArray = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iCloudClientGetImageInfo(obj, uid, tmp_infoArray, retVal);
        infoArray.value = (tmp_infoArray.value.length() > 0) ? new org.virtualbox_6_1.IStringArray(tmp_infoArray.value, getObjMgr(), port) : null;
           return (retVal.value.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal.value, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public org.virtualbox_6_1.IProgress startCloudNetworkGateway(org.virtualbox_6_1.ICloudNetwork network, String sshPublicKey, Holder<org.virtualbox_6_1.ICloudNetworkGatewayInfo> gatewayInfo)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
        javax.xml.ws.Holder<String> tmp_gatewayInfo = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iCloudClientStartCloudNetworkGateway(obj, ((network == null) ? null :network.getWrapped()), sshPublicKey, tmp_gatewayInfo, retVal);
        gatewayInfo.value = (tmp_gatewayInfo.value.length() > 0) ? new org.virtualbox_6_1.ICloudNetworkGatewayInfo(tmp_gatewayInfo.value, getObjMgr(), port) : null;
           return (retVal.value.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal.value, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public org.virtualbox_6_1.IProgress setupCloudNetworkEnvironment(String tunnelNetworkName, String tunnelNetworkRange, String gatewayOsName, String gatewayOsVersion, String gatewayShape, Holder<org.virtualbox_6_1.ICloudNetworkEnvironmentInfo> networkEnvironmentInfo)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
        javax.xml.ws.Holder<String> tmp_networkEnvironmentInfo = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<String> retVal = new javax.xml.ws.Holder<String>();
        port.iCloudClientSetupCloudNetworkEnvironment(obj, tunnelNetworkName, tunnelNetworkRange, gatewayOsName, gatewayOsVersion, gatewayShape, tmp_networkEnvironmentInfo, retVal);
        networkEnvironmentInfo.value = (tmp_networkEnvironmentInfo.value.length() > 0) ? new org.virtualbox_6_1.ICloudNetworkEnvironmentInfo(tmp_networkEnvironmentInfo.value, getObjMgr(), port) : null;
           return (retVal.value.length() > 0) ? new org.virtualbox_6_1.IProgress(retVal.value, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
}
