
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestFileReadEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_0;

import org.virtualbox_6_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when data has been read from a guest file.

Interface ID: <tt>{4EE3CBCB-486F-40DB-9150-DEEE3FD24189}</tt>
*/
public class IGuestFileReadEvent extends IGuestFileIOEvent
{

    public IGuestFileReadEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Actual data read.
@return byte[]
*/
    public byte[] getData()
    {
        try
        {
            /*base64*/String retVal = port.iGuestFileReadEventGetData(obj);
            return Helper.decodeBase64(retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IGuestFileReadEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestFileReadEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
