/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_6_0;

import java.util.List;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.virtualbox_6_0.DeviceActivity;
import org.virtualbox_6_0.DeviceType;
import org.virtualbox_6_0.IDisplay;
import org.virtualbox_6_0.IEmulatedUSB;
import org.virtualbox_6_0.IEventSource;
import org.virtualbox_6_0.IGuest;
import org.virtualbox_6_0.IHostUSBDevice;
import org.virtualbox_6_0.IKeyboard;
import org.virtualbox_6_0.IMachine;
import org.virtualbox_6_0.IMachineDebugger;
import org.virtualbox_6_0.IMouse;
import org.virtualbox_6_0.IPCIDeviceAttachment;
import org.virtualbox_6_0.IProgress;
import org.virtualbox_6_0.ISharedFolder;
import org.virtualbox_6_0.IUSBDevice;
import org.virtualbox_6_0.IVRDEServerInfo;
import org.virtualbox_6_0.MachineState;
import org.virtualbox_6_0.VBoxException;
import org.virtualbox_6_0.xpcom.Helper;
import org.virtualbox_6_0.xpcom.IUnknown;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IConsole
extends IUnknown {
    public IConsole(org.mozilla.interfaces.IConsole iConsole) {
        super(iConsole);
    }

    public org.mozilla.interfaces.IConsole getTypedWrapped() {
        return (org.mozilla.interfaces.IConsole)this.getWrapped();
    }

    public IMachine getMachine() {
        try {
            org.mozilla.interfaces.IMachine iMachine = this.getTypedWrapped().getMachine();
            return iMachine != null ? new IMachine(iMachine) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public MachineState getState() {
        try {
            long l = this.getTypedWrapped().getState();
            return MachineState.fromValue(l);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IGuest getGuest() {
        try {
            org.mozilla.interfaces.IGuest iGuest = this.getTypedWrapped().getGuest();
            return iGuest != null ? new IGuest(iGuest) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IKeyboard getKeyboard() {
        try {
            org.mozilla.interfaces.IKeyboard iKeyboard = this.getTypedWrapped().getKeyboard();
            return iKeyboard != null ? new IKeyboard(iKeyboard) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IMouse getMouse() {
        try {
            org.mozilla.interfaces.IMouse iMouse = this.getTypedWrapped().getMouse();
            return iMouse != null ? new IMouse(iMouse) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IDisplay getDisplay() {
        try {
            org.mozilla.interfaces.IDisplay iDisplay = this.getTypedWrapped().getDisplay();
            return iDisplay != null ? new IDisplay(iDisplay) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IMachineDebugger getDebugger() {
        try {
            org.mozilla.interfaces.IMachineDebugger iMachineDebugger = this.getTypedWrapped().getDebugger();
            return iMachineDebugger != null ? new IMachineDebugger(iMachineDebugger) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IUSBDevice> getUSBDevices() {
        try {
            org.mozilla.interfaces.IUSBDevice[] iUSBDeviceArray = this.getTypedWrapped().getUSBDevices(null);
            return Helper.wrap2(IUSBDevice.class, org.mozilla.interfaces.IUSBDevice.class, iUSBDeviceArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IHostUSBDevice> getRemoteUSBDevices() {
        try {
            org.mozilla.interfaces.IHostUSBDevice[] iHostUSBDeviceArray = this.getTypedWrapped().getRemoteUSBDevices(null);
            return Helper.wrap2(IHostUSBDevice.class, org.mozilla.interfaces.IHostUSBDevice.class, iHostUSBDeviceArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<ISharedFolder> getSharedFolders() {
        try {
            org.mozilla.interfaces.ISharedFolder[] iSharedFolderArray = this.getTypedWrapped().getSharedFolders(null);
            return Helper.wrap2(ISharedFolder.class, org.mozilla.interfaces.ISharedFolder.class, iSharedFolderArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IVRDEServerInfo getVRDEServerInfo() {
        try {
            org.mozilla.interfaces.IVRDEServerInfo iVRDEServerInfo = this.getTypedWrapped().getVRDEServerInfo();
            return iVRDEServerInfo != null ? new IVRDEServerInfo(iVRDEServerInfo) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IEventSource getEventSource() {
        try {
            org.mozilla.interfaces.IEventSource iEventSource = this.getTypedWrapped().getEventSource();
            return iEventSource != null ? new IEventSource(iEventSource) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IPCIDeviceAttachment> getAttachedPCIDevices() {
        try {
            org.mozilla.interfaces.IPCIDeviceAttachment[] iPCIDeviceAttachmentArray = this.getTypedWrapped().getAttachedPCIDevices(null);
            return Helper.wrap2(IPCIDeviceAttachment.class, org.mozilla.interfaces.IPCIDeviceAttachment.class, iPCIDeviceAttachmentArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public Boolean getUseHostClipboard() {
        try {
            boolean bl = this.getTypedWrapped().getUseHostClipboard();
            return bl;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void setUseHostClipboard(Boolean bl) {
        try {
            this.getTypedWrapped().setUseHostClipboard(bl);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IEmulatedUSB getEmulatedUSB() {
        try {
            org.mozilla.interfaces.IEmulatedUSB iEmulatedUSB = this.getTypedWrapped().getEmulatedUSB();
            return iEmulatedUSB != null ? new IEmulatedUSB(iEmulatedUSB) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public static IConsole queryInterface(IUnknown iUnknown) {
        nsISupports nsISupports2;
        nsISupports nsISupports3 = nsISupports2 = iUnknown != null ? (nsISupports)iUnknown.getWrapped() : null;
        if (nsISupports2 == null) {
            return null;
        }
        org.mozilla.interfaces.IConsole iConsole = Helper.queryInterface(nsISupports2, "{872da645-4a9b-1727-bee2-5585105b9eed}", org.mozilla.interfaces.IConsole.class);
        return iConsole == null ? null : new IConsole(iConsole);
    }

    public IProgress powerUp() {
        try {
            org.mozilla.interfaces.IProgress iProgress = this.getTypedWrapped().powerUp();
            return iProgress != null ? new IProgress(iProgress) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IProgress powerUpPaused() {
        try {
            org.mozilla.interfaces.IProgress iProgress = this.getTypedWrapped().powerUpPaused();
            return iProgress != null ? new IProgress(iProgress) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IProgress powerDown() {
        try {
            org.mozilla.interfaces.IProgress iProgress = this.getTypedWrapped().powerDown();
            return iProgress != null ? new IProgress(iProgress) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void reset() {
        try {
            this.getTypedWrapped().reset();
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void pause() {
        try {
            this.getTypedWrapped().pause();
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void resume() {
        try {
            this.getTypedWrapped().resume();
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void powerButton() {
        try {
            this.getTypedWrapped().powerButton();
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void sleepButton() {
        try {
            this.getTypedWrapped().sleepButton();
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public Boolean getPowerButtonHandled() {
        try {
            boolean bl = this.getTypedWrapped().getPowerButtonHandled();
            return bl;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public Boolean getGuestEnteredACPIMode() {
        try {
            boolean bl = this.getTypedWrapped().getGuestEnteredACPIMode();
            return bl;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<DeviceActivity> getDeviceActivity(List<DeviceType> list) {
        try {
            long[] lArray = this.getTypedWrapped().getDeviceActivity(list != null ? (long)list.size() : 0L, Helper.unwrapEnum(DeviceType.class, list), null);
            return Helper.wrapEnum(DeviceActivity.class, lArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void attachUSBDevice(String string, String string2) {
        try {
            this.getTypedWrapped().attachUSBDevice(string, string2);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IUSBDevice detachUSBDevice(String string) {
        try {
            org.mozilla.interfaces.IUSBDevice iUSBDevice = this.getTypedWrapped().detachUSBDevice(string);
            return iUSBDevice != null ? new IUSBDevice(iUSBDevice) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IUSBDevice findUSBDeviceByAddress(String string) {
        try {
            org.mozilla.interfaces.IUSBDevice iUSBDevice = this.getTypedWrapped().findUSBDeviceByAddress(string);
            return iUSBDevice != null ? new IUSBDevice(iUSBDevice) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IUSBDevice findUSBDeviceById(String string) {
        try {
            org.mozilla.interfaces.IUSBDevice iUSBDevice = this.getTypedWrapped().findUSBDeviceById(string);
            return iUSBDevice != null ? new IUSBDevice(iUSBDevice) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void createSharedFolder(String string, String string2, Boolean bl, Boolean bl2, String string3) {
        try {
            this.getTypedWrapped().createSharedFolder(string, string2, bl, bl2, string3);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void removeSharedFolder(String string) {
        try {
            this.getTypedWrapped().removeSharedFolder(string);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IProgress teleport(String string, Long l, String string2, Long l2) {
        try {
            org.mozilla.interfaces.IProgress iProgress = this.getTypedWrapped().teleport(string, l, string2, l2);
            return iProgress != null ? new IProgress(iProgress) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void addDiskEncryptionPassword(String string, String string2, Boolean bl) {
        try {
            this.getTypedWrapped().addDiskEncryptionPassword(string, string2, bl);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void addDiskEncryptionPasswords(List<String> list, List<String> list2, Boolean bl) {
        try {
            this.getTypedWrapped().addDiskEncryptionPasswords(list != null ? (long)list.size() : 0L, Helper.unwrapStr(list), list2 != null ? (long)list2.size() : 0L, Helper.unwrapStr(list2), bl);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void removeDiskEncryptionPassword(String string) {
        try {
            this.getTypedWrapped().removeDiskEncryptionPassword(string);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void clearAllDiskEncryptionPasswords() {
        try {
            this.getTypedWrapped().clearAllDiskEncryptionPasswords();
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }
}

