/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DimensionLine
extends HomeObject
implements Selectable,
Elevatable {
    private static final long serialVersionUID = 1L;
    private float xStart;
    private float yStart;
    private float xEnd;
    private float yEnd;
    private float offset;
    private TextStyle lengthStyle;
    private Level level;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient Shape shapeCache;

    public DimensionLine(float f, float f2, float f3, float f4, float f5) {
        this.xStart = f;
        this.yStart = f2;
        this.xEnd = f3;
        this.yEnd = f4;
        this.offset = f5;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        objectInputStream.defaultReadObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public float getXStart() {
        return this.xStart;
    }

    public void setXStart(float f) {
        if (f != this.xStart) {
            float f2 = this.xStart;
            this.xStart = f;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.X_START.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getYStart() {
        return this.yStart;
    }

    public void setYStart(float f) {
        if (f != this.yStart) {
            float f2 = this.yStart;
            this.yStart = f;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.Y_START.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getXEnd() {
        return this.xEnd;
    }

    public void setXEnd(float f) {
        if (f != this.xEnd) {
            float f2 = this.xEnd;
            this.xEnd = f;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.X_END.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getYEnd() {
        return this.yEnd;
    }

    public void setYEnd(float f) {
        if (f != this.yEnd) {
            float f2 = this.yEnd;
            this.yEnd = f;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.Y_END.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float f) {
        if (f != this.offset) {
            float f2 = this.offset;
            this.offset = f;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.OFFSET.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getLength() {
        return (float)Point2D.distance(this.getXStart(), this.getYStart(), this.getXEnd(), this.getYEnd());
    }

    public TextStyle getLengthStyle() {
        return this.lengthStyle;
    }

    public void setLengthStyle(TextStyle textStyle) {
        if (textStyle != this.lengthStyle) {
            TextStyle textStyle2 = this.lengthStyle;
            this.lengthStyle = textStyle;
            this.propertyChangeSupport.firePropertyChange(Property.LENGTH_STYLE.name(), textStyle2, textStyle);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            Level level2 = this.level;
            this.level = level;
            this.propertyChangeSupport.firePropertyChange(Property.LEVEL.name(), level2, level);
        }
    }

    public boolean isAtLevel(Level level) {
        return this.level == level || this.level != null && level != null && this.level.getElevation() == level.getElevation() && this.level.getElevationIndex() < level.getElevationIndex();
    }

    public float[][] getPoints() {
        double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
        float f = (float)(-Math.sin(d)) * this.offset;
        float f2 = (float)Math.cos(d) * this.offset;
        return new float[][]{{this.xStart, this.yStart}, {this.xStart + f, this.yStart + f2}, {this.xEnd + f, this.yEnd + f2}, {this.xEnd, this.yEnd}};
    }

    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return this.getShape().intersects(float_);
    }

    public boolean containsPoint(float f, float f2, float f3) {
        return this.containsShapeAtWithMargin(this.getShape(), f, f2, f3);
    }

    public boolean isMiddlePointAt(float f, float f2, float f3) {
        double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
        float f4 = (float)(-Math.sin(d)) * this.offset;
        float f5 = (float)Math.cos(d) * this.offset;
        float f6 = (this.xStart + this.xEnd) / 2.0f + f4;
        float f7 = (this.yStart + this.yEnd) / 2.0f + f5;
        return Math.abs(f - f6) <= f3 && Math.abs(f2 - f7) <= f3;
    }

    public boolean containsStartExtensionLinetAt(float f, float f2, float f3) {
        double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
        Line2D.Float float_ = new Line2D.Float(this.xStart, this.yStart, this.xStart + (float)(-Math.sin(d)) * this.offset, this.yStart + (float)Math.cos(d) * this.offset);
        return this.containsShapeAtWithMargin(float_, f, f2, f3);
    }

    public boolean containsEndExtensionLineAt(float f, float f2, float f3) {
        double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
        Line2D.Float float_ = new Line2D.Float(this.xEnd, this.yEnd, this.xEnd + (float)(-Math.sin(d)) * this.offset, this.yEnd + (float)Math.cos(d) * this.offset);
        return this.containsShapeAtWithMargin(float_, f, f2, f3);
    }

    private boolean containsShapeAtWithMargin(Shape shape, float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return shape.contains(f, f2);
        }
        return shape.intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
    }

    private Shape getShape() {
        if (this.shapeCache == null) {
            double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
            float f = (float)(-Math.sin(d)) * this.offset;
            float f2 = (float)Math.cos(d) * this.offset;
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Line2D.Float(this.xStart + f, this.yStart + f2, this.xEnd + f, this.yEnd + f2), false);
            generalPath.append(new Line2D.Float(this.xStart, this.yStart, this.xStart + f, this.yStart + f2), false);
            generalPath.append(new Line2D.Float(this.xEnd, this.yEnd, this.xEnd + f, this.yEnd + f2), false);
            this.shapeCache = generalPath;
        }
        return this.shapeCache;
    }

    public void move(float f, float f2) {
        this.setXStart(this.getXStart() + f);
        this.setYStart(this.getYStart() + f2);
        this.setXEnd(this.getXEnd() + f);
        this.setYEnd(this.getYEnd() + f2);
    }

    public DimensionLine clone() {
        DimensionLine dimensionLine = (DimensionLine)super.clone();
        dimensionLine.propertyChangeSupport = new PropertyChangeSupport(dimensionLine);
        dimensionLine.level = null;
        return dimensionLine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        X_START,
        Y_START,
        X_END,
        Y_END,
        OFFSET,
        LENGTH_STYLE,
        LEVEL;

    }
}

