/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdiplus;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.gdiplus.EMFPlusPathConstructor;
import org.freehep.graphicsio.emf.gdiplus.EMFPlusTag;
import org.freehep.graphicsio.emf.gdiplus.PathPoint;

public class GDIPlusObject
extends EMFPlusTag {
    protected static final int INVALID = 0;
    protected static final int BRUSH = 256;
    protected static final int PEN = 512;
    protected static final int PATH = 768;
    protected static final int REGION = 1024;
    protected static final int IMAGE = 1280;
    protected static final int FONT = 1536;
    protected static final int STRING_FORMAT = 1792;
    protected static final int IMAGE_ATTRIBUTES = 2048;
    protected static final int CUSTOM_LINE_CAP = 2304;
    protected static final int BRUSH_TYPE_SOLID_COLOR = 0;
    protected static final int BRUSH_TYPE_HATCH_FILL = 1;
    protected static final int BRUSH_TYPE_TEXTURE_GRADIENT = 2;
    protected static final int BRUSH_TYPE_PATH_GRADIENT = 3;
    protected static final int BRUSH_TYPE_LINEAR_GRADIENT = 4;
    protected static final int WRAP_MODE_TYLE = 0;
    protected static final int WRAP_MODE_TYLE_FLIP_X = 1;
    protected static final int WRAP_MODE_TYLE_FLIP_Y = 2;
    protected static final int WRAP_MODE_TYLE_FLIP_XY = 3;
    protected static final int WRAP_MODE_CLAMP = 4;
    protected static final int IMAGE_TYPE_UNKNOWN = 0;
    protected static final int IMAGE_TYPE_BITMAP = 1;
    protected static final int IMAGE_TYPE_METAFILE = 2;
    protected static final int FILL_MODE_ALTERNATE = 0;
    protected static final int FILL_MODE_WINDING = 8192;
    private Paint brush;
    private BasicStroke stroke;
    private PathPoint[] path;
    private int pathFillMode;
    private RenderedImage image;

    public GDIPlusObject() {
        super(8, 1);
    }

    public GDIPlusObject(int index, Paint brush) {
        this();
        this.brush = brush;
        this.flags = index | 0x100;
    }

    public GDIPlusObject(int index, Stroke stroke, Paint brush) {
        this();
        if (!(stroke instanceof BasicStroke)) {
            throw new IllegalArgumentException(this.getClass() + ": can only handle Stroke of class BasicStroke");
        }
        this.stroke = (BasicStroke)stroke;
        this.brush = brush;
        this.flags = index | 0x200;
    }

    public GDIPlusObject(int index, Shape shape, boolean windingFill) {
        this();
        try {
            EMFPlusPathConstructor p = new EMFPlusPathConstructor();
            p.reset();
            p.addPath(shape);
            this.path = p.getPath();
            this.flags = index | 0x300;
            this.pathFillMode = windingFill ? 8192 : 0;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public GDIPlusObject(int index, RenderedImage image) {
        this();
        this.image = image;
        this.flags = index | 0x500;
    }

    public EMFPlusTag read(int tagID, int flags, EMFInputStream emf, int len) throws IOException {
        GDIPlusObject tag = new GDIPlusObject();
        tag.flags = flags;
        int type = flags & 0xFF00;
        switch (type) {
            case 256: {
                tag.brush = this.readBrush(emf);
                break;
            }
            case 512: {
                emf.readUINT();
                emf.readUINT();
                emf.readUINT();
                emf.readUINT();
                float lineWidth = emf.readFLOAT();
                tag.stroke = new BasicStroke(lineWidth);
                tag.brush = this.readBrush(emf);
                break;
            }
            case 768: {
                int i;
                emf.readUINT();
                tag.path = new PathPoint[emf.readUINT()];
                int moreFlags = emf.readUINT();
                this.pathFillMode = moreFlags & 0x2000;
                for (i = 0; i < tag.path.length; ++i) {
                    tag.path[i] = new PathPoint();
                    tag.path[i].setX(emf.readFLOAT());
                    tag.path[i].setY(emf.readFLOAT());
                }
                for (i = 0; i < tag.path.length; ++i) {
                    tag.path[i].setType(emf.readUnsignedByte());
                }
                if (tag.path.length % 4 <= 0) break;
                for (i = 4 - tag.path.length % 4; i > 0; --i) {
                    emf.readBYTE();
                }
                break;
            }
            default: {
                System.err.println("GDIObject: Invalid TYPE: " + Integer.toHexString(type));
            }
        }
        return tag;
    }

    public void write(int tagID, int flags, EMFOutputStream emf) throws IOException {
        int type = flags & 0xFF00;
        switch (type) {
            case 256: {
                this.writeBrush(emf, this.brush);
                break;
            }
            case 512: {
                emf.writeUINT(-608169983);
                emf.writeUINT(0);
                emf.writeUINT(0);
                emf.writeUINT(0);
                emf.writeFLOAT(this.stroke.getLineWidth());
                this.writeBrush(emf, this.brush);
                break;
            }
            case 768: {
                int i;
                emf.writeUINT(-608169983);
                emf.writeUINT(this.path.length);
                emf.writeUINT(this.pathFillMode);
                for (i = 0; i < this.path.length; ++i) {
                    emf.writeFLOAT(this.path[i].getX());
                    emf.writeFLOAT(this.path[i].getY());
                }
                for (i = 0; i < this.path.length; ++i) {
                    emf.writeUnsignedByte(this.path[i].getType());
                }
                if (this.path.length % 4 <= 0) break;
                for (i = 4 - this.path.length % 4; i > 0; --i) {
                    emf.writeBYTE(0);
                }
                break;
            }
            case 1280: {
                this.writeImage(emf, this.image);
                break;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\n  ");
        int type = this.flags & 0xFF00;
        switch (type) {
            case 256: {
                sb.append("brush: " + this.brush);
                break;
            }
            case 512: {
                sb.append("stroke: " + this.stroke);
                sb.append("\n  brush: " + this.brush);
                break;
            }
            case 768: {
                sb.append("fillMode: " + this.pathFillMode);
                sb.append("\n  n: " + this.path.length);
                for (int i = 0; i < this.path.length; ++i) {
                    sb.append("\n  0x" + Integer.toHexString(this.path[i].getType()) + " (" + this.path[i].getX() + ", " + this.path[i].getY() + ")");
                }
                break;
            }
            default: {
                sb.append("UNKNOWN");
            }
        }
        return sb.toString();
    }

    private Paint readBrush(EMFInputStream emf) throws IOException {
        emf.readUINT();
        int brushType = emf.readUINT();
        switch (brushType) {
            case 0: {
                return emf.readCOLOR();
            }
            case 4: {
                emf.readUINT();
                return null;
            }
        }
        return Color.BLACK;
    }

    private void writeBrush(EMFOutputStream emf, Paint brush) throws IOException {
        emf.writeUINT(-608169983);
        if (brush instanceof Color) {
            emf.writeUINT(0);
            emf.writeCOLOR((Color)brush);
        } else if (brush instanceof GradientPaint) {
            GradientPaint paint = (GradientPaint)brush;
            emf.writeUINT(4);
            emf.writeUINT(2);
            emf.writeUINT(paint.isCyclic() ? 3 : 2);
            float x1 = (float)paint.getPoint1().getX();
            float y1 = (float)paint.getPoint1().getY();
            float x2 = (float)paint.getPoint2().getX();
            float y2 = (float)paint.getPoint2().getY();
            emf.writeFLOAT(Math.min(x1, x2));
            emf.writeFLOAT(Math.min(y1, y2));
            emf.writeFLOAT(Math.abs(x1 - x2));
            emf.writeFLOAT(Math.abs(y1 - y2));
            emf.writeCOLOR(paint.getColor1());
            emf.writeCOLOR(paint.getColor2());
            emf.writeCOLOR(paint.getColor1());
            emf.writeCOLOR(paint.getColor2());
            float dx = x2 - x1;
            float dy = y2 - y1;
            float scale = (float)paint.getPoint1().distance(paint.getPoint2()) / dx;
            System.err.println(paint.getPoint1() + " " + paint.getPoint2());
            System.err.println(x1 + " " + x2 + " " + y1 + " " + y2 + ":" + dx + " " + dy + " " + scale);
            float angle = (float)Math.atan2(dy, dx);
            AffineTransform transform = new AffineTransform(scale, 0.0f, 0.0f, scale, dx / 2.0f + x1, dy / 2.0f + y1);
            transform = new AffineTransform();
            transform.scale(scale, scale);
            transform.rotate(angle);
            GDIPlusObject.writeTransform(emf, transform);
        } else if (brush instanceof TexturePaint) {
            TexturePaint paint = (TexturePaint)brush;
            emf.writeUINT(2);
            emf.writeUINT(0);
            emf.writeUINT(0);
            this.writeImage(emf, paint.getImage());
        } else {
            System.err.println("No Brush for paint of class: " + brush.getClass() + " defaulting to black");
            emf.writeUINT(0);
            emf.writeCOLOR(Color.BLACK);
        }
    }

    public static void writeTransform(EMFOutputStream emf, AffineTransform transform) throws IOException {
        emf.writeFLOAT((float)transform.getScaleX());
        emf.writeFLOAT((float)transform.getShearY());
        emf.writeFLOAT((float)transform.getShearX());
        emf.writeFLOAT((float)transform.getScaleY());
        emf.writeFLOAT((float)transform.getTranslateX());
        emf.writeFLOAT((float)transform.getTranslateY());
    }

    private void writeImage(EMFOutputStream emf, RenderedImage image) throws IOException {
        emf.writeUINT(-608169983);
        emf.writeUINT(1);
        emf.writeUINT(0);
        emf.writeUINT(0);
        emf.writeUINT(0);
        emf.writeUINT(0);
        emf.writeUINT(1);
        ImageGraphics2D.writeImage((RenderedImage)image, (String)"png", (Properties)new Properties(), (OutputStream)((Object)emf));
    }
}

