/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdiplus;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.gdiplus.EMFPlusTag;

public class FillPath
extends EMFPlusTag {
    private Color brushColor = null;
    private int brushIndex;

    public FillPath() {
        super(20, 1);
    }

    public FillPath(int pathIndex, int brushIndex) {
        this();
        this.flags = pathIndex;
        this.brushIndex = brushIndex;
    }

    public EMFPlusTag read(int tagID, int flags, EMFInputStream emf, int len) throws IOException {
        FillPath tag = new FillPath();
        tag.flags = flags;
        if ((flags & 0x8000) > 0) {
            tag.brushColor = emf.readCOLOR();
        } else {
            tag.brushIndex = emf.readUINT();
        }
        return tag;
    }

    public void write(int tagID, int flags, EMFOutputStream emf) throws IOException {
        if (this.brushColor != null) {
            emf.writeCOLOR(this.brushColor);
        } else {
            emf.writeUINT(this.brushIndex);
        }
    }

    public String toString() {
        return super.toString() + "\n  " + (this.brushColor != null ? "brushColor: " + this.brushColor : "brushIndex: " + this.brushIndex);
    }
}

