/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdiplus;

import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class EMFPlusTag
extends EMFTag {
    private static final int OFFSET = 16384;

    protected EMFPlusTag(int id, int version) {
        super(id + 16384, version + 16384);
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        len = emf.readUINT();
        return this.read(tagID - 16384, this.flags, emf, len);
    }

    public abstract EMFPlusTag read(int var1, int var2, EMFInputStream var3, int var4) throws IOException;

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.pushBuffer();
        this.write(tagID - 16384, this.flags, emf);
        int len = emf.popBuffer();
        emf.writeUINT(len);
        emf.append();
    }

    public abstract void write(int var1, int var2, EMFOutputStream var3) throws IOException;

    public String toString() {
        int id = this.getTag();
        String s = "EMF+Tag " + this.getName() + " (" + id + ") (0x" + Integer.toHexString(id) + ")\n";
        s = s + "  flags: 0x" + Integer.toHexString(this.flags);
        return s;
    }
}

