/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.util.io.Tag;

public class GDIComment
extends EMFTag {
    private static final String EMF_PLUS = "EMF+";
    private byte[] bytes;
    private EMFTag tag;

    public GDIComment() {
        super(70, 1);
    }

    public GDIComment(String comment) {
        this(comment.getBytes());
    }

    public GDIComment(byte[] bytes) {
        this();
        this.bytes = bytes;
    }

    public GDIComment(EMFTag tag) {
        this();
        this.tag = tag;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int l = emf.readDWORD();
        GDIComment tag = new GDIComment(emf.readBYTE(l));
        if (l % 4 != 0) {
            emf.readBYTE(4 - l % 4);
        }
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        if (this.tag != null) {
            emf.pushBuffer();
            emf.writeBYTE(EMF_PLUS.getBytes());
            emf.writeTag(this.tag, true);
            int len = emf.popBuffer();
            emf.writeDWORD(len);
            emf.append();
        } else {
            emf.writeDWORD(this.bytes.length);
            emf.writeBYTE(this.bytes);
            if (this.bytes.length % 4 != 0) {
                for (int i = 0; i < 4 - this.bytes.length % 4; ++i) {
                    emf.writeBYTE(0);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\n");
        sb.append("  length: ");
        sb.append(this.bytes.length);
        sb.append("\n");
        String s = new String(this.bytes);
        if (s.startsWith(EMF_PLUS)) {
            try {
                EMFInputStream emf = new EMFInputStream((InputStream)new ByteArrayInputStream(this.bytes, 4, this.bytes.length - 4), 16385);
                sb.append(" --> Embedding:\n");
                Tag emfPlusTag = emf.readTag();
                while (emfPlusTag != null) {
                    sb.append(emfPlusTag);
                    emfPlusTag = emf.readTag();
                    if (emfPlusTag == null) continue;
                    sb.append("\n");
                }
                ((InputStream)((Object)emf)).close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        } else {
            int n = Math.min(this.bytes.length, 40);
            sb.append("  bytes: ");
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.bytes[i]));
            }
            sb.append(" ");
            sb.append(new String(this.bytes));
        }
        return sb.toString();
    }

    public void render(EMFRenderer renderer) {
    }
}

