/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.io.IOException;
import java.util.logging.Logger;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTagHeader;
import org.freehep.graphicsio.emf.gdi.GDIObject;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TaggedInputStream;
import org.freehep.util.io.TaggedOutputStream;

public abstract class EMFTag
extends Tag
implements GDIObject {
    protected static final Logger logger = Logger.getLogger("org.freehep.graphicsio.emf");
    protected int flags = 0;

    protected EMFTag(int id, int version) {
        super(id, version);
    }

    public Tag read(int tagID, TaggedInputStream input, int len) throws IOException {
        EMFInputStream emf = (EMFInputStream)input;
        EMFTagHeader tagHeader = (EMFTagHeader)emf.getTagHeader();
        this.flags = tagHeader.getFlags();
        return this.read(tagID, emf, len);
    }

    public abstract EMFTag read(int var1, EMFInputStream var2, int var3) throws IOException;

    public void write(int tagID, TaggedOutputStream output) throws IOException {
        this.write(tagID, (EMFOutputStream)output);
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        int id = this.getTag();
        return "EMFTag " + this.getName() + " (" + id + ") (0x" + Integer.toHexString(id) + ")";
    }

    public void render(EMFRenderer renderer) {
        logger.warning("EMF tag not supported: " + this.toString());
    }
}

