/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.emf.EMFHandleManager;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.gdi.EOF;
import org.freehep.graphicsio.emf.gdiplus.Clear;
import org.freehep.graphicsio.emf.gdiplus.DrawImage;
import org.freehep.graphicsio.emf.gdiplus.DrawPath;
import org.freehep.graphicsio.emf.gdiplus.EndOfFile;
import org.freehep.graphicsio.emf.gdiplus.FillPath;
import org.freehep.graphicsio.emf.gdiplus.GDIPlusObject;
import org.freehep.graphicsio.emf.gdiplus.Header;
import org.freehep.graphicsio.emf.gdiplus.MultiplyWorldTransform;
import org.freehep.graphicsio.emf.gdiplus.ResetClip;
import org.freehep.graphicsio.emf.gdiplus.Restore;
import org.freehep.graphicsio.emf.gdiplus.Save;
import org.freehep.graphicsio.emf.gdiplus.SetAntiAliasMode;
import org.freehep.graphicsio.emf.gdiplus.SetClipPath;
import org.freehep.graphicsio.emf.gdiplus.SetWorldTransform;
import org.freehep.util.UserProperties;
import org.freehep.util.Value;

public class EMFPlusGraphics2D
extends AbstractVectorGraphicsIO {
    public static final String version = "$Revision: 10140 $";
    private OutputStream ros;
    private EMFOutputStream os;
    private Rectangle imageBounds;
    private EMFHandleManager handleManager;
    private Value containerIndex;
    private Paint restorePaint;
    private static final String rootKey = (class$org$freehep$graphicsio$emf$EMFPlusGraphics2D == null ? (class$org$freehep$graphicsio$emf$EMFPlusGraphics2D = EMFPlusGraphics2D.class$("org.freehep.graphicsio.emf.EMFPlusGraphics2D")) : class$org$freehep$graphicsio$emf$EMFPlusGraphics2D).getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    private static final UserProperties defaultProperties = new UserProperties();
    static /* synthetic */ Class class$org$freehep$graphicsio$emf$EMFPlusGraphics2D;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), true, true);
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public EMFPlusGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public EMFPlusGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public EMFPlusGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.imageBounds = new Rectangle(0, 0, size.width, size.height);
        this.init(os);
    }

    public EMFPlusGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.imageBounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.handleManager = new EMFHandleManager();
        this.ros = os;
        this.containerIndex = new Value();
        this.containerIndex.set(0);
        this.initProperties((Properties)defaultProperties);
    }

    protected EMFPlusGraphics2D(EMFPlusGraphics2D graphics, boolean doRestoreOnDispose) {
        super((AbstractVectorGraphicsIO)graphics, doRestoreOnDispose);
        this.os = graphics.os;
        this.imageBounds = graphics.imageBounds;
        this.handleManager = graphics.handleManager;
        this.containerIndex = graphics.containerIndex;
        this.restorePaint = graphics.getPaint();
    }

    public void writeHeader() throws IOException {
        this.ros = new BufferedOutputStream(this.ros);
        Dimension device = this.isDeviceIndependent() ? new Dimension(1024, 768) : Toolkit.getDefaultToolkit().getScreenSize();
        String producer = ((Object)((Object)this)).getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os = new EMFOutputStream(this.ros, this.imageBounds, this.handleManager, this.getCreator(), producer, device, 16385);
        this.os.writeTag(new Header());
        this.os.writeTag(new SetAntiAliasMode(true));
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.os.writeTag(new Clear(this.getBackground()));
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.os.writeTag(new Clear(this.getBackground()));
        }
    }

    public void writeTrailer() throws IOException {
        int handle;
        while ((handle = this.handleManager.highestHandleInUse()) >= 0) {
            this.handleManager.freeHandle(handle);
        }
        this.os.writeTag(new EndOfFile());
        this.os.writeTag(new EOF());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new EMFPlusGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        EMFPlusGraphics2D graphics = new EMFPlusGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.writeTag(new Save(this.containerIndex.getInt()));
        this.containerIndex.set(this.containerIndex.getInt() + 1);
    }

    protected void writeGraphicsRestore() throws IOException {
        this.containerIndex.set(this.containerIndex.getInt() - 1);
        this.os.writeTag(new Restore(this.containerIndex.getInt()));
        if (this.restorePaint != null) {
            this.writePaint(this.restorePaint);
        }
    }

    public void draw(Shape shape) {
        try {
            Stroke stroke = this.getStroke();
            if (stroke instanceof BasicStroke && ((BasicStroke)stroke).getLineWidth() == 0.0f) {
                this.os.writeTag(new GDIPlusObject(1, shape, false));
                this.os.writeTag(new GDIPlusObject(2, new BasicStroke(0.0f), this.getPaint()));
                this.os.writeTag(new DrawPath(1, 2));
            } else {
                Shape strokedShape = this.getStroke().createStrokedShape(shape);
                this.fill(new Area(strokedShape));
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape shape) {
        try {
            this.os.writeTag(new GDIPlusObject(1, shape, false));
            this.os.writeTag(new FillPath(1, 0));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        this.writeGraphicsSave();
        this.os.writeTag(new GDIPlusObject(5, image));
        this.os.writeTag(new MultiplyWorldTransform(xform, true));
        this.os.writeTag(new DrawImage(5, image));
        this.writeGraphicsRestore();
    }

    protected void writeString(String string, double x, double y) throws IOException {
    }

    protected void writeTransform(AffineTransform t) throws IOException {
        this.os.writeTag(new MultiplyWorldTransform(t, true));
    }

    protected void writeSetTransform(AffineTransform t) throws IOException {
        this.os.writeTag(new SetWorldTransform(t));
    }

    protected void writeClip(Shape s) throws IOException {
        this.os.writeTag(new GDIPlusObject(4, s, false));
        this.os.writeTag(new SetClipPath(4, 1));
    }

    protected void writeSetClip(Shape s) throws IOException {
        if (s != null) {
            this.os.writeTag(new GDIPlusObject(4, s, false));
            this.os.writeTag(new SetClipPath(4, 0));
        } else {
            this.os.writeTag(new ResetClip());
        }
    }

    protected void writeWidth(float width) throws IOException {
    }

    protected void writeCap(int cap) throws IOException {
    }

    protected void writeJoin(int join) throws IOException {
    }

    protected void writeMiterLimit(float limit) throws IOException {
    }

    protected void writeDash(float[] dash, float phase) throws IOException {
    }

    public void setPaintMode() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color p) throws IOException {
        this.os.writeTag(new GDIPlusObject(0, p));
    }

    protected void writePaint(GradientPaint p) throws IOException {
        this.os.writeTag(new GDIPlusObject(0, p));
    }

    protected void writePaint(TexturePaint p) throws IOException {
        this.os.writeTag(new GDIPlusObject(0, p));
    }

    protected void writePaint(Paint p) throws IOException {
        this.os.writeTag(new GDIPlusObject(0, p));
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String comment) throws IOException {
        this.writeWarning(((Object)((Object)this)).getClass() + ": writeComment(String) not implemented.");
    }

    protected void writeWarning(String string) {
        System.err.println(string);
    }

    public String toString() {
        return "EMFPlusGraphics2D";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(AbstractVectorGraphicsIO.CLIP, true);
        defaultProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, true);
    }
}

