/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.history_browser.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.history_browser.CommandHistory;
import org.scilab.modules.history_browser.CommandHistoryMessages;

public final class CopyAction
extends CommonCallBack {
    private static final long serialVersionUID = 1L;
    private static final String LABEL = CommandHistoryMessages.COPY;
    private static final String ICON = FindIconHelper.findIcon((String)"edit-copy");
    private static final char MNEMONIC = 'C';
    private static final String KEY = "OSSCKEY C";
    private static final String COPY = "COPY";

    public CopyAction() {
        super("");
    }

    public static void registerKeyAction() {
        CommandHistory.getTree().getActionMap().put(COPY, (Action)((Object)new CopyAction()));
        CommandHistory.getTree().getInputMap().put(ScilabKeyStroke.getKeyStroke((String)KEY), COPY);
    }

    public static MenuItem createMenuItem() {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setText(LABEL);
        menuItem.setMnemonic('C');
        menuItem.setCallback(CopyAction.getCallBack());
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setIcon((Icon)new ImageIcon(ICON));
        return menuItem;
    }

    public static JButton createPushButton() {
        JButton jButton = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        jButton.setIcon(new ImageIcon(ICON));
        jButton.setToolTipText(LABEL);
        jButton.addActionListener((ActionListener)CopyAction.getCallBack());
        return jButton;
    }

    private static CommonCallBack getCallBack() {
        CommonCallBack commonCallBack = null;
        try {
            commonCallBack = (CommonCallBack)CopyAction.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return commonCallBack;
    }

    public void callBack() {
        String string = CommandHistory.getSelectedCommands();
        if (string == null) {
            return;
        }
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }
}

