/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.utils;

import com.mxgraph.io.mxCodec;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxStylesheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Logger;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.xcos.utils.XcosMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class FileUtils {
    public static final String STYLE_FILENAME = "Xcos-style.xml";

    private FileUtils() {
    }

    public static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileChannel fileChannel = fileInputStream.getChannel();
        FileChannel fileChannel2 = fileOutputStream.getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            Logger.getLogger(FileUtils.class.getName()).warning(iOException.toString());
            throw iOException;
        }
        finally {
            fileChannel.close();
            fileInputStream.close();
            fileChannel2.close();
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceCopy(File file, File file2) {
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
        if (!file2.exists()) {
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                Logger.getLogger(FileUtils.class.getName()).warning(iOException.toString());
            }
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            abstractInterruptibleChannel2 = fileOutputStream.getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferTo(0L, ((FileChannel)abstractInterruptibleChannel).size(), (WritableByteChannel)((Object)abstractInterruptibleChannel2));
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(FileUtils.class.getName()).warning(iOException.toString());
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(FileUtils.class.getName()).warning(iOException.toString());
                }
            }
            if (abstractInterruptibleChannel2 != null) {
                try {
                    abstractInterruptibleChannel2.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(FileUtils.class.getName()).warning(iOException.toString());
                }
            }
        }
    }

    public static void delete(File file) {
        if (!file.delete()) {
            Logger.getLogger(FileUtils.class.getName()).severe(XcosMessages.UNABLE_TO_DELETE + file);
        }
    }

    public static void delete(String string) {
        if (!new File(string).delete()) {
            Logger.getLogger(FileUtils.class.getName()).severe(XcosMessages.UNABLE_TO_DELETE + string);
        }
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static void decodeStyle(mxStylesheet mxStylesheet2) throws IOException {
        String string = ScilabConstants.SCI.getAbsolutePath();
        File file = new File(string + "/modules/xcos/etc/" + STYLE_FILENAME);
        String string2 = ScilabConstants.SCIHOME.getAbsolutePath();
        File file2 = new File(string2 + '/' + STYLE_FILENAME);
        String string3 = ScilabConstants.SCI.toURI().toURL().toString();
        String string4 = ScilabConstants.SCIHOME.toURI().toURL().toString();
        String string5 = mxUtils.readFile((String)file.getAbsolutePath());
        string5 = string5.replaceAll("\\$SCILAB", string3);
        string5 = string5.replaceAll("\\$SCIHOME", string4);
        Document document = mxXmlUtils.parseXml((String)string5);
        new mxCodec().decode((Node)document.getDocumentElement(), (Object)mxStylesheet2);
        if (file2.exists()) {
            string5 = mxUtils.readFile((String)file2.getAbsolutePath());
            string5 = string5.replaceAll("\\$SCILAB", string3);
            string5 = string5.replaceAll("\\$SCIHOME", string4);
            document = mxXmlUtils.parseXml((String)string5);
            new mxCodec().decode((Node)document.getDocumentElement(), (Object)mxStylesheet2);
        }
    }

    public static String toValidCIdentifier(String string) {
        String string2 = mxUtils.getBodyMarkup((String)string, (boolean)true);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                stringBuilder.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                stringBuilder.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (stringBuilder.length() <= 0) continue;
                stringBuilder.append(c);
                continue;
            }
            if (c != '_' && c != ' ') continue;
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }
}

