/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.utils;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxStyleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.io.scicos.BasicBlockInfo;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.Orientation;
import org.scilab.modules.xcos.utils.XcosConstants;

public final class BlockPositioning {
    public static final double DEFAULT_GRIDSIZE = Double.MIN_NORMAL;
    public static final int ROTATION_STEP = 90;
    public static final int MAX_ROTATION = 360;

    private BlockPositioning() {
    }

    public static void updateWestPortsPosition(XcosDiagram xcosDiagram, BasicBlock basicBlock, List<? extends BasicPort> list) {
        double d = xcosDiagram.getGridSize();
        mxGeometry mxGeometry2 = basicBlock.getGeometry();
        assert (mxGeometry2 != null);
        int n = list.size();
        double d2 = mxGeometry2.getHeight();
        double d3 = d2 / (double)(n + 1);
        xcosDiagram.getModel().beginUpdate();
        int n2 = 0;
        while (n2 < n) {
            BasicPort basicPort = list.get(n2);
            mxGeometry mxGeometry3 = (mxGeometry)basicPort.getGeometry().clone();
            double d4 = -mxGeometry3.getWidth();
            int n3 = n2++;
            double d5 = BlockPositioning.calculateAlignedPosition(d, d3, n3);
            mxGeometry3.setX(d4);
            mxGeometry3.setY(d5);
            xcosDiagram.getModel().setGeometry((Object)basicPort, mxGeometry3);
            xcosDiagram.getModel().setStyle((Object)basicPort, basicPort.computeLabelPosition(Orientation.WEST));
        }
        xcosDiagram.getModel().endUpdate();
    }

    private static double calculateAlignedPosition(double d, double d2, int n) {
        double d3 = (double)(n + 1) * d2;
        double d4 = d3 - Math.IEEEremainder(d3, d);
        double d5 = d4 - 4.0;
        return d5;
    }

    public static void updateNorthPortsPosition(XcosDiagram xcosDiagram, BasicBlock basicBlock, List<? extends BasicPort> list) {
        double d = xcosDiagram.getGridSize();
        mxGeometry mxGeometry2 = basicBlock.getGeometry();
        assert (mxGeometry2 != null);
        int n = list.size();
        double d2 = mxGeometry2.getWidth();
        double d3 = d2 / (double)(n + 1);
        xcosDiagram.getModel().beginUpdate();
        int n2 = 0;
        while (n2 < n) {
            BasicPort basicPort = list.get(n2);
            mxGeometry mxGeometry3 = (mxGeometry)basicPort.getGeometry().clone();
            double d4 = -mxGeometry3.getHeight();
            int n3 = n2++;
            double d5 = BlockPositioning.calculateAlignedPosition(d, d3, n3);
            mxGeometry3.setX(d5);
            mxGeometry3.setY(d4);
            xcosDiagram.getModel().setGeometry((Object)basicPort, mxGeometry3);
            xcosDiagram.getModel().setStyle((Object)basicPort, basicPort.computeLabelPosition(Orientation.NORTH));
        }
        xcosDiagram.getModel().endUpdate();
    }

    public static void updateEastPortsPosition(XcosDiagram xcosDiagram, BasicBlock basicBlock, List<? extends BasicPort> list) {
        double d = xcosDiagram.getGridSize();
        mxGeometry mxGeometry2 = basicBlock.getGeometry();
        assert (mxGeometry2 != null);
        int n = list.size();
        double d2 = mxGeometry2.getHeight();
        double d3 = d2 / (double)(n + 1);
        xcosDiagram.getModel().beginUpdate();
        int n2 = 0;
        while (n2 < n) {
            BasicPort basicPort = list.get(n2);
            mxGeometry mxGeometry3 = (mxGeometry)basicPort.getGeometry().clone();
            double d4 = mxGeometry2.getWidth();
            int n3 = n2++;
            double d5 = BlockPositioning.calculateAlignedPosition(d, d3, n3);
            mxGeometry3.setX(d4);
            mxGeometry3.setY(d5);
            xcosDiagram.getModel().setGeometry((Object)basicPort, mxGeometry3);
            xcosDiagram.getModel().setStyle((Object)basicPort, basicPort.computeLabelPosition(Orientation.EAST));
        }
        xcosDiagram.getModel().endUpdate();
    }

    public static void updateSouthPortsPosition(XcosDiagram xcosDiagram, BasicBlock basicBlock, List<? extends BasicPort> list) {
        double d = xcosDiagram.getGridSize();
        mxGeometry mxGeometry2 = basicBlock.getGeometry();
        assert (mxGeometry2 != null);
        int n = list.size();
        double d2 = mxGeometry2.getWidth();
        double d3 = d2 / (double)(n + 1);
        xcosDiagram.getModel().beginUpdate();
        int n2 = 0;
        while (n2 < n) {
            BasicPort basicPort = list.get(n2);
            mxGeometry mxGeometry3 = (mxGeometry)basicPort.getGeometry().clone();
            double d4 = mxGeometry2.getHeight();
            int n3 = n2++;
            double d5 = BlockPositioning.calculateAlignedPosition(d, d3, n3);
            mxGeometry3.setX(d5);
            mxGeometry3.setY(d4);
            xcosDiagram.getModel().setGeometry((Object)basicPort, mxGeometry3);
            xcosDiagram.getModel().setStyle((Object)basicPort, basicPort.computeLabelPosition(Orientation.SOUTH));
        }
        xcosDiagram.getModel().endUpdate();
    }

    public static void updatePortsPosition(XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        Map<Orientation, List<BasicPort>> map = BasicBlockInfo.getAllOrientedPorts(basicBlock);
        xcosDiagram.getModel().beginUpdate();
        for (Orientation orientation : Orientation.values()) {
            List<BasicPort> list = map.get((Object)orientation);
            if (list == null || list.isEmpty()) continue;
            BlockPositioning.updatePortsPositions(xcosDiagram, basicBlock, list, orientation);
        }
        xcosDiagram.getModel().endUpdate();
    }

    private static void updatePortsPositions(XcosDiagram xcosDiagram, BasicBlock basicBlock, List<BasicPort> arrayList, Orientation orientation) {
        ArrayList<BasicPort> arrayList2 = new ArrayList<BasicPort>(arrayList){
            {
                Collections.reverse(this);
            }
        };
        JavaController javaController = new JavaController();
        String[] stringArray = new String[1];
        javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.STYLE, stringArray);
        StyleMap styleMap = new StyleMap(stringArray[0]);
        boolean bl = Boolean.TRUE.toString().equals(styleMap.get((Object)"mirror"));
        boolean bl2 = Boolean.TRUE.toString().equals(styleMap.get((Object)"flip"));
        int n = Double.valueOf((String)styleMap.getOrDefault((Object)XcosConstants.STYLE_ROTATION, (Object)"0")).intValue();
        int n2 = (Math.round(n) % 360 + 360) % 360;
        ArrayList<BasicPort> arrayList3 = arrayList;
        if (bl2 && (orientation == Orientation.NORTH || orientation == Orientation.SOUTH)) {
            arrayList3 = arrayList2;
        }
        if (bl && (orientation == Orientation.EAST || orientation == Orientation.WEST)) {
            arrayList3 = arrayList2;
        }
        Orientation orientation2 = BlockPositioning.rotateOrientation(orientation, bl, bl2);
        BlockPositioning.updatePortsPosition(xcosDiagram, basicBlock, orientation2, n2, (List<BasicPort>)arrayList3);
    }

    private static Orientation rotateOrientation(Orientation orientation, boolean bl, boolean bl2) {
        int n = Orientation.values().length;
        Orientation orientation2 = orientation;
        if (bl && (orientation2 == Orientation.EAST || orientation2 == Orientation.WEST)) {
            orientation2 = Orientation.values()[(orientation2.ordinal() + 2) % n];
        }
        if (bl2 && (orientation2 == Orientation.NORTH || orientation2 == Orientation.SOUTH)) {
            orientation2 = Orientation.values()[(orientation2.ordinal() + 2) % n];
        }
        return orientation2;
    }

    private static void updatePortsPosition(XcosDiagram xcosDiagram, BasicBlock basicBlock, Orientation orientation, double d, List<BasicPort> list) {
        int n = Orientation.values().length;
        Orientation orientation2 = orientation;
        double d2 = d / 90.0;
        orientation2 = Orientation.values()[(orientation2.ordinal() + (int)d2) % n];
        switch (orientation2) {
            case NORTH: {
                BlockPositioning.updateNorthPortsPosition(xcosDiagram, basicBlock, list);
                break;
            }
            case SOUTH: {
                BlockPositioning.updateSouthPortsPosition(xcosDiagram, basicBlock, list);
                break;
            }
            case EAST: {
                BlockPositioning.updateEastPortsPosition(xcosDiagram, basicBlock, list);
                break;
            }
            case WEST: {
                BlockPositioning.updateWestPortsPosition(xcosDiagram, basicBlock, list);
                break;
            }
        }
    }

    public static void rotateAllPorts(XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        JavaController javaController = new JavaController();
        String[] stringArray = new String[1];
        javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.STYLE, stringArray);
        StyleMap styleMap = new StyleMap(stringArray[0]);
        boolean bl = Boolean.TRUE.toString().equals(styleMap.get((Object)"mirror"));
        boolean bl2 = Boolean.TRUE.toString().equals(styleMap.get((Object)"flip"));
        int n = Double.valueOf((String)styleMap.getOrDefault((Object)XcosConstants.STYLE_ROTATION, (Object)"0")).intValue();
        int n2 = (Math.round(n) % 360 + 360) % 360;
        int n3 = basicBlock.getChildCount();
        for (int i = 0; i < n3; ++i) {
            if (!(basicBlock.getChildAt(i) instanceof BasicPort)) continue;
            BasicPort basicPort = (BasicPort)basicBlock.getChildAt(i);
            Orientation orientation = basicPort.getOrientation();
            xcosDiagram.getModel().beginUpdate();
            mxIGraphModel mxIGraphModel2 = xcosDiagram.getModel();
            String string = Integer.toString(orientation.getRelativeAngle(n2, ((Object)((Object)basicPort)).getClass(), bl2, bl));
            mxStyleUtils.setCellStyles((mxIGraphModel)mxIGraphModel2, (Object[])new Object[]{basicPort}, (String)XcosConstants.STYLE_ROTATION, (String)string);
            xcosDiagram.getModel().endUpdate();
        }
    }

    public static void updateBlockView(XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        if (basicBlock.getKind() != Kind.BLOCK) {
            return;
        }
        xcosDiagram.getModel().beginUpdate();
        basicBlock.updateBlockView();
        BlockPositioning.updatePortsPosition(xcosDiagram, basicBlock);
        BlockPositioning.rotateAllPorts(xcosDiagram, basicBlock);
        xcosDiagram.getModel().endUpdate();
    }

    public static void updatePortsPosition(XcosDiagram xcosDiagram, Object[] objectArray) {
        xcosDiagram.getModel().beginUpdate();
        for (Object object : objectArray) {
            BasicBlock basicBlock = (BasicBlock)object;
            BlockPositioning.updatePortsPosition(xcosDiagram, basicBlock);
        }
        xcosDiagram.getModel().endUpdate();
    }

    public static void toggleFlip(XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        StyleMap styleMap = new StyleMap(basicBlock.getStyle());
        boolean bl = !Boolean.TRUE.toString().equals(styleMap.get((Object)"flip"));
        styleMap.put((Object)"flip", (Object)Boolean.toString(bl));
        xcosDiagram.getModel().setStyle((Object)basicBlock, styleMap.toString());
        BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
    }

    public static void toggleMirror(XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        StyleMap styleMap = new StyleMap(basicBlock.getStyle());
        boolean bl = !Boolean.TRUE.toString().equals(styleMap.get((Object)"mirror"));
        styleMap.put((Object)"mirror", (Object)Boolean.toString(bl));
        xcosDiagram.getModel().setStyle((Object)basicBlock, styleMap.toString());
        BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
    }

    public static void toggleAntiClockwiseRotation(XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        StyleMap styleMap = new StyleMap(basicBlock.getStyle());
        BlockPositioning.computeNextAntiClockwiseAngle(styleMap);
        mxGeometry mxGeometry2 = basicBlock.getGeometry();
        mxGeometry mxGeometry3 = new mxGeometry(mxGeometry2.getCenterX() - mxGeometry2.getHeight() / 2.0, mxGeometry2.getCenterY() - mxGeometry2.getWidth() / 2.0, mxGeometry2.getHeight(), mxGeometry2.getWidth());
        xcosDiagram.getModel().setGeometry((Object)basicBlock, mxGeometry3);
        xcosDiagram.getModel().setStyle((Object)basicBlock, styleMap.toString());
        BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
    }

    private static void computeNextAntiClockwiseAngle(StyleMap styleMap) {
        int n = Double.valueOf((String)styleMap.getOrDefault((Object)XcosConstants.STYLE_ROTATION, (Object)"0")).intValue();
        boolean bl = Boolean.TRUE.toString().equals(styleMap.get((Object)"flip"));
        boolean bl2 = Boolean.TRUE.toString().equals(styleMap.get((Object)"mirror"));
        int n2 = (n - 90 + 360) % 360;
        if (n2 > 90) {
            n2 -= 180;
            bl = !bl;
            boolean bl3 = bl2 = !bl2;
        }
        if (n2 == 0) {
            styleMap.remove((Object)XcosConstants.STYLE_ROTATION);
        } else {
            styleMap.put((Object)XcosConstants.STYLE_ROTATION, (Object)Integer.toString(n2));
        }
        if (!bl) {
            styleMap.remove((Object)"flip");
        } else {
            styleMap.put((Object)"flip", (Object)Boolean.toString(bl));
        }
        if (!bl2) {
            styleMap.remove((Object)"mirror");
        } else {
            styleMap.put((Object)"mirror", (Object)Boolean.toString(bl2));
        }
    }

    public static int roundAngle(int n) {
        int n2 = n;
        if (n < 0 || n > 360) {
            n2 = (n + 360) % 360;
        }
        for (int i = 0; i < 4; ++i) {
            int n3 = i * 90;
            int n4 = (i + 1) * 90;
            if (n2 >= (n3 + n4) / 2) continue;
            n2 = n3;
            break;
        }
        return n2;
    }
}

