/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.utils;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.xcos.block.SplitBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.swing.handler.SelectionCellsHandler;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.Orientation;
import org.scilab.modules.xcos.utils.XcosRoute;
import org.scilab.modules.xcos.utils.XcosRouteUtils;

public abstract class BlockAutoPositionUtils {
    public static void changeSplitBlocksPosition(XcosDiagram xcosDiagram, Object[] objectArray) {
        Object[] objectArray2;
        Object[] objectArray3 = xcosDiagram.getChildCells(xcosDiagram.getDefaultParent());
        for (Object object : objectArray2 = BlockAutoPositionUtils.selectRootSplitBlock(xcosDiagram, objectArray)) {
            if (!(object instanceof SplitBlock)) continue;
            SplitBlock splitBlock = (SplitBlock)object;
            if (BlockAutoPositionUtils.getSplitBlockNumber(splitBlock) == 1) {
                BlockAutoPositionUtils.changeSplitBlockPosition(splitBlock, objectArray3, xcosDiagram);
                continue;
            }
            BlockAutoPositionUtils.changeSplitBlockPositionMulti(splitBlock, objectArray3, xcosDiagram);
        }
    }

    private static Object[] selectRootSplitBlock(XcosDiagram xcosDiagram, Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(0);
        for (Object object : objectArray) {
            SplitBlock splitBlock;
            if (!(object instanceof SplitBlock) || arrayList.contains(splitBlock = BlockAutoPositionUtils.getRootSplitBlock((SplitBlock)object)) || BlockAutoPositionUtils.isListContainsCell(arrayList, splitBlock)) continue;
            arrayList.add(splitBlock);
        }
        return arrayList.toArray();
    }

    private static SplitBlock getRootSplitBlock(SplitBlock splitBlock) {
        mxICell mxICell2 = BlockAutoPositionUtils.getSplitInLinkPort(splitBlock);
        while (mxICell2 != null && mxICell2.getParent() instanceof SplitBlock) {
            mxICell2 = BlockAutoPositionUtils.getSplitInLinkPort((SplitBlock)mxICell2.getParent());
        }
        if (mxICell2 == null) {
            return null;
        }
        mxICell mxICell3 = mxICell2.getEdgeAt(0);
        mxICell mxICell4 = ((mxCell)mxICell3).getTarget();
        return (SplitBlock)mxICell4.getParent();
    }

    private static boolean isListContainsCell(List<Object> list, SplitBlock splitBlock) {
        for (Object object : list) {
            SplitBlock splitBlock2;
            List<mxICell> list2;
            if (!(object instanceof SplitBlock) || !(list2 = BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel(splitBlock2 = (SplitBlock)object)).contains(splitBlock)) continue;
            return true;
        }
        return false;
    }

    private static int getSplitBlockNumber(SplitBlock splitBlock) {
        SplitBlock splitBlock2 = BlockAutoPositionUtils.getRootSplitBlock(splitBlock);
        List<mxICell> list = BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel(splitBlock2);
        return list.size() + 1;
    }

    protected static void changeSplitBlockPosition(SplitBlock splitBlock, Object[] objectArray, XcosDiagram xcosDiagram) {
        mxICell mxICell2 = BlockAutoPositionUtils.getSplitInLinkPort(splitBlock);
        mxICell mxICell3 = BlockAutoPositionUtils.getSplitLinkPort(splitBlock, splitBlock.getOut1());
        mxICell mxICell4 = BlockAutoPositionUtils.getSplitLinkPort(splitBlock, splitBlock.getOut2());
        Object[] objectArray2 = BlockAutoPositionUtils.getObstacles(splitBlock, objectArray);
        List<mxPoint> list = BlockAutoPositionUtils.getRoute(splitBlock, mxICell2, mxICell3, objectArray2, xcosDiagram);
        List<mxPoint> list2 = BlockAutoPositionUtils.getRoute(splitBlock, mxICell2, mxICell4, objectArray2, xcosDiagram);
        ArrayList<mxICell> arrayList = new ArrayList<mxICell>(0);
        arrayList.add(mxICell2);
        arrayList.add(mxICell3);
        arrayList.add(mxICell4);
        BlockAutoPositionUtils.adjustRoutes(list, list2, objectArray2, arrayList);
        mxPoint mxPoint2 = BlockAutoPositionUtils.getSplitPoint(list, list2);
        if (mxPoint2 == null) {
            return;
        }
        BlockAutoPositionUtils.updatePortOrientation(splitBlock, list, list2, mxPoint2);
        mxGeometry mxGeometry2 = (mxGeometry)xcosDiagram.getModel().getGeometry((Object)splitBlock).clone();
        mxGeometry2.setX(mxPoint2.getX() - mxGeometry2.getWidth() / 2.0);
        mxGeometry2.setY(mxPoint2.getY() - mxGeometry2.getHeight() / 2.0);
        xcosDiagram.getModel().setGeometry((Object)splitBlock, mxGeometry2);
        BlockAutoPositionUtils.updateSplitLink(splitBlock, objectArray2, xcosDiagram);
    }

    protected static void changeSplitBlockPositionMulti(SplitBlock splitBlock, Object[] objectArray, XcosDiagram xcosDiagram) {
        Object object;
        List<mxICell> list;
        int n;
        Object object22;
        BlockAutoPositionUtils.adjustSplitBlock(splitBlock);
        mxICell mxICell3 = BlockAutoPositionUtils.getSplitInLinkPort(splitBlock);
        List<mxICell> list2 = BlockAutoPositionUtils.getSplitAllTargetPort(splitBlock);
        ArrayList<SplitBlock> arrayList = new ArrayList<SplitBlock>(0);
        arrayList.add(splitBlock);
        arrayList.addAll(BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel(splitBlock));
        HashMap hashMap = new HashMap(0);
        ArrayList<List<mxPoint>> arrayList2 = new ArrayList<List<mxPoint>>(0);
        Object[] objectArray2 = BlockAutoPositionUtils.getObstacles(splitBlock, objectArray);
        XcosRoute xcosRoute = new XcosRoute();
        for (mxICell mxICell4 : list2) {
            boolean bl;
            ArrayList<mxPoint> mxICell22 = new ArrayList<mxPoint>(0);
            if (mxICell3 != null) {
                mxICell22.add(BlockAutoPositionUtils.getPortPosition(mxICell3));
            }
            if (bl = xcosRoute.computeRoute(mxICell3, mxICell4, objectArray2, xcosDiagram)) {
                for (Object object22 : xcosRoute.getNonRedundantPoints()) {
                    mxICell22.add(new mxPoint((double)Math.round(object22.getX()), (double)Math.round(object22.getY())));
                }
            } else {
                return;
            }
            if (mxICell4 != null) {
                mxICell22.add(BlockAutoPositionUtils.getPortPosition(mxICell4));
            }
            hashMap.put(mxICell4, mxICell22);
            arrayList2.add(mxICell22);
        }
        ArrayList arrayList3 = new ArrayList(0);
        arrayList3.add(mxICell3);
        arrayList3.addAll(list2);
        BlockAutoPositionUtils.adjustRoutes(arrayList2, objectArray2, arrayList3);
        for (n = 0; n < arrayList.size(); ++n) {
            mxICell mxICell2 = (mxICell)arrayList.get(n);
            SplitBlock splitBlock2 = (SplitBlock)mxICell2;
            list = null;
            if (n == 0) {
                list = BlockAutoPositionUtils.getSplitAllTargetPort(splitBlock2);
            } else {
                for (int i = 0; i < n; ++i) {
                    object = (SplitBlock)arrayList.get(i);
                    if (BlockAutoPositionUtils.isSplitBlocksConnected(splitBlock2, (SplitBlock)object) == null) continue;
                    list = BlockAutoPositionUtils.getSplitAllTargetPort(splitBlock2, (SplitBlock)object);
                    break;
                }
            }
            object22 = new ArrayList(0);
            for (mxICell mxICell4 : list) {
                object22.add(hashMap.get(mxICell4));
            }
            object = BlockAutoPositionUtils.getSplitPoint((List<List<mxPoint>>)object22);
            if (object == null) {
                return;
            }
            mxGeometry mxGeometry2 = (mxGeometry)xcosDiagram.getModel().getGeometry((Object)splitBlock2).clone();
            mxGeometry2.setX(object.getX() - mxGeometry2.getWidth() / 2.0);
            mxGeometry2.setY(object.getY() - mxGeometry2.getHeight() / 2.0);
            xcosDiagram.getModel().setGeometry((Object)splitBlock2, mxGeometry2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            mxICell mxICell5 = (mxICell)arrayList.get(n);
            SplitBlock splitBlock3 = (SplitBlock)mxICell5;
            list = null;
            object22 = null;
            if (n == 0) {
                list = BlockAutoPositionUtils.getSplitAllTargetPort(splitBlock3);
            } else {
                for (int i = 0; i < n; ++i) {
                    SplitBlock splitBlock4 = (SplitBlock)arrayList.get(i);
                    if (BlockAutoPositionUtils.isSplitBlocksConnected(splitBlock3, splitBlock4) == null) continue;
                    list = BlockAutoPositionUtils.getSplitAllTargetPort(splitBlock3, splitBlock4);
                    object22 = BlockAutoPositionUtils.isSplitBlocksConnected(splitBlock3, splitBlock4);
                    break;
                }
            }
            object = new ArrayList(0);
            for (mxICell mxICell6 : list) {
                object.add(hashMap.get(mxICell6));
            }
            BlockAutoPositionUtils.updatePortOrientation(splitBlock3, (List<List<mxPoint>>)object, xcosDiagram, (BasicPort)((Object)object22));
        }
        for (mxICell mxICell7 : arrayList) {
            SplitBlock splitBlock5 = (SplitBlock)mxICell7;
            BlockAutoPositionUtils.updateSplitLink(splitBlock5, objectArray2, xcosDiagram);
        }
    }

    private static mxICell getSplitInLinkPort(SplitBlock splitBlock) {
        mxICell mxICell2 = null;
        BasicPort basicPort = splitBlock.getIn();
        mxICell mxICell3 = basicPort.getEdgeAt(0);
        if (mxICell3 != null && mxICell3 instanceof mxCell && (mxICell2 = ((mxCell)mxICell3).getSource()) == basicPort) {
            mxICell2 = ((mxCell)mxICell3).getTarget();
        }
        return mxICell2;
    }

    private static mxICell getSplitLinkPort(SplitBlock splitBlock, BasicPort basicPort) {
        mxICell mxICell2 = null;
        mxICell mxICell3 = basicPort.getEdgeAt(0);
        if (mxICell3 != null && mxICell3 instanceof mxCell && (mxICell2 = ((mxCell)mxICell3).getTarget()) == basicPort) {
            mxICell2 = ((mxCell)mxICell3).getSource();
        }
        return mxICell2;
    }

    private static BasicPort isSplitBlocksConnected(SplitBlock splitBlock, SplitBlock splitBlock2) {
        BasicPort basicPort = splitBlock.getIn();
        BasicPort basicPort2 = splitBlock.getOut1();
        BasicPort basicPort3 = splitBlock.getOut2();
        BasicPort basicPort4 = splitBlock2.getIn();
        BasicPort basicPort5 = splitBlock2.getOut1();
        BasicPort basicPort6 = splitBlock2.getOut2();
        if (basicPort.getEdgeAt(0) == basicPort4.getEdgeAt(0) || basicPort.getEdgeAt(0) == basicPort5.getEdgeAt(0) || basicPort.getEdgeAt(0) == basicPort6.getEdgeAt(0)) {
            return basicPort;
        }
        if (basicPort2.getEdgeAt(0) == basicPort4.getEdgeAt(0) || basicPort2.getEdgeAt(0) == basicPort5.getEdgeAt(0) || basicPort2.getEdgeAt(0) == basicPort6.getEdgeAt(0)) {
            return basicPort2;
        }
        if (basicPort3.getEdgeAt(0) == basicPort4.getEdgeAt(0) || basicPort3.getEdgeAt(0) == basicPort5.getEdgeAt(0) || basicPort3.getEdgeAt(0) == basicPort6.getEdgeAt(0)) {
            return basicPort3;
        }
        return null;
    }

    private static List<mxICell> getSplitAllTargetPort(SplitBlock splitBlock) {
        return BlockAutoPositionUtils.getSplitAllTargetPort(splitBlock, null);
    }

    private static List<mxICell> getSplitAllTargetPort(SplitBlock splitBlock, SplitBlock splitBlock2) {
        ArrayList<mxICell> arrayList = new ArrayList<mxICell>(0);
        BasicPort basicPort = splitBlock.getOut1();
        BasicPort basicPort2 = splitBlock.getOut2();
        mxICell mxICell2 = BlockAutoPositionUtils.getSplitInLinkPort(splitBlock);
        mxICell mxICell3 = BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort);
        mxICell mxICell4 = BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort2);
        if (splitBlock2 != null && !(mxICell2.getParent() instanceof SplitBlock)) {
            arrayList.add(mxICell2);
        }
        if (!(mxICell3.getParent() instanceof SplitBlock)) {
            arrayList.add(mxICell3);
        }
        if (!(mxICell4.getParent() instanceof SplitBlock)) {
            arrayList.add(mxICell4);
        }
        if (splitBlock2 != null && mxICell2.getParent() instanceof SplitBlock && splitBlock2 != mxICell2.getParent()) {
            arrayList.addAll(BlockAutoPositionUtils.getSplitAllTargetPort((SplitBlock)mxICell2.getParent(), splitBlock));
        }
        if (mxICell3.getParent() instanceof SplitBlock && splitBlock2 != mxICell3.getParent()) {
            arrayList.addAll(BlockAutoPositionUtils.getSplitAllTargetPort((SplitBlock)mxICell3.getParent(), splitBlock));
        }
        if (mxICell4.getParent() instanceof SplitBlock && splitBlock2 != mxICell4.getParent()) {
            arrayList.addAll(BlockAutoPositionUtils.getSplitAllTargetPort((SplitBlock)mxICell4.getParent(), splitBlock));
        }
        return arrayList;
    }

    private static List<mxICell> getAllChildrenSplitBlockByLevel(SplitBlock splitBlock) {
        return BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel(splitBlock, null);
    }

    private static List<mxICell> getAllChildrenSplitBlockByLevel(SplitBlock splitBlock, SplitBlock splitBlock2) {
        ArrayList<mxICell> arrayList = new ArrayList<mxICell>(0);
        BasicPort basicPort = splitBlock.getOut1();
        BasicPort basicPort2 = splitBlock.getOut2();
        mxICell mxICell2 = BlockAutoPositionUtils.getSplitInLinkPort(splitBlock);
        mxICell mxICell3 = BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort);
        mxICell mxICell4 = BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort2);
        if (mxICell2.getParent() instanceof SplitBlock && splitBlock2 != mxICell2.getParent()) {
            arrayList.add(mxICell2.getParent());
        }
        if (mxICell3.getParent() instanceof SplitBlock && splitBlock2 != mxICell3.getParent()) {
            arrayList.add(mxICell3.getParent());
        }
        if (mxICell4.getParent() instanceof SplitBlock && splitBlock2 != mxICell4.getParent()) {
            arrayList.add(mxICell4.getParent());
        }
        if (mxICell2.getParent() instanceof SplitBlock && splitBlock2 != mxICell2.getParent()) {
            arrayList.addAll(BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel((SplitBlock)mxICell2.getParent(), splitBlock));
        }
        if (mxICell3.getParent() instanceof SplitBlock && splitBlock2 != mxICell3.getParent()) {
            arrayList.addAll(BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel((SplitBlock)mxICell3.getParent(), splitBlock));
        }
        if (mxICell4.getParent() instanceof SplitBlock && splitBlock2 != mxICell4.getParent()) {
            arrayList.addAll(BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel((SplitBlock)mxICell4.getParent(), splitBlock));
        }
        return arrayList;
    }

    private static List<mxICell> getAllLinksOnSplitBlock(SplitBlock splitBlock) {
        ArrayList<mxICell> arrayList = new ArrayList<mxICell>(0);
        ArrayList<SplitBlock> arrayList2 = new ArrayList<SplitBlock>(0);
        arrayList2.add(splitBlock);
        arrayList2.addAll(BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel(splitBlock));
        for (mxICell mxICell2 : arrayList2) {
            SplitBlock splitBlock2 = (SplitBlock)mxICell2;
            mxICell mxICell3 = splitBlock2.getIn().getEdgeAt(0);
            mxICell mxICell4 = splitBlock2.getOut1().getEdgeAt(0);
            mxICell mxICell5 = splitBlock2.getOut2().getEdgeAt(0);
            if (!arrayList.contains(mxICell3)) {
                arrayList.add(mxICell3);
            }
            if (!arrayList.contains(mxICell4)) {
                arrayList.add(mxICell4);
            }
            if (arrayList.contains(mxICell5)) continue;
            arrayList.add(mxICell5);
        }
        return arrayList;
    }

    private static void adjustSplitBlock(SplitBlock splitBlock) {
        BasicPort basicPort = splitBlock.getOut1();
        BasicPort basicPort2 = splitBlock.getOut2();
        mxICell mxICell2 = BlockAutoPositionUtils.getSplitInLinkPort(splitBlock);
        mxICell mxICell3 = BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort);
        mxICell mxICell4 = BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort2);
        if (mxICell2.getParent() instanceof SplitBlock) {
            if (!(mxICell3.getParent() instanceof SplitBlock)) {
                BlockAutoPositionUtils.adjustCell(mxICell2, mxICell3);
            }
            if (!(mxICell4.getParent() instanceof SplitBlock)) {
                BlockAutoPositionUtils.adjustCell(mxICell2, mxICell4);
            }
        }
        if (mxICell3 instanceof SplitBlock && !(mxICell2.getParent() instanceof SplitBlock)) {
            BlockAutoPositionUtils.adjustCell(mxICell3, mxICell2);
        }
        if (mxICell4 instanceof SplitBlock && !(mxICell2.getParent() instanceof SplitBlock)) {
            BlockAutoPositionUtils.adjustCell(mxICell4, mxICell2);
        }
    }

    private static void adjustCell(mxICell mxICell2, mxICell mxICell3) {
        double d = 2.0;
        mxPoint mxPoint2 = BlockAutoPositionUtils.getPortPosition(mxICell2);
        mxGeometry mxGeometry2 = mxICell2.getParent().getGeometry();
        mxPoint mxPoint3 = BlockAutoPositionUtils.getPortPosition(mxICell3);
        if (Math.abs(mxPoint2.getX() - mxPoint3.getX()) <= d) {
            mxGeometry2.setX(mxPoint3.getX() - mxGeometry2.getWidth() / 2.0);
        }
        if (Math.abs(mxPoint2.getY() - mxPoint3.getY()) <= d) {
            mxGeometry2.setY(mxPoint3.getY() - mxGeometry2.getHeight() / 2.0);
        }
    }

    private static void adjustRoutes(List<mxPoint> list, List<mxPoint> list2, Object[] objectArray, List<mxICell> list3) {
        ArrayList<List<mxPoint>> arrayList = new ArrayList<List<mxPoint>>(0);
        arrayList.add(list);
        arrayList.add(list2);
        BlockAutoPositionUtils.adjustRoutes(arrayList, objectArray, list3);
    }

    private static void adjustRoutes(List<List<mxPoint>> list, Object[] objectArray, List<mxICell> list2) {
        ArrayList<mxGeometry> arrayList = new ArrayList<mxGeometry>(0);
        for (mxICell object : list2) {
            mxGeometry mxGeometry2 = BlockAutoPositionUtils.getPortGeometry(object);
            arrayList.add(mxGeometry2);
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            List<mxPoint> list3 = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                List<mxPoint> list4 = list.get(j);
                for (int k = 0; k < list3.size() - 1; ++k) {
                    mxPoint mxPoint2 = list3.get(k);
                    mxPoint mxPoint3 = list3.get(k + 1);
                    double d = mxPoint2.getX();
                    double d2 = mxPoint2.getY();
                    double d3 = mxPoint3.getX();
                    double d4 = mxPoint3.getY();
                    for (int i2 = 0; i2 < list4.size() - 1; ++i2) {
                        boolean bl;
                        mxPoint mxPoint4;
                        mxPoint mxPoint5;
                        if (k == 0 && i2 == 0 || k == list3.size() - 2 && i2 == list4.size() - 2 || k == 0 && i2 == list4.size() - 2 || i2 == 0 && k == list3.size() - 2) continue;
                        mxPoint mxPoint6 = list4.get(i2);
                        mxPoint mxPoint7 = list4.get(i2 + 1);
                        double d5 = mxPoint6.getX();
                        double d6 = mxPoint6.getY();
                        double d7 = mxPoint7.getX();
                        double d8 = mxPoint7.getY();
                        if (d == d3 && d5 == d7 && d == d5 || d2 == d4 && d6 == d8 && d2 == d6 || !XcosRouteUtils.isLineParallel(d, d2, d3, d4, d5, d6, d7, d8, true)) continue;
                        if (k == 0 || k == list3.size() - 2) {
                            boolean bl5;
                            mxPoint5 = list4.get(i2 - 1);
                            mxPoint4 = list4.get(i2 + 2);
                            if (d == d3) {
                                boolean bl6 = !XcosRouteUtils.checkObstacle(mxPoint5.getX(), mxPoint5.getY(), d, d6, objectArray) && !XcosRouteUtils.checkObstacle(d, d6, d, d8, objectArray) && !XcosRouteUtils.checkObstacle(d, d8, mxPoint4.getX(), mxPoint4.getY(), objectArray);
                                for (mxGeometry bl8 : arrayList) {
                                    if (!XcosRouteUtils.checkPointInGeometry(d, d6, bl8) && !XcosRouteUtils.checkPointInGeometry(d, d8, bl8)) continue;
                                    bl6 = false;
                                    break;
                                }
                                if (!bl6) continue;
                                mxPoint6.setX(d);
                                mxPoint7.setX(d);
                                continue;
                            }
                            if (d2 != d4) continue;
                            boolean bl2 = bl5 = !XcosRouteUtils.checkObstacle(mxPoint5.getX(), mxPoint5.getY(), d5, d2, objectArray) && !XcosRouteUtils.checkObstacle(d5, d2, d7, d2, objectArray) && !XcosRouteUtils.checkObstacle(d7, d2, mxPoint4.getX(), mxPoint4.getY(), objectArray);
                            if (!bl5) continue;
                            mxPoint6.setY(d2);
                            mxPoint7.setY(d2);
                            continue;
                        }
                        if (i2 == 0 || i2 == list4.size() - 2) {
                            boolean bl3;
                            mxPoint5 = list3.get(k - 1);
                            mxPoint4 = list3.get(k + 2);
                            if (d == d3) {
                                boolean mxPoint8 = !XcosRouteUtils.checkObstacle(mxPoint5.getX(), mxPoint5.getY(), d5, d2, objectArray) && !XcosRouteUtils.checkObstacle(d5, d2, d5, d4, objectArray) && !XcosRouteUtils.checkObstacle(d5, d4, mxPoint4.getX(), mxPoint4.getY(), objectArray);
                                for (mxGeometry bl9 : arrayList) {
                                    if (!XcosRouteUtils.checkPointInGeometry(d5, d2, bl9) && !XcosRouteUtils.checkPointInGeometry(d5, d4, bl9)) continue;
                                    mxPoint8 = false;
                                    break;
                                }
                                if (!mxPoint8) continue;
                                mxPoint2.setX(d5);
                                mxPoint3.setX(d5);
                                continue;
                            }
                            if (d2 != d4) continue;
                            boolean bl4 = bl3 = !XcosRouteUtils.checkObstacle(mxPoint5.getX(), mxPoint5.getY(), d, d6, objectArray) && !XcosRouteUtils.checkObstacle(d, d6, d3, d6, objectArray) && !XcosRouteUtils.checkObstacle(d3, d6, mxPoint4.getX(), mxPoint4.getY(), objectArray);
                            if (!bl3) continue;
                            mxPoint2.setY(d6);
                            mxPoint3.setY(d6);
                            continue;
                        }
                        mxPoint5 = list4.get(i2 - 1);
                        mxPoint4 = list4.get(i2 + 2);
                        mxPoint mxPoint8 = list3.get(k - 1);
                        mxPoint mxPoint9 = list3.get(k + 2);
                        if (d == d3) {
                            boolean bl5 = !XcosRouteUtils.checkObstacle(mxPoint5.getX(), mxPoint5.getY(), d, d6, objectArray) && !XcosRouteUtils.checkObstacle(d, d6, d, d8, objectArray) && !XcosRouteUtils.checkObstacle(d, d8, mxPoint4.getX(), mxPoint4.getY(), objectArray);
                            bl = !XcosRouteUtils.checkObstacle(mxPoint8.getX(), mxPoint8.getY(), d5, d2, objectArray) && !XcosRouteUtils.checkObstacle(d5, d2, d5, d4, objectArray) && !XcosRouteUtils.checkObstacle(d5, d4, mxPoint9.getX(), mxPoint9.getY(), objectArray);
                            for (mxGeometry mxGeometry3 : arrayList) {
                                if (XcosRouteUtils.checkPointInGeometry(d, d6, mxGeometry3) || XcosRouteUtils.checkPointInGeometry(d, d8, mxGeometry3)) {
                                    bl5 = false;
                                }
                                if (XcosRouteUtils.checkPointInGeometry(d5, d2, mxGeometry3) || XcosRouteUtils.checkPointInGeometry(d5, d4, mxGeometry3)) {
                                    bl = false;
                                }
                                if (bl || bl5) continue;
                                break;
                            }
                            if (bl5) {
                                mxPoint6.setX(d);
                                mxPoint7.setX(d);
                                continue;
                            }
                            if (!bl) continue;
                            mxPoint2.setX(d5);
                            mxPoint3.setX(d5);
                            continue;
                        }
                        if (d2 != d4) continue;
                        boolean bl6 = !XcosRouteUtils.checkObstacle(mxPoint5.getX(), mxPoint5.getY(), d5, d2, objectArray) && !XcosRouteUtils.checkObstacle(d5, d2, d7, d2, objectArray) && !XcosRouteUtils.checkObstacle(d7, d2, mxPoint4.getX(), mxPoint4.getY(), objectArray);
                        bl = !XcosRouteUtils.checkObstacle(mxPoint8.getX(), mxPoint8.getY(), d, d6, objectArray) && !XcosRouteUtils.checkObstacle(d, d6, d3, d6, objectArray) && !XcosRouteUtils.checkObstacle(d3, d6, mxPoint9.getX(), mxPoint9.getY(), objectArray);
                        for (mxGeometry mxGeometry3 : arrayList) {
                            if (XcosRouteUtils.checkPointInGeometry(d5, d2, mxGeometry3) || XcosRouteUtils.checkPointInGeometry(d7, d2, mxGeometry3)) {
                                bl6 = false;
                            }
                            if (XcosRouteUtils.checkPointInGeometry(d, d6, mxGeometry3) || XcosRouteUtils.checkPointInGeometry(d3, d6, mxGeometry3)) {
                                bl = false;
                            }
                            if (bl || bl6) continue;
                            break;
                        }
                        if (bl6) {
                            mxPoint6.setY(d2);
                            mxPoint7.setY(d2);
                            continue;
                        }
                        if (!bl) continue;
                        mxPoint2.setY(d6);
                        mxPoint3.setY(d6);
                    }
                }
            }
        }
    }

    private static List<mxPoint> getRoute(SplitBlock splitBlock, mxICell mxICell2, mxICell mxICell3, Object[] objectArray, XcosDiagram xcosDiagram) {
        XcosRoute xcosRoute = new XcosRoute();
        mxICell mxICell4 = splitBlock.getIn().getEdgeAt(0);
        mxICell mxICell5 = splitBlock.getOut1().getEdgeAt(0);
        mxICell mxICell6 = splitBlock.getOut2().getEdgeAt(0);
        Object[] objectArray2 = xcosRoute.getAllOtherCells(objectArray, mxICell2, mxICell3, mxICell2.getEdgeAt(0), mxICell3.getEdgeAt(0), mxICell4, mxICell5, mxICell6);
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(0);
        arrayList.add(BlockAutoPositionUtils.getPortPosition(mxICell2));
        if (xcosRoute.computeRoute(mxICell2, mxICell3, objectArray2, xcosDiagram)) {
            for (mxPoint mxPoint2 : xcosRoute.getNonRedundantPoints()) {
                arrayList.add(new mxPoint((double)Math.round(mxPoint2.getX()), (double)Math.round(mxPoint2.getY())));
            }
        }
        arrayList.add(BlockAutoPositionUtils.getPortPosition(mxICell3));
        return arrayList;
    }

    private static Object[] getObstacles(SplitBlock splitBlock, Object[] objectArray) {
        List<mxICell> list = BlockAutoPositionUtils.getSplitAllTargetPort(splitBlock);
        ArrayList<SplitBlock> arrayList = new ArrayList<SplitBlock>(0);
        arrayList.add(splitBlock);
        arrayList.addAll(BlockAutoPositionUtils.getAllChildrenSplitBlockByLevel(splitBlock));
        List<mxICell> list2 = BlockAutoPositionUtils.getAllLinksOnSplitBlock(splitBlock);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(0);
        arrayList2.add(BlockAutoPositionUtils.getSplitInLinkPort(splitBlock));
        arrayList2.addAll(list);
        arrayList2.addAll(arrayList);
        arrayList2.addAll(list2);
        Object[] objectArray2 = arrayList2.toArray();
        XcosRoute xcosRoute = new XcosRoute();
        Object[] objectArray3 = xcosRoute.getAllOtherCells(objectArray, objectArray2);
        return objectArray3;
    }

    private static mxGeometry getPortGeometry(mxICell mxICell2) {
        mxGeometry mxGeometry2 = new mxGeometry();
        if (mxICell2 == null) {
            return null;
        }
        if (mxICell2.getParent() instanceof SplitBlock) {
            SplitBlock splitBlock = (SplitBlock)mxICell2.getParent();
            mxGeometry2.setX(splitBlock.getGeometry().getX());
            mxGeometry2.setY(splitBlock.getGeometry().getY());
            mxGeometry2.setWidth(splitBlock.getGeometry().getWidth());
            mxGeometry2.setHeight(splitBlock.getGeometry().getHeight());
        } else {
            mxGeometry mxGeometry3 = mxICell2.getGeometry();
            double d = mxGeometry3.getX();
            double d2 = mxGeometry3.getY();
            mxICell mxICell3 = mxICell2.getParent();
            mxGeometry mxGeometry4 = mxICell3.getGeometry();
            if (mxGeometry3.isRelative()) {
                d *= mxGeometry4.getWidth();
                d2 *= mxGeometry4.getHeight();
            }
            mxGeometry2.setX(mxGeometry4.getX() + d);
            mxGeometry2.setY(mxGeometry4.getY() + d2);
            mxGeometry2.setWidth(mxGeometry3.getWidth());
            mxGeometry2.setHeight(mxGeometry3.getHeight());
        }
        return mxGeometry2;
    }

    private static mxPoint getPortPosition(mxICell mxICell2) {
        mxPoint mxPoint2 = new mxPoint();
        if (mxICell2 == null) {
            return null;
        }
        if (mxICell2.getParent() instanceof SplitBlock) {
            SplitBlock splitBlock = (SplitBlock)mxICell2.getParent();
            mxPoint2.setX(splitBlock.getGeometry().getCenterX());
            mxPoint2.setY(splitBlock.getGeometry().getCenterY());
        } else {
            mxGeometry mxGeometry2 = mxICell2.getGeometry();
            double d = mxGeometry2.getX();
            double d2 = mxGeometry2.getY();
            double d3 = mxGeometry2.getWidth();
            double d4 = mxGeometry2.getHeight();
            mxICell mxICell3 = mxICell2.getParent();
            mxGeometry mxGeometry3 = mxICell3.getGeometry();
            if (mxGeometry2.isRelative()) {
                d *= mxGeometry3.getWidth();
                d2 *= mxGeometry3.getHeight();
            }
            mxPoint2.setX(mxGeometry3.getX() + d + d3 / 2.0);
            mxPoint2.setY(mxGeometry3.getY() + d2 + d4 / 2.0);
        }
        mxPoint2.setX((double)Math.round(mxPoint2.getX()));
        mxPoint2.setY((double)Math.round(mxPoint2.getY()));
        return mxPoint2;
    }

    private static mxPoint getSplitPoint(List<mxPoint> list, List<mxPoint> list2) {
        mxPoint mxPoint2 = null;
        int n = Math.min(list.size(), list2.size());
        if (n <= 1 || !list.get(0).equals((Object)list2.get(0))) {
            return null;
        }
        int n2 = 1;
        int n3 = 1;
        for (int i = n2; i < list.size(); ++i) {
            for (int j = n3; j < list2.size(); ++j) {
                mxPoint mxPoint3 = list.get(i - 1);
                mxPoint mxPoint4 = list.get(i);
                mxPoint mxPoint5 = list2.get(j - 1);
                mxPoint mxPoint6 = list2.get(j);
                mxPoint mxPoint7 = XcosRouteUtils.getIntersection(mxPoint3.getX(), mxPoint3.getY(), mxPoint4.getX(), mxPoint4.getY(), mxPoint5.getX(), mxPoint5.getY(), mxPoint6.getX(), mxPoint6.getY());
                if (mxPoint7 == null) continue;
                n2 = i;
                n3 = j;
                mxPoint2 = (mxPoint)mxPoint7.clone();
            }
        }
        return mxPoint2;
    }

    private static mxPoint getSplitPoint(List<List<mxPoint>> list) {
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(0);
        for (int i = 0; i < list.size() - 1; ++i) {
            List<mxPoint> list2 = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                List<mxPoint> list3 = list.get(j);
                mxPoint mxPoint2 = BlockAutoPositionUtils.getSplitPoint(list2, list3);
                if (mxPoint2 == null || arrayList.contains(mxPoint2)) continue;
                arrayList.add(mxPoint2);
            }
        }
        mxPoint mxPoint3 = null;
        for (mxPoint mxPoint4 : arrayList) {
            double d = mxPoint4.getX();
            double d2 = mxPoint4.getY();
            for (int i = 0; i < list.size() && XcosRouteUtils.pointInLink(d, d2, list.get(i)); ++i) {
                if (i != list.size() - 1) continue;
                mxPoint3 = new mxPoint();
                mxPoint3.setX(d);
                mxPoint3.setY(d2);
            }
        }
        return mxPoint3;
    }

    private static void updatePortOrientation(SplitBlock splitBlock, List<mxPoint> list, List<mxPoint> list2, mxPoint mxPoint2) {
        Orientation orientation;
        Orientation orientation2;
        Orientation orientation3 = BlockAutoPositionUtils.getInportOrientation(list, list2, mxPoint2);
        if (orientation3 != null) {
            splitBlock.getIn().setOrientation(orientation3);
        }
        if ((orientation2 = BlockAutoPositionUtils.getPortOrientation(list, mxPoint2)) != null) {
            splitBlock.getOut1().setOrientation(orientation2);
        }
        if ((orientation = BlockAutoPositionUtils.getPortOrientation(list2, mxPoint2)) != null) {
            splitBlock.getOut2().setOrientation(orientation);
        }
    }

    private static Orientation getInportOrientation(List<mxPoint> list, List<mxPoint> list2, mxPoint mxPoint2) {
        ArrayList<List<mxPoint>> arrayList = new ArrayList<List<mxPoint>>(0);
        arrayList.add(list);
        arrayList.add(list2);
        mxPoint mxPoint3 = list.get(0);
        return BlockAutoPositionUtils.getInputOrientation(arrayList, mxPoint3, mxPoint2);
    }

    private static Orientation getInputOrientation(List<List<mxPoint>> list, mxPoint mxPoint2, mxPoint mxPoint3) {
        int n;
        int n2;
        int[] nArray = new int[list.size()];
        Orientation[] orientationArray = new Orientation[list.size()];
        double d = mxPoint3.getX();
        double d2 = mxPoint3.getY();
        double d3 = mxPoint2.getX();
        double d4 = mxPoint2.getY();
        block0: for (n2 = 0; n2 < list.size(); ++n2) {
            List<mxPoint> list2 = list.get(n2);
            n = list2.size();
            if (n <= 1) continue;
            int n3 = 1;
            int n4 = 0;
            while (n3 < n) {
                double d5;
                double d6;
                double d7;
                mxPoint mxPoint4 = list2.get(n3 - 1);
                mxPoint mxPoint5 = list2.get(n3);
                double d8 = mxPoint4.getX();
                if (XcosRouteUtils.pointInLineSegment(d3, d4, d8, d7 = mxPoint4.getY(), d6 = mxPoint5.getX(), d5 = mxPoint5.getY())) {
                    n4 = 0;
                }
                if (XcosRouteUtils.pointInLineSegment(d, d2, d8, d7, d6, d5)) {
                    nArray[n2] = n4;
                    if (d6 == d8 && d5 > d7) {
                        orientationArray[n2] = Orientation.NORTH;
                        continue block0;
                    }
                    if (d6 == d8 && d5 < d7) {
                        orientationArray[n2] = Orientation.SOUTH;
                        continue block0;
                    }
                    if (d5 == d7 && d6 > d8) {
                        orientationArray[n2] = Orientation.WEST;
                        continue block0;
                    }
                    if (d5 != d7 || !(d6 < d8)) continue block0;
                    orientationArray[n2] = Orientation.EAST;
                    continue block0;
                }
                ++n3;
                ++n4;
            }
        }
        n2 = 0;
        int n5 = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n] >= n5) continue;
            n5 = nArray[n];
            n2 = n;
        }
        return orientationArray[n2];
    }

    private static Orientation getPortOrientation(List<mxPoint> list, mxPoint mxPoint2) {
        double d = mxPoint2.getX();
        double d2 = mxPoint2.getY();
        int n = list.size();
        if (n <= 1) {
            return null;
        }
        for (int i = 1; i < n; ++i) {
            double d3;
            double d4;
            double d5;
            mxPoint mxPoint3 = list.get(i - 1);
            mxPoint mxPoint4 = list.get(i);
            double d6 = mxPoint3.getX();
            if (!XcosRouteUtils.pointInLineSegment(d, d2, d6, d5 = mxPoint3.getY(), d4 = mxPoint4.getX(), d3 = mxPoint4.getY())) continue;
            if (d == d4 && d2 == d3 && i + 1 != n) {
                mxPoint mxPoint5 = list.get(i + 1);
                double d7 = mxPoint5.getX();
                double d8 = mxPoint5.getY();
                if (d == d7 && d2 < d8) {
                    return Orientation.SOUTH;
                }
                if (d == d7 && d2 > d8) {
                    return Orientation.NORTH;
                }
                if (d2 == d8 && d < d7) {
                    return Orientation.EAST;
                }
                if (d2 == d8 && d > d7) {
                    return Orientation.WEST;
                }
            }
            if (d4 == d6 && d3 > d5) {
                return Orientation.SOUTH;
            }
            if (d4 == d6 && d3 < d5) {
                return Orientation.NORTH;
            }
            if (d3 == d5 && d4 > d6) {
                return Orientation.EAST;
            }
            if (d3 != d5 || !(d4 < d6)) break;
            return Orientation.WEST;
        }
        return null;
    }

    private static void updatePortOrientation(SplitBlock splitBlock, List<List<mxPoint>> list, XcosDiagram xcosDiagram, BasicPort basicPort) {
        block7: {
            mxPoint mxPoint2;
            mxPoint mxPoint3;
            mxPoint mxPoint4;
            BasicPort basicPort2;
            BasicPort basicPort3;
            BasicPort basicPort4;
            mxPoint mxPoint5;
            block8: {
                block6: {
                    mxGeometry mxGeometry2 = xcosDiagram.getModel().getGeometry((Object)splitBlock);
                    mxPoint5 = new mxPoint(mxGeometry2.getCenterX(), mxGeometry2.getCenterY());
                    basicPort4 = splitBlock.getIn();
                    basicPort3 = splitBlock.getOut1();
                    basicPort2 = splitBlock.getOut2();
                    mxPoint4 = BlockAutoPositionUtils.getPortPosition(BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort4));
                    mxPoint3 = BlockAutoPositionUtils.getPortPosition(BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort3));
                    mxPoint2 = BlockAutoPositionUtils.getPortPosition(BlockAutoPositionUtils.getSplitLinkPort(splitBlock, basicPort2));
                    if (basicPort != null && basicPort != basicPort4) break block6;
                    basicPort4.setOrientation(BlockAutoPositionUtils.getInputOrientation(list, mxPoint4, mxPoint5));
                    for (int i = 0; i < list.size(); ++i) {
                        List<mxPoint> list2 = list.get(i);
                        if (XcosRouteUtils.pointInLink(mxPoint3.getX(), mxPoint3.getY(), list2)) {
                            basicPort3.setOrientation(BlockAutoPositionUtils.getPortOrientation(list2, mxPoint5));
                        }
                        if (!XcosRouteUtils.pointInLink(mxPoint2.getX(), mxPoint2.getY(), list2)) continue;
                        basicPort2.setOrientation(BlockAutoPositionUtils.getPortOrientation(list2, mxPoint5));
                    }
                    break block7;
                }
                if (basicPort != basicPort3) break block8;
                basicPort3.setOrientation(BlockAutoPositionUtils.getInputOrientation(list, mxPoint3, mxPoint5));
                for (int i = 0; i < list.size(); ++i) {
                    List<mxPoint> list3 = list.get(i);
                    if (XcosRouteUtils.pointInLink(mxPoint4.getX(), mxPoint4.getY(), list3)) {
                        basicPort4.setOrientation(BlockAutoPositionUtils.getPortOrientation(list3, mxPoint5));
                    }
                    if (!XcosRouteUtils.pointInLink(mxPoint2.getX(), mxPoint2.getY(), list3)) continue;
                    basicPort2.setOrientation(BlockAutoPositionUtils.getPortOrientation(list3, mxPoint5));
                }
                break block7;
            }
            if (basicPort != basicPort2) break block7;
            basicPort2.setOrientation(BlockAutoPositionUtils.getInputOrientation(list, mxPoint2, mxPoint5));
            for (int i = 0; i < list.size(); ++i) {
                List<mxPoint> list4 = list.get(i);
                if (XcosRouteUtils.pointInLink(mxPoint3.getX(), mxPoint3.getY(), list4)) {
                    basicPort3.setOrientation(BlockAutoPositionUtils.getPortOrientation(list4, mxPoint5));
                }
                if (!XcosRouteUtils.pointInLink(mxPoint4.getX(), mxPoint4.getY(), list4)) continue;
                basicPort4.setOrientation(BlockAutoPositionUtils.getPortOrientation(list4, mxPoint5));
            }
        }
    }

    private static void updateSplitLink(SplitBlock splitBlock, Object[] objectArray, XcosDiagram xcosDiagram) {
        XcosRoute xcosRoute = new XcosRoute();
        BasicLink basicLink = (BasicLink)splitBlock.getIn().getEdgeAt(0);
        BasicLink basicLink2 = (BasicLink)splitBlock.getOut1().getEdgeAt(0);
        BasicLink basicLink3 = (BasicLink)splitBlock.getOut2().getEdgeAt(0);
        boolean bl = true;
        BlockAutoPositionUtils.reset(xcosDiagram, (Object)basicLink);
        BlockAutoPositionUtils.reset(xcosDiagram, (Object)basicLink2);
        BlockAutoPositionUtils.reset(xcosDiagram, (Object)basicLink3);
        xcosDiagram.setCellStyles(mxConstants.STYLE_NOEDGESTYLE, "1", (Object[])new BasicLink[]{basicLink, basicLink2, basicLink3});
        xcosRoute.updateRoute(basicLink, objectArray, xcosDiagram, bl);
        xcosRoute.updateRoute(basicLink2, objectArray, xcosDiagram, bl);
        xcosRoute.updateRoute(basicLink3, objectArray, xcosDiagram, bl);
    }

    private static void reset(ScilabGraph scilabGraph, Object object) {
        SelectionCellsHandler selectionCellsHandler = (SelectionCellsHandler)scilabGraph.getAsComponent().getSelectionCellsHandler();
        scilabGraph.resetEdge(object);
        selectionCellsHandler.clearCellHandler(object);
    }
}

