/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.preferences;

import java.util.Set;
import org.scilab.modules.commons.xml.XConfigurationEvent;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.xcos.preferences.XcosKeyMap;
import org.scilab.modules.xcos.preferences.XcosOptions;

public class XcosConfiguration
implements XConfigurationListener {
    public void configurationChanged(XConfigurationEvent xConfigurationEvent) {
        KeyMap keyMap;
        Options options = new Options(xConfigurationEvent.getModifiedPaths());
        if (options.changed()) {
            XcosOptions.invalidate(options);
        }
        if ((keyMap = new KeyMap(xConfigurationEvent.getModifiedPaths())).changed()) {
            XcosKeyMap.invalidate(keyMap);
            XcosKeyMap.updateActionKeys();
        }
    }

    protected static class KeyMap {
        public boolean keymap;

        public KeyMap(Set<String> set) {
            this.keymap = set.contains("ALL") ? true : set.contains("//general/shortcuts/body/actions/action-folder[@xconf-uid=\"xcos\"]/action");
        }

        public boolean changed() {
            return this.keymap;
        }
    }

    protected static class Options {
        public boolean preferences;
        public boolean edition;
        public boolean simulation;

        public Options(Set<String> set) {
            if (set.contains("ALL")) {
                this.preferences = true;
                this.edition = true;
                this.simulation = true;
            } else {
                this.preferences = set.contains("//xcos/body/xcos-preferences");
                this.edition = set.contains("//xcos/edition/body/xcos-edition");
                this.simulation = set.contains("//xcos/simulation/body/xcos-simulation");
            }
        }

        public boolean changed() {
            return this.preferences || this.edition || this.simulation;
        }
    }
}

