/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.port;

import com.mxgraph.util.mxConstants;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.output.OutputPort;

public enum Orientation {
    WEST,
    NORTH,
    EAST,
    SOUTH;

    private static final int MAX_ROTATION = 360;
    private static final int PERPENDICULAR_ROTATION = 90;

    public int getRelativeAngle(int n, Class<? extends BasicPort> clazz, boolean bl, boolean bl2) {
        int n2 = this.getOrientationAngle();
        int n3 = this.getBaseAngle(clazz, n2);
        return this.getFlippedAndMirroredAngle(n3 + n, bl, bl2);
    }

    public int getAbsoluteAngle(Class<? extends BasicPort> clazz, boolean bl, boolean bl2) {
        int n = this.getOrientationAngle();
        int n2 = this.getBaseAngle(clazz, n);
        return this.getFlippedAndMirroredAngle(n2, bl, bl2);
    }

    private int getFlippedAndMirroredAngle(int n, boolean bl, boolean bl2) {
        int n2 = n;
        switch (this) {
            case NORTH: 
            case SOUTH: {
                if (!bl) break;
                n2 += 180;
                break;
            }
            case WEST: 
            case EAST: {
                if (!bl2) break;
                n2 += 180;
                break;
            }
        }
        return n2 % 360;
    }

    private int getOrientationAngle() {
        return this.ordinal() * 90;
    }

    private int getBaseAngle(Class<? extends BasicPort> clazz, int n) {
        boolean bl;
        boolean bl2 = bl = OutputPort.class.isAssignableFrom(clazz) || CommandPort.class.isAssignableFrom(clazz);
        if (bl) {
            return n + 180;
        }
        return n;
    }

    public String getLabelPosition() {
        String string;
        switch (this) {
            case EAST: {
                string = "right";
                break;
            }
            case WEST: {
                string = "left";
                break;
            }
            default: {
                string = "center";
            }
        }
        return string;
    }

    public String getVerticalLabelPosition() {
        String string;
        switch (this) {
            case NORTH: {
                string = "top";
                break;
            }
            case SOUTH: {
                string = "bottom";
                break;
            }
            default: {
                string = "middle";
            }
        }
        return string;
    }

    public String getSpacingSide() {
        String string;
        switch (this) {
            case NORTH: {
                string = mxConstants.STYLE_SPACING_TOP;
                break;
            }
            case SOUTH: {
                string = mxConstants.STYLE_SPACING_BOTTOM;
                break;
            }
            case EAST: {
                string = mxConstants.STYLE_SPACING_RIGHT;
                break;
            }
            default: {
                string = mxConstants.STYLE_SPACING_LEFT;
            }
        }
        return string;
    }
}

