/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.port;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.PortKind;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.port.Orientation;

public abstract class BasicPort
extends XcosCell {
    private static final long serialVersionUID = 0L;
    public static final double DEFAULT_PORTSIZE = 8.0;
    private Orientation orientation;

    public BasicPort(JavaController javaController, long l, Kind kind, Object object, String string, String string2, Orientation orientation, boolean bl, PortKind portKind) {
        super(javaController, l, kind, object, new mxGeometry(0.0, 0.0, 8.0, 8.0), string, string2);
        this.vertex = true;
        javaController.setObjectProperty(l, Kind.PORT, ObjectProperties.IMPLICIT, bl);
        javaController.setObjectProperty(l, Kind.PORT, ObjectProperties.PORT_KIND, portKind.ordinal());
        this.orientation = orientation;
        this.setStyle(this.computeLabelPosition(orientation));
    }

    public abstract Type getType();

    public abstract PortKind getPortKind();

    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.setStyle(this.computeLabelPosition(this.orientation));
        }
    }

    public final String computeLabelPosition(Orientation orientation) {
        if (orientation != null) {
            StyleMap styleMap = new StyleMap(this.getStyle());
            styleMap.remove((Object)mxConstants.STYLE_LABEL_POSITION);
            styleMap.remove((Object)mxConstants.STYLE_VERTICAL_LABEL_POSITION);
            styleMap.remove((Object)mxConstants.STYLE_SPACING_BOTTOM);
            styleMap.remove((Object)mxConstants.STYLE_SPACING_LEFT);
            styleMap.remove((Object)mxConstants.STYLE_SPACING_RIGHT);
            styleMap.remove((Object)mxConstants.STYLE_SPACING_TOP);
            styleMap.put((Object)mxConstants.STYLE_ALIGN, (Object)orientation.getLabelPosition());
            styleMap.put((Object)mxConstants.STYLE_VERTICAL_ALIGN, (Object)orientation.getVerticalLabelPosition());
            styleMap.put((Object)mxConstants.STYLE_SPACING, (Object)Double.toString(10.0));
            return styleMap.toString();
        }
        return this.getStyle();
    }

    public void updateLabel(ScilabType scilabType) {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        mxICell mxICell2 = this.getParent();
        if (mxICell2 != null) {
            if (mxICell2 instanceof BasicBlock) {
                JavaController javaController = new JavaController();
                String[] stringArray = new String[1];
                javaController.getObjectProperty(((BasicBlock)mxICell2).getUID(), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, stringArray);
                stringBuilder.append(stringArray[0]).append('.');
            } else {
                stringBuilder.append(mxICell2.getClass().getSimpleName()).append('.');
            }
        }
        if (this.getChildCount() > 0) {
            stringBuilder.append(this.getChildAt(0).getValue());
        } else {
            stringBuilder.append(((Object)((Object)this)).getClass().getSimpleName());
        }
        if (mxICell2 != null) {
            stringBuilder.append('[').append(this.getParent().getIndex((mxICell)this)).append(']');
        }
        if (this.getEdgeCount() == 1) {
            stringBuilder.append(" (connected)");
        } else if (this.getEdgeCount() > 1) {
            stringBuilder.append(" - multiple links (");
            stringBuilder.append(this.getEdgeCount());
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static enum DataType {
        UNKNOW_TYPE,
        REAL_MATRIX,
        COMPLEX_MATRIX,
        INT32_MATRIX,
        INT16_MATRIX,
        INT8_MATRIX,
        UINT32_MATRIX,
        UINT16_MATRIX,
        UINT8_MATRIX;


        public int asScilabValue() {
            if (this.equals((Object)UNKNOW_TYPE)) {
                return -1;
            }
            return this.ordinal();
        }

        public static DataType convertScilabValue(int n) {
            if (n <= 0 || n > DataType.values().length - 1) {
                return UNKNOW_TYPE;
            }
            return DataType.values()[n];
        }

        public static DataType convertScilabValue(double d) {
            return DataType.convertScilabValue((int)d);
        }
    }

    public static enum Type {
        IMPLICIT,
        EXPLICIT;


        public String getAsString() {
            switch (this) {
                case IMPLICIT: {
                    return "I";
                }
                case EXPLICIT: {
                    return "E";
                }
            }
            return "";
        }
    }
}

