/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.xcos.palette.model.Category;
import org.scilab.modules.xcos.palette.model.Palette;
import org.scilab.modules.xcos.palette.model.PreLoaded;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PaletteNode")
@XmlSeeAlso(value={Category.class, Palette.class})
public abstract class PaletteNode
implements TreeNode {
    private static final Logger LOG = Logger.getLogger(PaletteNode.class.getName());
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=true)
    private boolean enable;
    @XmlTransient
    private Category parent;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public void setParent(Category category) {
        this.parent = category;
    }

    @Override
    public Category getParent() {
        return this.parent;
    }

    public String toString() {
        if (this.getName() != null && !this.getName().isEmpty()) {
            return Messages.gettext((String)this.getName());
        }
        return this.getName();
    }

    public static void checkRemoving(PaletteNode paletteNode) {
        if (paletteNode == null) {
            throw new RuntimeException(String.format(org.scilab.modules.xcos.palette.Palette.WRONG_INPUT_ARGUMENT_S_INVALID_TREE_PATH, "name"));
        }
        if (paletteNode instanceof PreLoaded && !(paletteNode instanceof PreLoaded.Dynamic)) {
            throw new RuntimeException(String.format(org.scilab.modules.xcos.palette.Palette.WRONG_INPUT_ARGUMENT_S_INVALID_NODE, "name"));
        }
        if (paletteNode instanceof Category) {
            for (PaletteNode paletteNode2 : ((Category)paletteNode).getNode()) {
                PaletteNode.checkRemoving(paletteNode2);
            }
        }
    }

    public static void remove(PaletteNode paletteNode) {
        int n;
        PaletteNode.checkRemoving(paletteNode);
        Category category = paletteNode.getParent();
        if (category == null) {
            LOG.severe("parent node is null");
            throw new RuntimeException("Parent node is 'null'");
        }
        TreeNode treeNode = category.getChildCount() > 1 ? ((n = category.getIndex(paletteNode)) > 0 ? category.getChildAt(n - 1) : category.getChildAt(n + 1)) : category;
        paletteNode.setParent(null);
        category.getNode().remove(paletteNode);
        PaletteNode.refreshView(category, treeNode);
    }

    public static void refreshView(TreeNode treeNode, TreeNode treeNode2) {
        if (PaletteManagerView.get() != null) {
            JTree jTree = PaletteManagerView.get().getTree();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
            defaultTreeModel.reload();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (TreeNode treeNode3 = treeNode2; treeNode3 != null; treeNode3 = treeNode3.getParent()) {
                arrayList.add(treeNode3);
            }
            Collections.reverse(arrayList);
            if (arrayList.get(0) != jTree.getModel().getRoot()) {
                arrayList.add(0, jTree.getModel().getRoot());
            }
            jTree.setSelectionPath(new TreePath(arrayList.toArray()));
            PaletteManagerView.get().getSearchManager().setIndexIsOutdated(true);
        }
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        if (object != null) {
            this.setParent((Category)object);
        }
    }
}

