/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.scilab.modules.xcos.palette.PaletteSearchManager;

public final class PaletteSearcher {
    private PaletteSearchManager mgr;

    public PaletteSearcher(PaletteSearchManager paletteSearchManager) {
        this.mgr = paletteSearchManager;
    }

    public List<Document> search(String string) {
        ArrayList<Document> arrayList = new ArrayList<Document>();
        try (DirectoryReader directoryReader = DirectoryReader.open((Directory)this.mgr.getDirectory());){
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)directoryReader);
            StandardQueryParser standardQueryParser = new StandardQueryParser();
            standardQueryParser.setAllowLeadingWildcard(true);
            standardQueryParser.setLowercaseExpandedTerms(true);
            standardQueryParser.setAnalyzer(this.mgr.getAnalyzer());
            standardQueryParser.setMultiFields((CharSequence[])new String[]{"refname", "refpurpose", "content"});
            Query query = standardQueryParser.parse(string, null);
            TopDocs topDocs = indexSearcher.search(query, 150);
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            if (scoreDocArray.length == 0) {
                query = standardQueryParser.parse("*" + string + "*", null);
                topDocs = indexSearcher.search(query, 150);
                scoreDocArray = topDocs.scoreDocs;
            }
            for (int i = 0; i < scoreDocArray.length; ++i) {
                Document document = indexSearcher.doc(scoreDocArray[i].doc);
                arrayList.add(document);
            }
        }
        catch (IOException | QueryNodeException throwable) {
            Logger.getLogger(PaletteSearcher.class.getName()).log(Level.SEVERE, null, throwable);
        }
        return arrayList;
    }
}

