/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeModel;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.scilab.modules.xcos.palette.PaletteIndexer;
import org.scilab.modules.xcos.palette.PaletteSearcher;
import org.scilab.modules.xcos.palette.model.PaletteBlock;
import org.scilab.modules.xcos.palette.model.PaletteNode;
import org.scilab.modules.xcos.palette.model.PreLoaded;
import org.scilab.modules.xcos.palette.view.PaletteManagerPanel;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.palette.view.PaletteSearchView;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class PaletteSearchManager {
    private Boolean indexIsOutdated = true;
    private Analyzer analyzer;
    private IndexWriter writer;
    private Directory indexedDirectory;
    private PaletteIndexer paletteIndexer;
    private PaletteSearcher paletteSearcher;
    private PaletteSearchView view;
    private Map<String, PaletteBlock> nameToPalette;

    public PaletteSearchManager() {
        try {
            this.indexedDirectory = new RAMDirectory();
            this.analyzer = new StandardAnalyzer();
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            this.writer = new IndexWriter(this.indexedDirectory, indexWriterConfig);
        }
        catch (IOException iOException) {
            Logger.getLogger(PaletteSearchManager.class.getName()).log(Level.SEVERE, null, iOException);
        }
        this.nameToPalette = new HashMap<String, PaletteBlock>();
        this.view = new PaletteSearchView();
        this.paletteIndexer = new PaletteIndexer(this);
        this.paletteSearcher = new PaletteSearcher(this);
    }

    public void search(String string) {
        PaletteManagerView.get().getTree().clearSelection();
        this.view.initComponents();
        String string2 = "'" + string + "' - ";
        this.view.setText(string2 + XcosMessages.SEARCHING);
        PaletteManagerPanel paletteManagerPanel = PaletteManagerView.get().getPanel();
        JScrollPane jScrollPane = (JScrollPane)paletteManagerPanel.getRightComponent();
        jScrollPane.setViewportView(this.view);
        if (this.indexIsOutdated.booleanValue()) {
            this.refreshIndex();
            this.indexIsOutdated = false;
        }
        List<Document> list = this.paletteSearcher.search(string);
        for (Document document : list) {
            PaletteBlock paletteBlock = this.nameToPalette.get(document.get("refname"));
            if (paletteBlock == null) continue;
            this.view.addBlock(paletteBlock);
        }
        this.view.setText(string2 + list.size() + " " + XcosMessages.MATCHES);
        this.view.revalidate();
        jScrollPane.revalidate();
    }

    private void refreshIndex() {
        TreeModel treeModel = PaletteManagerView.get().getTree().getModel();
        if (treeModel != null) {
            this.loadHashTable(treeModel, treeModel.getRoot(), "");
            this.paletteIndexer.createIndex(this.nameToPalette);
        }
    }

    private void loadHashTable(TreeModel treeModel, Object object, String string) {
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            PaletteNode paletteNode = (PaletteNode)treeModel.getChild(object, i);
            if (paletteNode instanceof PreLoaded) {
                for (PaletteBlock paletteBlock : ((PreLoaded)paletteNode).getBlock()) {
                    this.nameToPalette.put(paletteBlock.getName(), paletteBlock);
                }
                continue;
            }
            this.loadHashTable(treeModel, paletteNode, string + File.separator + paletteNode.toString());
        }
    }

    public void setIndexIsOutdated(Boolean bl) {
        this.indexIsOutdated = bl;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public IndexWriter getIndexWriter() {
        return this.writer;
    }

    public Directory getDirectory() {
        return this.indexedDirectory;
    }
}

