/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.xcos.palette.PaletteSearchManager;
import org.scilab.modules.xcos.palette.model.PaletteBlock;

public final class PaletteIndexer {
    private PaletteSearchManager mgr;
    private List<File> roots;

    public PaletteIndexer(PaletteSearchManager paletteSearchManager) {
        this.mgr = paletteSearchManager;
        this.roots = new ArrayList<File>();
        this.roots.add(new File(ScilabConstants.SCI.getAbsolutePath() + "/modules/helptools/javaHelp"));
        this.roots.add(new File(ScilabConstants.SCI.getAbsolutePath() + "/modules/helptools/jar"));
    }

    public void createIndex(final Map<String, PaletteBlock> map) {
        try {
            this.mgr.getIndexWriter().deleteAll();
            for (String object : map.keySet()) {
                this.index(object);
            }
            for (File file : this.roots) {
                if (!file.exists()) continue;
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        String string = path.getFileName().toString();
                        int n = string.lastIndexOf(46);
                        if (n <= 0) {
                            return FileVisitResult.CONTINUE;
                        }
                        String string2 = string.substring(0, n);
                        if (string.endsWith(".jar")) {
                            try (JarFile jarFile = new JarFile(path.toFile());){
                                PaletteIndexer.this.index(path.toAbsolutePath().toUri().toString(), string2, jarFile, map);
                            }
                        } else if (string.endsWith(".html") && map.containsKey(string2)) {
                            PaletteIndexer.this.index(string2, path.toUri().toURL());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            this.mgr.getIndexWriter().commit();
        }
        catch (IOException iOException) {
            Logger.getLogger(PaletteIndexer.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    private void index(final String string, final String string2, JarFile jarFile, Map<String, PaletteBlock> map) {
        class Entry {
            JarEntry je;
            String blk;
            URL url;

            Entry(JarEntry jarEntry) {
                this.je = jarEntry;
            }

            boolean block() {
                int n = this.je.getName().lastIndexOf(47) + 1;
                int n2 = this.je.getName().lastIndexOf(46);
                if (n < 0 || n2 < 0) {
                    return false;
                }
                this.blk = this.je.getName().substring(n, n2);
                return true;
            }

            boolean url() {
                try {
                    this.url = new URL("jar:" + string + "!/" + string2 + '/' + this.blk + ".html");
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(PaletteIndexer.class.getName()).log(Level.SEVERE, null, malformedURLException);
                }
                return true;
            }
        }
        jarFile.stream().map(jarEntry -> new Entry((JarEntry)jarEntry)).filter(entry -> entry.block()).filter(entry -> map.containsKey(entry.blk)).filter(entry -> entry.url()).forEach(entry -> this.index(entry.blk, entry.url));
    }

    private void index(String string2, URL uRL) {
        try {
            Document document = new Document();
            TextField textField = new TextField("refname", string2, Field.Store.YES);
            textField.setBoost(100.0f);
            document.add((IndexableField)textField);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));){
                Optional<String> optional = bufferedReader.lines().filter(string -> string.contains("refpurpose")).findFirst();
                TextField textField2 = optional.isPresent() ? new TextField("refpurpose", optional.get(), Field.Store.YES) : new TextField("refpurpose", "", Field.Store.YES);
                textField2.setBoost(10.0f);
                document.add((IndexableField)textField2);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            var6_7 = null;
            try {
                document.add((IndexableField)new TextField("content", (Reader)bufferedReader));
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
            finally {
                if (bufferedReader != null) {
                    if (var6_7 != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        bufferedReader.close();
                    }
                }
            }
            this.mgr.getIndexWriter().addDocument((Iterable)document);
        }
        catch (IOException iOException) {
            Logger.getLogger(PaletteIndexer.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    private void index(String string) {
        try {
            Document document = new Document();
            document.add((IndexableField)new StringField("refname", string, Field.Store.YES));
            document.add((IndexableField)new StringField("refpurpose", string, Field.Store.YES));
            document.add((IndexableField)new TextField("content", string, Field.Store.YES));
            this.mgr.getIndexWriter().addDocument((Iterable)document);
        }
        catch (IOException iOException) {
            Logger.getLogger(PaletteIndexer.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }
}

