/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.modelica;

import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.xcos.modelica.ModelStatistics;
import org.scilab.modules.xcos.modelica.Modelica;
import org.scilab.modules.xcos.modelica.ModelicaMessages;
import org.scilab.modules.xcos.modelica.TerminalAccessor;
import org.scilab.modules.xcos.modelica.model.Model;
import org.scilab.modules.xcos.modelica.model.Struct;
import org.scilab.modules.xcos.modelica.model.Terminal;
import org.scilab.modules.xcos.modelica.view.MainPanel;

public final class ModelicaController {
    private static final String VARIABLE = "variable";
    private static final String FIXED_PARAMETER = "fixed_parameter";
    private static final Pattern DERIVATIVE_REGEX = Pattern.compile("(\\p{Graph}*)__der_(\\p{Graph}*)");
    private final Model root;
    private final ModelStatistics statistics = new ModelStatistics();
    private boolean compileNeeded;
    private boolean valid;
    private boolean parameterEmbedded;
    private boolean jacobianEnable;
    private ComputationMethod computeMethod;
    private final EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent;

    public ModelicaController(Model model) {
        this.root = model;
        this.statistics.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ModelStatistics modelStatistics = (ModelStatistics)changeEvent.getSource();
                ModelicaController.this.setValid(modelStatistics.getEquations() >= modelStatistics.getUnknowns() + modelStatistics.getDiscreteStates() + modelStatistics.getInputs() + modelStatistics.getOutputs());
            }
        });
        this.setDefaultValues();
    }

    public static void showDialog(File file, File file2) {
        JDialog jDialog = new JDialog();
        jDialog.setTitle(ModelicaMessages.MODELICA_SETTINGS);
        jDialog.setAlwaysOnTop(false);
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"scilab"));
        jDialog.setIconImage(imageIcon.getImage());
        try {
            Model model = Modelica.getInstance().load(file);
            Model model2 = Modelica.getInstance().load(file2);
            ModelicaController modelicaController = new ModelicaController(Modelica.getInstance().merge(model, model2));
            jDialog.add(new MainPanel(modelicaController));
            jDialog.setVisible(true);
            jDialog.pack();
            jDialog.setDefaultCloseOperation(2);
            ScilabSwingUtilities.closeOnEscape((Window)jDialog);
        }
        catch (JAXBException jAXBException) {
            System.err.println((Object)jAXBException);
            Logger.getLogger(ModelicaController.class.getName()).severe(jAXBException.toString());
        }
    }

    public Model getRoot() {
        return this.root;
    }

    public boolean isCompileNeeded() {
        return this.compileNeeded;
    }

    public void setCompileNeeded(boolean bl) {
        if (this.compileNeeded != bl) {
            this.compileNeeded = bl;
            this.fireChange();
        }
    }

    public boolean isParameterEmbedded() {
        return this.parameterEmbedded;
    }

    public void setParameterEmbedded(boolean bl) {
        if (this.parameterEmbedded != bl) {
            this.parameterEmbedded = bl;
            this.fireChange();
        }
    }

    public boolean isJacobianEnable() {
        return this.jacobianEnable;
    }

    public void setJacobianEnable(boolean bl) {
        if (this.jacobianEnable != bl) {
            this.jacobianEnable = bl;
            this.fireChange();
        }
    }

    public boolean isSquare() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        if (this.valid != bl) {
            this.valid = bl;
            this.fireChange();
        }
    }

    public ComputationMethod getComputeMethod() {
        return this.computeMethod;
    }

    public void setComputeMethod(ComputationMethod computationMethod) {
        if (this.computeMethod != null && !this.computeMethod.equals((Object)computationMethod)) {
            this.computeMethod = computationMethod;
            this.fireChange();
        }
    }

    public ModelStatistics getStatistics() {
        if (!this.statistics.isEmpty()) {
            this.statistics.clear();
        }
        this.statistics.setEquations(this.root.getEquations().getEquation().size());
        this.updateIdentifiers(this.root.getIdentifiers());
        for (Struct struct : this.getRoot().getElements().getStruct()) {
            this.updateInfo(struct);
        }
        return this.statistics;
    }

    private void updateIdentifiers(Model.Identifiers identifiers) {
        if (identifiers != null) {
            List<JAXBElement<String>> list = identifiers.getParameterOrExplicitVariableOrImplicitVariable();
            QName qName = new QName("", "implicit_variable");
            long l = 0L;
            for (JAXBElement<String> jAXBElement : list) {
                if (!jAXBElement.getName().equals(qName)) continue;
                ++l;
            }
            this.statistics.setRelaxedVariables(l);
        }
    }

    private void updateInfo(Struct struct) {
        for (Object object : struct.getSubnodes().getStructOrTerminal()) {
            if (object instanceof Terminal) {
                Terminal terminal = (Terminal)object;
                String string = (String)TerminalAccessor.getData(TerminalAccessor.KIND, terminal);
                Double d = (Double)TerminalAccessor.getData(TerminalAccessor.WEIGHT, terminal);
                String string2 = (String)TerminalAccessor.getData(TerminalAccessor.ID, terminal);
                this.incrementTerminalWeight(string, d);
                if (string2 == null || !DERIVATIVE_REGEX.matcher(string2).matches()) continue;
                this.statistics.incDerivativeStates();
                continue;
            }
            this.updateInfo((Struct)object);
        }
    }

    private void incrementTerminalWeight(String string, double d) {
        if (FIXED_PARAMETER.equals(string)) {
            if (d >= 1.0) {
                this.statistics.incFixedParameters();
            } else {
                this.statistics.incRelaxedParameters();
            }
        } else if (VARIABLE.equals(string)) {
            if (d >= 1.0) {
                this.statistics.incFixedVariables();
            } else {
                this.statistics.incRelaxedVariables();
            }
        } else if ("discrete_variable".equals(string)) {
            this.statistics.incDiscreteStates();
        } else if ("input".equals(string)) {
            this.statistics.incInputs();
        } else if ("output".equals(string)) {
            this.statistics.incOutputs();
        }
    }

    private void setDefaultValues() {
        for (Struct struct : this.getRoot().getElements().getStruct()) {
            this.setDefaultValues(struct);
        }
    }

    private void setDefaultValues(Struct struct) {
        for (Object object : struct.getSubnodes().getStructOrTerminal()) {
            if (object instanceof Terminal) {
                Terminal terminal = (Terminal)object;
                Boolean bl = (Boolean)TerminalAccessor.getData(TerminalAccessor.FIXED, terminal);
                Double d = (Double)TerminalAccessor.getData(TerminalAccessor.WEIGHT, terminal);
                Double d2 = (Double)TerminalAccessor.getData(TerminalAccessor.INITIAL, terminal);
                continue;
            }
            this.setDefaultValues((Struct)object);
        }
    }

    public void fixWeight(double d, double d2) {
        for (Struct struct : this.getRoot().getElements().getStruct()) {
            this.updateWeight(struct, d, d2);
        }
        this.getStatistics().fireChange();
        this.fireChange();
    }

    private void updateWeight(Struct struct, double d, double d2) {
        Object object;
        Terminal terminal;
        HashMap<String, Terminal> hashMap = new HashMap<String, Terminal>();
        HashMap<String, Terminal> hashMap2 = new HashMap<String, Terminal>();
        for (Object object2 : struct.getSubnodes().getStructOrTerminal()) {
            if (object2 instanceof Terminal) {
                terminal = (Terminal)object2;
                object = (String)TerminalAccessor.getData(TerminalAccessor.ID, terminal);
                Matcher matcher = DERIVATIVE_REGEX.matcher((CharSequence)object);
                if (matcher.matches()) {
                    String string = matcher.group(1) + matcher.group(2);
                    hashMap.put(string, terminal);
                    continue;
                }
                hashMap2.put((String)object, terminal);
                continue;
            }
            this.updateWeight((Struct)object2, d, d2);
        }
        for (Object object2 : hashMap.keySet()) {
            assert (hashMap.containsKey(object2));
            assert (hashMap2.containsKey(object2));
            terminal = (Terminal)hashMap.get(object2);
            object = (Terminal)hashMap2.get(object2);
            TerminalAccessor.WEIGHT.setData(d2, (Terminal)object);
            TerminalAccessor.WEIGHT.setData(d, terminal);
            TerminalAccessor.FIXED.setData(Boolean.TRUE, (Terminal)object);
            TerminalAccessor.FIXED.setData(Boolean.TRUE, terminal);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeFooListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public void fireChange() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public static enum ComputationMethod {
        Kinsol("Kinsol"),
        Ida("Ida (init)"),
        Fsolve("Fsolve"),
        Optim("Optim"),
        NelderMead("Nelder_Mead"),
        Hompack77("Hompack77");

        private final String name;

        private ComputationMethod(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

