/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabInteger;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.VectorOfString;
import org.scilab.modules.xcos.io.ScilabTypeCoder;
import org.scilab.modules.xcos.io.writer.ScilabWriter;
import org.scilab.modules.xcos.io.writer.XcosWriter;

public class RawDataWriter
extends ScilabWriter {
    private final HashMap<ScilabType, Integer> dictionaryMap = new HashMap();

    public RawDataWriter(XcosWriter xcosWriter) {
        super(xcosWriter);
    }

    public void fillSharedDictionary() {
        if (this.shared.dictionary == null) {
            return;
        }
        this.shared.dictionary.addAll(Collections.nCopies(this.dictionaryMap.size(), new ScilabDouble()));
        for (Map.Entry<ScilabType, Integer> entry : this.dictionaryMap.entrySet()) {
            this.shared.dictionary.set(entry.getValue().intValue(), (Object)entry.getKey());
        }
    }

    @Override
    public void write(long l, Kind kind) throws XMLStreamException {
        switch (kind) {
            case BLOCK: {
                this.writeBlock(l, kind);
                break;
            }
            case DIAGRAM: {
                this.writeContext(l, kind);
                break;
            }
        }
    }

    public void writeContext(long l, Kind kind) throws XMLStreamException {
        VectorOfString vectorOfString = new VectorOfString();
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.DIAGRAM_CONTEXT, vectorOfString);
        String[] stringArray = new String[vectorOfString.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = vectorOfString.get(i);
        }
        this.write(stringArray, "context");
    }

    private void writeBlock(long l, Kind kind) throws XMLStreamException {
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        VectorOfInt vectorOfInt = new VectorOfInt();
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.EXPRS, vectorOfDouble);
        this.write(new ScilabTypeCoder().vec2var(vectorOfDouble), "exprs");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.RPAR, vectorOfDouble);
        this.write(vectorOfDouble, "realParameters");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.IPAR, vectorOfInt);
        this.write(vectorOfInt, "integerParameters");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.OPAR, vectorOfDouble);
        this.write(new ScilabTypeCoder().vec2var(vectorOfDouble), "objectsParameters");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.NZCROSS, vectorOfInt);
        this.write(vectorOfInt, "nbZerosCrossing");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.NMODE, vectorOfInt);
        this.write(vectorOfInt, "nmode");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.STATE, vectorOfDouble);
        this.write(vectorOfDouble, "state");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.DSTATE, vectorOfDouble);
        this.write(vectorOfDouble, "dState");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.ODSTATE, vectorOfDouble);
        this.write(new ScilabTypeCoder().vec2var(vectorOfDouble), "oDState");
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.EQUATIONS, vectorOfDouble);
        this.write(new ScilabTypeCoder().vec2var(vectorOfDouble), "equations");
    }

    private void write(String[] stringArray, String string) throws XMLStreamException {
        this.shared.stream.writeStartElement("Array");
        this.shared.stream.writeAttribute("as", string);
        this.shared.stream.writeAttribute("scilabClass", "String[]");
        for (String string2 : stringArray) {
            this.shared.stream.writeEmptyElement("add");
            this.shared.stream.writeAttribute("value", string2);
        }
        this.shared.stream.writeEndElement();
    }

    private void write(ScilabType scilabType, String string) throws XMLStreamException {
        if (this.shared.dictionary == null) {
            this.writeAsXml(scilabType, string);
        } else {
            this.writeAsBinary(scilabType, string);
        }
    }

    private void writeAsXml(ScilabType scilabType, String string) throws XMLStreamException {
        boolean bl;
        String string2;
        String string3;
        String string4;
        ScilabTypeEnum scilabTypeEnum = scilabType.getType();
        switch (scilabTypeEnum) {
            case sci_boolean: {
                string4 = "ScilabBoolean";
                string3 = null;
                string2 = null;
                break;
            }
            case sci_ints: {
                string4 = "ScilabInteger";
                string3 = null;
                string2 = ((ScilabInteger)scilabType).getPrec().name();
                break;
            }
            case sci_matrix: {
                string4 = "ScilabDouble";
                string3 = null;
                string2 = null;
                break;
            }
            case sci_strings: {
                string4 = "ScilabString";
                string3 = null;
                string2 = null;
                break;
            }
            case sci_list: {
                string4 = "Array";
                string3 = "ScilabList";
                string2 = null;
                break;
            }
            case sci_mlist: {
                string4 = "Array";
                string3 = "ScilabMList";
                string2 = null;
                break;
            }
            case sci_tlist: {
                string4 = "Array";
                string3 = "ScilabTList";
                string2 = null;
                break;
            }
            default: {
                throw new XMLStreamException("Not handled ScilabType : " + scilabTypeEnum.name());
            }
        }
        boolean bl2 = bl = scilabType.getHeight() > 0 && scilabType.getWidth() > 0;
        if (bl) {
            this.shared.stream.writeStartElement(string4);
        } else {
            this.shared.stream.writeEmptyElement(string4);
        }
        if (string != null) {
            this.shared.stream.writeAttribute("as", string);
        }
        if (scilabType instanceof ArrayList) {
            this.writeList(scilabType, string3);
        } else {
            this.writeMatrix(scilabType, scilabTypeEnum, string2);
        }
        if (bl) {
            this.shared.stream.writeEndElement();
        }
    }

    private void writeList(ScilabType scilabType, String string) throws XMLStreamException {
        this.shared.stream.writeAttribute("scilabClass", string);
        ArrayList arrayList = (ArrayList)scilabType;
        for (ScilabType scilabType2 : arrayList) {
            this.write(scilabType2, null);
        }
    }

    private void writeMatrix(ScilabType scilabType, ScilabTypeEnum scilabTypeEnum, String string) throws XMLStreamException {
        this.shared.stream.writeAttribute("height", Integer.toString(scilabType.getHeight()));
        this.shared.stream.writeAttribute("width", Integer.toString(scilabType.getWidth()));
        if (string != null) {
            this.shared.stream.writeAttribute("intPrecision", string);
        }
        for (int i = 0; i < scilabType.getHeight(); ++i) {
            block7: for (int j = 0; j < scilabType.getWidth(); ++j) {
                this.shared.stream.writeEmptyElement("data");
                this.shared.stream.writeAttribute("line", Integer.toString(i));
                this.shared.stream.writeAttribute("column", Integer.toString(j));
                switch (scilabTypeEnum) {
                    case sci_boolean: {
                        boolean bl = ((ScilabBoolean)scilabType).getElement(i, j);
                        this.shared.stream.writeAttribute("value", Boolean.toString(bl));
                        continue block7;
                    }
                    case sci_ints: {
                        long l = ((ScilabInteger)scilabType).getElement(i, j);
                        this.shared.stream.writeAttribute("value", Long.toString(l));
                        continue block7;
                    }
                    case sci_matrix: {
                        double d = ((ScilabDouble)scilabType).getRealElement(i, j);
                        this.shared.stream.writeAttribute("realPart", Double.toString(d));
                        if (((ScilabDouble)scilabType).isReal()) continue block7;
                        d = ((ScilabDouble)scilabType).getImaginaryElement(i, j);
                        this.shared.stream.writeAttribute("imaginaryPart", Double.toString(d));
                        continue block7;
                    }
                    case sci_strings: {
                        String string2 = ((ScilabString)scilabType).getData()[i][j];
                        this.shared.stream.writeAttribute("value", string2);
                    }
                }
            }
        }
    }

    private void writeAsBinary(ScilabType scilabType, String string) throws XMLStreamException {
        String string2;
        ScilabTypeEnum scilabTypeEnum = scilabType.getType();
        switch (scilabTypeEnum) {
            case sci_boolean: {
                string2 = "ScilabBoolean";
                break;
            }
            case sci_ints: {
                string2 = "ScilabInteger";
                break;
            }
            case sci_matrix: {
                string2 = "ScilabDouble";
                break;
            }
            case sci_strings: {
                string2 = "ScilabString";
                break;
            }
            case sci_list: 
            case sci_mlist: 
            case sci_tlist: {
                string2 = "Array";
                break;
            }
            default: {
                throw new XMLStreamException("Not handled ScilabType : " + scilabTypeEnum.name());
            }
        }
        Integer n = this.dictionaryMap.size();
        Integer n2 = this.dictionaryMap.putIfAbsent(scilabType, n);
        if (n2 == null) {
            n2 = n;
        }
        if (XcosWriter.LOG.isLoggable(Level.FINE)) {
            XcosWriter.LOG.fine("put:" + scilabType.toString() + ":" + n2.toString());
        }
        this.shared.stream.writeEmptyElement(string2);
        this.shared.stream.writeAttribute("as", string);
        this.shared.stream.writeAttribute("binary", "true");
        this.shared.stream.writeAttribute("position", n2.toString());
    }

    private void write(VectorOfDouble vectorOfDouble, String string) throws XMLStreamException {
        int n = vectorOfDouble.size();
        if (n > 0) {
            double[][] dArray = new double[1][n];
            vectorOfDouble.asByteBuffer(0, n).asDoubleBuffer().get(dArray[0]);
            this.write((ScilabType)new ScilabDouble(dArray), string);
        } else {
            this.write((ScilabType)new ScilabDouble(), string);
        }
    }

    private void write(VectorOfInt vectorOfInt, String string) throws XMLStreamException {
        int n = vectorOfInt.size();
        if (n > 0) {
            int[][] nArray = new int[1][n];
            vectorOfInt.asByteBuffer(0, n).asIntBuffer().get(nArray[0]);
            this.write((ScilabType)new ScilabInteger(nArray, false), string);
        } else {
            this.write((ScilabType)new ScilabDouble(), string);
        }
    }
}

