/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.writer;

import java.rmi.server.UID;
import javax.xml.stream.XMLStreamException;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.io.writer.ScilabWriter;
import org.scilab.modules.xcos.io.writer.XcosWriter;
import org.scilab.modules.xcos.port.BasicPort;

public class PortWriter
extends ScilabWriter {
    private final ObjectProperties portKind;
    private int ordering;

    public PortWriter(XcosWriter xcosWriter, ObjectProperties objectProperties) {
        super(xcosWriter);
        this.portKind = objectProperties;
        this.ordering = 0;
    }

    @Override
    public void write(long l, Kind kind) throws XMLStreamException {
        String string;
        assert (kind == Kind.PORT);
        boolean[] blArray = new boolean[1];
        this.shared.controller.getObjectProperty(l, Kind.PORT, ObjectProperties.IMPLICIT, blArray);
        switch (this.portKind) {
            case INPUTS: {
                if (blArray[0]) {
                    string = "ImplicitInputPort";
                    break;
                }
                string = "ExplicitInputPort";
                break;
            }
            case OUTPUTS: {
                if (blArray[0]) {
                    string = "ImplicitOutputPort";
                    break;
                }
                string = "ExplicitOutputPort";
                break;
            }
            case EVENT_INPUTS: {
                string = "ControlPort";
                break;
            }
            case EVENT_OUTPUTS: {
                string = "CommandPort";
                break;
            }
            default: {
                return;
            }
        }
        String[] stringArray = new String[1];
        this.shared.stream.writeEmptyElement(string);
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.UID, stringArray);
        while (stringArray[0].isEmpty() || this.shared.uniqueUIDs.contains(stringArray[0])) {
            stringArray[0] = new UID().toString();
        }
        this.shared.controller.setObjectProperty(l, kind, ObjectProperties.UID, stringArray[0]);
        this.shared.stream.writeAttribute("id", stringArray[0]);
        this.shared.stream.writeAttribute("parent", this.shared.layers.peek());
        this.shared.stream.writeAttribute("ordering", Integer.toString(++this.ordering));
        VectorOfInt vectorOfInt = new VectorOfInt();
        this.shared.controller.getObjectProperty(l, Kind.PORT, ObjectProperties.DATATYPE, vectorOfInt);
        int n = vectorOfInt.get(2);
        if (0 <= n && n < BasicPort.DataType.values().length) {
            this.shared.stream.writeAttribute("dataType", BasicPort.DataType.values()[n].name());
            this.shared.stream.writeAttribute("dataColumns", Integer.toString(vectorOfInt.get(1)));
            this.shared.stream.writeAttribute("dataLines", Integer.toString(vectorOfInt.get(0)));
        }
        double[] dArray = new double[1];
        this.shared.controller.getObjectProperty(l, Kind.PORT, ObjectProperties.FIRING, dArray);
        this.shared.stream.writeAttribute("initialState", Double.toString(dArray[0]));
        String[] stringArray2 = new String[1];
        this.shared.controller.getObjectProperty(l, Kind.PORT, ObjectProperties.STYLE, stringArray2);
        this.shared.stream.writeAttribute("style", stringArray2[0]);
        String[] stringArray3 = new String[1];
        this.shared.controller.getObjectProperty(l, Kind.PORT, ObjectProperties.LABEL, stringArray3);
        this.shared.stream.writeAttribute("value", stringArray3[0]);
    }
}

