/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.writer;

import java.rmi.server.UID;
import javax.xml.stream.XMLStreamException;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.io.HandledElement;
import org.scilab.modules.xcos.io.writer.ScilabWriter;
import org.scilab.modules.xcos.io.writer.XcosWriter;

public class CustomWriter
extends ScilabWriter {
    private static final String SEP = " - ";

    public CustomWriter(XcosWriter xcosWriter) {
        super(xcosWriter);
    }

    @Override
    public void write(long l, Kind kind) throws XMLStreamException {
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        switch (kind) {
            case DIAGRAM: {
                this.shared.stream.writeStartDocument();
                this.shared.stream.writeStartElement(HandledElement.XcosDiagram.name());
                this.shared.controller.getObjectProperty(l, kind, ObjectProperties.DEBUG_LEVEL, nArray);
                this.shared.stream.writeAttribute("debugLevel", Integer.toString(nArray[0]));
                this.shared.controller.getObjectProperty(l, kind, ObjectProperties.PROPERTIES, vectorOfDouble);
                String string = Double.toString(vectorOfDouble.get(0));
                this.shared.stream.writeAttribute("finalIntegrationTime", string);
                string = Double.toString(vectorOfDouble.get(1));
                this.shared.stream.writeAttribute("integratorAbsoluteTolerance", string);
                string = Double.toString(vectorOfDouble.get(2));
                this.shared.stream.writeAttribute("integratorRelativeTolerance", string);
                string = Double.toString(vectorOfDouble.get(3));
                this.shared.stream.writeAttribute("toleranceOnTime", string);
                string = Double.toString(vectorOfDouble.get(4));
                this.shared.stream.writeAttribute("maxIntegrationTimeInterval", string);
                string = Double.toString(vectorOfDouble.get(7));
                this.shared.stream.writeAttribute("maximumStepSize", string);
                string = Double.toString(vectorOfDouble.get(5));
                this.shared.stream.writeAttribute("realTimeScaling", string);
                string = Double.toString(vectorOfDouble.get(6));
                this.shared.stream.writeAttribute("solver", string);
                this.shared.controller.getObjectProperty(l, kind, ObjectProperties.CHILDREN, vectorOfScicosID);
                String string2 = new UID(0).toString();
                this.shared.uniqueUIDs.add(string2);
                this.writeDiagramAndSuperDiagramContent(l, kind, vectorOfScicosID, string2);
                this.shared.stream.writeEndElement();
                this.shared.stream.writeEndDocument();
                this.shared.rawDataWriter.fillSharedDictionary();
                break;
            }
            case BLOCK: {
                this.shared.controller.getObjectProperty(l, kind, ObjectProperties.CHILDREN, vectorOfScicosID);
                if (vectorOfScicosID.size() <= 0) break;
                this.shared.stream.writeStartElement(HandledElement.SuperBlockDiagram.name());
                this.shared.stream.writeAttribute("as", "child");
                this.writeDiagramAndSuperDiagramContent(l, kind, vectorOfScicosID, this.shared.layers.peek());
                this.shared.stream.writeEndElement();
                break;
            }
            case PORT: {
                break;
            }
        }
    }

    private void writeDiagramAndSuperDiagramContent(long l, Kind kind, VectorOfScicosID vectorOfScicosID, String string) throws XMLStreamException {
        String[] stringArray;
        VectorOfInt vectorOfInt = new VectorOfInt();
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.COLOR, vectorOfInt);
        this.shared.stream.writeAttribute("background", Integer.toString(vectorOfInt.get(0)));
        this.shared.stream.writeAttribute("gridEnabled", Integer.toString(vectorOfInt.get(1)));
        String[] stringArray2 = new String[1];
        this.shared.controller.getObjectProperty(l, kind, ObjectProperties.TITLE, stringArray2);
        this.shared.stream.writeAttribute("title", stringArray2[0]);
        if (kind == Kind.DIAGRAM) {
            stringArray = Package.getPackage("org.scilab.modules.xcos");
            String string2 = Xcos.TRADENAME + SEP + "2.0" + SEP + stringArray.getSpecificationVersion() + SEP + stringArray.getImplementationVersion();
            this.shared.stream.writeComment(string2);
        }
        this.shared.rawDataWriter.writeContext(l, kind);
        stringArray = string.split(":");
        long l2 = 1L;
        String string3 = stringArray[0] + ":" + Long.toString(Long.parseLong(stringArray[1], 16) + l2, 16) + ":" + stringArray[2];
        while (this.shared.uniqueUIDs.contains(string3)) {
            string3 = stringArray[0] + ":" + Long.toString(Long.parseLong(stringArray[1], 16) + l2, 16) + ":" + stringArray[2];
            ++l2;
        }
        this.shared.uniqueUIDs.add(string3);
        String string4 = stringArray[0] + ":" + Long.toString(Long.parseLong(stringArray[1], 16) + l2, 16) + ":" + stringArray[2];
        while (this.shared.uniqueUIDs.contains(string4)) {
            string4 = stringArray[0] + ":" + Long.toString(Long.parseLong(stringArray[1], 16) + l2, 16) + ":" + stringArray[2];
            ++l2;
        }
        this.shared.uniqueUIDs.add(string4);
        this.shared.layers.push(string4);
        this.shared.stream.writeStartElement("mxGraphModel");
        this.shared.stream.writeAttribute("as", "model");
        this.shared.stream.writeStartElement("root");
        this.shared.stream.writeEmptyElement("mxCell");
        this.shared.stream.writeAttribute("id", string3);
        this.shared.stream.writeEmptyElement("mxCell");
        this.shared.stream.writeAttribute("id", string4);
        this.shared.stream.writeAttribute("parent", string3);
        VectorOfInt vectorOfInt2 = new VectorOfInt();
        this.shared.controller.sortAndFillKind(vectorOfScicosID, vectorOfInt2);
        int n = vectorOfScicosID.size();
        for (int i = 0; i < n; ++i) {
            long l3 = vectorOfScicosID.get(i);
            if (l3 == 0L) continue;
            Kind kind2 = Kind.values()[vectorOfInt2.get(i)];
            this.shared.write(l3, kind2);
        }
        this.shared.layers.pop();
        this.shared.stream.writeEndElement();
        this.shared.stream.writeEndElement();
        this.shared.stream.writeEmptyElement("mxCell");
        this.shared.stream.writeAttribute("as", "defaultParent");
        this.shared.stream.writeAttribute("id", string4);
        this.shared.stream.writeAttribute("parent", string3);
    }
}

