/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.scilab.modules.javasci.JavasciException;
import org.scilab.modules.javasci.Scilab;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.io.scicos.Handler;

public class ScilabDirectHandler
implements Handler {
    public static final String CONTEXT = "context";
    public static final String SCS_M = "scs_m";
    public static final String BLK = "blk";
    private static final Logger LOG = Logger.getLogger(ScilabDirectHandler.class.getPackage().getName());
    private static final ScilabDirectHandler INSTANCE = new ScilabDirectHandler();
    private final Semaphore lock = new Semaphore(1, true);

    private ScilabDirectHandler() {
    }

    public static ScilabDirectHandler acquire() {
        LOG.finest("lock request");
        try {
            boolean bl = ScilabDirectHandler.INSTANCE.lock.tryAcquire(0L, TimeUnit.SECONDS);
            if (!bl) {
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        LOG.finest("lock acquired");
        return INSTANCE;
    }

    public void release() {
        LOG.finest("lock release");
        ScilabDirectHandler.INSTANCE.lock.release();
    }

    @Override
    public synchronized Map<String, String> readContext() {
        ScilabMList scilabMList;
        ScilabType scilabType;
        LOG.entering("ScilabDirectHandler", "readContext");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            scilabType = Scilab.getInCurrentScilabSession((String)CONTEXT);
        }
        catch (JavasciException javasciException) {
            throw new RuntimeException(javasciException);
        }
        if (scilabType instanceof ScilabMList) {
            scilabMList = (ScilabMList)scilabType;
            LOG.finer("data available");
        } else {
            scilabMList = new ScilabMList();
            LOG.finer("data unavailable");
        }
        for (int i = 2; i < scilabMList.size(); ++i) {
            String string = ((ScilabString)scilabMList.get(0)).getData()[0][i];
            String string2 = ((ScilabType)scilabMList.get(i)).toString();
            linkedHashMap.put(string, string2);
        }
        LOG.exiting("ScilabDirectHandler", "readContext");
        return linkedHashMap;
    }

    @Override
    public void writeContext(String[] stringArray) {
        LOG.entering("ScilabDirectHandler", "writeContext");
        try {
            Scilab.putInCurrentScilabSession((String)CONTEXT, (ScilabType)new ScilabString(stringArray));
        }
        catch (JavasciException javasciException) {
            throw new RuntimeException(javasciException);
        }
        LOG.exiting("ScilabDirectHandler", "writeContext");
    }
}

