/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxPoint;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SuperBlock;
import org.scilab.modules.xcos.block.io.ContextUpdate;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.BlockElement;
import org.scilab.modules.xcos.io.scicos.LabelElement;
import org.scilab.modules.xcos.io.scicos.LinkElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.io.scicos.ScicosParametersElement;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.utils.BlockPositioning;

public final class DiagramElement
extends AbstractElement<XcosDiagram> {
    protected static final List<String> DATA_FIELD_NAMES = Arrays.asList("diagram", "props", "objs");
    protected static final List<String> DATA_FIELD_NAMES_FULL = Arrays.asList("diagram", "props", "objs", "version", "contrib");
    private static final List<String> VERSIONS = Arrays.asList("", "scicos4.2", "scicos4.3", "scicos4.4");
    private static final int OBJS_INDEX = DATA_FIELD_NAMES_FULL.indexOf("objs");
    private static final int VERSION_INDEX = DATA_FIELD_NAMES_FULL.indexOf("version");
    private static final double H_MARGIN = 40.0;
    private static final double V_MARGIN = 40.0;
    private static final String[] PROPS_FIELDS = new String[]{"params", "wpar", "title", "tol", "tf", "context", "void1", "options", "void2", "void3", "doc"};
    private static final int TITLE_INDEX = 2;
    private static final String[] OPTS_FIELDS = new String[]{"scsopt", "3D", "Background", "Link", "ID", "Cmap"};
    private static final double[][] WPAR = new double[][]{{600.0, 450.0, 0.0, 0.0, 600.0, 450.0}};
    private static final ScilabTList DIAGRAM_OPTIONS = new ScilabTList(OPTS_FIELDS, Arrays.asList(new ScilabList(Arrays.asList(new ScilabBoolean(true), new ScilabDouble(33.0))), new ScilabDouble((double[][])new double[][]{{8.0, 1.0}}), new ScilabDouble((double[][])new double[][]{{1.0, 5.0}}), new ScilabList(Arrays.asList(new ScilabDouble((double[][])new double[][]{{5.0, 1.0}}), new ScilabDouble((double[][])new double[][]{{4.0, 1.0}}))), new ScilabDouble((double[][])new double[][]{{0.8, 0.8, 0.8}})));
    private ScilabMList base;
    private double minimalYaxisValue = Double.POSITIVE_INFINITY;
    private double minimalXaxisValue = Double.POSITIVE_INFINITY;

    public DiagramElement(JavaController javaController) {
        super(javaController);
    }

    @Override
    public XcosDiagram decode(ScilabType scilabType, XcosDiagram xcosDiagram) throws ScicosFormatException {
        return this.decode(scilabType, xcosDiagram, true);
    }

    public XcosDiagram decode(ScilabType scilabType, XcosDiagram xcosDiagram, boolean bl) throws ScicosFormatException {
        this.base = (ScilabMList)scilabType;
        XcosDiagram xcosDiagram2 = xcosDiagram;
        if (xcosDiagram2 == null) {
            throw new IllegalArgumentException();
        }
        xcosDiagram2 = this.beforeDecode(scilabType, xcosDiagram2);
        xcosDiagram2.getModel().beginUpdate();
        String string = null;
        try {
            this.validate(bl);
        }
        catch (ScicosFormatException.VersionMismatchException versionMismatchException) {
            string = versionMismatchException.getWrongVersion();
        }
        this.decodeDiagram(xcosDiagram2, bl);
        xcosDiagram2.getModel().endUpdate();
        xcosDiagram2 = this.afterDecode(scilabType, xcosDiagram2);
        if (string != null) {
            throw new ScicosFormatException.VersionMismatchException(string);
        }
        return xcosDiagram2;
    }

    private void decodeDiagram(XcosDiagram xcosDiagram, boolean bl) throws ScicosFormatException {
        String string = ((ScilabString)((ScilabTList)this.base.get(1)).get(2)).getData()[0][0];
        xcosDiagram.setTitle(string);
        ScicosParametersElement scicosParametersElement = new ScicosParametersElement(this.controller);
        scicosParametersElement.decode((ScilabType)this.base.get(1), new ScicosParameters(Xcos.findRoot(this.controller, xcosDiagram), new ScicosObjectOwner(this.controller, xcosDiagram.getUID(), xcosDiagram.getKind())));
        this.decodeObjs(xcosDiagram);
        this.updateObjs(xcosDiagram, bl);
    }

    private void decodeObjs(XcosDiagram xcosDiagram) throws ScicosFormatException {
        XcosCell xcosCell;
        XcosCell xcosCell2;
        ScilabMList scilabMList;
        int n;
        int n2 = ((ScilabList)this.base.get(OBJS_INDEX)).size();
        HashMap<Integer, BasicBlock> hashMap = new HashMap<Integer, BasicBlock>(n2, 1.0f);
        BlockElement blockElement = new BlockElement(this.controller, xcosDiagram);
        LinkElement linkElement = new LinkElement(this.controller, hashMap);
        LabelElement labelElement = new LabelElement(this.controller);
        for (n = 0; n < n2; ++n) {
            scilabMList = (ScilabMList)((ScilabList)this.base.get(OBJS_INDEX)).get(n);
            xcosCell2 = null;
            if (blockElement.canDecode((ScilabType)scilabMList)) {
                xcosCell = blockElement.decode((ScilabType)scilabMList, null);
                hashMap.put(n, (BasicBlock)xcosCell);
                xcosCell2 = xcosCell;
                BlockPositioning.updateBlockView(xcosDiagram, xcosCell);
                this.minimalYaxisValue = Math.min(this.minimalYaxisValue, ((mxCell)xcosCell2).getGeometry().getY());
                this.minimalXaxisValue = Math.min(this.minimalXaxisValue, ((mxCell)xcosCell2).getGeometry().getX());
            } else if (labelElement.canDecode((ScilabType)scilabMList)) {
                xcosCell2 = labelElement.decode((ScilabType)scilabMList, null);
                this.minimalYaxisValue = Math.min(this.minimalYaxisValue, ((mxCell)xcosCell2).getGeometry().getY());
                this.minimalXaxisValue = Math.min(this.minimalXaxisValue, ((mxCell)xcosCell2).getGeometry().getX());
            }
            if (xcosCell2 == null) continue;
            xcosDiagram.addCell((Object)xcosCell2);
        }
        for (n = n2 - 1; n >= 0; --n) {
            scilabMList = (ScilabMList)((ScilabList)this.base.get(OBJS_INDEX)).get(n);
            xcosCell2 = null;
            if (linkElement.canDecode((ScilabType)scilabMList)) {
                xcosCell = linkElement.decode((ScilabType)scilabMList, null);
                xcosCell2 = xcosCell;
                List list = ((mxCell)xcosCell2).getGeometry().getPoints();
                for (mxPoint mxPoint2 : list) {
                    this.minimalYaxisValue = Math.min(this.minimalYaxisValue, mxPoint2.getY());
                    this.minimalXaxisValue = Math.min(this.minimalXaxisValue, mxPoint2.getX());
                }
            }
            if (xcosCell2 == null) continue;
            xcosDiagram.addCell((Object)xcosCell2);
        }
    }

    private void updateObjs(XcosDiagram xcosDiagram, boolean bl) {
        mxGraphModel mxGraphModel2 = (mxGraphModel)xcosDiagram.getModel();
        double d = -this.minimalYaxisValue + 40.0;
        double d2 = -this.minimalXaxisValue + 40.0;
        for (Object v : mxGraphModel2.getCells().values()) {
            DiagramElement.updateMinimalSize(v, (mxIGraphModel)mxGraphModel2);
            DiagramElement.translate(v, (mxIGraphModel)mxGraphModel2, d2, d);
            if (!bl) continue;
            DiagramElement.updateLabels(v, (mxIGraphModel)mxGraphModel2);
        }
    }

    private static final void updateMinimalSize(Object object, mxIGraphModel mxIGraphModel2) {
        double d;
        double d2;
        if (!(object instanceof BasicBlock)) {
            return;
        }
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
        if (mxGeometry2 == null) {
            return;
        }
        if (mxGeometry2.getWidth() < 7.0) {
            d2 = (mxGeometry2.getWidth() - 7.0) / 2.0;
            mxGeometry2.setWidth(7.0);
        } else {
            d2 = 0.0;
        }
        if (mxGeometry2.getHeight() < 7.0) {
            d = (mxGeometry2.getHeight() - 7.0) / 2.0;
            mxGeometry2.setHeight(7.0);
        } else {
            d = 0.0;
        }
        mxGeometry2.translate(d2, d);
    }

    private static final void translate(Object object, mxIGraphModel mxIGraphModel2, double d, double d2) {
        if (object instanceof BasicPort) {
            return;
        }
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
        if (mxGeometry2 != null) {
            mxGeometry2.translate(d, d2);
        }
    }

    private static final void updateLabels(Object object, mxIGraphModel mxIGraphModel2) {
        if (!(object instanceof SuperBlock)) {
            return;
        }
        SuperBlock superBlock = (SuperBlock)object;
        Map<ContextUpdate.IOBlocks, List<mxICell>> map = ContextUpdate.IOBlocks.getAllPorts(superBlock);
    }

    private void validate(boolean bl) throws ScicosFormatException {
        String string;
        if (this.base.size() < DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        int n = 0;
        if (!(this.base.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.base.get(n)).getData()[0];
        if (stringArray.length < DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < DATA_FIELD_NAMES.size(); ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.base.get(++n) instanceof ScilabTList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.base.get(++n) instanceof ScilabList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (this.base.size() <= ++n) {
            return;
        }
        if (!(this.base.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (bl && !VERSIONS.contains(string = ((ScilabString)this.base.get(n)).getData()[0][0])) {
            throw new ScicosFormatException.VersionMismatchException(string);
        }
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        if (!(scilabType instanceof ScilabMList)) {
            return false;
        }
        this.base = (ScilabMList)scilabType;
        String string = ((ScilabString)this.base.get(0)).getData()[0][0];
        boolean bl = string.equals(DATA_FIELD_NAMES.get(0));
        String string2 = this.base.size() > VERSION_INDEX ? ((ScilabString)this.base.get(VERSION_INDEX)).getData()[0][0] : "";
        boolean bl2 = VERSIONS.contains(string2);
        return bl && bl2;
    }
}

