/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import com.mxgraph.model.mxICell;
import java.rmi.server.UID;
import java.util.Arrays;
import java.util.List;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.io.ScilabTypeCoder;
import org.scilab.modules.xcos.io.scicos.BasicBlockInfo;
import org.scilab.modules.xcos.io.scicos.BlockPartsElement;
import org.scilab.modules.xcos.io.scicos.DiagramElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.control.ControlPort;

final class BlockModelElement
extends BlockPartsElement {
    protected static final List<String> DATA_FIELD_NAMES = Arrays.asList("model", "sim", "in", "in2", "intyp", "out", "out2", "outtyp", "evtin", "evtout", "state", "dstate", "odstate", "rpar", "ipar", "opar", "blocktype", "firing", "dep_ut", "label", "nzcross", "nmode", "equations");
    protected static final List<String> DATA_FIELD_NAMES_FULL = Arrays.asList("model", "sim", "in", "in2", "intyp", "out", "out2", "outtyp", "evtin", "evtout", "state", "dstate", "odstate", "rpar", "ipar", "opar", "blocktype", "firing", "dep_ut", "label", "nzcross", "nmode", "equations", "uid");
    private static final int CTRL_PORT_INDEX = DATA_FIELD_NAMES.indexOf("evtin");
    private static final int CMD_PORT_INDEX = DATA_FIELD_NAMES.indexOf("evtout");
    private static final int STATE_INDEX = DATA_FIELD_NAMES.indexOf("state");
    private static final int FIRING_INDEX = DATA_FIELD_NAMES.indexOf("firing");
    private static final int DEPENDU_INDEX = DATA_FIELD_NAMES.indexOf("dep_ut");
    private ScilabMList data;
    private final XcosDiagram diag;

    public BlockModelElement(JavaController javaController, XcosDiagram xcosDiagram) {
        super(javaController);
        this.diag = xcosDiagram;
    }

    @Override
    public BasicBlock decode(ScilabType scilabType, BasicBlock basicBlock) throws ScicosFormatException {
        if (basicBlock == null) {
            throw new IllegalArgumentException();
        }
        this.data = (ScilabMList)scilabType;
        BasicBlock basicBlock2 = basicBlock;
        this.validate();
        basicBlock2 = this.beforeDecode(scilabType, basicBlock2);
        this.fillSimulationFunction(basicBlock2);
        this.fillControlCommandPorts(basicBlock2);
        this.fillFirstRawParameters(basicBlock2);
        this.fillFiringParameters(basicBlock2);
        this.fillSecondRawParameters(basicBlock2);
        basicBlock2 = this.afterDecode(scilabType, basicBlock2);
        return basicBlock2;
    }

    private void fillSimulationFunction(BasicBlock basicBlock) {
        String[] stringArray = new String[1];
        this.controller.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_FUNCTION_NAME, stringArray);
        int[] nArray = new int[1];
        this.controller.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_FUNCTION_API, nArray);
        if (this.data.get(1) instanceof ScilabString) {
            stringArray[0] = ((ScilabString)this.data.get(1)).getData()[0][0];
        } else if (this.data.get(1) instanceof ScilabList) {
            stringArray[0] = ((ScilabString)((ScilabList)this.data.get(1)).get(0)).getData()[0][0];
            nArray[0] = (int)((ScilabDouble)((ScilabList)this.data.get(1)).get(1)).getRealPart()[0][0];
        }
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_FUNCTION_NAME, stringArray[0]);
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_FUNCTION_API, nArray[0]);
    }

    private void fillControlCommandPorts(BasicBlock basicBlock) {
        BasicPort basicPort;
        int n;
        int n2;
        int n3;
        ScilabDouble scilabDouble = (ScilabDouble)this.data.get(CTRL_PORT_INDEX);
        ScilabDouble scilabDouble2 = (ScilabDouble)this.data.get(CMD_PORT_INDEX);
        if (scilabDouble.getRealPart() != null) {
            n3 = basicBlock.getChildCount();
            n2 = scilabDouble.getHeight();
            for (n = 0; n < n2; ++n) {
                basicPort = new ControlPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, new UID().toString());
                basicBlock.insert((mxICell)basicPort, n3 + n);
            }
        }
        if (scilabDouble2.getRealPart() != null) {
            n3 = basicBlock.getChildCount();
            n2 = scilabDouble2.getHeight();
            for (n = 0; n < n2; ++n) {
                basicPort = new CommandPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, new UID().toString());
                basicBlock.insert((mxICell)basicPort, n3 + n);
            }
        }
    }

    private void fillFirstRawParameters(BasicBlock basicBlock) {
        int n = STATE_INDEX;
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.STATE, this.toVectorOfDouble((ScilabDouble)this.data.get(n)));
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.DSTATE, this.toVectorOfDouble((ScilabDouble)this.data.get(++n)));
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.ODSTATE, new ScilabTypeCoder().var2vec((ScilabType)this.data.get(++n)));
        if (this.data.get(++n) instanceof ScilabMList) {
            try {
                new DiagramElement(this.controller).decode((ScilabType)((ScilabMList)this.data.get(n)), new XcosDiagram(this.controller, basicBlock.getUID(), basicBlock.getKind(), basicBlock.getId()));
            }
            catch (ScicosFormatException scicosFormatException) {}
        } else if (this.data.get(n) instanceof ScilabDouble) {
            this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.RPAR, this.toVectorOfDouble((ScilabDouble)this.data.get(n)));
        }
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.IPAR, this.toVectorOfInt((ScilabDouble)this.data.get(++n)));
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.OPAR, new ScilabTypeCoder().var2vec((ScilabType)this.data.get(++n)));
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_BLOCKTYPE, ((ScilabString)this.data.get(++n)).getData()[0][0]);
    }

    private void fillFiringParameters(BasicBlock basicBlock) {
        if (this.data.get(FIRING_INDEX) instanceof ScilabBoolean) {
            return;
        }
        ScilabDouble scilabDouble = (ScilabDouble)this.data.get(FIRING_INDEX);
        if (!BlockModelElement.isEmptyField((ScilabType)scilabDouble)) {
            List<CommandPort> list = BasicBlockInfo.getAllTypedPorts(basicBlock, false, CommandPort.class);
            boolean bl = scilabDouble.getHeight() >= scilabDouble.getWidth();
            double[][] dArray = scilabDouble.getRealPart();
            int[] nArray = new int[]{0, 0};
            for (int i = 0; i < list.size(); ++i) {
                CommandPort commandPort = list.get(i);
                this.controller.setObjectProperty(commandPort.getUID(), commandPort.getKind(), ObjectProperties.FIRING, dArray[nArray[0]][nArray[1]]);
                BlockModelElement.incrementIndexes(nArray, bl);
            }
        }
    }

    private VectorOfDouble toVectorOfDouble(ScilabDouble scilabDouble) {
        VectorOfDouble vectorOfDouble = new VectorOfDouble(scilabDouble.getHeight());
        for (int i = 0; i < scilabDouble.getWidth(); ++i) {
            vectorOfDouble.set(i, scilabDouble.getRealElement(i, 0));
        }
        return vectorOfDouble;
    }

    private VectorOfInt toVectorOfInt(ScilabDouble scilabDouble) {
        VectorOfInt vectorOfInt = new VectorOfInt(scilabDouble.getHeight());
        for (int i = 0; i < scilabDouble.getWidth(); ++i) {
            vectorOfInt.set(i, (int)scilabDouble.getRealElement(i, 0));
        }
        return vectorOfInt;
    }

    private void fillSecondRawParameters(BasicBlock basicBlock) throws ScicosFormatException.WrongStructureException {
        String string;
        int n = DEPENDU_INDEX;
        boolean[][] blArray = ((ScilabBoolean)this.data.get(n)).getData();
        VectorOfInt vectorOfInt = new VectorOfInt(2L);
        if (blArray.length == 1 && blArray[0].length == 2) {
            vectorOfInt.set(0, blArray[0][0] ? 1 : 0);
            vectorOfInt.set(1, blArray[0][1] ? 1 : 0);
        } else if (blArray.length == 2 && blArray[0].length == 1 && blArray[1].length == 1) {
            vectorOfInt.set(0, blArray[0][0] ? 1 : 0);
            vectorOfInt.set(1, blArray[1][0] ? 1 : 0);
        } else {
            throw new ScicosFormatException.WrongStructureException(((ScilabString)this.data.get(0)).getData()[0][DEPENDU_INDEX]);
        }
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_DEP_UT, vectorOfInt);
        ++n;
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.NZCROSS, this.toVectorOfInt((ScilabDouble)this.data.get(++n)));
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.NMODE, this.toVectorOfInt((ScilabDouble)this.data.get(++n)));
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.EQUATIONS, new ScilabTypeCoder().var2vec((ScilabType)this.data.get(++n)));
        if (++n >= this.data.size()) {
            return;
        }
        ScilabType scilabType = (ScilabType)this.data.get(n);
        if (scilabType instanceof ScilabString && (string = ((ScilabString)scilabType).getData()[0][0]) != null && !string.isEmpty()) {
            basicBlock.setId(string);
        }
    }

    private void validate() throws ScicosFormatException {
        if (!this.canDecode((ScilabType)this.data)) {
            throw new ScicosFormatException.WrongElementException();
        }
        int n = 0;
        if (this.data.size() < DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.data.get(n)).getData()[0];
        if (stringArray.length < DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < DATA_FIELD_NAMES.size(); ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(++n) instanceof ScilabString) && !(this.data.get(n) instanceof ScilabList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble) && !(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble) && !(this.data.get(n) instanceof ScilabList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble || this.data.get(n) instanceof ScilabMList || this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble) && !(this.data.get(n) instanceof ScilabList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble) && !(this.data.get(n) instanceof ScilabList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble) && !(this.data.get(n) instanceof ScilabBoolean)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabBoolean)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabTList) && !BlockModelElement.isEmptyField((ScilabType)this.data.get(n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabMList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0));
    }
}

