/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import java.util.Arrays;
import java.util.List;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.io.ScilabTypeCoder;
import org.scilab.modules.xcos.io.scicos.BlockPartsElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.utils.BlockPositioning;

final class BlockGraphicElement
extends BlockPartsElement {
    protected static final List<String> DATA_FIELD_NAMES = Arrays.asList("graphics", "orig", "sz", "flip", "theta", "exprs", "pin", "pout", "pein", "peout", "gr_i", "id", "in_implicit", "out_implicit");
    protected static final List<String> DATA_FIELD_NAMES_FULL = Arrays.asList("graphics", "orig", "sz", "flip", "theta", "exprs", "pin", "pout", "pein", "peout", "gr_i", "id", "in_implicit", "out_implicit", "in_style", "out_style", "in_label", "out_label", "style");
    private static final int ORIGIN_INDEX = DATA_FIELD_NAMES_FULL.indexOf("orig");
    private static final int DIMS_INDEX = DATA_FIELD_NAMES_FULL.indexOf("sz");
    private static final int FLIP_INDEX = DATA_FIELD_NAMES_FULL.indexOf("flip");
    private static final int EXPRS_INDEX = DATA_FIELD_NAMES_FULL.indexOf("exprs");
    private static final int ID_INDEX = DATA_FIELD_NAMES_FULL.indexOf("id");
    private static final int STYLE_INDEX = DATA_FIELD_NAMES_FULL.indexOf("style");
    private static final int GRAPHICS_INSTRUCTION_SIZE = 8;
    private static final double DEFAULT_SIZE_FACTOR = 20.0;
    private ScilabMList data;
    private final XcosDiagram diag;
    private final double sizeFactor;

    public BlockGraphicElement(JavaController javaController) {
        this(javaController, null);
    }

    public BlockGraphicElement(JavaController javaController, XcosDiagram xcosDiagram) {
        super(javaController);
        this.diag = xcosDiagram;
        this.sizeFactor = xcosDiagram == null ? 20.0 : 1.0;
    }

    public BlockGraphicElement(JavaController javaController, XcosDiagram xcosDiagram, double d) {
        super(javaController);
        this.diag = xcosDiagram;
        this.sizeFactor = d;
    }

    @Override
    public BasicBlock decode(ScilabType scilabType, BasicBlock basicBlock) throws ScicosFormatException {
        ScilabString scilabString;
        String string;
        if (basicBlock == null) {
            throw new IllegalArgumentException();
        }
        BasicBlock basicBlock2 = basicBlock;
        this.data = (ScilabMList)scilabType;
        this.validate();
        basicBlock2 = this.beforeDecode(scilabType, basicBlock2);
        this.decodeDimension(basicBlock2);
        this.decodeOrigin(basicBlock2);
        this.decodeFlipAndRotation(basicBlock2);
        this.decodeIdCell(basicBlock2);
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.EXPRS, new ScilabTypeCoder().var2vec((ScilabType)this.data.get(EXPRS_INDEX)));
        if (this.data.size() > STYLE_INDEX && !BlockGraphicElement.isEmptyField((ScilabType)this.data.get(STYLE_INDEX)) && (string = (scilabString = (ScilabString)this.data.get(STYLE_INDEX)).getData()[0][0]) != null && !string.isEmpty()) {
            basicBlock2.setStyle(string);
        }
        basicBlock2 = this.afterDecode(scilabType, basicBlock2);
        return basicBlock2;
    }

    private void validate() throws ScicosFormatException {
        if (!this.canDecode((ScilabType)this.data)) {
            throw new ScicosFormatException.WrongElementException();
        }
        int n = 0;
        if (this.data.size() < DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.data.get(n)).getData()[0];
        if (stringArray.length < DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < DATA_FIELD_NAMES.size(); ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabBoolean)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString || this.data.get(n) instanceof ScilabList || this.data.get(n) instanceof ScilabTList || BlockGraphicElement.isEmptyField((ScilabType)this.data.get(n)))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabDouble)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        ++n;
        if (!(this.data.get(++n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString) && !BlockGraphicElement.isEmptyField((ScilabType)this.data.get(n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString) && !BlockGraphicElement.isEmptyField((ScilabType)this.data.get(n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
    }

    private void decodeOrigin(BasicBlock basicBlock) {
        double[][] dArray = ((ScilabDouble)this.data.get(ORIGIN_INDEX)).getRealPart();
        double d = dArray[0][0];
        double[] dArray2 = dArray[dArray.length - 1];
        double d2 = dArray2[dArray2.length - 1];
        d2 *= this.sizeFactor;
        d2 = -d2 - basicBlock.getGeometry().getHeight();
        basicBlock.getGeometry().setX(d *= this.sizeFactor);
        basicBlock.getGeometry().setY(d2);
    }

    private void decodeDimension(BasicBlock basicBlock) {
        double[][] dArray = ((ScilabDouble)this.data.get(DIMS_INDEX)).getRealPart();
        double d = dArray[0][0];
        double[] dArray2 = dArray[dArray.length - 1];
        double d2 = dArray2[dArray2.length - 1];
        basicBlock.getGeometry().setWidth(d *= this.sizeFactor);
        basicBlock.getGeometry().setHeight(d2 *= this.sizeFactor);
    }

    private void decodeFlipAndRotation(BasicBlock basicBlock) {
        int n;
        String[] stringArray = new String[1];
        this.controller.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.INTERFACE_FUNCTION, stringArray);
        StyleMap styleMap = new StyleMap(stringArray[0]);
        if (!((ScilabBoolean)this.data.get(FLIP_INDEX)).getData()[0][0]) {
            styleMap.put((Object)"flip", (Object)Boolean.TRUE.toString());
        }
        if ((n = (int)((ScilabDouble)this.data.get(FLIP_INDEX + 1)).getRealPart()[0][0]) != 0) {
            n = BlockPositioning.roundAngle(-n);
            styleMap.put((Object)mxConstants.STYLE_ROTATION, (Object)Integer.toString(n));
        }
        this.controller.setObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.STYLE, styleMap.toString());
    }

    private void decodeIdCell(BasicBlock basicBlock) {
        if (this.diag == null) {
            return;
        }
        String[][] stringArray = ((ScilabString)this.data.get(ID_INDEX)).getData();
        if (stringArray.length == 0 || stringArray[0].length == 0 || stringArray[0][0].isEmpty()) {
            return;
        }
        mxCell mxCell2 = this.diag.createCellIdentifier(basicBlock);
        mxCell2.setValue((Object)stringArray[0][0]);
        basicBlock.insert((mxICell)mxCell2);
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabMList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0));
    }
}

