/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.sax;

import com.mxgraph.model.mxGeometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabInteger;
import org.scilab.modules.types.ScilabIntegerTypeEnum;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.VectorOfString;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.io.HandledElement;
import org.scilab.modules.xcos.io.ScilabTypeCoder;
import org.scilab.modules.xcos.io.sax.ScilabHandler;
import org.scilab.modules.xcos.io.sax.XcosSAXHandler;
import org.scilab.modules.xcos.io.scicos.DiagramElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.xml.sax.Attributes;

class RawDataHandler
implements ScilabHandler {
    private final XcosSAXHandler saxHandler;
    private final Map<String, ObjectProperties> propertyMap;

    RawDataHandler(XcosSAXHandler xcosSAXHandler) {
        this.saxHandler = xcosSAXHandler;
        HashMap<String, ObjectProperties> hashMap = new HashMap<String, ObjectProperties>();
        hashMap.put("context", ObjectProperties.DIAGRAM_CONTEXT);
        hashMap.put("exprs", ObjectProperties.EXPRS);
        hashMap.put("realParameters", ObjectProperties.RPAR);
        hashMap.put("integerParameters", ObjectProperties.IPAR);
        hashMap.put("objectsParameters", ObjectProperties.OPAR);
        hashMap.put("nbZerosCrossing", ObjectProperties.NZCROSS);
        hashMap.put("nmode", ObjectProperties.NMODE);
        hashMap.put("state", ObjectProperties.STATE);
        hashMap.put("dState", ObjectProperties.DSTATE);
        hashMap.put("oDState", ObjectProperties.ODSTATE);
        hashMap.put("equations", ObjectProperties.EQUATIONS);
        hashMap.put("points", ObjectProperties.CONTROL_POINTS);
        this.propertyMap = Collections.unmodifiableMap(hashMap);
    }

    @Override
    public Object startElement(HandledElement handledElement, Attributes attributes) {
        block0 : switch (handledElement) {
            case ScilabBoolean: 
            case ScilabDouble: 
            case ScilabInteger: 
            case ScilabString: 
            case Array: {
                String string = attributes.getValue("as");
                boolean bl = false;
                int n = -1;
                String string2 = attributes.getValue("binary");
                if (string2 != null) {
                    bl = Boolean.valueOf(string2);
                }
                if ((string2 = attributes.getValue("position")) != null) {
                    n = Integer.valueOf(string2);
                }
                if (bl && this.saxHandler.dictionary != null && 0 <= n && n < this.saxHandler.dictionary.size()) {
                    ObjectProperties objectProperties = this.propertyMap.get(string);
                    return new RawDataDescriptor(objectProperties, handledElement, null, this.saxHandler.dictionary.get(n));
                }
                int n2 = 0;
                int n3 = 0;
                String string3 = "ScilabDouble";
                string2 = attributes.getValue("height");
                if (string2 != null) {
                    n2 = Integer.valueOf(string2);
                }
                if ((string2 = attributes.getValue("width")) != null) {
                    n3 = Integer.valueOf(string2);
                }
                if ((string2 = attributes.getValue("scilabClass")) != null) {
                    string3 = string2;
                }
                Object object = this.allocateDataType(handledElement, attributes, n2, n3, string3);
                ObjectProperties objectProperties = this.propertyMap.get(string);
                return new RawDataDescriptor(objectProperties, handledElement, string3, object);
            }
            case add: {
                if (!(this.saxHandler.parents.peek() instanceof RawDataDescriptor)) {
                    return null;
                }
                RawDataDescriptor rawDataDescriptor = (RawDataDescriptor)this.saxHandler.parents.peek();
                switch (rawDataDescriptor.as) {
                    case DIAGRAM_CONTEXT: {
                        ArrayList arrayList = (ArrayList)rawDataDescriptor.value;
                        arrayList.add(attributes.getValue("value"));
                        break block0;
                    }
                }
                break;
            }
            case data: {
                if (!(this.saxHandler.parents.peek() instanceof RawDataDescriptor)) {
                    return null;
                }
                RawDataDescriptor rawDataDescriptor = (RawDataDescriptor)this.saxHandler.parents.peek();
                int n = 0;
                int n4 = 0;
                String string = attributes.getValue("column");
                if (string != null) {
                    n = Integer.valueOf(string);
                }
                if ((string = attributes.getValue("line")) != null) {
                    n4 = Integer.valueOf(string);
                }
                block8 : switch (rawDataDescriptor.found) {
                    case ScilabBoolean: {
                        ScilabBoolean scilabBoolean = (ScilabBoolean)rawDataDescriptor.value;
                        boolean[][] blArray = scilabBoolean.getData();
                        string = attributes.getValue("value");
                        if (string == null) break block0;
                        blArray[n4][n] = Boolean.valueOf(string);
                        break;
                    }
                    case ScilabDouble: {
                        ScilabDouble scilabDouble = (ScilabDouble)rawDataDescriptor.value;
                        double[][] dArray = scilabDouble.getRealPart();
                        double[][] dArray2 = scilabDouble.getImaginaryPart();
                        string = attributes.getValue("realPart");
                        if (string != null) {
                            dArray[n4][n] = Double.valueOf(string);
                        }
                        if ((string = attributes.getValue("imaginaryPart")) == null) break block0;
                        if (scilabDouble.isReal()) {
                            dArray2 = new double[scilabDouble.getHeight()][scilabDouble.getWidth()];
                            scilabDouble.setImaginaryPart(dArray2);
                        }
                        dArray2[n4][n] = Double.valueOf(string);
                        break;
                    }
                    case ScilabInteger: {
                        ScilabInteger scilabInteger = (ScilabInteger)rawDataDescriptor.value;
                        ScilabIntegerTypeEnum scilabIntegerTypeEnum = scilabInteger.getPrec();
                        string = attributes.getValue("value");
                        if (string == null) break block0;
                        switch (scilabIntegerTypeEnum) {
                            case sci_int8: 
                            case sci_uint8: {
                                scilabInteger.getDataAsByte()[n4][n] = Byte.valueOf(string);
                                break block8;
                            }
                            case sci_int16: 
                            case sci_uint16: {
                                scilabInteger.getDataAsShort()[n4][n] = Short.valueOf(string);
                                break block8;
                            }
                            case sci_int32: 
                            case sci_uint32: {
                                scilabInteger.getDataAsInt()[n4][n] = Integer.valueOf(string);
                                break block8;
                            }
                            case sci_int64: 
                            case sci_uint64: {
                                scilabInteger.getDataAsLong()[n4][n] = Long.valueOf(string);
                            }
                        }
                        break;
                    }
                    case ScilabString: {
                        ScilabString scilabString = (ScilabString)rawDataDescriptor.value;
                        String[][] stringArray = scilabString.getData();
                        stringArray[n4][n] = attributes.getValue("value");
                        break;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    private Object allocateDataType(HandledElement handledElement, Attributes attributes, int n, int n2, String string) {
        Object object;
        block0 : switch (handledElement) {
            case ScilabBoolean: {
                object = new ScilabBoolean(new boolean[n][n2]);
                break;
            }
            case ScilabDouble: {
                object = new ScilabDouble(new double[n][n2]);
                break;
            }
            case ScilabInteger: {
                String string2 = attributes.getValue("intPrecision");
                if (string2 != null) {
                    boolean bl = true;
                    switch (ScilabIntegerTypeEnum.valueOf((String)string2)) {
                        case sci_int8: {
                            bl = false;
                        }
                        case sci_uint8: {
                            object = new ScilabInteger(new byte[n][n2], bl);
                            break block0;
                        }
                        case sci_int16: {
                            bl = false;
                        }
                        case sci_uint16: {
                            object = new ScilabInteger(new short[n][n2], bl);
                            break block0;
                        }
                        case sci_int32: {
                            bl = false;
                        }
                        case sci_uint32: {
                            object = new ScilabInteger(new int[n][n2], bl);
                            break block0;
                        }
                        case sci_int64: {
                            bl = false;
                        }
                        case sci_uint64: {
                            object = new ScilabInteger(new long[n][n2], bl);
                            break block0;
                        }
                    }
                    object = new ScilabInteger(new long[n][n2], false);
                    break;
                }
                object = new ScilabInteger(new long[n][n2], false);
                break;
            }
            case ScilabString: {
                object = new ScilabString(new String[n][n2]);
                break;
            }
            default: {
                object = "ScilabMList".equals(string) ? new ScilabMList() : ("ScilabTList".equals(string) ? new ScilabTList() : ("ScilabList".equals(string) ? new ScilabList() : new ScilabList()));
            }
        }
        return object;
    }

    @Override
    public void endElement(HandledElement handledElement) {
        block1 : switch (handledElement) {
            case ScilabBoolean: 
            case ScilabDouble: 
            case ScilabInteger: 
            case ScilabString: 
            case Array: {
                if (!(this.saxHandler.parents.peek() instanceof RawDataDescriptor)) {
                    return;
                }
                RawDataDescriptor rawDataDescriptor = (RawDataDescriptor)this.saxHandler.parents.peek();
                Object object = this.saxHandler.parents.peek(1);
                if (rawDataDescriptor.as == null) {
                    if (!(object instanceof RawDataDescriptor)) {
                        return;
                    }
                    ArrayList arrayList = (ArrayList)((RawDataDescriptor)object).value;
                    arrayList.add(rawDataDescriptor.value);
                    return;
                }
                switch (rawDataDescriptor.as) {
                    case CONTROL_POINTS: {
                        if (!(object instanceof mxGeometry)) {
                            return;
                        }
                        mxGeometry mxGeometry2 = (mxGeometry)object;
                        ArrayList arrayList = (ArrayList)rawDataDescriptor.value;
                        mxGeometry2.setPoints((List)arrayList);
                        break;
                    }
                    case DIAGRAM_CONTEXT: {
                        if (!(object instanceof XcosCell)) {
                            return;
                        }
                        XcosCell xcosCell = (XcosCell)((Object)object);
                        ArrayList arrayList = (ArrayList)rawDataDescriptor.value;
                        VectorOfString vectorOfString = new VectorOfString(arrayList.size());
                        for (int i = 0; i < arrayList.size(); ++i) {
                            vectorOfString.set(i, (String)arrayList.get(i));
                        }
                        this.saxHandler.controller.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.DIAGRAM_CONTEXT, vectorOfString);
                        break;
                    }
                    case STATE: 
                    case DSTATE: 
                    case RPAR: {
                        if (!(object instanceof XcosCell)) {
                            return;
                        }
                        XcosCell xcosCell = (XcosCell)((Object)object);
                        if (rawDataDescriptor.as == ObjectProperties.RPAR && rawDataDescriptor.value instanceof ScilabMList) {
                            VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
                            this.saxHandler.controller.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
                            if (vectorOfScicosID.size() == 0) {
                                try {
                                    new DiagramElement(this.saxHandler.controller).decode((ScilabType)((ScilabMList)rawDataDescriptor.value), new XcosDiagram(this.saxHandler.controller, xcosCell.getUID(), xcosCell.getKind(), xcosCell.getId()));
                                }
                                catch (ScicosFormatException scicosFormatException) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                        if (!(rawDataDescriptor.value instanceof ScilabDouble)) break block1;
                        ScilabDouble scilabDouble = (ScilabDouble)rawDataDescriptor.value;
                        VectorOfDouble vectorOfDouble = new VectorOfDouble(scilabDouble.getHeight() * scilabDouble.getWidth());
                        for (int i = 0; i < scilabDouble.getWidth(); ++i) {
                            for (int j = 0; j < scilabDouble.getHeight(); ++j) {
                                vectorOfDouble.set(scilabDouble.getHeight() * i + j, scilabDouble.getRealElement(j, i));
                            }
                        }
                        this.saxHandler.controller.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), rawDataDescriptor.as, vectorOfDouble);
                        break;
                    }
                    case NZCROSS: 
                    case NMODE: 
                    case IPAR: {
                        if (!(object instanceof XcosCell)) {
                            return;
                        }
                        XcosCell xcosCell = (XcosCell)((Object)object);
                        VectorOfInt vectorOfInt = null;
                        if (rawDataDescriptor.value instanceof ScilabDouble) {
                            ScilabDouble scilabDouble = (ScilabDouble)rawDataDescriptor.value;
                            vectorOfInt = new VectorOfInt(scilabDouble.getHeight() * scilabDouble.getWidth());
                            for (int i = 0; i < scilabDouble.getWidth(); ++i) {
                                for (int j = 0; j < scilabDouble.getHeight(); ++j) {
                                    vectorOfInt.set(scilabDouble.getHeight() * i + j, (int)scilabDouble.getRealElement(j, i));
                                }
                            }
                        } else if (rawDataDescriptor.value instanceof ScilabInteger) {
                            ScilabInteger scilabInteger = (ScilabInteger)rawDataDescriptor.value;
                            vectorOfInt = new VectorOfInt(scilabInteger.getHeight() * scilabInteger.getWidth());
                            for (int i = 0; i < scilabInteger.getWidth(); ++i) {
                                block26: for (int j = 0; j < scilabInteger.getHeight(); ++j) {
                                    int n = scilabInteger.getHeight() * i + j;
                                    switch (scilabInteger.getPrec()) {
                                        case sci_int8: 
                                        case sci_uint8: {
                                            vectorOfInt.set(n, scilabInteger.getByteElement(j, i));
                                            continue block26;
                                        }
                                        case sci_int16: 
                                        case sci_uint16: {
                                            vectorOfInt.set(n, scilabInteger.getShortElement(j, i));
                                            continue block26;
                                        }
                                        case sci_int32: 
                                        case sci_uint32: {
                                            vectorOfInt.set(n, scilabInteger.getIntElement(j, i));
                                            continue block26;
                                        }
                                        case sci_int64: 
                                        case sci_uint64: {
                                            vectorOfInt.set(n, (int)scilabInteger.getLongElement(j, i));
                                        }
                                    }
                                }
                            }
                        }
                        if (vectorOfInt == null) break block1;
                        this.saxHandler.controller.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), rawDataDescriptor.as, vectorOfInt);
                        break;
                    }
                    case EXPRS: 
                    case EQUATIONS: 
                    case OPAR: 
                    case ODSTATE: {
                        if (!(object instanceof XcosCell)) {
                            return;
                        }
                        XcosCell xcosCell = (XcosCell)((Object)object);
                        ScilabType scilabType = (ScilabType)rawDataDescriptor.value;
                        VectorOfDouble vectorOfDouble = new ScilabTypeCoder().var2vec(scilabType);
                        this.saxHandler.controller.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), rawDataDescriptor.as, vectorOfDouble);
                        break;
                    }
                    default: {
                        XcosSAXHandler.LOG.warning("RawDataHandler not handled: " + (Object)((Object)rawDataDescriptor.as));
                        break;
                    }
                }
                break;
            }
            case add: {
                break;
            }
            case data: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    static class RawDataDescriptor {
        final ObjectProperties as;
        final HandledElement found;
        final String scilabClass;
        final Object value;

        public RawDataDescriptor(ObjectProperties objectProperties, HandledElement handledElement, String string, Object object) {
            this.as = objectProperties;
            this.found = handledElement;
            this.scilabClass = string;
            this.value = object;
        }
    }
}

