/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.sax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.io.HandledElement;
import org.scilab.modules.xcos.io.sax.ScilabHandler;
import org.scilab.modules.xcos.io.sax.XcosSAXHandler;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.Orientation;
import org.xml.sax.Attributes;

class CustomHandler
implements ScilabHandler {
    private final XcosSAXHandler saxHandler;

    CustomHandler(XcosSAXHandler xcosSAXHandler) {
        this.saxHandler = xcosSAXHandler;
    }

    @Override
    public Object startElement(HandledElement handledElement, Attributes attributes) {
        long l = 0L;
        switch (handledElement) {
            case Orientation: {
                if (!(this.saxHandler.parents.peek() instanceof BasicPort)) {
                    return null;
                }
                BasicPort basicPort = (BasicPort)((Object)this.saxHandler.parents.peek());
                String string = attributes.getValue("value");
                if (string != null) {
                    String string2 = string;
                    Optional<Orientation> optional = Stream.of(Orientation.values()).filter(orientation -> orientation.name().equals(string2)).findFirst();
                    if (optional.isPresent()) {
                        basicPort.setOrientation(optional.get());
                    }
                }
                return null;
            }
            case XcosDiagram: {
                if (XcosSAXHandler.LOG.isLoggable(Level.FINER)) {
                    XcosSAXHandler.LOG.entering(CustomHandler.class.getName(), "startElement(\"XcosDiagram\", ...)");
                }
                l = this.saxHandler.root.getUID();
                String string = attributes.getValue("debugLevel");
                if (string != null) {
                    this.saxHandler.controller.setObjectProperty(l, Kind.DIAGRAM, ObjectProperties.DEBUG_LEVEL, Integer.valueOf(string));
                }
                VectorOfDouble vectorOfDouble = new VectorOfDouble();
                this.saxHandler.controller.getObjectProperty(l, Kind.DIAGRAM, ObjectProperties.PROPERTIES, vectorOfDouble);
                string = attributes.getValue("finalIntegrationTime");
                if (string != null) {
                    vectorOfDouble.set(0, Double.valueOf(string));
                }
                if ((string = attributes.getValue("integratorAbsoluteTolerance")) != null) {
                    vectorOfDouble.set(1, Double.valueOf(string));
                }
                if ((string = attributes.getValue("integratorRelativeTolerance")) != null) {
                    vectorOfDouble.set(2, Double.valueOf(string));
                }
                if ((string = attributes.getValue("toleranceOnTime")) != null) {
                    vectorOfDouble.set(3, Double.valueOf(string));
                }
                if ((string = attributes.getValue("maxIntegrationTimeinterval")) != null) {
                    vectorOfDouble.set(4, Double.valueOf(string));
                }
                if ((string = attributes.getValue("maximumStepSize")) != null) {
                    vectorOfDouble.set(7, Double.valueOf(string));
                }
                if ((string = attributes.getValue("realTimeScaling")) != null) {
                    vectorOfDouble.set(5, Double.valueOf(string));
                }
                if ((string = attributes.getValue("solver")) != null) {
                    vectorOfDouble.set(6, Double.valueOf(string));
                }
                this.saxHandler.controller.setObjectProperty(l, Kind.DIAGRAM, ObjectProperties.PROPERTIES, vectorOfDouble);
            }
            case SuperBlockDiagram: {
                Kind kind;
                XcosCell xcosCell;
                if (l == 0L) {
                    xcosCell = this.saxHandler.lookupForParentXcosCellElement();
                    l = xcosCell.getUID();
                    kind = xcosCell.getKind();
                } else {
                    kind = Kind.DIAGRAM;
                    xcosCell = new XcosCell(this.saxHandler.controller, l, kind, null, null, "", "");
                }
                VectorOfInt vectorOfInt = new VectorOfInt();
                this.saxHandler.controller.getObjectProperty(l, kind, ObjectProperties.COLOR, vectorOfInt);
                String string = attributes.getValue("background");
                if (string != null) {
                    vectorOfInt.set(0, Integer.valueOf(string));
                }
                if ((string = attributes.getValue("gridEnabled")) != null) {
                    vectorOfInt.set(1, Integer.valueOf(string));
                }
                this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.COLOR, vectorOfInt);
                string = attributes.getValue("title");
                if (string != null) {
                    this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.TITLE, string);
                }
                this.saxHandler.allChildren.push(new HashMap());
                return xcosCell;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void endElement(HandledElement handledElement) {
        switch (handledElement) {
            case Orientation: {
                break;
            }
            case XcosDiagram: {
                this.resolve();
                this.saxHandler.allChildren.pop();
                XcosCellFactory.insertChildren(this.saxHandler.controller, this.saxHandler.root);
                if (!XcosSAXHandler.LOG.isLoggable(Level.FINER)) break;
                XcosSAXHandler.LOG.exiting(CustomHandler.class.getName(), "endElement(\"XcosDiagram\")");
                break;
            }
            case SuperBlockDiagram: {
                this.resolve();
                this.saxHandler.allChildren.pop();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void resolve() {
        HashMap<String, Long> hashMap = this.saxHandler.allChildren.peek();
        for (Map.Entry<String, ArrayList<XcosSAXHandler.UnresolvedReference>> entry : this.saxHandler.unresolvedReferences.entrySet()) {
            Long l = hashMap.get(entry.getKey());
            if (l == null) continue;
            long l2 = l;
            for (XcosSAXHandler.UnresolvedReference unresolvedReference : entry.getValue()) {
                unresolvedReference.resolve(this.saxHandler.controller, l2, this.saxHandler.controller.getKind(l2));
            }
        }
    }
}

