/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.sax;

import com.mxgraph.util.mxUtils;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.block.AfficheBlock;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SplitBlock;
import org.scilab.modules.xcos.block.SuperBlock;
import org.scilab.modules.xcos.block.TextBlock;
import org.scilab.modules.xcos.block.custom.BigSom;
import org.scilab.modules.xcos.block.custom.GroundBlock;
import org.scilab.modules.xcos.block.custom.Product;
import org.scilab.modules.xcos.block.custom.RoundBlock;
import org.scilab.modules.xcos.block.custom.Summation;
import org.scilab.modules.xcos.block.custom.VoltageSensorBlock;
import org.scilab.modules.xcos.block.io.EventInBlock;
import org.scilab.modules.xcos.block.io.EventOutBlock;
import org.scilab.modules.xcos.block.io.ExplicitInBlock;
import org.scilab.modules.xcos.block.io.ExplicitOutBlock;
import org.scilab.modules.xcos.block.io.ImplicitInBlock;
import org.scilab.modules.xcos.block.io.ImplicitOutBlock;
import org.scilab.modules.xcos.graph.model.BlockInterFunction;
import org.scilab.modules.xcos.io.HandledElement;
import org.scilab.modules.xcos.io.sax.ScilabHandler;
import org.scilab.modules.xcos.io.sax.XcosSAXHandler;
import org.xml.sax.Attributes;

class BlockHandler
implements ScilabHandler {
    private static Pattern validCIdentifier = null;
    private final XcosSAXHandler saxHandler;

    BlockHandler(XcosSAXHandler xcosSAXHandler) {
        this.saxHandler = xcosSAXHandler;
    }

    @Override
    public BasicBlock startElement(HandledElement handledElement, Attributes attributes) {
        Object object;
        BasicBlock basicBlock;
        String string;
        String string2;
        Kind kind = handledElement == HandledElement.TextBlock ? Kind.ANNOTATION : Kind.BLOCK;
        long l = this.saxHandler.controller.createObject(kind);
        String string3 = attributes.getValue("value");
        if (validCIdentifier == null) {
            validCIdentifier = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
        }
        if (string3 != null && validCIdentifier.matcher(string3).matches()) {
            this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.DESCRIPTION, string3);
        }
        if (string3 != null) {
            string3 = mxUtils.getBodyMarkup((String)string3, (boolean)false);
        }
        if ((string2 = attributes.getValue("style")) != null) {
            this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.STYLE, string2);
        }
        if ((string = attributes.getValue("id")) != null) {
            this.saxHandler.allChildren.peek().put(string, l);
        }
        switch (handledElement) {
            case AfficheBlock: {
                basicBlock = new AfficheBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case BasicBlock: {
                basicBlock = new BasicBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case BigSom: {
                basicBlock = new BigSom(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case ConstBlock: {
                basicBlock = new BasicBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case EventInBlock: {
                basicBlock = new EventInBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case EventOutBlock: {
                basicBlock = new EventOutBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case ExplicitInBlock: {
                basicBlock = new ExplicitInBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case ExplicitOutBlock: {
                basicBlock = new ExplicitOutBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case GainBlock: {
                basicBlock = new BasicBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case GroundBlock: {
                basicBlock = new GroundBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case ImplicitInBlock: {
                basicBlock = new ImplicitInBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case ImplicitOutBlock: {
                basicBlock = new ImplicitOutBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case PrintBlock: {
                basicBlock = new BasicBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case Product: {
                basicBlock = new Product(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case RoundBlock: {
                basicBlock = new RoundBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case SplitBlock: {
                basicBlock = new SplitBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case Summation: {
                basicBlock = new Summation(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case SuperBlock: {
                basicBlock = new SuperBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case TextBlock: {
                basicBlock = new TextBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            case VoltageSensorBlock: {
                basicBlock = new VoltageSensorBlock(this.saxHandler.controller, l, kind, string3, null, string2, string);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String string4 = attributes.getValue("interfaceFunctionName");
        if (string4 != null) {
            this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.INTERFACE_FUNCTION, string4);
        } else if (kind == Kind.BLOCK) {
            object = Arrays.stream(BlockInterFunction.values()).filter(blockInterFunction -> blockInterFunction.getKlass().equals(basicBlock.getClass())).map(blockInterFunction -> blockInterFunction.name()).findFirst().get();
            this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.INTERFACE_FUNCTION, (String)object);
        }
        string4 = attributes.getValue("simulationFunctionName");
        if (string4 != null) {
            this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.SIM_FUNCTION_NAME, string4);
        }
        if ((string4 = attributes.getValue("blockType")) != null) {
            this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.SIM_BLOCKTYPE, string4);
        }
        object = new VectorOfInt(2L);
        string4 = attributes.getValue("dependsOnU");
        if ("1".equals(string4)) {
            ((VectorOfInt)object).set(0, 1);
        }
        if ("1".equals(string4 = attributes.getValue("dependsOnT"))) {
            ((VectorOfInt)object).set(1, 1);
        }
        this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.SIM_DEP_UT, (VectorOfInt)object);
        string4 = attributes.getValue("simulationFunctionType");
        if (string4 != null) {
            BasicBlock.SimulationFunctionType simulationFunctionType = BasicBlock.SimulationFunctionType.valueOf(string4);
            this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.SIM_FUNCTION_API, simulationFunctionType.getValue());
        }
        this.saxHandler.insertChild(basicBlock);
        return basicBlock;
    }

    @Override
    public void endElement(HandledElement handledElement) {
    }
}

