/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.scilab.modules.commons.xml.ScilabXMLOutputFactory;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.JavaXMIResource;
import org.scilab.modules.xcos.View;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.io.sax.XcosSAXHandler;
import org.scilab.modules.xcos.io.spec.XcosPackage;
import org.scilab.modules.xcos.io.writer.IndentingXMLStreamWriter;
import org.scilab.modules.xcos.io.writer.XcosWriter;
import org.scilab.modules.xcos.utils.XcosMessages;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public enum XcosFileType {
    ZCOS("zcos", XcosMessages.FILE_ZCOS){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(String string, XcosDiagram xcosDiagram) throws TransformerException, IOException, SAXException, ParserConfigurationException {
            LOG.entering("XcosFileType.ZCOS", "load");
            View view = JavaController.lookup_view(Xcos.class.getName());
            try {
                JavaController.unregister_view(view);
                XcosPackage xcosPackage = new XcosPackage(new File(string));
                xcosPackage.setContent(xcosDiagram);
                xcosPackage.load();
            }
            finally {
                JavaController.register_view(Xcos.class.getName(), view);
            }
            LOG.exiting("XcosFileType.ZCOS", "load");
        }

        @Override
        public void save(String string, XcosDiagram xcosDiagram) throws Exception {
            LOG.entering("XcosFileType.ZCOS", "save");
            XcosPackage xcosPackage = new XcosPackage(new File(string));
            xcosPackage.setContent(xcosDiagram);
            xcosPackage.store();
            LOG.exiting("XcosFileType.ZCOS", "save");
        }
    }
    ,
    XCOS("xcos", XcosMessages.FILE_XCOS){

        @Override
        public void load(String string, XcosDiagram xcosDiagram) throws IOException {
            View view = JavaController.lookup_view(Xcos.class.getName());
            try {
                JavaController.unregister_view(view);
                XcosSAXHandler xcosSAXHandler = new XcosSAXHandler(xcosDiagram, null);
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setContentHandler(xcosSAXHandler);
                xMLReader.setErrorHandler(xcosSAXHandler);
                LOG.entering("XMLReader", "parse");
                xMLReader.parse(new InputSource(string));
                LOG.exiting("XMLReader", "parse");
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                throw new RuntimeException(sAXException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
            finally {
                JavaController.register_view(Xcos.class.getName(), view);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void save(String string, XcosDiagram xcosDiagram) throws Exception {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            XMLOutputFactory xMLOutputFactory = ScilabXMLOutputFactory.newInstance();
            try (XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(fileOutputStream, "UTF-8");){
                LOG.entering("XMLStreamWriter", "write");
                new XcosWriter(null, new IndentingXMLStreamWriter(xMLStreamWriter)).write(xcosDiagram.getUID(), xcosDiagram.getKind());
                LOG.exiting("XMLStreamWriter", "write");
            }
        }
    }
    ,
    XMI("xmi", XcosMessages.FILE_XMI){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(String string, XcosDiagram xcosDiagram) throws Exception {
            View view = JavaController.lookup_view(Xcos.class.getName());
            try {
                JavaController.unregister_view(view);
                JavaController javaController = new JavaController();
                JavaXMIResource.load(string, xcosDiagram.getUID());
                XcosCellFactory.insertChildren(javaController, xcosDiagram);
            }
            finally {
                JavaController.register_view(Xcos.class.getName(), view);
            }
        }

        @Override
        public void save(String string, XcosDiagram xcosDiagram) throws Exception {
            JavaXMIResource.save(string, xcosDiagram.getUID());
        }
    }
    ,
    COSF("cosf", XcosMessages.FILE_COSF){

        @Override
        public void load(String string, XcosDiagram xcosDiagram) throws Exception {
            XcosDiagram xcosDiagram2 = XcosCellFactory.createDiagramFromCOSF(new JavaController(), string);
            xcosDiagram.addCell(xcosDiagram2.getDefaultParent(), xcosDiagram.getDefaultParent());
        }

        @Override
        public void save(String string, XcosDiagram xcosDiagram) throws Exception {
            throw new UnsupportedOperationException();
        }
    };

    private static final String BEFORE_EXT = " (*.";
    private static final String AFTER_EXT = ")";
    private static final Logger LOG;
    private final String extension;
    private final String description;

    private XcosFileType(String string2, String string3) {
        this.extension = string2;
        this.description = string3 + BEFORE_EXT + string2 + AFTER_EXT;
    }

    public String getDottedExtension() {
        return "." + this.extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getFileMask() {
        return "*." + this.getExtension();
    }

    public String getDescription() {
        return this.description;
    }

    public static XcosFileType findFileType(String string) {
        int n = string.lastIndexOf(46);
        String string2 = "";
        XcosFileType xcosFileType = null;
        if (n > 0 && n <= string.length() - 2) {
            string2 = string.substring(n + 1);
        }
        for (XcosFileType xcosFileType2 : XcosFileType.values()) {
            if (string2.compareToIgnoreCase(xcosFileType2.extension) != 0) continue;
            xcosFileType = xcosFileType2;
            break;
        }
        return xcosFileType;
    }

    public static XcosFileType findFileType(File file) {
        XcosFileType xcosFileType = XcosFileType.findFileType(file.getName());
        if (file.exists() && (xcosFileType == XCOS || xcosFileType == ZCOS)) {
            xcosFileType = XcosFileType.checkHeader(file);
        }
        return xcosFileType;
    }

    public static XcosFileType findFileType(FileFilter fileFilter) {
        FileFilter[] fileFilterArray = XcosFileType.getSavingFilters();
        int n = 0;
        for (FileFilter fileFilter2 : fileFilterArray) {
            if (fileFilter2.getDescription().equals(fileFilter.getDescription())) break;
            ++n;
        }
        if (n > 0) {
            return XcosFileType.values()[n - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XcosFileType checkHeader(File file) {
        XcosFileType xcosFileType = null;
        byte[] byArray = "<?xml".getBytes();
        byte[] byArray2 = new byte[byArray.length];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n = fileInputStream.read(byArray2);
            if (n == byArray.length && Arrays.equals(byArray, byArray2)) {
                xcosFileType = XCOS;
            }
        }
        catch (IOException iOException) {
            xcosFileType = null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(XcosFileType.class.getName()).severe(iOException.toString());
                }
            }
        }
        if (xcosFileType == null) {
            try {
                new XcosPackage(file).checkHeader();
                xcosFileType = ZCOS;
            }
            catch (IOException | ParserConfigurationException | TransformerException exception) {
                // empty catch block
            }
        }
        return xcosFileType;
    }

    public abstract void load(String var1, XcosDiagram var2) throws Exception;

    public abstract void save(String var1, XcosDiagram var2) throws Exception;

    public static FileFilter[] getLoadingFilters() {
        int n;
        EnumSet<XcosFileType> enumSet = EnumSet.allOf(XcosFileType.class);
        Iterator iterator = enumSet.iterator();
        FileFilter[] fileFilterArray = new FileFilter[enumSet.size() + 1];
        String[] stringArray = new String[enumSet.size()];
        String[] stringArray2 = new String[enumSet.size()];
        for (n = 0; n < stringArray.length; ++n) {
            XcosFileType xcosFileType = (XcosFileType)((Object)iterator.next());
            stringArray2[n] = xcosFileType.getDescription();
            stringArray[n] = xcosFileType.getExtension();
        }
        fileFilterArray[0] = new FileNameExtensionFilter(XcosMessages.ALL_SUPPORTED_FORMATS, stringArray);
        for (n = 0; n < stringArray2.length; ++n) {
            fileFilterArray[n + 1] = new FileNameExtensionFilter(stringArray2[n], stringArray[n]);
        }
        return fileFilterArray;
    }

    public static FileFilter[] getSavingFilters() {
        int n;
        Set<XcosFileType> set = XcosFileType.getAvailableSaveFormats();
        Iterator iterator = set.iterator();
        FileFilter[] fileFilterArray = new FileFilter[set.size() + 1];
        String[] stringArray = new String[set.size()];
        String[] stringArray2 = new String[set.size()];
        for (n = 0; n < stringArray.length; ++n) {
            XcosFileType xcosFileType = (XcosFileType)((Object)iterator.next());
            stringArray2[n] = xcosFileType.getDescription();
            stringArray[n] = xcosFileType.getExtension();
        }
        fileFilterArray[0] = new FileNameExtensionFilter(XcosMessages.ALL_SUPPORTED_FORMATS, stringArray);
        for (n = 0; n < stringArray2.length; ++n) {
            fileFilterArray[n + 1] = new FileNameExtensionFilter(stringArray2[n], stringArray[n]);
        }
        return fileFilterArray;
    }

    public static Set<XcosFileType> getAvailableSaveFormats() {
        EnumSet<XcosFileType> enumSet = EnumSet.noneOf(XcosFileType.class);
        enumSet.add(XCOS);
        enumSet.add(ZCOS);
        enumSet.add(XMI);
        return enumSet;
    }

    static {
        LOG = Logger.getLogger(XcosFileType.class.getName());
    }
}

