/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.graph.model;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.utils.ScilabExported;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.XcosView;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SplitBlock;
import org.scilab.modules.xcos.block.custom.RoundBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.BlockInterFunction;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.link.CommandControlLink;
import org.scilab.modules.xcos.link.ExplicitLink;
import org.scilab.modules.xcos.link.ImplicitLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.control.ControlPort;
import org.scilab.modules.xcos.port.input.ExplicitInputPort;
import org.scilab.modules.xcos.port.input.ImplicitInputPort;
import org.scilab.modules.xcos.port.output.ExplicitOutputPort;
import org.scilab.modules.xcos.port.output.ImplicitOutputPort;
import org.scilab.modules.xcos.utils.BlockPositioning;

public final class XcosCellFactory {
    private static final double DEFAULT_SIZE_FACTOR = 20.0;
    private static final Logger LOG = Logger.getLogger(XcosCellFactory.class.getName());
    private static ScicosObjectOwner lastCreated = null;
    private static BasicBlock previousBlock = null;
    private static XcosDiagram previousDiagram = null;

    private XcosCellFactory() {
    }

    @ScilabExported(module="xcos", filename="XcosCellFactory.giws.xml")
    public static synchronized void created(long l, int n) {
        lastCreated = new ScicosObjectOwner(l, Kind.values()[n]);
    }

    @ScilabExported(module="xcos", filename="XcosCellFactory.giws.xml")
    public static synchronized void update(long l, int n) {
        lastCreated = new ScicosObjectOwner(l, Kind.values()[n]);
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (n == Kind.BLOCK.ordinal()) {
                    JavaController javaController = new JavaController();
                    XcosDiagram xcosDiagram = previousDiagram;
                    xcosDiagram.getModel().beginUpdate();
                    try {
                        BasicBlock basicBlock = XcosCellFactory.createBlock(javaController, lastCreated);
                        previousBlock.updateBlockSettings(javaController, xcosDiagram, basicBlock);
                        BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
                    }
                    finally {
                        xcosDiagram.getModel().beginUpdate();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized ScicosObjectOwner getLastCreated() {
        ScicosObjectOwner scicosObjectOwner = lastCreated;
        lastCreated = null;
        return scicosObjectOwner;
    }

    public static synchronized void setPrevious(BasicBlock basicBlock, XcosDiagram xcosDiagram) {
        previousBlock = basicBlock;
        previousDiagram = xcosDiagram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XcosDiagram createDiagramFromCOSF(JavaController javaController, String string) {
        XcosDiagram xcosDiagram;
        XcosView xcosView = (XcosView)JavaController.lookup_view(Xcos.class.getName());
        JavaController.unregister_view(xcosView);
        try {
            ScilabInterpreterManagement.synchronousScilabExec((String)("function f(), " + ScilabInterpreterManagement.buildCall((String)"exec", (Object[])new Object[]{string, -1}) + "; " + ScilabInterpreterManagement.buildCall((String)"xcosCellCreated", (Object[])new Object[]{"scs_m".toCharArray()}) + "endfunction; f();"));
            ScicosObjectOwner scicosObjectOwner = XcosCellFactory.getLastCreated();
            if (scicosObjectOwner.getKind() == Kind.DIAGRAM) {
                String[] stringArray = new String[1];
                javaController.getObjectProperty(scicosObjectOwner.getUID(), scicosObjectOwner.getKind(), ObjectProperties.UID, stringArray);
                xcosDiagram = new XcosDiagram(javaController, scicosObjectOwner.getUID(), scicosObjectOwner.getKind(), stringArray[0]);
                XcosCellFactory.insertChildren(javaController, xcosDiagram);
            } else {
                xcosDiagram = null;
            }
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            xcosDiagram = null;
        }
        finally {
            JavaController.register_view(Xcos.class.getName(), xcosView);
        }
        return xcosDiagram;
    }

    public static void insertChildren(JavaController javaController, XcosDiagram xcosDiagram) {
        XcosCell xcosCell;
        Object object;
        Object object2;
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        javaController.getObjectProperty(xcosDiagram.getUID(), xcosDiagram.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
        int n = vectorOfScicosID.size();
        ArrayList<BasicLink> arrayList = new ArrayList<BasicLink>(n / 2);
        HashMap hashMap = new HashMap(n);
        XcosCell[] xcosCellArray = new XcosCell[n];
        for (int i = 0; i < n; ++i) {
            long l = vectorOfScicosID.get(i);
            object2 = javaController.getKind(l);
            switch (object2) {
                case ANNOTATION: 
                case BLOCK: {
                    object = XcosCellFactory.createBlock(javaController, l, object2);
                    xcosCellArray[i] = object;
                    BlockPositioning.updatePortsPosition(xcosDiagram, (BasicBlock)object);
                    ((BasicBlock)object).getTypedChildrenIndexes(BasicPort.class).stream().map(arg_0 -> XcosCellFactory.lambda$insertChildren$43((BasicBlock)object, arg_0)).filter(mxICell2 -> mxICell2 instanceof BasicPort).map(mxICell2 -> (BasicPort)((Object)mxICell2)).forEach(basicPort -> hashMap.put(basicPort.getUID(), basicPort));
                    break;
                }
                case LINK: {
                    xcosCell = XcosCellFactory.createLink(javaController, l, object2);
                    xcosCellArray[i] = xcosCell;
                    arrayList.add((BasicLink)xcosCell);
                    break;
                }
            }
            object = new long[]{0L};
            javaController.getObjectProperty(l, (Kind)((Object)object2), ObjectProperties.LABEL, (long[])object);
            if (object[0] == 0L) continue;
            xcosCellArray[i].insert((mxICell)XcosCellFactory.createAnnotation(javaController, (long)object[0], Kind.ANNOTATION));
        }
        for (BasicLink basicLink : arrayList) {
            long[] lArray = new long[1];
            javaController.getObjectProperty(basicLink.getUID(), basicLink.getKind(), ObjectProperties.SOURCE_PORT, lArray);
            object2 = new long[1];
            javaController.getObjectProperty(basicLink.getUID(), basicLink.getKind(), ObjectProperties.DESTINATION_PORT, (long[])object2);
            object = (BasicPort)((Object)hashMap.get(lArray[0]));
            if (object != null) {
                basicLink.setSource((mxICell)object);
            } else {
                LOG.severe("Unable to connect link " + basicLink.getId() + " : invalid source " + lArray[0]);
                int n2 = Arrays.asList(xcosCellArray).indexOf((Object)basicLink);
                if (n2 >= 0) {
                    xcosCellArray[n2] = null;
                }
            }
            xcosCell = (BasicPort)((Object)hashMap.get((long)object2[0]));
            if (xcosCell != null) {
                basicLink.setTarget((mxICell)xcosCell);
                continue;
            }
            LOG.severe("Unable to connect link " + basicLink.getId() + " : invalid target " + (long)object2[0]);
            int n3 = Arrays.asList(xcosCellArray).indexOf((Object)basicLink);
            if (n3 < 0) continue;
            xcosCellArray[n3] = null;
        }
        vectorOfScicosID.clear();
        javaController.setObjectProperty(xcosDiagram.getUID(), xcosDiagram.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
        xcosDiagram.addCells((Object[])xcosCellArray);
    }

    public static BasicBlock createBlock(BlockInterFunction blockInterFunction) throws ScilabInterpreterManagement.InterpreterException {
        return XcosCellFactory.createBlock(blockInterFunction, blockInterFunction.name());
    }

    public static BasicBlock createBlock(String string) throws ScilabInterpreterManagement.InterpreterException {
        Optional<BlockInterFunction> optional = EnumSet.allOf(BlockInterFunction.class).stream().filter(blockInterFunction -> blockInterFunction.name().equals(string)).findFirst();
        BasicBlock basicBlock = optional.isPresent() ? XcosCellFactory.createBlock(optional.get()) : XcosCellFactory.createBlock(BlockInterFunction.BASIC_BLOCK, string);
        basicBlock.setStyle(string);
        return basicBlock;
    }

    private static BasicBlock createBlock(BlockInterFunction blockInterFunction, String string) throws ScilabInterpreterManagement.InterpreterException {
        return XcosCellFactory.createBlock(new JavaController(), blockInterFunction, string);
    }

    private static BasicBlock createBlock(JavaController javaController, BlockInterFunction blockInterFunction, String string) throws ScilabInterpreterManagement.InterpreterException {
        ScicosObjectOwner scicosObjectOwner;
        if (BlockInterFunction.BASIC_BLOCK.name().equals(string)) {
            scicosObjectOwner = new ScicosObjectOwner(javaController.createObject(Kind.BLOCK), Kind.BLOCK);
        } else {
            ScilabInterpreterManagement.synchronousScilabExec((String)("xcosCellCreated(" + string + "(\"define\")); "));
            scicosObjectOwner = XcosCellFactory.getLastCreated();
        }
        if (scicosObjectOwner == null) {
            throw new ScilabInterpreterManagement.InterpreterException("XcosCellFactory#createBlock : unable to allocate " + string);
        }
        BasicBlock basicBlock = EnumSet.of(Kind.BLOCK, Kind.ANNOTATION).contains((Object)scicosObjectOwner.getKind()) ? XcosCellFactory.createBlock(javaController, blockInterFunction, string, scicosObjectOwner.getUID(), scicosObjectOwner.getKind()) : null;
        return basicBlock;
    }

    public static BasicBlock createBlock(JavaController javaController, long l, Kind kind) {
        String[] stringArray = new String[1];
        if (kind == Kind.BLOCK) {
            javaController.getObjectProperty(l, kind, ObjectProperties.INTERFACE_FUNCTION, stringArray);
        } else {
            stringArray[0] = "TEXT_f";
        }
        BlockInterFunction blockInterFunction = XcosCellFactory.lookForInterfunction(stringArray[0]);
        return XcosCellFactory.createBlock(javaController, blockInterFunction, stringArray[0], l, kind);
    }

    public static BlockInterFunction lookForInterfunction(String string) {
        Optional<BlockInterFunction> optional = EnumSet.allOf(BlockInterFunction.class).stream().filter(blockInterFunction -> blockInterFunction.name().equals(string)).findFirst();
        BlockInterFunction blockInterFunction2 = optional.isPresent() ? optional.get() : BlockInterFunction.BASIC_BLOCK;
        return blockInterFunction2;
    }

    public static BasicBlock createBlock(JavaController javaController, BlockInterFunction blockInterFunction, String string, long l, Kind kind) {
        boolean bl;
        EnumMap<ObjectProperties, Integer> enumMap = new EnumMap<ObjectProperties, Integer>(ObjectProperties.class);
        enumMap.put(ObjectProperties.INPUTS, 0);
        enumMap.put(ObjectProperties.OUTPUTS, 0);
        enumMap.put(ObjectProperties.EVENT_INPUTS, 0);
        enumMap.put(ObjectProperties.EVENT_OUTPUTS, 0);
        String[] stringArray = new String[1];
        javaController.getObjectProperty(l, kind, ObjectProperties.UID, stringArray);
        String[] stringArray2 = new String[1];
        javaController.getObjectProperty(l, kind, ObjectProperties.STYLE, stringArray2);
        if (stringArray2[0].isEmpty()) {
            stringArray2[0] = string;
        }
        String[] stringArray3 = new String[]{null};
        javaController.getObjectProperty(l, kind, ObjectProperties.DESCRIPTION, stringArray3);
        String string2 = stringArray3[0];
        VectorOfDouble vectorOfDouble = new VectorOfDouble(4L);
        javaController.getObjectProperty(l, kind, ObjectProperties.GEOMETRY, vectorOfDouble);
        double d = vectorOfDouble.get(0);
        double d2 = vectorOfDouble.get(1);
        double d3 = vectorOfDouble.get(2);
        double d4 = vectorOfDouble.get(3);
        mxGeometry mxGeometry2 = new mxGeometry(d, d2, d3, d4);
        BasicBlock basicBlock = null;
        try {
            Constructor<? extends BasicBlock> constructor = blockInterFunction.getKlass().getConstructor(JavaController.class, Long.TYPE, Kind.class, Object.class, mxGeometry.class, String.class, String.class);
            basicBlock = constructor.newInstance(new Object[]{javaController, l, kind, string2, mxGeometry2, stringArray2[0], stringArray[0]});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return basicBlock;
        }
        if (basicBlock.getKind() == Kind.BLOCK) {
            XcosCellFactory.insertPortChildren(javaController, enumMap, (XcosCell)basicBlock);
        }
        if (basicBlock instanceof SplitBlock) {
            bl = false;
        } else if (basicBlock instanceof RoundBlock) {
            int n = enumMap.get((Object)ObjectProperties.INPUTS) + 1 + enumMap.get((Object)ObjectProperties.OUTPUTS) + 1 + enumMap.get((Object)ObjectProperties.EVENT_INPUTS) + 1 + enumMap.get((Object)ObjectProperties.EVENT_OUTPUTS) + 1;
            bl = 2.0 * d3 + 2.0 * d4 < (double)n * 8.0;
        } else {
            double d5 = Math.max((double)(enumMap.get((Object)ObjectProperties.INPUTS) + 1) * 8.0, (double)(enumMap.get((Object)ObjectProperties.OUTPUTS) + 1) * 8.0);
            double d6 = Math.max((double)(enumMap.get((Object)ObjectProperties.EVENT_INPUTS) + 1) * 8.0, (double)(enumMap.get((Object)ObjectProperties.EVENT_OUTPUTS) + 1) * 8.0);
            bl = d4 < d5 | d3 < d6;
            bl |= d4 * d3 < d5 * d6;
        }
        if (bl) {
            d2 = -d2 - (d4 *= 20.0);
            basicBlock.setGeometry(new mxGeometry(d, d2, d3 *= 20.0, d4));
        }
        return basicBlock;
    }

    public static BasicBlock createBlock(JavaController javaController, ScicosObjectOwner scicosObjectOwner) {
        if (scicosObjectOwner.getKind() != Kind.ANNOTATION && scicosObjectOwner.getKind() != Kind.BLOCK) {
            return null;
        }
        String[] stringArray = new String[1];
        BlockInterFunction blockInterFunction = XcosCellFactory.lookForInterfunction(stringArray[0]);
        return XcosCellFactory.createBlock(javaController, blockInterFunction, stringArray[0], scicosObjectOwner.getUID(), scicosObjectOwner.getKind());
    }

    private static void insertPortChildren(JavaController javaController, EnumMap<ObjectProperties, Integer> enumMap, XcosCell xcosCell) {
        for (ObjectProperties objectProperties : enumMap.keySet()) {
            enumMap.put(objectProperties, XcosCellFactory.insertPortChildren(javaController, objectProperties, xcosCell));
        }
    }

    private static int insertPortChildren(JavaController javaController, ObjectProperties objectProperties, XcosCell xcosCell) {
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        javaController.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), objectProperties, vectorOfScicosID);
        XcosCell[] xcosCellArray = new XcosCell[vectorOfScicosID.size()];
        for (int i = 0; i < xcosCellArray.length; ++i) {
            BasicPort basicPort = XcosCellFactory.createPort(javaController, vectorOfScicosID.get(i), objectProperties);
            xcosCellArray[i] = basicPort;
        }
        vectorOfScicosID.clear();
        javaController.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), objectProperties, vectorOfScicosID);
        Arrays.stream(xcosCellArray).forEach(xcosCell2 -> xcosCell.insert((mxICell)xcosCell2));
        return xcosCellArray.length;
    }

    private static final BasicPort createPort(JavaController javaController, long l, ObjectProperties objectProperties) {
        BasicPort basicPort;
        boolean[] blArray = new boolean[]{false};
        String[] stringArray = new String[]{""};
        javaController.getObjectProperty(l, Kind.PORT, ObjectProperties.UID, stringArray);
        String[] stringArray2 = new String[]{""};
        javaController.getObjectProperty(l, Kind.PORT, ObjectProperties.STYLE, stringArray2);
        String[] stringArray3 = new String[]{""};
        javaController.getObjectProperty(l, Kind.PORT, ObjectProperties.LABEL, stringArray3);
        switch (objectProperties) {
            case INPUTS: {
                javaController.getObjectProperty(l, Kind.PORT, ObjectProperties.IMPLICIT, blArray);
                if (blArray[0]) {
                    basicPort = new ImplicitInputPort(javaController, l, Kind.PORT, stringArray3[0], stringArray2[0], stringArray[0]);
                    break;
                }
                basicPort = new ExplicitInputPort(javaController, l, Kind.PORT, stringArray3[0], stringArray2[0], stringArray[0]);
                break;
            }
            case OUTPUTS: {
                javaController.getObjectProperty(l, Kind.PORT, ObjectProperties.IMPLICIT, blArray);
                if (blArray[0]) {
                    basicPort = new ImplicitOutputPort(javaController, l, Kind.PORT, stringArray3[0], stringArray2[0], stringArray[0]);
                    break;
                }
                basicPort = new ExplicitOutputPort(javaController, l, Kind.PORT, stringArray3[0], stringArray2[0], stringArray[0]);
                break;
            }
            case EVENT_INPUTS: {
                basicPort = new ControlPort(javaController, l, Kind.PORT, stringArray3[0], stringArray2[0], stringArray[0]);
                break;
            }
            case EVENT_OUTPUTS: {
                basicPort = new CommandPort(javaController, l, Kind.PORT, stringArray3[0], stringArray2[0], stringArray[0]);
                break;
            }
            default: {
                return null;
            }
        }
        return basicPort;
    }

    private static BasicLink createLink(JavaController javaController, long l, Kind kind) {
        BasicLink basicLink;
        int[] nArray = new int[1];
        javaController.getObjectProperty(l, kind, ObjectProperties.KIND, nArray);
        String[] stringArray = new String[]{null};
        javaController.getObjectProperty(l, kind, ObjectProperties.DESCRIPTION, stringArray);
        String string = stringArray[0];
        String[] stringArray2 = new String[]{""};
        javaController.getObjectProperty(l, kind, ObjectProperties.STYLE, stringArray2);
        String[] stringArray3 = new String[]{""};
        javaController.getObjectProperty(l, kind, ObjectProperties.UID, stringArray3);
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(l, kind, ObjectProperties.CONTROL_POINTS, vectorOfDouble);
        int n = vectorOfDouble.size() / 2;
        mxGeometry mxGeometry2 = new mxGeometry();
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
        int n2 = 0;
        ++n2;
        while (n2 < n - 1) {
            arrayList.add(new mxPoint(vectorOfDouble.get(2 * n2), vectorOfDouble.get(2 * n2 + 1)));
            ++n2;
        }
        ++n2;
        mxGeometry2.setPoints(arrayList);
        switch (nArray[0]) {
            case -1: {
                basicLink = new CommandControlLink(javaController, l, kind, string, mxGeometry2, stringArray2[0], stringArray3[0]);
                break;
            }
            case 1: {
                basicLink = new ExplicitLink(javaController, l, kind, string, mxGeometry2, stringArray2[0], stringArray3[0]);
                break;
            }
            case 2: {
                basicLink = new ImplicitLink(javaController, l, kind, string, mxGeometry2, stringArray2[0], stringArray3[0]);
                break;
            }
            default: {
                return null;
            }
        }
        return basicLink;
    }

    private static XcosCell createAnnotation(JavaController javaController, long l, Kind kind) {
        String[] stringArray = new String[]{""};
        javaController.getObjectProperty(l, kind, ObjectProperties.DESCRIPTION, stringArray);
        VectorOfDouble vectorOfDouble = new VectorOfDouble(4L);
        javaController.getObjectProperty(l, kind, ObjectProperties.GEOMETRY, vectorOfDouble);
        double d = vectorOfDouble.get(0);
        double d2 = vectorOfDouble.get(1);
        double d3 = vectorOfDouble.get(2);
        double d4 = vectorOfDouble.get(3);
        mxGeometry mxGeometry2 = new mxGeometry(d, d2, d3, d4);
        String[] stringArray2 = new String[1];
        javaController.getObjectProperty(l, kind, ObjectProperties.UID, stringArray2);
        String[] stringArray3 = new String[1];
        javaController.getObjectProperty(l, kind, ObjectProperties.STYLE, stringArray3);
        XcosCell xcosCell = new XcosCell(javaController, l, kind, stringArray[0], mxGeometry2, stringArray3[0], stringArray2[0]);
        xcosCell.setConnectable(false);
        xcosCell.setVertex(true);
        return xcosCell;
    }

    private static /* synthetic */ mxICell lambda$insertChildren$43(BasicBlock basicBlock, Integer n) {
        return basicBlock.getChildAt(n);
    }
}

