/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.graph.model;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import java.rmi.server.UID;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.PortKind;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.block.TextBlock;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;

public class XcosCell
extends mxCell {
    private static final long serialVersionUID = 1L;
    private static Pattern validCIdentifier = null;
    private transient ScicosObjectOwner owner;

    public XcosCell(JavaController javaController, long l, Kind kind, Object object, mxGeometry mxGeometry2, String string, String string2) {
        if (l == 0L) {
            throw new IllegalArgumentException();
        }
        this.owner = new ScicosObjectOwner(javaController, l, kind);
        this.setValue(javaController, object);
        this.setGeometry(javaController, mxGeometry2);
        this.setStyle(javaController, string);
        this.setId(javaController, string2);
    }

    public long getUID() {
        return this.owner.getUID();
    }

    public Kind getKind() {
        return this.owner.getKind();
    }

    public void setValue(Object object) {
        this.setValue(new JavaController(), object);
    }

    public final void setValue(JavaController javaController, Object object) {
        super.setValue(object);
        this.setMVCValue(javaController, object);
    }

    protected void setMVCValue(JavaController javaController, Object object) {
        if (object == null) {
            return;
        }
        switch (this.getKind()) {
            case BLOCK: {
                String string;
                if (validCIdentifier == null) {
                    validCIdentifier = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
                }
                if (!validCIdentifier.matcher(string = String.valueOf(object)).matches()) break;
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.DESCRIPTION, string);
                break;
            }
            case ANNOTATION: {
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.DESCRIPTION, String.valueOf(object));
                break;
            }
            case LINK: {
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.DESCRIPTION, String.valueOf(object));
                break;
            }
            case PORT: {
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.LABEL, String.valueOf(object));
                break;
            }
        }
    }

    public void setId(String string) {
        this.setId(new JavaController(), string);
    }

    public final void setId(JavaController javaController, String string) {
        if (string == null || string.isEmpty()) {
            string = new UID().toString();
        }
        super.setId(string);
        this.setMVCId(javaController, string);
    }

    private void setMVCId(JavaController javaController, String string) {
        if (string == null) {
            return;
        }
        switch (this.getKind()) {
            case BLOCK: 
            case ANNOTATION: 
            case LINK: 
            case PORT: {
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.UID, string);
                break;
            }
        }
    }

    public void setGeometry(mxGeometry mxGeometry2) {
        this.setGeometry(new JavaController(), mxGeometry2);
    }

    public final void setGeometry(JavaController javaController, mxGeometry mxGeometry2) {
        super.setGeometry(mxGeometry2);
        this.setMVCGeometry(javaController, mxGeometry2);
    }

    private void setMVCGeometry(JavaController javaController, mxGeometry mxGeometry2) {
        if (mxGeometry2 == null) {
            return;
        }
        switch (this.getKind()) {
            case BLOCK: 
            case ANNOTATION: {
                VectorOfDouble vectorOfDouble = new VectorOfDouble(4L);
                vectorOfDouble.set(0, mxGeometry2.getX());
                vectorOfDouble.set(1, mxGeometry2.getY());
                vectorOfDouble.set(2, mxGeometry2.getWidth());
                vectorOfDouble.set(3, mxGeometry2.getHeight());
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.GEOMETRY, vectorOfDouble);
                break;
            }
            case LINK: {
                List list;
                mxPoint mxPoint2 = null;
                mxPoint mxPoint3 = null;
                mxICell mxICell2 = this.getSource();
                mxICell mxICell3 = this.getTarget();
                if (mxICell2 != null && mxICell2.getGeometry() != null) {
                    mxPoint2 = new mxPoint(mxICell2.getGeometry().getCenterX(), mxICell2.getGeometry().getCenterY());
                }
                if (mxICell3 != null && mxICell3.getGeometry() != null) {
                    mxPoint3 = new mxPoint(mxICell3.getGeometry().getCenterX(), mxICell3.getGeometry().getCenterY());
                }
                if (mxPoint2 == null) {
                    mxPoint2 = mxGeometry2.getSourcePoint();
                }
                if (mxPoint3 == null) {
                    mxPoint3 = mxGeometry2.getTargetPoint();
                }
                if (mxPoint2 == null) {
                    mxPoint2 = new mxPoint();
                }
                if (mxPoint3 == null) {
                    mxPoint3 = new mxPoint();
                }
                if ((list = mxGeometry2.getPoints()) == null) {
                    list = Collections.emptyList();
                }
                int n = 2 + list.size();
                VectorOfDouble vectorOfDouble = new VectorOfDouble(2 * n);
                int n2 = 0;
                vectorOfDouble.set(2 * n2, mxPoint2.getX());
                vectorOfDouble.set(2 * n2 + 1, mxPoint2.getY());
                ++n2;
                while (n2 < n - 1) {
                    vectorOfDouble.set(2 * n2, ((mxPoint)list.get(n2 - 1)).getX());
                    vectorOfDouble.set(2 * n2 + 1, ((mxPoint)list.get(n2 - 1)).getY());
                    ++n2;
                }
                vectorOfDouble.set(2 * n2, mxPoint3.getX());
                vectorOfDouble.set(2 * n2 + 1, mxPoint3.getY());
                ++n2;
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.CONTROL_POINTS, vectorOfDouble);
                break;
            }
        }
    }

    public void setStyle(String string) {
        this.setStyle(new JavaController(), string);
    }

    public final void setStyle(JavaController javaController, String string) {
        super.setStyle(string);
        this.setMVCStyle(javaController, string);
    }

    private void setMVCStyle(JavaController javaController, String string) {
        if (string == null) {
            return;
        }
        switch (this.getKind()) {
            case BLOCK: 
            case ANNOTATION: 
            case LINK: 
            case PORT: {
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.STYLE, string);
                break;
            }
        }
    }

    public void removeFromParent() {
        super.removeFromParent();
        if (this.parent == null) {
            return;
        }
        JavaController javaController = new JavaController();
        switch (this.getKind()) {
            case BLOCK: 
            case ANNOTATION: 
            case LINK: {
                long[] lArray = new long[1];
                Kind kind = Kind.BLOCK;
                ObjectProperties objectProperties = ObjectProperties.PARENT_BLOCK;
                javaController.getObjectProperty(this.getUID(), this.getKind(), objectProperties, lArray);
                if (lArray[0] == 0L) {
                    kind = Kind.DIAGRAM;
                    objectProperties = ObjectProperties.PARENT_DIAGRAM;
                    javaController.getObjectProperty(this.getUID(), this.getKind(), objectProperties, lArray);
                }
                if (lArray[0] == 0L) break;
                VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
                javaController.getObjectProperty(lArray[0], kind, ObjectProperties.CHILDREN, vectorOfScicosID);
                vectorOfScicosID.remove(this.getUID());
                javaController.setObjectProperty(lArray[0], kind, ObjectProperties.CHILDREN, vectorOfScicosID);
                javaController.setObjectProperty(this.getUID(), this.getKind(), objectProperties, 0L);
                break;
            }
            case PORT: {
                long[] lArray = new long[1];
                Kind kind = Kind.BLOCK;
                javaController.getObjectProperty(this.getUID(), this.getKind(), ObjectProperties.SOURCE_BLOCK, lArray);
                int[] nArray = new int[1];
                javaController.getObjectProperty(this.getUID(), this.getKind(), ObjectProperties.PORT_KIND, nArray);
                ObjectProperties objectProperties = this.relatedPortKindProperty(nArray[0]);
                VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
                javaController.getObjectProperty(lArray[0], kind, objectProperties, vectorOfScicosID);
                vectorOfScicosID.remove(this.getUID());
                javaController.setObjectProperty(lArray[0], kind, objectProperties, vectorOfScicosID);
                javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.SOURCE_BLOCK, 0L);
                break;
            }
        }
    }

    private ObjectProperties relatedPortKindProperty(int n) {
        ObjectProperties objectProperties;
        switch (PortKind.values()[n]) {
            case PORT_IN: {
                objectProperties = ObjectProperties.INPUTS;
                break;
            }
            case PORT_OUT: {
                objectProperties = ObjectProperties.OUTPUTS;
                break;
            }
            case PORT_EIN: {
                objectProperties = ObjectProperties.EVENT_INPUTS;
                break;
            }
            case PORT_EOUT: {
                objectProperties = ObjectProperties.EVENT_OUTPUTS;
                break;
            }
            default: {
                objectProperties = null;
            }
        }
        return objectProperties;
    }

    public void setParent(mxICell mxICell2) {
        super.setParent(mxICell2);
        if (mxICell2 instanceof XcosCell) {
            XcosCell xcosCell = (XcosCell)mxICell2;
            JavaController javaController = new JavaController();
            switch (this.getKind()) {
                case ANNOTATION: {
                    if (this instanceof TextBlock) {
                        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.PARENT_BLOCK, xcosCell.getUID());
                        long[] lArray = new long[1];
                        javaController.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.PARENT_DIAGRAM, lArray);
                        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.PARENT_DIAGRAM, lArray[0]);
                        break;
                    }
                    javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.RELATED_TO, xcosCell.getUID());
                    break;
                }
                case BLOCK: 
                case LINK: {
                    if (xcosCell.getKind() == Kind.DIAGRAM) {
                        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.PARENT_DIAGRAM, xcosCell.getUID());
                        break;
                    }
                    javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.PARENT_BLOCK, xcosCell.getUID());
                    long[] lArray = new long[1];
                    javaController.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.PARENT_DIAGRAM, lArray);
                    javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.PARENT_DIAGRAM, lArray[0]);
                    break;
                }
                case PORT: {
                    javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.SOURCE_BLOCK, xcosCell.getUID());
                    break;
                }
            }
        }
    }

    public mxICell setTerminal(mxICell mxICell2, boolean bl) {
        mxICell mxICell3 = super.setTerminal(mxICell2, bl);
        if (mxICell3 == null) {
            return mxICell3;
        }
        long l = ((XcosCell)mxICell3).getUID();
        Kind kind = ((XcosCell)mxICell3).getKind();
        JavaController javaController = new JavaController();
        switch (this.getKind()) {
            case LINK: {
                if (bl) {
                    javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.SOURCE_PORT, l);
                } else {
                    javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.DESTINATION_PORT, l);
                }
                if (l == 0L) break;
                javaController.setObjectProperty(l, kind, ObjectProperties.CONNECTED_SIGNALS, this.getUID());
                break;
            }
        }
        return mxICell3;
    }

    public mxICell insert(mxICell mxICell2, int n) {
        mxICell mxICell3 = super.insert(mxICell2, n);
        if (!(mxICell2 instanceof XcosCell)) {
            return mxICell3;
        }
        XcosCell xcosCell = (XcosCell)mxICell2;
        switch (this.getKind()) {
            case BLOCK: {
                switch (xcosCell.getKind()) {
                    case ANNOTATION: {
                        if (xcosCell instanceof TextBlock) {
                            this.insertChild(xcosCell, n);
                            break;
                        }
                        this.insertLabel(xcosCell);
                        break;
                    }
                    case BLOCK: 
                    case LINK: {
                        this.insertChild(xcosCell, n);
                        break;
                    }
                    case PORT: {
                        this.insertPort(xcosCell, n);
                    }
                }
                break;
            }
            case DIAGRAM: {
                this.insertChild(xcosCell, n);
                break;
            }
        }
        return mxICell3;
    }

    private void insertPort(XcosCell xcosCell, int n) {
        JavaController javaController = new JavaController();
        int[] nArray = new int[1];
        javaController.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.PORT_KIND, nArray);
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        ObjectProperties objectProperties = this.relatedPortKindProperty(nArray[0]);
        if (objectProperties != null) {
            javaController.getObjectProperty(this.getUID(), this.getKind(), objectProperties, vectorOfScicosID);
            vectorOfScicosID.add(xcosCell.getUID());
            javaController.setObjectProperty(this.getUID(), this.getKind(), objectProperties, vectorOfScicosID);
        }
    }

    private void insertChild(XcosCell xcosCell, int n) {
        JavaController javaController = new JavaController();
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        javaController.getObjectProperty(this.getUID(), this.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
        vectorOfScicosID.add(xcosCell.getUID());
        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
    }

    private void insertLabel(XcosCell xcosCell) {
        JavaController javaController = new JavaController();
        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.LABEL, xcosCell.getUID());
    }

    public mxICell remove(mxICell mxICell2) {
        mxICell mxICell3 = super.remove(mxICell2);
        if (!(mxICell2 instanceof XcosCell)) {
            return mxICell3;
        }
        XcosCell xcosCell = (XcosCell)mxICell2;
        switch (this.getKind()) {
            case BLOCK: {
                switch (xcosCell.getKind()) {
                    case ANNOTATION: {
                        if (xcosCell instanceof TextBlock) {
                            this.removeChild(xcosCell);
                            break;
                        }
                        this.removeLabel(xcosCell);
                        break;
                    }
                    case BLOCK: 
                    case LINK: {
                        this.removeChild(xcosCell);
                        break;
                    }
                    case PORT: {
                        this.removePort(xcosCell);
                    }
                }
                break;
            }
            case DIAGRAM: {
                this.removeChild(xcosCell);
                break;
            }
        }
        return mxICell3;
    }

    private void removePort(XcosCell xcosCell) {
        ObjectProperties objectProperties;
        JavaController javaController = new JavaController();
        int[] nArray = new int[1];
        javaController.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.PORT_KIND, nArray);
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        switch (PortKind.values()[nArray[0]]) {
            case PORT_IN: {
                objectProperties = ObjectProperties.INPUTS;
                break;
            }
            case PORT_OUT: {
                objectProperties = ObjectProperties.OUTPUTS;
                break;
            }
            case PORT_EIN: {
                objectProperties = ObjectProperties.EVENT_INPUTS;
                break;
            }
            case PORT_EOUT: {
                objectProperties = ObjectProperties.EVENT_OUTPUTS;
                break;
            }
            default: {
                objectProperties = null;
            }
        }
        javaController.getObjectProperty(this.getUID(), this.getKind(), objectProperties, vectorOfScicosID);
        vectorOfScicosID.remove(xcosCell.getUID());
        javaController.setObjectProperty(this.getUID(), this.getKind(), objectProperties, vectorOfScicosID);
    }

    private void removeChild(XcosCell xcosCell) {
        JavaController javaController = new JavaController();
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        javaController.getObjectProperty(this.getUID(), this.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
        vectorOfScicosID.remove(xcosCell.getUID());
        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
    }

    private void removeLabel(XcosCell xcosCell) {
        JavaController javaController = new JavaController();
        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.LABEL, 0);
        javaController.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.RELATED_TO, 0);
    }

    public Object clone() throws CloneNotSupportedException {
        JavaController javaController = new JavaController();
        XcosCell xcosCell = (XcosCell)((Object)super.clone());
        xcosCell.owner = new ScicosObjectOwner(javaController.cloneObject(this.getUID(), true, false), this.getKind());
        return xcosCell;
    }
}

