/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.graph;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphSelectionModel;
import com.mxgraph.view.mxMultiplicity;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.xcos.Controller;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfBool;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.VectorOfString;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.actions.SaveAsAction;
import org.scilab.modules.xcos.block.AfficheBlock;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SplitBlock;
import org.scilab.modules.xcos.block.SuperBlock;
import org.scilab.modules.xcos.block.TextBlock;
import org.scilab.modules.xcos.block.io.ContextUpdate;
import org.scilab.modules.xcos.block.io.EventInBlock;
import org.scilab.modules.xcos.block.io.EventOutBlock;
import org.scilab.modules.xcos.block.io.ExplicitInBlock;
import org.scilab.modules.xcos.block.io.ExplicitOutBlock;
import org.scilab.modules.xcos.block.io.ImplicitInBlock;
import org.scilab.modules.xcos.block.io.ImplicitOutBlock;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.graph.model.BlockInterFunction;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.graph.model.XcosGraphModel;
import org.scilab.modules.xcos.graph.swing.GraphComponent;
import org.scilab.modules.xcos.io.ScilabTypeCoder;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.io.scicos.ScilabDirectHandler;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.link.CommandControlLink;
import org.scilab.modules.xcos.link.ExplicitLink;
import org.scilab.modules.xcos.link.ImplicitLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.Orientation;
import org.scilab.modules.xcos.port.PortCheck;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.control.ControlPort;
import org.scilab.modules.xcos.port.input.ExplicitInputPort;
import org.scilab.modules.xcos.port.input.ImplicitInputPort;
import org.scilab.modules.xcos.port.output.ExplicitOutputPort;
import org.scilab.modules.xcos.port.output.ImplicitOutputPort;
import org.scilab.modules.xcos.preferences.XcosOptions;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.Stack;
import org.scilab.modules.xcos.utils.XcosDialogs;
import org.scilab.modules.xcos.utils.XcosMessages;

public class XcosDiagram
extends ScilabGraph {
    private static final Logger LOG = Logger.getLogger(XcosDiagram.class.getName());
    private static final String CELLS = "cells";
    public static final String IN = "in";
    public static final String OUT = "out";
    public static final String EIN = "ein";
    public static final String EOUT = "eout";
    public static final String HASH_IDENTIFIER = "#identifier";

    public XcosDiagram(JavaController javaController, long l, Kind kind, String string) {
        super((mxIGraphModel)new XcosGraphModel(javaController, l, kind, string), Xcos.getInstance().getStyleSheet());
        this.setDefaultParent(this.getModel().getChildAt(this.getModel().getRoot(), 0));
        this.setComponent(new GraphComponent(this));
        this.initComponent();
        this.setCellsDisconnectable(false);
        this.setAllowDanglingEdges(false);
        this.setAllowLoops(false);
        this.setCellsResizable(true);
        this.setHtmlLabels(true);
        this.setVertexLabelsMovable(true);
        this.setEdgeLabelsMovable(true);
        this.setCloneInvalidEdges(true);
        this.setCellsEditable(true);
        this.setConnectableEdges(true);
        this.setResetEdgesOnConnect(false);
        this.setMultiplicities();
        this.setAutoOrigin(true);
        ((mxGraphModel)this.getModel()).setMaintainEdgeParent(false);
    }

    public static Object[] filterByClass(Object[] objectArray, final Class<BasicBlock> clazz) {
        return mxGraphModel.filterCells((Object[])objectArray, (mxGraphModel.Filter)new mxGraphModel.Filter(){

            public boolean filter(Object object) {
                return clazz.isInstance(object);
            }
        });
    }

    public static Stack<ScicosObjectOwner> lookForHierarchy(ScicosObjectOwner scicosObjectOwner) {
        ScicosObjectOwner scicosObjectOwner2 = scicosObjectOwner;
        Stack<ScicosObjectOwner> stack = new Stack<ScicosObjectOwner>();
        JavaController javaController = new JavaController();
        long[] lArray = new long[]{scicosObjectOwner2.getUID()};
        if (scicosObjectOwner2.getKind() == Kind.DIAGRAM) {
            stack.push(scicosObjectOwner2);
            return stack;
        }
        while (lArray[0] != 0L) {
            stack.push(new ScicosObjectOwner(lArray[0], Kind.BLOCK));
            javaController.getObjectProperty(lArray[0], Kind.BLOCK, ObjectProperties.PARENT_BLOCK, lArray);
        }
        javaController.getObjectProperty(scicosObjectOwner2.getUID(), scicosObjectOwner2.getKind(), ObjectProperties.PARENT_DIAGRAM, lArray);
        stack.push(new ScicosObjectOwner(lArray[0], Kind.DIAGRAM));
        return stack;
    }

    public static List<? extends BasicBlock> iparSort(List<? extends BasicBlock> list, final JavaController javaController) {
        Collections.sort(list, new Comparator<BasicBlock>(){

            @Override
            public int compare(BasicBlock basicBlock, BasicBlock basicBlock2) {
                VectorOfInt vectorOfInt = new VectorOfInt();
                VectorOfInt vectorOfInt2 = new VectorOfInt();
                javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.IPAR, vectorOfInt);
                javaController.getObjectProperty(basicBlock2.getUID(), Kind.BLOCK, ObjectProperties.IPAR, vectorOfInt2);
                int n = vectorOfInt.size() >= 1 ? vectorOfInt.get(0) : 0;
                int n2 = vectorOfInt2.size() >= 1 ? vectorOfInt2.get(0) : 0;
                return n - n2;
            }
        });
        return list;
    }

    private <T extends BasicBlock> List<T> getAllTypedBlock(Class<T> clazz) {
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>();
        int n = this.getModel().getChildCount(this.getDefaultParent());
        for (int i = 0; i < n; ++i) {
            Object object = this.getModel().getChildAt(this.getDefaultParent(), i);
            if (!clazz.isInstance(object)) continue;
            arrayList.add((BasicBlock)object);
        }
        return arrayList;
    }

    private <T extends BasicBlock> List<T> getAllTypedBlock(Class<T>[] classArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Class<T> clazz : classArray) {
            arrayList.addAll(this.getAllTypedBlock(clazz));
        }
        return arrayList;
    }

    public final Map<Object, Object> fillContext(Map<Object, Object> map, JavaController javaController) {
        if (!map.containsKey(IN)) {
            map.put(IN, XcosDiagram.iparSort(this.getAllTypedBlock(new Class[]{ExplicitInBlock.class, ImplicitInBlock.class}), javaController));
        }
        if (!map.containsKey(OUT)) {
            map.put(OUT, XcosDiagram.iparSort(this.getAllTypedBlock(new Class[]{ExplicitOutBlock.class, ImplicitOutBlock.class}), javaController));
        }
        if (!map.containsKey(EIN)) {
            map.put(EIN, XcosDiagram.iparSort(this.getAllTypedBlock(new Class[]{EventInBlock.class}), javaController));
        }
        if (!map.containsKey(EOUT)) {
            map.put(EOUT, XcosDiagram.iparSort(this.getAllTypedBlock(new Class[]{EventOutBlock.class}), javaController));
        }
        return map;
    }

    public String validateCell(Object object, Hashtable<Object, Object> hashtable) {
        if (this.getKind() == Kind.BLOCK) {
            return this.validateChildDiagram(object, hashtable);
        }
        return null;
    }

    public String validateChildDiagram(Object object, Map<Object, Object> map) {
        String string;
        String string2 = null;
        if (object instanceof ExplicitInBlock || object instanceof ImplicitInBlock) {
            string = IN;
        } else if (object instanceof ExplicitOutBlock || object instanceof ImplicitOutBlock) {
            string = OUT;
        } else if (object instanceof EventInBlock) {
            string = EIN;
        } else if (object instanceof EventOutBlock) {
            string = EOUT;
        } else {
            return null;
        }
        BasicBlock basicBlock = (BasicBlock)object;
        JavaController javaController = new JavaController();
        this.fillContext(map, javaController);
        List list = (List)map.get(string);
        int n = list.indexOf(basicBlock) + 1;
        VectorOfInt vectorOfInt = new VectorOfInt();
        javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.IPAR, vectorOfInt);
        if (vectorOfInt.size() < 1) {
            return string2;
        }
        int n2 = vectorOfInt.get(0);
        if (n != n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><body><em>");
            stringBuilder.append(XcosMessages.WRONG_PORT_NUMBER);
            stringBuilder.append("</em><br/>");
            stringBuilder.append(String.format(XcosMessages.EXPECTING_NUMBER, n, n2));
            stringBuilder.append("</body></html>    ");
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public void updateBlock(BasicBlock basicBlock, Map<ObjectProperties, Object> map) {
        this.model.beginUpdate();
        try {
            this.blockUpdated(basicBlock, map);
            this.fireEvent(new mxEventObject("updateBlock", new Object[]{"block", basicBlock}));
        }
        finally {
            this.model.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockUpdated(BasicBlock basicBlock, Map<ObjectProperties, Object> map) {
        this.model.beginUpdate();
        try {
            for (Map.Entry<ObjectProperties, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof double[]) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (double[])entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof int[]) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (int[])entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof boolean[]) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (boolean[])entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof String[]) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (String[])entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof long[]) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (long[])entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof VectorOfDouble) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (VectorOfDouble)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof VectorOfInt) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (VectorOfInt)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof VectorOfBool) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (VectorOfBool)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof VectorOfString) {
                    ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (VectorOfString)entry.getValue());
                    continue;
                }
                if (!(entry.getValue() instanceof VectorOfScicosID)) continue;
                ((XcosGraphModel)this.model).setProperty(basicBlock, entry.getKey(), (VectorOfScicosID)entry.getValue());
            }
        }
        finally {
            this.model.endUpdate();
        }
    }

    public Object createEdge(Object object, String string, Object object2, Object object3, Object object4, String string2) {
        BasicLink basicLink = null;
        JavaController javaController = new JavaController();
        if (object3 instanceof BasicPort) {
            BasicPort basicPort = (BasicPort)((Object)object3);
            BasicLink basicLink2 = null;
            long l = javaController.createObject(Kind.LINK);
            basicLink2 = basicPort.getType() == BasicPort.Type.EXPLICIT ? new ExplicitLink(javaController, l, Kind.LINK, object2, null, string2, string) : (basicPort.getType() == BasicPort.Type.IMPLICIT ? new ImplicitLink(javaController, l, Kind.LINK, object2, null, string2, string) : new CommandControlLink(javaController, l, Kind.LINK, object2, null, string2, string));
            basicLink2.setGeometry(new mxGeometry());
            basicLink = basicLink2;
        } else {
            if (object3 instanceof SplitBlock) {
                SplitBlock splitBlock = (SplitBlock)object3;
                return this.createEdge(object, string, object2, (Object)splitBlock.getIn(), object4, string2);
            }
            if (object3 instanceof BasicLink) {
                BasicLink basicLink3 = (BasicLink)((Object)object3);
                BasicLink basicLink4 = null;
                try {
                    Class<?> clazz = ((Object)((Object)basicLink3)).getClass();
                    Constructor<?> constructor = clazz.getConstructor(JavaController.class, Long.TYPE, Kind.class, Object.class, mxGeometry.class, String.class, String.class);
                    basicLink4 = (BasicLink)((Object)constructor.newInstance(new Object[]{javaController, javaController.createObject(Kind.LINK), basicLink3.getKind(), null, new mxGeometry(), basicLink3.getStyle(), new UID().toString()}));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    LOG.severe(reflectiveOperationException.toString());
                }
                basicLink = basicLink4;
            }
        }
        if (basicLink == null) {
            LOG.warning("Unable to create an edge");
        }
        return basicLink;
    }

    public Object addCell(Object object, Object object2, Integer n, Object object3, Object object4) {
        if (object3 == null && object4 == null) {
            return super.addCell(object, object2, n, object3, object4);
        }
        if (object3 instanceof CommandPort && object4 instanceof ControlPort && object instanceof CommandControlLink) {
            return super.addCell(object, object2, n, object3, object4);
        }
        if (object4 instanceof CommandPort && object3 instanceof ControlPort && object instanceof CommandControlLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            basicLink.invertDirection();
            return super.addCell(object, object2, n, object4, object3);
        }
        if (object3 instanceof ExplicitOutputPort && object4 instanceof ExplicitInputPort && object instanceof ExplicitLink) {
            return super.addCell(object, object2, n, object3, object4);
        }
        if (object4 instanceof ExplicitOutputPort && object3 instanceof ExplicitInputPort && object instanceof ExplicitLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            basicLink.invertDirection();
            return super.addCell(object, object2, n, object4, object3);
        }
        if (object3 instanceof ImplicitOutputPort && object4 instanceof ImplicitInputPort && object instanceof ImplicitLink) {
            return super.addCell(object, object2, n, object3, object4);
        }
        if (object4 instanceof ImplicitOutputPort && object3 instanceof ImplicitInputPort && object instanceof ImplicitLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            basicLink.invertDirection();
            return super.addCell(object, object2, n, object4, object3);
        }
        if (object3 instanceof ImplicitInputPort && object4 instanceof ImplicitInputPort && object instanceof ImplicitLink) {
            return super.addCell(object, object2, n, object3, object4);
        }
        if (object4 instanceof ImplicitOutputPort && object3 instanceof ImplicitOutputPort && object instanceof ImplicitLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            basicLink.invertDirection();
            return super.addCell(object, object2, n, object4, object3);
        }
        if (object3 instanceof ExplicitLink && object4 instanceof ExplicitInputPort && object instanceof ExplicitLink) {
            SplitBlock splitBlock = this.addSplitEdge(((BasicLink)((Object)object)).getGeometry().getSourcePoint(), (BasicLink)((Object)object3));
            return this.addCell(object, object2, n, (Object)splitBlock.getOut2(), object4);
        }
        if (object4 instanceof ExplicitLink && object3 instanceof ExplicitInputPort && object instanceof ExplicitLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            SplitBlock splitBlock = this.addSplitEdge(basicLink.getGeometry().getTargetPoint(), (BasicLink)((Object)object4));
            basicLink.invertDirection();
            return this.addCell(object, object2, n, (Object)splitBlock.getOut2(), object3);
        }
        if (object3 instanceof ImplicitLink && object4 instanceof ImplicitInputPort && object instanceof ImplicitLink) {
            SplitBlock splitBlock = this.addSplitEdge(((BasicLink)((Object)object)).getGeometry().getSourcePoint(), (BasicLink)((Object)object3));
            return this.addCell(object, object2, n, (Object)splitBlock.getOut2(), object4);
        }
        if (object4 instanceof ImplicitLink && object3 instanceof ImplicitInputPort && object instanceof ImplicitLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            SplitBlock splitBlock = this.addSplitEdge(basicLink.getGeometry().getTargetPoint(), (BasicLink)((Object)object4));
            basicLink.invertDirection();
            return this.addCell(object, object2, n, (Object)splitBlock.getOut2(), object3);
        }
        if (object3 instanceof ImplicitLink && object4 instanceof ImplicitOutputPort && object instanceof ImplicitLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            SplitBlock splitBlock = this.addSplitEdge(basicLink.getGeometry().getTargetPoint(), (BasicLink)((Object)object3));
            return this.addCell(object, object2, n, (Object)splitBlock.getOut2(), object3);
        }
        if (object4 instanceof ImplicitLink && object3 instanceof ImplicitOutputPort && object instanceof ImplicitLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            SplitBlock splitBlock = this.addSplitEdge(basicLink.getGeometry().getTargetPoint(), (ImplicitLink)((Object)object4));
            return this.addCell(object, object2, n, (Object)splitBlock.getOut2(), object3);
        }
        if (object3 instanceof CommandControlLink && object4 instanceof ControlPort && object instanceof CommandControlLink) {
            SplitBlock splitBlock = this.addSplitEdge(((BasicLink)((Object)object)).getGeometry().getSourcePoint(), (BasicLink)((Object)object3));
            return this.addCell(object, object2, n, (Object)splitBlock.getOut2(), object4);
        }
        if (object4 instanceof CommandControlLink && object3 instanceof ControlPort && object instanceof CommandControlLink) {
            BasicLink basicLink = (BasicLink)((Object)object);
            SplitBlock splitBlock = this.addSplitEdge(basicLink.getGeometry().getTargetPoint(), (BasicLink)((Object)object4));
            basicLink.invertDirection();
            return this.addCell(object, object2, n, (Object)splitBlock.getOut2(), object3);
        }
        if (object instanceof BasicLink && object3 != null && object4 != null) {
            LOG.severe("Unable to add a typed link");
            return null;
        }
        LOG.severe("Adding an untyped edge");
        return super.addCell(object, object2, n, object3, object4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitBlock addSplitEdge(mxPoint mxPoint2, BasicLink basicLink) {
        SplitBlock splitBlock;
        BasicPort basicPort = (BasicPort)basicLink.getSource();
        BasicPort basicPort2 = (BasicPort)basicLink.getTarget();
        BlockInterFunction blockInterFunction = basicLink instanceof CommandControlLink ? BlockInterFunction.CLKSPLIT_f : (basicLink instanceof ImplicitLink ? BlockInterFunction.IMPSPLIT_f : BlockInterFunction.SPLIT_f);
        try {
            splitBlock = (SplitBlock)XcosCellFactory.createBlock(blockInterFunction);
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            throw new RuntimeException(interpreterException);
        }
        mxGeometry mxGeometry2 = splitBlock.getGeometry();
        double d = this.snap(mxPoint2.getX()) - 3.5;
        double d2 = this.snap(mxPoint2.getY()) - 3.5;
        mxGeometry2.setX(d);
        mxGeometry2.setY(d2);
        splitBlock.setGeometry(mxGeometry2);
        this.getModel().beginUpdate();
        try {
            mxGeometry mxGeometry3 = basicLink.getParent().getGeometry();
            if (mxGeometry3 == null) {
                mxGeometry3 = new mxPoint();
            }
            this.addCell(splitBlock);
            mxPoint mxPoint3 = new mxPoint(mxPoint2.getX() - mxGeometry3.getX(), mxPoint2.getY() - mxGeometry3.getY());
            int n = basicLink.findNearestSegment(mxPoint3);
            List<mxPoint> list = basicLink.getPoints(n, true);
            List<mxPoint> list2 = basicLink.getPoints(n, false);
            if (list2.size() > 0) {
                mxPoint mxPoint4 = list2.get(0);
                double d3 = mxPoint4.getX() - mxPoint3.getX();
                double d4 = mxPoint4.getY() - mxPoint3.getY();
                if (!this.getAsComponent().isSignificant(d3, d4)) {
                    list2.remove(0);
                }
            }
            this.getModel().remove((Object)basicLink);
            this.connect(basicPort, splitBlock.getIn(), list, (mxPoint)mxGeometry3);
            this.connect(splitBlock.getOut1(), basicPort2, list2, (mxPoint)mxGeometry3);
            this.refresh();
        }
        finally {
            this.getModel().endUpdate();
        }
        return splitBlock;
    }

    public void connect(BasicPort basicPort, BasicPort basicPort2, List<mxPoint> list, mxPoint mxPoint2) {
        Object object = this.createEdge(null, null, null, (Object)basicPort, (Object)basicPort2, null);
        this.addCell(object, null, null, (Object)basicPort, (Object)basicPort2);
        mxGeometry mxGeometry2 = this.getModel().getGeometry(object);
        if (this.getModel().getParent(object) instanceof BasicBlock) {
            mxPoint2.setX(mxPoint2.getX() + mxGeometry2.getX());
            mxPoint2.setY(mxPoint2.getY() + mxGeometry2.getY());
        }
        mxGeometry2.setPoints(list);
        this.getModel().setGeometry(object, mxGeometry2);
        mxGeometry2 = (mxGeometry)this.getModel().getGeometry(object).clone();
        double d = mxPoint2.getX();
        double d2 = mxPoint2.getY();
        mxGeometry2.translate(d, d2);
        this.getModel().setGeometry(object, mxGeometry2);
    }

    public final void initComponent() {
        this.getAsComponent().setToolTips(true);
        this.getAsComponent().setEnterStopsCellEditing(false);
        this.getAsComponent().setTolerance(1);
        this.getAsComponent().getViewport().setOpaque(false);
        this.getAsComponent().setBackground(XcosOptions.getEdition().getGraphBackground());
        boolean bl = XcosOptions.getEdition().isGraphGridEnable();
        this.setGridVisible(bl);
        if (bl) {
            this.setGridSize(XcosOptions.getEdition().getGraphGrid());
        }
    }

    private void setMultiplicities() {
        ArrayList<PortCheck> arrayList = new ArrayList<PortCheck>();
        arrayList.add(new PortCheck(ExplicitInputPort.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = -4987163442006736665L;
            {
                this.add(ExplicitOutputPort.class);
                this.add(ExplicitLink.class);
            }
        }), XcosMessages.LINK_ERROR_EXPLICIT_IN));
        arrayList.add(new PortCheck(ImplicitInputPort.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = 886376532181210926L;
            {
                this.add(ImplicitOutputPort.class);
                this.add(ImplicitInputPort.class);
                this.add(ImplicitLink.class);
            }
        }), XcosMessages.LINK_ERROR_IMPLICIT_IN));
        arrayList.add(new PortCheck(ExplicitOutputPort.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = 4594127972486054821L;
            {
                this.add(ExplicitInputPort.class);
            }
        }), XcosMessages.LINK_ERROR_EXPLICIT_OUT));
        arrayList.add(new PortCheck(ImplicitOutputPort.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = -3719677806532507973L;
            {
                this.add(ImplicitInputPort.class);
                this.add(ImplicitOutputPort.class);
                this.add(ImplicitLink.class);
            }
        }), XcosMessages.LINK_ERROR_IMPLICIT_OUT));
        arrayList.add(new PortCheck(ControlPort.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = 2941077191386058497L;
            {
                this.add(CommandPort.class);
                this.add(CommandControlLink.class);
            }
        }), XcosMessages.LINK_ERROR_EVENT_IN));
        arrayList.add(new PortCheck(CommandPort.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = -3470370027962480362L;
            {
                this.add(ControlPort.class);
            }
        }), XcosMessages.LINK_ERROR_EVENT_OUT));
        arrayList.add(new PortCheck(ExplicitLink.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = 7423543162930147373L;
            {
                this.add(ExplicitInputPort.class);
            }
        }), XcosMessages.LINK_ERROR_EVENT_OUT));
        arrayList.add(new PortCheck(ImplicitLink.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = 7775100011122283282L;
            {
                this.add(ImplicitInputPort.class);
                this.add(ImplicitOutputPort.class);
            }
        }), XcosMessages.LINK_ERROR_EVENT_OUT));
        arrayList.add(new PortCheck(CommandControlLink.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = 3260421433507192386L;
            {
                this.add(ControlPort.class);
            }
        }), XcosMessages.LINK_ERROR_EVENT_OUT));
        arrayList.add(new PortCheck(BasicPort.class, Collections.unmodifiableList(new ArrayList<Class<? extends mxCell>>(){
            private static final long serialVersionUID = 6376349598052836660L;
            {
                this.add(BasicPort.class);
            }
        }), XcosMessages.LINK_ERROR_ALREADY_CONNECTED));
        this.setMultiplicities(arrayList.toArray(new mxMultiplicity[arrayList.size()]));
    }

    public void installListeners() {
        this.getModel().removeListener((mxEventSource.mxIEventListener)SavedStatusTracker.getInstance(this));
        this.removeListener(UpdateSuperblockPortsTracker.getInstance());
        this.removeListener(RefreshBlockTracker.getInstance());
        this.removeListener(RepositionTracker.getInstance());
        this.addListener("cellsResized", RepositionTracker.getInstance());
        this.addListener("cellsMoved", RepositionTracker.getInstance());
        this.addListener("updateBlock", RefreshBlockTracker.getInstance());
        if (this.getKind() == Kind.BLOCK) {
            this.addListener("updateBlock", UpdateSuperblockPortsTracker.getInstance());
            this.addListener("addCells", UpdateSuperblockPortsTracker.getInstance());
            this.addListener("removeCells", UpdateSuperblockPortsTracker.getInstance());
            this.addListener("moveCells", UpdateSuperblockPortsTracker.getInstance());
        }
        this.getModel().addListener("change", (mxEventSource.mxIEventListener)SavedStatusTracker.getInstance(this));
    }

    public void translateCell(Object object, double d, double d2) {
        if (object instanceof SplitBlock) {
            mxGeometry mxGeometry2 = this.model.getGeometry(object);
            double d3 = this.snap(mxGeometry2.getX() + d) - 3.5;
            double d4 = this.snap(mxGeometry2.getY() + d2) - 3.5;
            d = d3 - mxGeometry2.getX();
            d2 = d4 - mxGeometry2.getY();
        }
        super.translateCell(object, d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] removeCells(Object[] objectArray, boolean bl) {
        List list;
        mxICell mxICell2;
        Object object;
        if (objectArray == null || objectArray.length == 0) {
            return super.removeCells(objectArray, bl);
        }
        Object[] objectArray2 = bl ? this.addAllEdges(objectArray) : objectArray;
        LinkedList<Object> linkedList = new LinkedList<Object>(Arrays.asList(objectArray2));
        HashSet<Object> hashSet = new HashSet<Object>(linkedList);
        ArrayList<BasicPort[]> arrayList = new ArrayList<BasicPort[]>();
        ArrayList<List<mxPoint>> arrayList2 = new ArrayList<List<mxPoint>>();
        while (linkedList.size() > 0) {
            BasicPort[] basicPortArray;
            SplitBlock splitBlock;
            object = linkedList.remove();
            if (object instanceof BasicLink) {
                if (((BasicLink)((Object)object)).getSource() == null || ((BasicLink)((Object)object)).getTarget() == null) continue;
                this.addTerminalParent(((BasicLink)((Object)object)).getSource(), hashSet, linkedList);
                this.addTerminalParent(((BasicLink)((Object)object)).getTarget(), hashSet, linkedList);
                continue;
            }
            if (!(object instanceof SplitBlock) || (splitBlock = (SplitBlock)object).getIn().getEdgeCount() == 0 || splitBlock.getOut1().getEdgeCount() == 0 || splitBlock.getOut2().getEdgeCount() == 0) continue;
            mxICell2 = splitBlock.getIn().getEdgeAt(0);
            list = splitBlock.getOut1().getEdgeAt(0);
            mxICell mxICell3 = splitBlock.getOut2().getEdgeAt(0);
            boolean bl2 = hashSet.contains(mxICell2);
            boolean bl3 = hashSet.contains(list);
            boolean bl4 = hashSet.contains(mxICell3);
            if (mxICell2 instanceof ExplicitLink && bl2) {
                if (hashSet.add(list)) {
                    linkedList.add(list);
                }
                if (hashSet.add(mxICell3)) {
                    linkedList.add(mxICell3);
                }
            }
            List<mxPoint> list2 = null;
            if (!bl2 && !bl3 && bl4) {
                basicPortArray = this.findTerminals(mxICell2, (mxICell)list, hashSet);
                list2 = this.getDirectPoints(splitBlock, mxICell2, (mxICell)list);
            } else if (!bl2 && bl3 && !bl4) {
                basicPortArray = this.findTerminals(mxICell2, mxICell3, hashSet);
                list2 = this.getDirectPoints(splitBlock, mxICell2, mxICell3);
            } else if (bl2 && !bl3 && !bl4) {
                if (list instanceof ExplicitLink || mxICell3 instanceof ExplicitLink) {
                    LOG.severe("Reconnection failed for explicit links");
                    basicPortArray = null;
                } else {
                    basicPortArray = this.findTerminals((mxICell)list, mxICell3, hashSet);
                    list2 = this.getDirectPoints(splitBlock, (mxICell)list, mxICell3);
                }
            } else {
                basicPortArray = null;
            }
            if (basicPortArray == null) continue;
            arrayList.add(basicPortArray);
            arrayList2.add(list2);
        }
        this.getModel().beginUpdate();
        try {
            object = super.removeCells(hashSet.toArray(), bl);
            for (int i = 0; i < arrayList.size(); ++i) {
                mxICell2 = (mxICell)arrayList.get(i);
                list = (List)arrayList2.get(i);
                if (hashSet.contains(mxICell2[0].getParent()) || hashSet.contains(mxICell2[1].getParent())) continue;
                this.connect((BasicPort)mxICell2[0], (BasicPort)mxICell2[1], list, new mxPoint());
            }
        }
        finally {
            this.getModel().endUpdate();
        }
        return object;
    }

    private void addTerminalParent(mxICell mxICell2, Collection<Object> collection, Collection<Object> collection2) {
        assert (mxICell2 == null || mxICell2 instanceof BasicPort);
        assert (collection != null);
        assert (collection2 != null);
        mxICell mxICell3 = null;
        mxICell3 = mxICell2 != null ? mxICell2.getParent() : null;
        if (mxICell3 instanceof SplitBlock && collection.add(mxICell3)) {
            collection2.add(mxICell3);
        }
    }

    private BasicPort[] findTerminals(mxICell mxICell2, mxICell mxICell3, Set<Object> set) {
        BasicPort basicPort = (BasicPort)mxICell2.getTerminal(true);
        BasicPort basicPort2 = (BasicPort)mxICell3.getTerminal(false);
        if (mxICell2 instanceof ImplicitLink) {
            if (set.contains(basicPort.getParent())) {
                basicPort = (BasicPort)mxICell2.getTerminal(false);
            }
            if (set.contains(basicPort2.getParent())) {
                basicPort2 = (BasicPort)mxICell3.getTerminal(true);
            }
        }
        return new BasicPort[]{basicPort, basicPort2};
    }

    private List<mxPoint> getDirectPoints(SplitBlock splitBlock, mxICell mxICell2, mxICell mxICell3) {
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
        if (mxICell2.getGeometry().getPoints() != null) {
            arrayList.addAll(mxICell2.getGeometry().getPoints());
        }
        arrayList.add(new mxPoint(this.snap(splitBlock.getGeometry().getCenterX()), this.snap(splitBlock.getGeometry().getCenterY())));
        if (mxICell3.getGeometry().getPoints() != null) {
            arrayList.addAll(mxICell3.getGeometry().getPoints());
        }
        return arrayList;
    }

    public boolean isCellFoldable(Object object, boolean bl) {
        return false;
    }

    public boolean isLabelMovable(Object object) {
        return !(object instanceof BasicBlock);
    }

    public boolean isCellSelectable(Object object) {
        if (object instanceof BasicPort) {
            return false;
        }
        return super.isCellSelectable(object);
    }

    public boolean isCellMovable(Object object) {
        Object[] objectArray;
        if (object instanceof BasicPort) {
            return false;
        }
        boolean bl = false;
        for (Object object2 : objectArray = this.getSelectionCells()) {
            if (object2 instanceof BasicLink) continue;
            bl = true;
            break;
        }
        return bl && super.isCellMovable(object);
    }

    public boolean isCellResizable(Object object) {
        if (object instanceof SplitBlock) {
            return false;
        }
        return object instanceof BasicBlock && super.isCellResizable(object);
    }

    public boolean isCellDeletable(Object object) {
        boolean bl = object instanceof BasicBlock && ((BasicBlock)object).isLocked();
        boolean bl2 = object.getClass().equals(mxCell.class);
        if (bl) {
            return false;
        }
        if (bl2) {
            return true;
        }
        return super.isCellDeletable(object);
    }

    public boolean isCellEditable(Object object) {
        return object instanceof TextBlock && super.isCellDeletable(object);
    }

    public mxCell getOrCreateCellIdentifier(mxCell mxCell2) {
        mxCell mxCell3;
        String string;
        if (mxCell2.getId().endsWith(HASH_IDENTIFIER)) {
            return mxCell2;
        }
        mxGraphModel mxGraphModel2 = (mxGraphModel)this.getModel();
        if (mxGraphModel2.getCell(string = mxCell2.getId() + HASH_IDENTIFIER) == null) {
            mxCell3 = this.createCellIdentifier(mxCell2);
            mxGraphModel2.add((Object)mxCell2, (Object)mxCell3, mxCell2.getChildCount());
        } else {
            mxCell3 = (mxCell)mxGraphModel2.getCell(string);
        }
        return mxCell3;
    }

    public mxCell getCellIdentifier(mxCell mxCell2) {
        mxGraphModel mxGraphModel2 = (mxGraphModel)this.getModel();
        String string = mxCell2.getId() + HASH_IDENTIFIER;
        return (mxCell)mxGraphModel2.getCell(string);
    }

    public mxCell createCellIdentifier(mxCell mxCell2) {
        mxGeometry mxGeometry2;
        String string = mxCell2.getId() + HASH_IDENTIFIER;
        JavaController javaController = new JavaController();
        long l = javaController.createObject(Kind.ANNOTATION);
        if (mxCell2.isVertex()) {
            mxGeometry2 = new mxGeometry(mxCell2.getGeometry().getWidth() * 0.5, mxCell2.getGeometry().getHeight() * 1.1, 0.0, 0.0);
        } else {
            mxPoint mxPoint2 = mxCell2.getGeometry().getSourcePoint();
            mxPoint mxPoint3 = mxCell2.getGeometry().getTargetPoint();
            mxGeometry2 = new mxGeometry(mxPoint2.getX(), mxPoint2.getY(), 0.0, 0.0);
            mxGeometry2.translate((mxPoint3.getX() - mxPoint2.getX()) / 2.0, (mxPoint3.getY() - mxPoint2.getY()) / 2.0);
        }
        XcosCell xcosCell = new XcosCell(new JavaController(), l, Kind.ANNOTATION, null, mxGeometry2, "noLabel=0;opacity=0;", string);
        xcosCell.setVertex(true);
        xcosCell.setConnectable(false);
        return xcosCell;
    }

    public String convertValueToString(Object object) {
        String string = null;
        if (object != null) {
            JavaController javaController = new JavaController();
            Map map = this.getCellStyle(object);
            String string2 = (String)map.get("displayedLabel");
            if (string2 != null) {
                if (object instanceof BasicBlock) {
                    BasicBlock basicBlock = (BasicBlock)object;
                    VectorOfDouble vectorOfDouble = new VectorOfDouble();
                    javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.EXPRS, vectorOfDouble);
                    try {
                        string = new ScilabTypeCoder().format(string2, vectorOfDouble);
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        LOG.severe(illegalFormatException.toString());
                        string = string2;
                    }
                } else {
                    string = string2;
                }
            } else {
                String string3 = super.convertValueToString(object);
                if (string3.isEmpty() && object instanceof BasicBlock) {
                    BasicBlock basicBlock = (BasicBlock)object;
                    String[] stringArray = new String[1];
                    javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.INTERFACE_FUNCTION, stringArray);
                    string = stringArray[0];
                } else {
                    string = string3;
                }
            }
        }
        return string;
    }

    public boolean isAutoSizeCell(Object object) {
        boolean bl = super.isAutoSizeCell(object);
        if (object instanceof AfficheBlock) {
            bl |= true;
        }
        if (object instanceof TextBlock) {
            bl &= false;
        }
        return bl;
    }

    public boolean isExtendParent(Object object) {
        BasicPort basicPort;
        boolean bl = object instanceof BasicPort ? (basicPort = (BasicPort)((Object)object)).getOrientation() != Orientation.NORTH && basicPort.getOrientation() != Orientation.SOUTH && super.isExtendParent((Object)basicPort) : super.isExtendParent(object);
        return bl;
    }

    public long getUID() {
        return ((XcosCell)((Object)this.getDefaultParent())).getUID();
    }

    public Kind getKind() {
        return ((XcosCell)((Object)this.getDefaultParent())).getKind();
    }

    public void setGridVisible(boolean bl) {
        this.setGridEnabled(bl);
        this.getAsComponent().setGridVisible(bl);
        this.getAsComponent().repaint();
    }

    public boolean saveDiagram() {
        return this.saveDiagramAs(this.getSavedFile());
    }

    public boolean saveDiagramAs(File file) {
        XcosFileType xcosFileType;
        Object object;
        boolean bl = false;
        File file2 = file;
        Object object2 = XcosOptions.getPreferences().getFileFormat();
        this.info(XcosMessages.SAVING_DIAGRAM);
        if (file == null) {
            Object object3;
            String string;
            object = SaveAsAction.createFileChooser();
            SaveAsAction.configureFileFilters((JFileChooser)object);
            ConfigurationManager.configureCurrentDirectory((JFileChooser)object);
            if (this.getSavedFile() != null) {
                string = this.getSavedFile().getName();
                string = string.substring(0, string.lastIndexOf(46));
                object.setSelectedFile(new File(string));
            } else {
                string = this.getTitle();
                if (string != null) {
                    object3 = "<>:\"/\\|?*".toCharArray();
                    String string2 = string;
                    for (char c : object3) {
                        string2 = string2.replace(c, '-');
                    }
                    object.setSelectedFile(new File(string2));
                }
            }
            int n = object.showSaveDialog((Component)this.getAsComponent());
            if (n != 0) {
                this.info("");
                return bl;
            }
            object3 = (Object)XcosFileType.findFileType(object.getFileFilter());
            if (XcosFileType.getAvailableSaveFormats().contains(object3)) {
                object2 = object3;
            }
            file2 = object.getSelectedFile();
        }
        if ((xcosFileType = XcosFileType.findFileType((String)(object = file2.getName()))) == null) {
            file2 = new File(file2.getParent(), (String)object + object2.getDottedExtension());
            xcosFileType = object2;
        }
        if (XcosFileType.getAvailableSaveFormats().contains((Object)xcosFileType)) {
            object2 = xcosFileType;
        } else {
            file2 = new File(file2.getParent(), (String)object + object2.getDottedExtension());
        }
        if (file2.exists() && !file2.equals(this.getSavedFile())) {
            boolean bl2;
            boolean bl3 = bl2 = ScilabModalDialog.show((SimpleTab)XcosTab.get(this), (String)XcosMessages.OVERWRITE_EXISTING_FILE, (String)XcosMessages.XCOS, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) == ScilabModalDialog.AnswerOption.YES_OPTION;
            if (!bl2) {
                this.info("");
                return false;
            }
        }
        try {
            object2.save(file2.getCanonicalPath(), this.getRootDiagram());
            this.setSavedFile(file2);
            this.setTitle(file2.getName().substring(0, file2.getName().lastIndexOf(46)));
            ConfigurationManager.getInstance().addToRecentFiles(file2);
            ScicosObjectOwner scicosObjectOwner = Xcos.findRoot(this);
            Xcos.getInstance().setModified(scicosObjectOwner, false);
            Xcos.getInstance().openedDiagrams(scicosObjectOwner).stream().forEach(xcosDiagram -> xcosDiagram.updateTabTitle());
            bl = true;
        }
        catch (Exception exception) {
            LOG.severe(exception.toString());
            XcosDialogs.couldNotSaveFile(this);
        }
        this.updateTabTitle();
        this.info("");
        return bl;
    }

    public void postLoad(File file) {
        String string = file.getName();
        if (XcosFileType.getAvailableSaveFormats().contains((Object)XcosFileType.findFileType(file))) {
            this.setSavedFile(file);
        }
        this.setTitle(string.substring(0, string.lastIndexOf(46)));
        this.setModified(false);
        this.updateTabTitle();
        this.fireEvent(new mxEventObject(mxEvent.ROOT));
        this.info("");
    }

    public void setSavedFile(File file) {
        super.setSavedFile(file);
        if (file != null) {
            JavaController javaController = new JavaController();
            javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.PATH, file.getAbsolutePath());
        }
    }

    public String getTitle() {
        JavaController javaController = new JavaController();
        String[] stringArray = new String[]{""};
        if (this.getKind() == Kind.DIAGRAM) {
            javaController.getObjectProperty(this.getUID(), this.getKind(), ObjectProperties.TITLE, stringArray);
        } else {
            javaController.getObjectProperty(this.getUID(), this.getKind(), ObjectProperties.DESCRIPTION, stringArray);
        }
        if (stringArray[0].isEmpty()) {
            return super.getTitle();
        }
        return stringArray[0];
    }

    public void setTitle(String string) {
        super.setTitle(string);
        JavaController javaController = new JavaController();
        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.TITLE, string);
    }

    public void updateTabTitle() {
        String string;
        Object object;
        String string2 = Xcos.getInstance().isModified(Xcos.findRoot(this)) ? "*" : "";
        String string3 = this.getTitle();
        CharSequence charSequence = "";
        if (this.getKind() == Kind.DIAGRAM && (object = this.getSavedFile()) != null) {
            try {
                string = ((File)object).getCanonicalPath();
                charSequence = new StringBuilder().append(" (").append(string).append(')');
            }
            catch (IOException iOException) {
                LOG.warning(iOException.toString());
            }
        }
        object = Xcos.TRADENAME;
        string = string2 + string3 + charSequence + " - " + (String)object;
        SwingScilabDockablePanel swingScilabDockablePanel = ScilabTabFactory.getInstance().getFromCache(this.getGraphTab());
        if (swingScilabDockablePanel != null) {
            swingScilabDockablePanel.setName(string);
        }
    }

    public void transformAndLoadFile(final JavaController javaController, final String string) {
        XcosFileType xcosFileType;
        File file;
        if (string != null) {
            file = new File(string);
            xcosFileType = XcosFileType.findFileType(file);
        } else {
            file = null;
            xcosFileType = null;
        }
        new SwingWorker<XcosDiagram, ActionEvent>(){
            int counter = 0;
            final Timer t = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    counter = (counter + 1) % ("...".length() + 1);
                    String string = XcosMessages.LOADING_DIAGRAM + "...".substring(0, counter);
                    XcosDiagram.this.info(string);
                }
            });

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected XcosDiagram doInBackground() {
                this.t.start();
                Xcos xcos = Xcos.getInstance();
                XcosDiagram xcosDiagram = XcosDiagram.this;
                xcosDiagram.setReadOnly(true);
                Xcos xcos2 = xcos;
                synchronized (xcos2) {
                    try {
                        if (file != null && xcosFileType != null) {
                            xcosFileType.load(string, XcosDiagram.this);
                        } else {
                            XcosCellFactory.insertChildren(javaController, XcosDiagram.this);
                        }
                        xcos.setLastError("");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Throwable throwable = exception;
                        while (throwable instanceof RuntimeException) {
                            throwable = throwable.getCause();
                        }
                        xcos.setLastError(throwable.getMessage());
                    }
                    xcos.notify();
                }
                return xcosDiagram;
            }

            @Override
            protected void done() {
                this.t.stop();
                XcosDiagram.this.setReadOnly(false);
                XcosDiagram.this.getUndoManager().clear();
                XcosDiagram.this.refresh();
                if (file != null && xcosFileType != null) {
                    XcosDiagram.this.postLoad(file);
                }
                XcosDiagram.this.info("");
            }
        }.execute();
    }

    public XcosDiagram getRootDiagram() {
        if (this.getKind() == Kind.DIAGRAM) {
            return this;
        }
        JavaController javaController = new JavaController();
        ScicosObjectOwner scicosObjectOwner = Xcos.findRoot(javaController, this);
        Collection<XcosDiagram> collection = Xcos.getInstance().getDiagrams(scicosObjectOwner);
        Optional<XcosDiagram> optional = collection.stream().filter(xcosDiagram -> xcosDiagram.getUID() == scicosObjectOwner.getUID()).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        String[] stringArray = new String[]{""};
        javaController.getObjectProperty(scicosObjectOwner.getUID(), Kind.DIAGRAM, ObjectProperties.UID, stringArray);
        return new XcosDiagram(javaController, scicosObjectOwner.getUID(), Kind.DIAGRAM, stringArray[0]);
    }

    public long getRootDiagramUID(JavaController javaController) {
        if (this.getKind() == Kind.DIAGRAM) {
            return this.getUID();
        }
        long[] lArray = new long[1];
        javaController.getObjectProperty(this.getUID(), this.getKind(), ObjectProperties.PARENT_DIAGRAM, lArray);
        return lArray[0];
    }

    public String getToolTipForCell(Object object) {
        if (object instanceof BasicBlock) {
            return this.getToolTipForCell((BasicBlock)object);
        }
        if (object instanceof BasicPort) {
            return this.getToolTipForCell((BasicPort)((Object)object));
        }
        if (object instanceof BasicLink) {
            return this.getToolTipForCell((BasicLink)((Object)object));
        }
        return "";
    }

    private String getToolTipForCell(BasicBlock basicBlock) {
        JavaController javaController = new JavaController();
        String[] stringArray = new String[]{""};
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        VectorOfInt vectorOfInt = new VectorOfInt();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.INTERFACE_FUNCTION, stringArray);
        stringBuilder.append(XcosMessages.TOOLTIP_BLOCK).append("<code>").append(stringArray[0]).append("</code>").append("<br>");
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.SIM_FUNCTION_NAME, stringArray);
        stringBuilder.append(XcosMessages.TOOLTIP_BLOCK_SIMULATION).append("<code>").append(stringArray[0]).append("</code>").append("<br>");
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.UID, stringArray);
        stringBuilder.append(XcosMessages.TOOLTIP_BLOCK_UID).append("<code>").append(stringArray[0]).append("</code>").append("<br>");
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.STYLE, stringArray);
        stringBuilder.append(XcosMessages.TOOLTIP_BLOCK_STYLE).append("<code>");
        this.appendReduced(stringBuilder, stringArray[0]).append("</code>").append("<br>");
        stringBuilder.append("<br>");
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.RPAR, vectorOfDouble);
        stringBuilder.append(XcosMessages.TOOLTIP_BLOCK_RPAR).append("<code>");
        this.appendReduced(stringBuilder, ScilabTypeCoder.toString(vectorOfDouble)).append("</code>").append("<br>");
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.IPAR, vectorOfInt);
        stringBuilder.append(XcosMessages.TOOLTIP_BLOCK_IPAR).append("<code>");
        this.appendReduced(stringBuilder, ScilabTypeCoder.toString(vectorOfInt)).append("</code>").append("<br>");
        javaController.getObjectProperty(basicBlock.getUID(), basicBlock.getKind(), ObjectProperties.OPAR, vectorOfDouble);
        stringBuilder.append(XcosMessages.TOOLTIP_BLOCK_OPAR).append("<code>");
        this.appendReduced(stringBuilder, ScilabTypeCoder.toString(vectorOfDouble)).append("</code>").append("<br>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private String getToolTipForCell(BasicPort basicPort) {
        JavaController javaController = new JavaController();
        boolean[] blArray = new boolean[]{false};
        String[] stringArray = new String[]{""};
        VectorOfInt vectorOfInt = new VectorOfInt();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        javaController.getObjectProperty(basicPort.getUID(), basicPort.getKind(), ObjectProperties.DATATYPE, vectorOfInt);
        stringBuilder.append(XcosMessages.TOOLTIP_PORT_DATATYPE).append("<code>");
        this.formatDatatype(stringBuilder, vectorOfInt).append("</code>").append("<br>");
        javaController.getObjectProperty(basicPort.getUID(), basicPort.getKind(), ObjectProperties.IMPLICIT, blArray);
        stringBuilder.append(XcosMessages.TOOLTIP_PORT_IMPLICIT).append("<code>").append(blArray[0]).append("</code>").append("<br>");
        javaController.getObjectProperty(basicPort.getUID(), basicPort.getKind(), ObjectProperties.STYLE, stringArray);
        stringBuilder.append(XcosMessages.TOOLTIP_PORT_STYLE).append("<code>");
        this.appendReduced(stringBuilder, stringArray[0]).append("</code>").append("<br>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private String getToolTipForCell(BasicLink basicLink) {
        JavaController javaController = new JavaController();
        long[] lArray = new long[]{0L};
        boolean[] blArray = new boolean[]{false};
        String[] stringArray = new String[]{""};
        VectorOfInt vectorOfInt = new VectorOfInt();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        javaController.getObjectProperty(basicLink.getUID(), basicLink.getKind(), ObjectProperties.SOURCE_PORT, lArray);
        if (lArray[0] != 0L) {
            javaController.getObjectProperty(lArray[0], Kind.PORT, ObjectProperties.DATATYPE, vectorOfInt);
            stringBuilder.append(XcosMessages.TOOLTIP_LINK_SRC_DATATYPE).append("<code>");
            this.formatDatatype(stringBuilder, vectorOfInt).append("</code>").append("<br>");
        }
        javaController.getObjectProperty(basicLink.getUID(), basicLink.getKind(), ObjectProperties.DESTINATION_PORT, lArray);
        if (lArray[0] != 0L) {
            javaController.getObjectProperty(lArray[0], Kind.PORT, ObjectProperties.DATATYPE, vectorOfInt);
            stringBuilder.append(XcosMessages.TOOLTIP_LINK_TRG_DATATYPE).append("<code>");
            this.formatDatatype(stringBuilder, vectorOfInt).append("</code>").append("<br>");
        }
        javaController.getObjectProperty(basicLink.getUID(), basicLink.getKind(), ObjectProperties.LABEL, stringArray);
        stringBuilder.append(XcosMessages.TOOLTIP_LINK_LABEL).append("<code>").append(stringArray[0]).append("</code>").append("<br>");
        javaController.getObjectProperty(basicLink.getUID(), basicLink.getKind(), ObjectProperties.STYLE, stringArray);
        stringBuilder.append(XcosMessages.TOOLTIP_LINK_STYLE).append("<code>");
        this.appendReduced(stringBuilder, stringArray[0]).append("</code>").append("<br>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private StringBuilder appendReduced(StringBuilder stringBuilder, String string) {
        if (string.length() > 37) {
            stringBuilder.append(string.substring(0, 37));
            stringBuilder.append("...");
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    private StringBuilder formatDatatype(StringBuilder stringBuilder, VectorOfInt vectorOfInt) {
        if (vectorOfInt.size() != 3) {
            stringBuilder.append(ScilabTypeCoder.toString(vectorOfInt));
        } else {
            int n = vectorOfInt.get(0);
            int n2 = vectorOfInt.get(1);
            int n3 = vectorOfInt.get(2);
            String[] stringArray = new String[]{"real", "complex", "int32", "int16", "int8", "uint32", "uint16", "uint8"};
            String string = 0 <= n3 && n3 < stringArray.length ? stringArray[n3 - 1] : "auto";
            stringBuilder.append(String.format("%s [%d %d]", string, n, n2));
        }
        return stringBuilder;
    }

    public void info(String string) {
        XcosTab xcosTab = XcosTab.get(this);
        if (xcosTab != null && xcosTab.getInfoBar() != null) {
            xcosTab.getInfoBar().setText(string);
        }
    }

    public void error(String string) {
        JOptionPane.showMessageDialog((Component)this.getAsComponent(), string, XcosMessages.XCOS, 0);
    }

    public void warnCellByUID(String string, String string2) {
        Object object = ((mxGraphModel)this.getModel()).getCell(string);
        if (object == null) {
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            System.err.printf("%s at %s\n    %s: %s\n", "warnCell", this.getRootDiagram().getTitle(), string, string2);
            return;
        }
        if (XcosTab.get(this) == null) {
            XcosTab.restore(this);
        }
        if (string2.isEmpty()) {
            this.getAsComponent().clearCellOverlays(object);
        } else {
            this.getAsComponent().setCellWarning(object, string2, null, true);
        }
    }

    public File getSavedFile() {
        if (this.getKind() == Kind.DIAGRAM) {
            return super.getSavedFile();
        }
        return this.getRootDiagram().getSavedFile();
    }

    public String[] getContext() {
        ArrayList arrayList = new ArrayList();
        Stack<ScicosObjectOwner> stack = XcosDiagram.lookForHierarchy(new ScicosObjectOwner(this.getUID(), this.getKind()));
        JavaController javaController = new JavaController();
        VectorOfString vectorOfString = new VectorOfString();
        stack.stream().forEach(scicosObjectOwner -> {
            javaController.getObjectProperty(scicosObjectOwner.getUID(), scicosObjectOwner.getKind(), ObjectProperties.DIAGRAM_CONTEXT, vectorOfString);
            int n = vectorOfString.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(vectorOfString.get(i));
            }
            arrayList.add("");
        });
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> evaluateContext() {
        Map<String, String> map = Collections.emptyMap();
        ScilabDirectHandler scilabDirectHandler = ScilabDirectHandler.acquire();
        if (scilabDirectHandler == null) {
            return map;
        }
        try {
            scilabDirectHandler.writeContext(this.getContext());
            ScilabInterpreterManagement.synchronousScilabExec((String)"context = script2var(context, struct());");
            map = scilabDirectHandler.readContext();
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            this.info("Unable to evaluate the context");
            interpreterException.printStackTrace();
        }
        finally {
            scilabDirectHandler.release();
        }
        return map;
    }

    public boolean isValidDropTarget(Object object, Object[] objectArray) {
        return !(object instanceof BasicBlock) && !(object instanceof BasicBlock) && !(object instanceof BasicPort) && super.isValidDropTarget(object, objectArray);
    }

    protected mxGraphSelectionModel createSelectionModel() {
        return new mxGraphSelectionModel((mxGraph)this){

            public void setCell(Object object) {
                Object object2 = object instanceof BasicPort ? XcosDiagram.this.getModel().getParent(object) : object;
                super.setCell(object2);
            }
        };
    }

    public int countChildren() {
        return this.getModel().getChildCount(this.getDefaultParent());
    }

    public static final class UpdateSuperblockPortsTracker
    implements mxEventSource.mxIEventListener {
        private static UpdateSuperblockPortsTracker instance = new UpdateSuperblockPortsTracker();

        public static UpdateSuperblockPortsTracker getInstance() {
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Object object2, mxEventObject mxEventObject2) {
            Object object3;
            List<Object> list;
            XcosDiagram xcosDiagram = (XcosDiagram)((Object)object2);
            if (xcosDiagram.isReadonly()) {
                return;
            }
            if ("updateBlock".equals(mxEventObject2.getName())) {
                list = new ArrayList<Object[]>();
                object3 = mxEventObject2.getProperty("block");
                if (object3 instanceof ContextUpdate) {
                    list.add((Object[])object3);
                }
            } else {
                object3 = (Object[])mxEventObject2.getProperty(XcosDiagram.CELLS);
                list = Arrays.stream(object3).filter(object -> object instanceof ContextUpdate).collect(Collectors.toList());
            }
            if (list.isEmpty()) {
                return;
            }
            object3 = new JavaController();
            String[] stringArray = new String[]{""};
            ((Controller)object3).getObjectProperty(xcosDiagram.getUID(), xcosDiagram.getKind(), ObjectProperties.UID, stringArray);
            List<XcosDiagram> list2 = Xcos.getInstance().openedDiagrams(Xcos.findRoot((JavaController)object3, xcosDiagram));
            for (XcosDiagram xcosDiagram2 : list2) {
                XcosGraphModel xcosGraphModel = (XcosGraphModel)xcosDiagram2.getModel();
                Object object4 = xcosGraphModel.getCell(stringArray[0]);
                if (object4 == null) continue;
                SuperBlock superBlock = (SuperBlock)object4;
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                xcosDiagram.fillContext(hashMap, (JavaController)object3);
                xcosDiagram.getAsComponent().clearCellOverlays();
                String string = xcosDiagram.getAsComponent().validateGraph();
                if (string != null) {
                    return;
                }
                xcosGraphModel.beginUpdate();
                try {
                    UpdateSuperblockPortsTracker.syncPorts((JavaController)object3, superBlock, ObjectProperties.INPUTS, (List)hashMap.get(XcosDiagram.IN), xcosDiagram2);
                    UpdateSuperblockPortsTracker.syncPorts((JavaController)object3, superBlock, ObjectProperties.OUTPUTS, (List)hashMap.get(XcosDiagram.OUT), xcosDiagram2);
                    UpdateSuperblockPortsTracker.syncPorts((JavaController)object3, superBlock, ObjectProperties.EVENT_INPUTS, (List)hashMap.get(XcosDiagram.EIN), xcosDiagram2);
                    UpdateSuperblockPortsTracker.syncPorts((JavaController)object3, superBlock, ObjectProperties.EVENT_OUTPUTS, (List)hashMap.get(XcosDiagram.EOUT), xcosDiagram2);
                    break;
                }
                finally {
                    xcosGraphModel.endUpdate();
                }
            }
        }

        public static void syncPorts(JavaController javaController, SuperBlock superBlock, ObjectProperties objectProperties, List<ContextUpdate> list, XcosDiagram xcosDiagram) {
            block3: {
                int n;
                VectorOfScicosID vectorOfScicosID;
                block2: {
                    vectorOfScicosID = new VectorOfScicosID();
                    javaController.getObjectProperty(superBlock.getUID(), superBlock.getKind(), objectProperties, vectorOfScicosID);
                    n = list.size() - vectorOfScicosID.size();
                    if (n <= 0) break block2;
                    for (int i = 0; i < n; ++i) {
                        BasicPort basicPort = ContextUpdate.IOBlocks.createPort(javaController, list.get(vectorOfScicosID.size() + i));
                        xcosDiagram.addCell((Object)basicPort, superBlock);
                    }
                    break block3;
                }
                if (n >= 0) break block3;
                for (int i = 0; i < -n; ++i) {
                    String[] stringArray = new String[]{""};
                    javaController.getObjectProperty(vectorOfScicosID.get(list.size() + i), Kind.PORT, ObjectProperties.UID, stringArray);
                    xcosDiagram.removeCells(new Object[]{((XcosGraphModel)xcosDiagram.getModel()).getCell(stringArray[0])});
                }
            }
        }

        public static void updateContext(Map<Object, Object> map, List<XcosCell> list, JavaController javaController) {
            List list2 = map.getOrDefault(XcosDiagram.IN, new ArrayList());
            list.stream().filter(xcosCell -> xcosCell instanceof ExplicitInBlock || xcosCell instanceof ImplicitInBlock).map(xcosCell -> (ContextUpdate)xcosCell).collect(Collectors.toCollection(() -> list2));
            XcosDiagram.iparSort(list2, javaController);
            map.putIfAbsent(XcosDiagram.IN, list2);
            list2 = map.getOrDefault(XcosDiagram.OUT, new ArrayList());
            list.stream().filter(xcosCell -> xcosCell instanceof ExplicitOutBlock || xcosCell instanceof ImplicitOutBlock).map(xcosCell -> (ContextUpdate)xcosCell).collect(Collectors.toCollection(() -> list2));
            XcosDiagram.iparSort(list2, javaController);
            map.putIfAbsent(XcosDiagram.OUT, list2);
            list2 = map.getOrDefault(XcosDiagram.EIN, new ArrayList());
            list.stream().filter(xcosCell -> xcosCell instanceof EventInBlock).map(xcosCell -> (ContextUpdate)xcosCell).collect(Collectors.toCollection(() -> list2));
            XcosDiagram.iparSort(list2, javaController);
            map.putIfAbsent(XcosDiagram.EIN, list2);
            list2 = map.getOrDefault(XcosDiagram.EOUT, new ArrayList());
            list.stream().filter(xcosCell -> xcosCell instanceof EventOutBlock).map(xcosCell -> (ContextUpdate)xcosCell).collect(Collectors.toCollection(() -> list2));
            XcosDiagram.iparSort(list2, javaController);
            map.putIfAbsent(XcosDiagram.EOUT, list2);
        }
    }

    private static final class SavedStatusTracker
    implements mxEventSource.mxIEventListener {
        private static final Map<XcosDiagram, SavedStatusTracker> instances = new HashMap<XcosDiagram, SavedStatusTracker>();
        private ScicosObjectOwner owner;

        private SavedStatusTracker(ScicosObjectOwner scicosObjectOwner) {
            this.owner = scicosObjectOwner;
        }

        public static SavedStatusTracker getInstance(XcosDiagram xcosDiagram) {
            return instances.putIfAbsent(xcosDiagram, new SavedStatusTracker(Xcos.findRoot(xcosDiagram)));
        }

        public void invoke(Object object, mxEventObject mxEventObject2) {
            if (object instanceof XcosGraphModel) {
                List<XcosDiagram> list = Xcos.getInstance().openedDiagrams(this.owner);
                list.stream().forEach(xcosDiagram -> xcosDiagram.updateTabTitle());
            }
        }
    }

    private static final class RefreshBlockTracker
    implements mxEventSource.mxIEventListener {
        private static RefreshBlockTracker instance = new RefreshBlockTracker();

        private RefreshBlockTracker() {
        }

        public static RefreshBlockTracker getInstance() {
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Object object, mxEventObject mxEventObject2) {
            XcosDiagram xcosDiagram = (XcosDiagram)((Object)object);
            if (xcosDiagram.isReadonly()) {
                return;
            }
            xcosDiagram.getModel().beginUpdate();
            try {
                BasicBlock basicBlock = (BasicBlock)mxEventObject2.getProperty("block");
                BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
                xcosDiagram.getView().clear((Object)basicBlock, true, true);
                xcosDiagram.getAsComponent().clearCellOverlays();
                xcosDiagram.getAsComponent().validateGraph();
                xcosDiagram.getView().validate();
            }
            finally {
                xcosDiagram.getModel().endUpdate();
            }
        }
    }

    private static final class RepositionTracker
    implements mxEventSource.mxIEventListener {
        private static RepositionTracker instance;

        private RepositionTracker() {
        }

        public static RepositionTracker getInstance() {
            if (instance == null) {
                instance = new RepositionTracker();
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Object object, mxEventObject mxEventObject2) {
            XcosDiagram xcosDiagram = (XcosDiagram)((Object)object);
            Object[] objectArray = (Object[])mxEventObject2.getProperty(XcosDiagram.CELLS);
            xcosDiagram.getModel().beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof BasicBlock)) continue;
                    BlockPositioning.updateBlockView(xcosDiagram, (BasicBlock)objectArray[i]);
                }
            }
            finally {
                xcosDiagram.getModel().endUpdate();
            }
        }
    }
}

