/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.configuration;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.configuration.model.DocumentType;
import org.scilab.modules.xcos.configuration.model.ObjectFactory;
import org.scilab.modules.xcos.configuration.model.SettingType;
import org.scilab.modules.xcos.configuration.utils.ConfigurationConstants;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.preferences.XcosOptions;
import org.scilab.modules.xcos.utils.FileUtils;
import org.scilab.modules.xcos.utils.XcosMessages;
import org.xml.sax.SAXException;

public final class ConfigurationManager {
    private static final String UNABLE_TO_VALIDATE_CONFIG = "Unable to validate the configuration file.\n";
    private static final String MODEL_CLASS_PACKAGE = "org.scilab.modules.xcos.configuration.model";
    private static final String SCHEMA_FILENAME = "/XcosConfiguration.xsd";
    private static final String INSTANCE_FILENAME = "/xcos.xml";
    private static ConfigurationManager instance;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private final SettingType settings = this.loadConfig();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    public SettingType getSettings() {
        return this.settings;
    }

    public SettingType loadConfig() {
        try {
            if (unmarshaller == null) {
                this.initUnmarshaller();
            }
            try {
                Object object;
                File file = new File(ScilabConstants.SCIHOME.getAbsoluteFile() + INSTANCE_FILENAME);
                if (!file.exists()) {
                    object = new File(ScilabConstants.SCI.getAbsoluteFile() + "/modules/xcos/etc" + INSTANCE_FILENAME);
                    FileUtils.forceCopy((File)object, file);
                }
                object = unmarshaller.unmarshal((Source)new StreamSource(file), SettingType.class);
                return (SettingType)object.getValue();
            }
            catch (JAXBException jAXBException) {
                Logger.getLogger(ConfigurationManager.class.getName()).warning("user configuration file is not valid.\nSwitching to the default one." + (Object)((Object)jAXBException));
                ScilabModalDialog.show(null, (String)XcosMessages.ERR_CONFIG_INVALID, (String)XcosMessages.XCOS_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
                try {
                    File file = new File(ScilabConstants.SCI.getAbsoluteFile() + "/modules/xcos/etc" + INSTANCE_FILENAME);
                    JAXBElement jAXBElement = unmarshaller.unmarshal((Source)new StreamSource(file), SettingType.class);
                    return (SettingType)jAXBElement.getValue();
                }
                catch (JAXBException jAXBException2) {
                    Logger.getLogger(ConfigurationManager.class.getName()).severe("base configuration file corrupted.\n" + (Object)((Object)jAXBException2));
                }
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
        return new ObjectFactory().createSettingType();
    }

    private void initUnmarshaller() throws JAXBException {
        String string = ScilabConstants.SCI.getAbsolutePath() + "/modules/xcos/etc" + SCHEMA_FILENAME;
        JAXBContext jAXBContext = JAXBContext.newInstance((String)MODEL_CLASS_PACKAGE);
        unmarshaller = jAXBContext.createUnmarshaller();
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(string));
            unmarshaller.setSchema(schema);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(ConfigurationManager.class.getName()).severe(UNABLE_TO_VALIDATE_CONFIG + sAXException);
        }
    }

    public void saveConfig() {
        try {
            if (marshaller == null) {
                this.initMarshaller();
            }
            try {
                File file = new File(ScilabConstants.SCIHOME.getAbsoluteFile() + INSTANCE_FILENAME);
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal(new ObjectFactory().createSettings(this.getSettings()), file);
            }
            catch (JAXBException jAXBException) {
                Logger.getLogger(ConfigurationManager.class.getName()).warning("Unable to save user configuration file.\n" + (Object)((Object)jAXBException));
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return;
        }
    }

    private void initMarshaller() throws JAXBException {
        String string = ScilabConstants.SCI.getAbsolutePath() + "/modules/xcos/etc" + SCHEMA_FILENAME;
        JAXBContext jAXBContext = JAXBContext.newInstance((String)MODEL_CLASS_PACKAGE);
        marshaller = jAXBContext.createMarshaller();
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(string));
            marshaller.setSchema(schema);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(ConfigurationManager.class.getName()).warning(UNABLE_TO_VALIDATE_CONFIG + sAXException);
        }
    }

    public void addToRecentFiles(File file) {
        DatatypeFactory datatypeFactory;
        String string;
        List<DocumentType> list = this.getSettings().getRecent();
        int n = XcosOptions.getPreferences().getNumberOfRecentlyOpen();
        int n2 = list.size() - n;
        for (int i = 0; i < n2; ++i) {
            list.remove(list.size() - 1);
        }
        try {
            string = file.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(ConfigurationManager.class.getName()).severe(malformedURLException.toString());
            return;
        }
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            Logger.getLogger(ConfigurationManager.class.getName()).severe(datatypeConfigurationException.toString());
            return;
        }
        DocumentType documentType = new ObjectFactory().createDocumentType();
        documentType.setUrl(string);
        documentType.setDate(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
        DocumentType[] documentTypeArray = list.toArray(new DocumentType[list.size()]);
        Arrays.sort(documentTypeArray, ConfigurationConstants.FILENAME_COMPARATOR);
        DocumentType documentType2 = null;
        int n3 = Arrays.binarySearch(documentTypeArray, documentType, ConfigurationConstants.FILENAME_COMPARATOR);
        if (n3 >= 0) {
            documentType2 = documentTypeArray[n3];
            list.remove(documentType2);
        } else if (list.size() == n && list.size() > 0) {
            documentType2 = list.remove(list.size() - 1);
        }
        list.add(0, documentType);
        this.firePropertyChange("recentFilesHasChanged", documentType2, documentType);
    }

    public void addToRecentTabs(XcosDiagram xcosDiagram) {
        DocumentType documentType = this.allocate(xcosDiagram);
        if (xcosDiagram.getSavedFile() != null) {
            try {
                documentType.setUrl(xcosDiagram.getSavedFile().toURI().toURL().toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.savePath(xcosDiagram, documentType);
        documentType.setUuid(xcosDiagram.getGraphTab());
        documentType.setViewport(xcosDiagram.getViewPortTab());
    }

    private DocumentType allocate(XcosDiagram xcosDiagram) {
        List<DocumentType> list = this.getSettings().getTab();
        DocumentType documentType = null;
        for (DocumentType documentType2 : list) {
            if (!documentType2.getUuid().equals(xcosDiagram.getGraphTab())) continue;
            documentType = documentType2;
            break;
        }
        if (documentType == null) {
            documentType = new ObjectFactory().createDocumentType();
            list.add(documentType);
        }
        return documentType;
    }

    public void removeFromRecentTabs(String string) {
        List<DocumentType> list = this.getSettings().getTab();
        boolean bl = false;
        boolean bl2 = false;
        DocumentType documentType = null;
        for (DocumentType documentType2 : list) {
            bl = string.equals(documentType2.getUuid());
            bl2 = string.equals(documentType2.getViewport());
            if (!bl && !bl2) continue;
            documentType = documentType2;
            break;
        }
        if (bl) {
            documentType.setUuid(null);
        } else if (bl2) {
            documentType.setViewport(null);
        }
        if (documentType != null && documentType.getUuid() == null && documentType.getViewport() == null) {
            list.remove(documentType);
        }
    }

    public XcosDiagram loadDiagram(DocumentType documentType) {
        XcosDiagram xcosDiagram;
        File file = this.getFile(documentType);
        if (file != null && !file.exists()) {
            file = null;
        }
        try {
            JavaController javaController = new JavaController();
            xcosDiagram = new XcosDiagram(javaController, javaController.createObject(Kind.DIAGRAM), Kind.DIAGRAM, "");
            xcosDiagram.installListeners();
            Xcos.getInstance().addDiagram(new ScicosObjectOwner(xcosDiagram.getUID(), Kind.DIAGRAM), xcosDiagram);
            if (file != null) {
                String string = file.getCanonicalPath();
                XcosFileType xcosFileType = XcosFileType.findFileType(file);
                xcosFileType.load(string, xcosDiagram);
                xcosDiagram.postLoad(file);
            }
            xcosDiagram = this.loadPath(documentType, xcosDiagram);
            xcosDiagram.setGraphTab(documentType.getUuid());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.getLogger(ConfigurationManager.class.getName()).log(Level.SEVERE, null, exception);
            xcosDiagram = null;
        }
        return xcosDiagram;
    }

    public File getFile(DocumentType documentType) {
        File file;
        try {
            URL uRL = new URL(documentType.getUrl());
            file = new File(uRL.toURI());
        }
        catch (Exception exception) {
            return null;
        }
        return file;
    }

    private XcosDiagram loadPath(DocumentType documentType, XcosDiagram xcosDiagram) {
        String string = documentType.getPath();
        if (string == null || string.isEmpty()) {
            return xcosDiagram;
        }
        String[] stringArray = string.split("/");
        String string2 = stringArray[stringArray.length - 1];
        String[] stringArray2 = new String[]{};
        JavaController javaController = new JavaController();
        VectorOfScicosID vectorOfScicosID = javaController.getAll(Kind.BLOCK);
        int n = vectorOfScicosID.size();
        for (int i = 0; i < n; ++i) {
            javaController.getObjectProperty(vectorOfScicosID.get(i), Kind.BLOCK, ObjectProperties.UID, stringArray2);
            if (!string2.equals(stringArray2[0])) continue;
            return new XcosDiagram(javaController, vectorOfScicosID.get(i), Kind.BLOCK, stringArray2[0]);
        }
        return xcosDiagram;
    }

    private void savePath(XcosDiagram xcosDiagram, DocumentType documentType) {
        if (xcosDiagram.getKind() != Kind.BLOCK) {
            return;
        }
        JavaController javaController = new JavaController();
        ArrayList<String> arrayList = new ArrayList<String>();
        long[] lArray = new long[1];
        String[] stringArray = new String[1];
        javaController.getObjectProperty(xcosDiagram.getUID(), Kind.BLOCK, ObjectProperties.PARENT_BLOCK, lArray);
        while (lArray[0] != 0L) {
            javaController.getObjectProperty(lArray[0], Kind.BLOCK, ObjectProperties.UID, stringArray);
            arrayList.add(stringArray[0]);
            javaController.getObjectProperty(lArray[0], Kind.BLOCK, ObjectProperties.PARENT_BLOCK, lArray);
        }
        Collections.reverse(arrayList);
        documentType.setPath(String.join((CharSequence)"/", arrayList.toArray(new String[arrayList.size()])));
    }

    public static void configureCurrentDirectory(JFileChooser jFileChooser) {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        Iterator<DocumentType> iterator = configurationManager.getSettings().getRecent().iterator();
        File file = null;
        if (iterator.hasNext()) {
            try {
                file = new File(new URL(iterator.next().getUrl()).toURI());
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        jFileChooser.setCurrentDirectory(file);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }
}

