/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxCellState;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Timer;
import org.scilab.modules.graph.utils.Font;
import org.scilab.modules.graph.utils.ScilabExported;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosGraphModel;

public final class AfficheBlock
extends BasicBlock {
    private static final int DEFAULT_TIMER_RATE = 200;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String SPACE = "  ";
    private static final TreeMap<String, String[][]> values = new TreeMap();
    private static final UpdateValueListener updateAction = new UpdateValueListener();
    private static final Timer printTimer = new Timer(200, updateAction);

    public AfficheBlock(JavaController javaController, long l, Kind kind, Object object, mxGeometry mxGeometry2, String string, String string2) {
        super(javaController, l, kind, object, mxGeometry2, string, string2);
    }

    @Override
    protected void setMVCValue(JavaController javaController, Object object) {
        if (object == null) {
            return;
        }
        javaController.setObjectProperty(this.getUID(), this.getKind(), ObjectProperties.DESCRIPTION, String.valueOf(object));
    }

    @Override
    protected void updateStyle(JavaController javaController, XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        StyleMap styleMap = new StyleMap(basicBlock.getStyle());
        VectorOfInt vectorOfInt = new VectorOfInt();
        javaController.getObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.IPAR, vectorOfInt);
        int n = vectorOfInt.get(0);
        styleMap.put((Object)mxConstants.STYLE_FONTFAMILY, (Object)Font.getFont((int)n).getName());
        int n2 = vectorOfInt.get(1);
        styleMap.put((Object)mxConstants.STYLE_FONTSIZE, (Object)Integer.toString(Font.getSize((int)n2)));
        int n3 = vectorOfInt.get(2);
        String string = "#" + Integer.toHexString(Font.getColor((int)n3).getRGB());
        styleMap.put((Object)mxConstants.STYLE_FONTCOLOR, (Object)string);
        xcosDiagram.getModel().setStyle((Object)this, styleMap.toString());
    }

    @Override
    protected void updateValue(JavaController javaController, XcosDiagram xcosDiagram, BasicBlock basicBlock) {
        VectorOfInt vectorOfInt = new VectorOfInt();
        javaController.getObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.IPAR, vectorOfInt);
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        javaController.getObjectProperty(this.getUID(), Kind.BLOCK, ObjectProperties.DSTATE, vectorOfDouble);
        int n = vectorOfInt.get(3);
        int n2 = vectorOfInt.get(4);
        int n3 = vectorOfInt.get(5);
        int n4 = (vectorOfDouble.size() - 6) / n3;
        String string = "%" + Integer.toString(n) + "." + Integer.toString(n2) + "f";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                stringBuilder.append(new Formatter(Locale.US).format(string, 0.0).toString());
                stringBuilder.append(SPACE);
            }
            stringBuilder.append(NEW_LINE);
        }
        xcosDiagram.getModel().setValue((Object)this, (Object)stringBuilder.toString());
    }

    private static String getText(String[][] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (n2 != 0) {
                    stringBuilder.append(SPACE);
                }
                stringBuilder.append(stringArray[i][j]);
            }
            stringBuilder.append(NEW_LINE);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScilabExported(module="scicos_blocks", filename="Blocks.giws.xml")
    public static void setValue(String string, String[][] stringArray) {
        if (stringArray.length == 0 || stringArray[0].length == 0) {
            throw new IllegalArgumentException("value is not a non-empty String matrix (String[][])");
        }
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        TreeMap<String, String[][]> treeMap = values;
        synchronized (treeMap) {
            values.put(string, stringArray);
            if (!printTimer.isRunning()) {
                printTimer.start();
            }
        }
    }

    private static class UpdateValueListener
    implements ActionListener,
    Serializable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<XcosDiagram> list = Xcos.getInstance().openedDiagrams();
            TreeMap treeMap = values;
            synchronized (treeMap) {
                Iterator iterator = values.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.update(list, (String)entry.getKey(), (String[][])entry.getValue());
                    iterator.remove();
                }
            }
        }

        private void update(List<XcosDiagram> list, String string, String[][] stringArray) {
            class DiagramBlockPair {
                final XcosDiagram diag;
                final Object block;

                DiagramBlockPair(XcosDiagram xcosDiagram, Object object) {
                    this.diag = xcosDiagram;
                    this.block = object;
                }
            }
            DiagramBlockPair diagramBlockPair2 = list.stream().map(xcosDiagram -> new DiagramBlockPair((XcosDiagram)((Object)xcosDiagram), ((XcosGraphModel)xcosDiagram.getModel()).getCell(string))).filter(diagramBlockPair -> diagramBlockPair.block != null).findAny().orElse(null);
            if (diagramBlockPair2 == null) {
                return;
            }
            String string2 = AfficheBlock.getText(stringArray);
            diagramBlockPair2.diag.getModel().setValue(diagramBlockPair2.block, (Object)string2);
            mxCellState mxCellState2 = diagramBlockPair2.diag.getView().getState(diagramBlockPair2.block);
            if (mxCellState2 != null) {
                mxCellState2.setLabel(string2);
            }
            diagramBlockPair2.diag.getAsComponent().redraw(mxCellState2);
        }
    }
}

